% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookoutmetrics_operations.R
\name{lookoutmetrics_create_alert}
\alias{lookoutmetrics_create_alert}
\title{Creates an alert for an anomaly detector}
\usage{
lookoutmetrics_create_alert(
  AlertName,
  AlertSensitivityThreshold = NULL,
  AlertDescription = NULL,
  AnomalyDetectorArn,
  Action,
  Tags = NULL,
  AlertFilters = NULL
)
}
\arguments{
\item{AlertName}{[required] The name of the alert.}

\item{AlertSensitivityThreshold}{An integer from 0 to 100 specifying the alert sensitivity threshold.}

\item{AlertDescription}{A description of the alert.}

\item{AnomalyDetectorArn}{[required] The ARN of the detector to which the alert is attached.}

\item{Action}{[required] Action that will be triggered when there is an alert.}

\item{Tags}{A list of
\href{https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html}{tags}
to apply to the alert.}

\item{AlertFilters}{The configuration of the alert filters, containing MetricList and
DimensionFilterList.}
}
\description{
Creates an alert for an anomaly detector.

See \url{https://www.paws-r-sdk.com/docs/lookoutmetrics_create_alert/} for full documentation.
}
\keyword{internal}
