% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_trial_component}
\alias{sagemaker_create_trial_component}
\title{Creates a trial component, which is a stage of a machine learning trial}
\usage{
sagemaker_create_trial_component(
  TrialComponentName,
  DisplayName = NULL,
  Status = NULL,
  StartTime = NULL,
  EndTime = NULL,
  Parameters = NULL,
  InputArtifacts = NULL,
  OutputArtifacts = NULL,
  MetadataProperties = NULL,
  Tags = NULL
)
}
\arguments{
\item{TrialComponentName}{[required] The name of the component. The name must be unique in your Amazon Web
Services account and is not case-sensitive.}

\item{DisplayName}{The name of the component as displayed. The name doesn't need to be
unique. If \code{DisplayName} isn't specified, \code{TrialComponentName} is
displayed.}

\item{Status}{The status of the component. States include:
\itemize{
\item InProgress
\item Completed
\item Failed
}}

\item{StartTime}{When the component started.}

\item{EndTime}{When the component ended.}

\item{Parameters}{The hyperparameters for the component.}

\item{InputArtifacts}{The input artifacts for the component. Examples of input artifacts are
datasets, algorithms, hyperparameters, source code, and instance types.}

\item{OutputArtifacts}{The output artifacts for the component. Examples of output artifacts are
metrics, snapshots, logs, and images.}

\item{MetadataProperties}{}

\item{Tags}{A list of tags to associate with the component. You can use
\code{\link[=sagemaker_search]{search}} API to search on the tags.}
}
\description{
Creates a \emph{trial component}, which is a stage of a machine learning \emph{trial}. A trial is composed of one or more trial components. A trial component can be used in multiple trials.

See \url{https://paws-r.github.io/docs/sagemaker/create_trial_component.html} for full documentation.
}
\keyword{internal}
