% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_create_entity_recognizer}
\alias{comprehend_create_entity_recognizer}
\title{Creates an entity recognizer using submitted files}
\usage{
comprehend_create_entity_recognizer(RecognizerName, DataAccessRoleArn,
  Tags, InputDataConfig, ClientRequestToken, LanguageCode, VolumeKmsKeyId,
  VpcConfig)
}
\arguments{
\item{RecognizerName}{[required] The name given to the newly created recognizer. Recognizer names can be
a maximum of 256 characters. Alphanumeric characters, hyphens (-) and
underscores (\\_) are allowed. The name must be unique in the
account/region.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM)
role that grants Amazon Comprehend read access to your input data.}

\item{Tags}{Tags to be associated with the entity recognizer being created. A tag is
a key-value pair that adds as a metadata to a resource used by Amazon
Comprehend. For example, a tag with \"Sales\" as the key might be added
to a resource to indicate its use by the sales department.}

\item{InputDataConfig}{[required] Specifies the format and location of the input data. The S3 bucket
containing the input data must be located in the same region as the
entity recognizer being created.}

\item{ClientRequestToken}{A unique identifier for the request. If you don\'t set the client
request token, Amazon Comprehend generates one.}

\item{LanguageCode}{[required] The language of the input documents. All documents must be in the same
language. Only English (\"en\") is currently supported.}

\item{VolumeKmsKeyId}{ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
uses to encrypt data on the storage volume attached to the ML compute
instance(s) that process the analysis job. The VolumeKmsKeyId can be
either of the following formats:
\itemize{
\item KMS Key ID: \code{"1234abcd-12ab-34cd-56ef-1234567890ab"}
\item Amazon Resource Name (ARN) of a KMS Key:
\code{"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"}
}}

\item{VpcConfig}{Configuration parameters for an optional private Virtual Private Cloud
(VPC) containing the resources you are using for your custom entity
recognizer. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html}{Amazon VPC}.}
}
\description{
Creates an entity recognizer using submitted files. After your
\code{CreateEntityRecognizer} request is submitted, you can check job status
using the API.
}
\section{Request syntax}{
\preformatted{svc$create_entity_recognizer(
  RecognizerName = "string",
  DataAccessRoleArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  InputDataConfig = list(
    EntityTypes = list(
      list(
        Type = "string"
      )
    ),
    Documents = list(
      S3Uri = "string"
    ),
    Annotations = list(
      S3Uri = "string"
    ),
    EntityList = list(
      S3Uri = "string"
    )
  ),
  ClientRequestToken = "string",
  LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
  VolumeKmsKeyId = "string",
  VpcConfig = list(
    SecurityGroupIds = list(
      "string"
    ),
    Subnets = list(
      "string"
    )
  )
)
}
}

\keyword{internal}
