% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_workteam}
\alias{sagemaker_create_workteam}
\title{Creates a new work team for labeling your data}
\usage{
sagemaker_create_workteam(WorkteamName, MemberDefinitions, Description,
  NotificationConfiguration, Tags)
}
\arguments{
\item{WorkteamName}{[required] The name of the work team. Use this name to identify the work team.}

\item{MemberDefinitions}{[required] A list of \code{MemberDefinition} objects that contains objects that identify
the Amazon Cognito user pool that makes up the work team. For more
information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html}{Amazon Cognito User Pools}.

All of the \code{CognitoMemberDefinition} objects that make up the member
definition must have the same \code{ClientId} and \code{UserPool} values.}

\item{Description}{[required] A description of the work team.}

\item{NotificationConfiguration}{Configures notification of workers regarding available or expiring work
items.}

\item{Tags}{An array of key-value pairs.

For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html}{Resource Tag}
and \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what}{Using Cost Allocation Tags}
in the \emph{AWS Billing and Cost Management User Guide}.}
}
\description{
Creates a new work team for labeling your data. A work team is defined
by one or more Amazon Cognito user pools. You must first create the user
pools before you can create a work team.
}
\details{
You cannot create more than 25 work teams in an account and region.
}
\section{Request syntax}{
\preformatted{svc$create_workteam(
  WorkteamName = "string",
  MemberDefinitions = list(
    list(
      CognitoMemberDefinition = list(
        UserPool = "string",
        UserGroup = "string",
        ClientId = "string"
      )
    )
  ),
  Description = "string",
  NotificationConfiguration = list(
    NotificationTopicArn = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
