% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_monitoring_schedule}
\alias{sagemaker_update_monitoring_schedule}
\title{Updates a previously created schedule}
\usage{
sagemaker_update_monitoring_schedule(MonitoringScheduleName,
  MonitoringScheduleConfig)
}
\arguments{
\item{MonitoringScheduleName}{[required] The name of the monitoring schedule. The name must be unique within an
AWS Region within an AWS account.}

\item{MonitoringScheduleConfig}{[required] The configuration object that specifies the monitoring schedule and
defines the monitoring job.}
}
\description{
Updates a previously created schedule.
}
\section{Request syntax}{
\preformatted{svc$update_monitoring_schedule(
  MonitoringScheduleName = "string",
  MonitoringScheduleConfig = list(
    ScheduleConfig = list(
      ScheduleExpression = "string"
    ),
    MonitoringJobDefinition = list(
      BaselineConfig = list(
        ConstraintsResource = list(
          S3Uri = "string"
        ),
        StatisticsResource = list(
          S3Uri = "string"
        )
      ),
      MonitoringInputs = list(
        list(
          EndpointInput = list(
            EndpointName = "string",
            LocalPath = "string",
            S3InputMode = "Pipe"|"File",
            S3DataDistributionType = "FullyReplicated"|"ShardedByS3Key"
          )
        )
      ),
      MonitoringOutputConfig = list(
        MonitoringOutputs = list(
          list(
            S3Output = list(
              S3Uri = "string",
              LocalPath = "string",
              S3UploadMode = "Continuous"|"EndOfJob"
            )
          )
        ),
        KmsKeyId = "string"
      ),
      MonitoringResources = list(
        ClusterConfig = list(
          InstanceCount = 123,
          InstanceType = "ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.r5.large"|"ml.r5.xlarge"|"ml.r5.2xlarge"|"ml.r5.4xlarge"|"ml.r5.8xlarge"|"ml.r5.12xlarge"|"ml.r5.16xlarge"|"ml.r5.24xlarge",
          VolumeSizeInGB = 123,
          VolumeKmsKeyId = "string"
        )
      ),
      MonitoringAppSpecification = list(
        ImageUri = "string",
        ContainerEntrypoint = list(
          "string"
        ),
        ContainerArguments = list(
          "string"
        ),
        RecordPreprocessorSourceUri = "string",
        PostAnalyticsProcessorSourceUri = "string"
      ),
      StoppingCondition = list(
        MaxRuntimeInSeconds = 123
      ),
      Environment = list(
        "string"
      ),
      NetworkConfig = list(
        EnableNetworkIsolation = TRUE|FALSE,
        VpcConfig = list(
          SecurityGroupIds = list(
            "string"
          ),
          Subnets = list(
            "string"
          )
        )
      ),
      RoleArn = "string"
    )
  )
)
}
}

\keyword{internal}
