% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_compilation_job}
\alias{sagemaker_create_compilation_job}
\title{Starts a model compilation job}
\usage{
sagemaker_create_compilation_job(CompilationJobName, RoleArn,
  InputConfig, OutputConfig, StoppingCondition)
}
\arguments{
\item{CompilationJobName}{[required] A name for the model compilation job. The name must be unique within the
AWS Region and within your AWS account.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of an IAM role that enables Amazon
SageMaker to perform tasks on your behalf.

During model compilation, Amazon SageMaker needs your permission to:
\itemize{
\item Read input data from an S3 bucket
\item Write model artifacts to an S3 bucket
\item Write logs to Amazon CloudWatch Logs
\item Publish metrics to Amazon CloudWatch
}

You grant permissions for all of these tasks to an IAM role. To pass
this role to Amazon SageMaker, the caller of this API must have the
\code{iam:PassRole} permission. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html}{Amazon SageMaker Roles.}}

\item{InputConfig}{[required] Provides information about the location of input model artifacts, the
name and shape of the expected data inputs, and the framework in which
the model was trained.}

\item{OutputConfig}{[required] Provides information about the output location for the compiled model
and the target device the model runs on.}

\item{StoppingCondition}{[required] Specifies a limit to how long a model compilation job can run. When the
job reaches the time limit, Amazon SageMaker ends the compilation job.
Use this API to cap model training costs.}
}
\description{
Starts a model compilation job. After the model has been compiled,
Amazon SageMaker saves the resulting model artifacts to an Amazon Simple
Storage Service (Amazon S3) bucket that you specify.
}
\details{
If you choose to host your model using Amazon SageMaker hosting
services, you can use the resulting model artifacts as part of the
model. You can also use the artifacts with AWS IoT Greengrass. In that
case, deploy them as an ML resource.

In the request body, you provide the following:
\itemize{
\item A name for the compilation job
\item Information about the input model artifacts
\item The output location for the compiled model and the device (target)
that the model runs on
\item \code{The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job}
}

You can also provide a \code{Tag} to track the model compilation job's
resource use and costs. The response body contains the
\code{CompilationJobArn} for the compiled job.

To stop a model compilation job, use StopCompilationJob. To get
information about a particular model compilation job, use
DescribeCompilationJob. To get information about multiple model
compilation jobs, use ListCompilationJobs.
}
\section{Request syntax}{
\preformatted{svc$create_compilation_job(
  CompilationJobName = "string",
  RoleArn = "string",
  InputConfig = list(
    S3Uri = "string",
    DataInputConfig = "string",
    Framework = "TENSORFLOW"|"MXNET"|"ONNX"|"PYTORCH"|"XGBOOST"
  ),
  OutputConfig = list(
    S3OutputLocation = "string",
    TargetDevice = "lambda"|"ml_m4"|"ml_m5"|"ml_c4"|"ml_c5"|"ml_p2"|"ml_p3"|"jetson_tx1"|"jetson_tx2"|"jetson_nano"|"rasp3b"|"deeplens"|"rk3399"|"rk3288"|"sbe_c"
  ),
  StoppingCondition = list(
    MaxRuntimeInSeconds = 123
  )
)
}
}

\keyword{internal}
