% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_stop_training_job}
\alias{sagemaker_stop_training_job}
\title{Stops a training job}
\usage{
sagemaker_stop_training_job(TrainingJobName)
}
\arguments{
\item{TrainingJobName}{[required] The name of the training job to stop.}
}
\value{
An empty list.
}
\description{
Stops a training job. To stop a job, Amazon SageMaker sends the
algorithm the \code{SIGTERM} signal, which delays job termination for 120
seconds. Algorithms might use this 120-second window to save the model
artifacts, so the results of the training is not lost.

When it receives a \code{\link[=sagemaker_stop_training_job]{stop_training_job}}
request, Amazon SageMaker changes the status of the job to \code{Stopping}.
After Amazon SageMaker stops the job, it sets the status to \code{Stopped}.
}
\section{Request syntax}{
\preformatted{svc$stop_training_job(
  TrainingJobName = "string"
)
}
}

\keyword{internal}
