% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexruntimeservice_operations.R
\name{lexruntimeservice_put_session}
\alias{lexruntimeservice_put_session}
\title{Creates a new session or modifies an existing session with an Amazon Lex
bot}
\usage{
lexruntimeservice_put_session(botName, botAlias, userId,
  sessionAttributes, dialogAction, recentIntentSummaryView, accept,
  activeContexts)
}
\arguments{
\item{botName}{[required] The name of the bot that contains the session data.}

\item{botAlias}{[required] The alias in use for the bot that contains the session data.}

\item{userId}{[required] The ID of the client application user. Amazon Lex uses this to identify
a user's conversation with your bot.}

\item{sessionAttributes}{Map of key/value pairs representing the session-specific context
information. It contains application information passed between Amazon
Lex and a client application.}

\item{dialogAction}{Sets the next action that the bot should take to fulfill the
conversation.}

\item{recentIntentSummaryView}{A summary of the recent intents for the bot. You can use the intent
summary view to set a checkpoint label on an intent and modify
attributes of intents. You can also use it to remove or add intent
summary objects to the list.

An intent that you modify or add to the list must make sense for the
bot. For example, the intent name must be valid for the bot. You must
provide valid values for:
\itemize{
\item \code{intentName}
\item slot names
\item \code{slotToElict}
}

If you send the \code{recentIntentSummaryView} parameter in a
\code{\link[=lexruntimeservice_put_session]{put_session}} request, the contents of
the new summary view replaces the old summary view. For example, if a
\code{\link[=lexruntimeservice_get_session]{get_session}} request returns three
intents in the summary view and you call
\code{\link[=lexruntimeservice_put_session]{put_session}} with one intent in the
summary view, the next call to
\code{\link[=lexruntimeservice_get_session]{get_session}} will only return one
intent.}

\item{accept}{The message that Amazon Lex returns in the response can be either text
or speech based depending on the value of this field.
\itemize{
\item If the value is \verb{text/plain; charset=utf-8}, Amazon Lex returns text
in the response.
\item If the value begins with \verb{audio/}, Amazon Lex returns speech in the
response. Amazon Lex uses Amazon Polly to generate the speech in the
configuration that you specify. For example, if you specify
\code{audio/mpeg} as the value, Amazon Lex returns speech in the MPEG
format.
\item If the value is \code{audio/pcm}, the speech is returned as \code{audio/pcm}
in 16-bit, little endian format.
\item The following are the accepted values:
\itemize{
\item \code{audio/mpeg}
\item \code{audio/ogg}
\item \code{audio/pcm}
\item \verb{audio/*} (defaults to mpeg)
\item \verb{text/plain; charset=utf-8}
}
}}

\item{activeContexts}{A list of contexts active for the request. A context can be activated
when a previous intent is fulfilled, or by including the context in the
request,

If you don't specify a list of contexts, Amazon Lex will use the current
list of contexts for the session. If you specify an empty list, all
contexts for the session are cleared.}
}
\value{
A list with the following syntax:\preformatted{list(
  contentType = "string",
  intentName = "string",
  slots = "string",
  sessionAttributes = "string",
  message = "string",
  messageFormat = "PlainText"|"CustomPayload"|"SSML"|"Composite",
  dialogState = "ElicitIntent"|"ConfirmIntent"|"ElicitSlot"|"Fulfilled"|"ReadyForFulfillment"|"Failed",
  slotToElicit = "string",
  audioStream = raw,
  sessionId = "string",
  activeContexts = "string"
)
}
}
\description{
Creates a new session or modifies an existing session with an Amazon Lex
bot. Use this operation to enable your application to set the state of
the bot.

For more information, see \href{https://docs.aws.amazon.com/lex/latest/dg/how-session-api.html}{Managing Sessions}.
}
\section{Request syntax}{
\preformatted{svc$put_session(
  botName = "string",
  botAlias = "string",
  userId = "string",
  sessionAttributes = list(
    "string"
  ),
  dialogAction = list(
    type = "ElicitIntent"|"ConfirmIntent"|"ElicitSlot"|"Close"|"Delegate",
    intentName = "string",
    slots = list(
      "string"
    ),
    slotToElicit = "string",
    fulfillmentState = "Fulfilled"|"Failed"|"ReadyForFulfillment",
    message = "string",
    messageFormat = "PlainText"|"CustomPayload"|"SSML"|"Composite"
  ),
  recentIntentSummaryView = list(
    list(
      intentName = "string",
      checkpointLabel = "string",
      slots = list(
        "string"
      ),
      confirmationStatus = "None"|"Confirmed"|"Denied",
      dialogActionType = "ElicitIntent"|"ConfirmIntent"|"ElicitSlot"|"Close"|"Delegate",
      fulfillmentState = "Fulfilled"|"Failed"|"ReadyForFulfillment",
      slotToElicit = "string"
    )
  ),
  accept = "string",
  activeContexts = list(
    list(
      name = "string",
      timeToLive = list(
        timeToLiveInSeconds = 123,
        turnsToLive = 123
      ),
      parameters = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
