% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_delete_intent}
\alias{lexmodelbuildingservice_delete_intent}
\title{Deletes all versions of the intent, including the $LATEST version}
\usage{
lexmodelbuildingservice_delete_intent(name)
}
\arguments{
\item{name}{[required] The name of the intent. The name is case sensitive.}
}
\value{
An empty list.
}
\description{
Deletes all versions of the intent, including the \verb{$LATEST} version. To
delete a specific version of the intent, use the
\code{\link[=lexmodelbuildingservice_delete_intent_version]{delete_intent_version}}
operation.

You can delete a version of an intent only if it is not referenced. To
delete an intent that is referred to in one or more bots (see
how-it-works), you must remove those references first.

If you get the \code{ResourceInUseException} exception, it provides an
example reference that shows where the intent is referenced. To remove
the reference to the intent, either update the bot or delete it. If you
get the same exception when you attempt to delete the intent again,
repeat until the intent has no references and the call to
\code{\link[=lexmodelbuildingservice_delete_intent]{delete_intent}} is successful.

This operation requires permission for the \code{lex:DeleteIntent} action.
}
\section{Request syntax}{
\preformatted{svc$delete_intent(
  name = "string"
)
}
}

\keyword{internal}
