% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_project}
\alias{sagemaker_create_project}
\title{Creates a machine learning (ML) project that can contain one or more
templates that set up an ML pipeline from training to deploying an
approved model}
\usage{
sagemaker_create_project(ProjectName, ProjectDescription,
  ServiceCatalogProvisioningDetails, Tags)
}
\arguments{
\item{ProjectName}{[required] The name of the project.}

\item{ProjectDescription}{A description for the project.}

\item{ServiceCatalogProvisioningDetails}{[required] The product ID and provisioning artifact ID to provision a service
catalog. For information, see \href{https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html}{What is AWS Service Catalog}.}

\item{Tags}{An array of key-value pairs that you want to use to organize and track
your AWS resource costs. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html}{Tagging AWS resources}
in the \emph{AWS General Reference Guide}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProjectArn = "string",
  ProjectId = "string"
)
}
}
\description{
Creates a machine learning (ML) project that can contain one or more
templates that set up an ML pipeline from training to deploying an
approved model.
}
\section{Request syntax}{
\preformatted{svc$create_project(
  ProjectName = "string",
  ProjectDescription = "string",
  ServiceCatalogProvisioningDetails = list(
    ProductId = "string",
    ProvisioningArtifactId = "string",
    PathId = "string",
    ProvisioningParameters = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
