% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_stop_compilation_job}
\alias{sagemaker_stop_compilation_job}
\title{Stops a model compilation job}
\usage{
sagemaker_stop_compilation_job(CompilationJobName)
}
\arguments{
\item{CompilationJobName}{[required] The name of the model compilation job to stop.}
}
\description{
Stops a model compilation job.

To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal.
This gracefully shuts the job down. If the job hasn't stopped, it sends
the SIGKILL signal.

When it receives a \code{StopCompilationJob} request, Amazon SageMaker
changes the CompilationJobSummary$CompilationJobStatus of the job to
\code{Stopping}. After Amazon SageMaker stops the job, it sets the
CompilationJobSummary$CompilationJobStatus to \code{Stopped}.
}
\section{Request syntax}{
\preformatted{svc$stop_compilation_job(
  CompilationJobName = "string"
)
}
}

\keyword{internal}
