% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_describe_workspace_images}
\alias{workspaces_describe_workspace_images}
\title{Retrieves a list that describes one or more specified images, if the
image identifiers are provided}
\usage{
workspaces_describe_workspace_images(ImageIds, ImageType, NextToken,
  MaxResults)
}
\arguments{
\item{ImageIds}{The identifier of the image.}

\item{ImageType}{The type (owned or shared) of the image.}

\item{NextToken}{If you received a \code{NextToken} from a previous call that was paginated,
provide this token to receive the next set of results.}

\item{MaxResults}{The maximum number of items to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  Images = list(
    list(
      ImageId = "string",
      Name = "string",
      Description = "string",
      OperatingSystem = list(
        Type = "WINDOWS"|"LINUX"
      ),
      State = "AVAILABLE"|"PENDING"|"ERROR",
      RequiredTenancy = "DEFAULT"|"DEDICATED",
      ErrorCode = "string",
      ErrorMessage = "string",
      Created = as.POSIXct(
        "2015-01-01"
      ),
      OwnerAccountId = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list that describes one or more specified images, if the
image identifiers are provided. Otherwise, all images in the account are
described.
}
\section{Request syntax}{
\preformatted{svc$describe_workspace_images(
  ImageIds = list(
    "string"
  ),
  ImageType = "OWNED"|"SHARED",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
