% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_describe_resource_permissions}
\alias{workdocs_describe_resource_permissions}
\title{Describes the permissions of a specified resource}
\usage{
workdocs_describe_resource_permissions(AuthenticationToken, ResourceId,
  PrincipalId, Limit, Marker)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{ResourceId}{[required] The ID of the resource.}

\item{PrincipalId}{The ID of the principal to filter permissions by.}

\item{Limit}{The maximum number of items to return with this call.}

\item{Marker}{The marker for the next set of results. (You received this marker from a
previous call)}
}
\value{
A list with the following syntax:\preformatted{list(
  Principals = list(
    list(
      Id = "string",
      Type = "USER"|"GROUP"|"INVITE"|"ANONYMOUS"|"ORGANIZATION",
      Roles = list(
        list(
          Role = "VIEWER"|"CONTRIBUTOR"|"OWNER"|"COOWNER",
          Type = "DIRECT"|"INHERITED"
        )
      )
    )
  ),
  Marker = "string"
)
}
}
\description{
Describes the permissions of a specified resource.
}
\section{Request syntax}{
\preformatted{svc$describe_resource_permissions(
  AuthenticationToken = "string",
  ResourceId = "string",
  PrincipalId = "string",
  Limit = 123,
  Marker = "string"
)
}
}

\keyword{internal}
