% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_list_reports}
\alias{codebuild_list_reports}
\title{Returns a list of ARNs for the reports in the current Amazon Web
Services account}
\usage{
codebuild_list_reports(
  sortOrder = NULL,
  nextToken = NULL,
  maxResults = NULL,
  filter = NULL
)
}
\arguments{
\item{sortOrder}{Specifies the sort order for the list of returned reports. Valid values
are:
\itemize{
\item \code{ASCENDING}: return reports in chronological order based on their
creation date.
\item \code{DESCENDING}: return reports in the reverse chronological order
based on their creation date.
}}

\item{nextToken}{During a previous call, the maximum number of items that can be returned
is the value specified in \code{maxResults}. If there more items in the list,
then a unique string called a \emph{nextToken} is returned. To get the next
batch of items in the list, call this operation again, adding the next
token to the call. To get all of the items in the list, keep calling
this operation with each subsequent next token that is returned, until
no more next tokens are returned.}

\item{maxResults}{The maximum number of paginated reports returned per response. Use
\code{nextToken} to iterate pages in the list of returned \code{Report} objects.
The default value is 100.}

\item{filter}{A \code{ReportFilter} object used to filter the returned reports.}
}
\description{
Returns a list of ARNs for the reports in the current Amazon Web Services account.

See \url{https://www.paws-r-sdk.com/docs/codebuild_list_reports/} for full documentation.
}
\keyword{internal}
