% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeguruprofiler_operations.R
\name{codeguruprofiler_get_findings_report_account_summary}
\alias{codeguruprofiler_get_findings_report_account_summary}
\title{Returns a list of FindingsReportSummary objects that contain analysis
results for all profiling groups in your AWS account}
\usage{
codeguruprofiler_get_findings_report_account_summary(
  dailyReportsOnly = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{dailyReportsOnly}{A \code{Boolean} value indicating whether to only return reports from daily
profiles. If set to \code{True}, only analysis data from daily profiles is
returned. If set to \code{False}, analysis data is returned from smaller time
windows (for example, one hour).}

\item{maxResults}{The maximum number of results returned by
\code{\link[=codeguruprofiler_get_findings_report_account_summary]{get_findings_report_account_summary}}
in paginated output. When this parameter is used,
\code{\link[=codeguruprofiler_get_findings_report_account_summary]{get_findings_report_account_summary}}
only returns \code{maxResults} results in a single page along with a
\code{nextToken} response element. The remaining results of the initial
request can be seen by sending another
\code{\link[=codeguruprofiler_get_findings_report_account_summary]{get_findings_report_account_summary}}
request with the returned \code{nextToken} value.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{\link[=codeguruprofiler_get_findings_report_account_summary]{get_findings_report_account_summary}}
request where \code{maxResults} was used and the results exceeded the value
of that parameter. Pagination continues from the end of the previous
results that returned the \code{nextToken} value.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}
}
\description{
Returns a list of \href{https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html}{\code{FindingsReportSummary}} objects that contain analysis results for all profiling groups in your AWS account.

See \url{https://paws-r.github.io/docs/codeguruprofiler/get_findings_report_account_summary.html} for full documentation.
}
\keyword{internal}
