% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_untag_resource}
\alias{codedeploy_untag_resource}
\title{Disassociates a resource from a list of tags}
\usage{
codedeploy_untag_resource(ResourceArn, TagKeys)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) that specifies from which resource to
disassociate the tags with the keys in the \code{TagKeys} input parameter.}

\item{TagKeys}{[required] A list of keys of \code{Tag} objects. The \code{Tag} objects identified by the
keys are disassociated from the resource specified by the \code{ResourceArn}
input parameter.}
}
\value{
An empty list.
}
\description{
Disassociates a resource from a list of tags. The resource is identified
by the \code{ResourceArn} input parameter. The tags are identified by the
list of keys in the \code{TagKeys} input parameter.
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  ResourceArn = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
