% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_list_on_premises_instances}
\alias{codedeploy_list_on_premises_instances}
\title{Gets a list of names for one or more on-premises instances}
\usage{
codedeploy_list_on_premises_instances(registrationStatus, tagFilters,
  nextToken)
}
\arguments{
\item{registrationStatus}{The registration status of the on-premises instances:
\itemize{
\item \code{Deregistered}: Include deregistered on-premises instances in the
resulting list.
\item \code{Registered}: Include registered on-premises instances in the
resulting list.
}}

\item{tagFilters}{The on-premises instance tags that are used to restrict the on-premises
instance names returned.}

\item{nextToken}{An identifier returned from the previous list on-premises instances
call. It can be used to return the next set of on-premises instances in
the list.}
}
\value{
A list with the following syntax:\preformatted{list(
  instanceNames = list(
    "string"
  ),
  nextToken = "string"
)
}
}
\description{
Gets a list of names for one or more on-premises instances.

Unless otherwise specified, both registered and deregistered on-premises
instance names are listed. To list only registered or deregistered
on-premises instance names, use the registration status parameter.
}
\section{Request syntax}{
\preformatted{svc$list_on_premises_instances(
  registrationStatus = "Registered"|"Deregistered",
  tagFilters = list(
    list(
      Key = "string",
      Value = "string",
      Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
    )
  ),
  nextToken = "string"
)
}
}

\keyword{internal}
