% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_batch_get_projects}
\alias{codebuild_batch_get_projects}
\title{Gets information about one or more build projects}
\usage{
codebuild_batch_get_projects(names)
}
\arguments{
\item{names}{[required] The names or ARNs of the build projects. To get information about a
project shared with your AWS account, its ARN must be specified. You
cannot specify a shared project using its name.}
}
\value{
A list with the following syntax:\preformatted{list(
  projects = list(
    list(
      name = "string",
      arn = "string",
      description = "string",
      source = list(
        type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
        location = "string",
        gitCloneDepth = 123,
        gitSubmodulesConfig = list(
          fetchSubmodules = TRUE|FALSE
        ),
        buildspec = "string",
        auth = list(
          type = "OAUTH",
          resource = "string"
        ),
        reportBuildStatus = TRUE|FALSE,
        buildStatusConfig = list(
          context = "string",
          targetUrl = "string"
        ),
        insecureSsl = TRUE|FALSE,
        sourceIdentifier = "string"
      ),
      secondarySources = list(
        list(
          type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
          location = "string",
          gitCloneDepth = 123,
          gitSubmodulesConfig = list(
            fetchSubmodules = TRUE|FALSE
          ),
          buildspec = "string",
          auth = list(
            type = "OAUTH",
            resource = "string"
          ),
          reportBuildStatus = TRUE|FALSE,
          buildStatusConfig = list(
            context = "string",
            targetUrl = "string"
          ),
          insecureSsl = TRUE|FALSE,
          sourceIdentifier = "string"
        )
      ),
      sourceVersion = "string",
      secondarySourceVersions = list(
        list(
          sourceIdentifier = "string",
          sourceVersion = "string"
        )
      ),
      artifacts = list(
        type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
        location = "string",
        path = "string",
        namespaceType = "NONE"|"BUILD_ID",
        name = "string",
        packaging = "NONE"|"ZIP",
        overrideArtifactName = TRUE|FALSE,
        encryptionDisabled = TRUE|FALSE,
        artifactIdentifier = "string"
      ),
      secondaryArtifacts = list(
        list(
          type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
          location = "string",
          path = "string",
          namespaceType = "NONE"|"BUILD_ID",
          name = "string",
          packaging = "NONE"|"ZIP",
          overrideArtifactName = TRUE|FALSE,
          encryptionDisabled = TRUE|FALSE,
          artifactIdentifier = "string"
        )
      ),
      cache = list(
        type = "NO_CACHE"|"S3"|"LOCAL",
        location = "string",
        modes = list(
          "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
        )
      ),
      environment = list(
        type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
        image = "string",
        computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
        environmentVariables = list(
          list(
            name = "string",
            value = "string",
            type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
          )
        ),
        privilegedMode = TRUE|FALSE,
        certificate = "string",
        registryCredential = list(
          credential = "string",
          credentialProvider = "SECRETS_MANAGER"
        ),
        imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
      ),
      serviceRole = "string",
      timeoutInMinutes = 123,
      queuedTimeoutInMinutes = 123,
      encryptionKey = "string",
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      ),
      created = as.POSIXct(
        "2015-01-01"
      ),
      lastModified = as.POSIXct(
        "2015-01-01"
      ),
      webhook = list(
        url = "string",
        payloadUrl = "string",
        secret = "string",
        branchFilter = "string",
        filterGroups = list(
          list(
            list(
              type = "EVENT"|"BASE_REF"|"HEAD_REF"|"ACTOR_ACCOUNT_ID"|"FILE_PATH"|"COMMIT_MESSAGE",
              pattern = "string",
              excludeMatchedPattern = TRUE|FALSE
            )
          )
        ),
        buildType = "BUILD"|"BUILD_BATCH",
        lastModifiedSecret = as.POSIXct(
          "2015-01-01"
        )
      ),
      vpcConfig = list(
        vpcId = "string",
        subnets = list(
          "string"
        ),
        securityGroupIds = list(
          "string"
        )
      ),
      badge = list(
        badgeEnabled = TRUE|FALSE,
        badgeRequestUrl = "string"
      ),
      logsConfig = list(
        cloudWatchLogs = list(
          status = "ENABLED"|"DISABLED",
          groupName = "string",
          streamName = "string"
        ),
        s3Logs = list(
          status = "ENABLED"|"DISABLED",
          location = "string",
          encryptionDisabled = TRUE|FALSE
        )
      ),
      fileSystemLocations = list(
        list(
          type = "EFS",
          location = "string",
          mountPoint = "string",
          identifier = "string",
          mountOptions = "string"
        )
      ),
      buildBatchConfig = list(
        serviceRole = "string",
        combineArtifacts = TRUE|FALSE,
        restrictions = list(
          maximumBuildsAllowed = 123,
          computeTypesAllowed = list(
            "string"
          )
        ),
        timeoutInMins = 123
      )
    )
  ),
  projectsNotFound = list(
    "string"
  )
)
}
}
\description{
Gets information about one or more build projects.
}
\section{Request syntax}{
\preformatted{svc$batch_get_projects(
  names = list(
    "string"
  )
)
}
}

\keyword{internal}
