# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include qldbsession_service.R
NULL

#' Sends a command to an Amazon QLDB ledger
#'
#' @description
#' Sends a command to an Amazon QLDB ledger.
#'
#' See [https://www.paws-r-sdk.com/docs/qldbsession_send_command/](https://www.paws-r-sdk.com/docs/qldbsession_send_command/) for full documentation.
#'
#' @param SessionToken Specifies the session token for the current command. A session token is
#' constant throughout the life of the session.
#' 
#' To obtain a session token, run the `StartSession` command. This
#' `SessionToken` is required for every subsequent command that is issued
#' during the current session.
#' @param StartSession Command to start a new session. A session token is obtained as part of
#' the response.
#' @param StartTransaction Command to start a new transaction.
#' @param EndSession Command to end the current session.
#' @param CommitTransaction Command to commit the specified transaction.
#' @param AbortTransaction Command to abort the current transaction.
#' @param ExecuteStatement Command to execute a statement in the specified transaction.
#' @param FetchPage Command to fetch a page.
#'
#' @keywords internal
#'
#' @rdname qldbsession_send_command
qldbsession_send_command <- function(SessionToken = NULL, StartSession = NULL, StartTransaction = NULL, EndSession = NULL, CommitTransaction = NULL, AbortTransaction = NULL, ExecuteStatement = NULL, FetchPage = NULL) {
  op <- new_operation(
    name = "SendCommand",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list()
  )
  input <- .qldbsession$send_command_input(SessionToken = SessionToken, StartSession = StartSession, StartTransaction = StartTransaction, EndSession = EndSession, CommitTransaction = CommitTransaction, AbortTransaction = AbortTransaction, ExecuteStatement = ExecuteStatement, FetchPage = FetchPage)
  output <- .qldbsession$send_command_output()
  config <- get_config()
  svc <- .qldbsession$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.qldbsession$operations$send_command <- qldbsession_send_command
