% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memorydb_operations.R
\name{memorydb_create_cluster}
\alias{memorydb_create_cluster}
\title{Creates a cluster}
\usage{
memorydb_create_cluster(
  ClusterName,
  NodeType,
  ParameterGroupName = NULL,
  Description = NULL,
  NumShards = NULL,
  NumReplicasPerShard = NULL,
  SubnetGroupName = NULL,
  SecurityGroupIds = NULL,
  MaintenanceWindow = NULL,
  Port = NULL,
  SnsTopicArn = NULL,
  TLSEnabled = NULL,
  KmsKeyId = NULL,
  SnapshotArns = NULL,
  SnapshotName = NULL,
  SnapshotRetentionLimit = NULL,
  Tags = NULL,
  SnapshotWindow = NULL,
  ACLName,
  EngineVersion = NULL,
  AutoMinorVersionUpgrade = NULL,
  DataTiering = NULL
)
}
\arguments{
\item{ClusterName}{[required] The name of the cluster. This value must be unique as it also serves as
the cluster identifier.}

\item{NodeType}{[required] The compute and memory capacity of the nodes in the cluster.}

\item{ParameterGroupName}{The name of the parameter group associated with the cluster.}

\item{Description}{An optional description of the cluster.}

\item{NumShards}{The number of shards the cluster will contain. The default value is 1.}

\item{NumReplicasPerShard}{The number of replicas to apply to each shard. The default value is 1.
The maximum is 5.}

\item{SubnetGroupName}{The name of the subnet group to be used for the cluster.}

\item{SecurityGroupIds}{A list of security group names to associate with this cluster.}

\item{MaintenanceWindow}{Specifies the weekly time range during which maintenance on the cluster
is performed. It is specified as a range in the format
ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window
is a 60 minute period.

Valid values for \code{ddd} are:
\itemize{
\item \code{sun}
\item \code{mon}
\item \code{tue}
\item \code{wed}
\item \code{thu}
\item \code{fri}
\item \code{sat}
}

Example: \code{sun:23:00-mon:01:30}}

\item{Port}{The port number on which each of the nodes accepts connections.}

\item{SnsTopicArn}{The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
(SNS) topic to which notifications are sent.}

\item{TLSEnabled}{A flag to enable in-transit encryption on the cluster.}

\item{KmsKeyId}{The ID of the KMS key used to encrypt the cluster.}

\item{SnapshotArns}{A list of Amazon Resource Names (ARN) that uniquely identify the RDB
snapshot files stored in Amazon S3. The snapshot files are used to
populate the new cluster. The Amazon S3 object name in the ARN cannot
contain any commas.}

\item{SnapshotName}{The name of a snapshot from which to restore data into the new cluster.
The snapshot status changes to restoring while the new cluster is being
created.}

\item{SnapshotRetentionLimit}{The number of days for which MemoryDB retains automatic snapshots before
deleting them. For example, if you set SnapshotRetentionLimit to 5, a
snapshot that was taken today is retained for 5 days before being
deleted.}

\item{Tags}{A list of tags to be added to this resource. Tags are comma-separated
key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include
multiple tags as shown following: Key=myKey, Value=myKeyValue
Key=mySecondKey, Value=mySecondKeyValue.}

\item{SnapshotWindow}{The daily time range (in UTC) during which MemoryDB begins taking a
daily snapshot of your shard.

Example: 05:00-09:00

If you do not specify this parameter, MemoryDB automatically chooses an
appropriate time range.}

\item{ACLName}{[required] The name of the Access Control List to associate with the cluster.}

\item{EngineVersion}{The version number of the Redis engine to be used for the cluster.}

\item{AutoMinorVersionUpgrade}{When set to true, the cluster will automatically receive minor engine
version upgrades after launch.}

\item{DataTiering}{Enables data tiering. Data tiering is only supported for clusters using
the r6gd node type. This parameter must be set when using r6gd nodes.
For more information, see \href{https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html}{Data tiering}.}
}
\description{
Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.

See \url{https://www.paws-r-sdk.com/docs/memorydb_create_cluster/} for full documentation.
}
\keyword{internal}
