% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_cluster}
\alias{redshift_modify_cluster}
\title{Modifies the settings for a cluster}
\usage{
redshift_modify_cluster(
  ClusterIdentifier,
  ClusterType = NULL,
  NodeType = NULL,
  NumberOfNodes = NULL,
  ClusterSecurityGroups = NULL,
  VpcSecurityGroupIds = NULL,
  MasterUserPassword = NULL,
  ClusterParameterGroupName = NULL,
  AutomatedSnapshotRetentionPeriod = NULL,
  ManualSnapshotRetentionPeriod = NULL,
  PreferredMaintenanceWindow = NULL,
  ClusterVersion = NULL,
  AllowVersionUpgrade = NULL,
  HsmClientCertificateIdentifier = NULL,
  HsmConfigurationIdentifier = NULL,
  NewClusterIdentifier = NULL,
  PubliclyAccessible = NULL,
  ElasticIp = NULL,
  EnhancedVpcRouting = NULL,
  MaintenanceTrackName = NULL,
  Encrypted = NULL,
  KmsKeyId = NULL,
  AvailabilityZoneRelocation = NULL,
  AvailabilityZone = NULL,
  Port = NULL,
  ManageMasterPassword = NULL,
  MasterPasswordSecretKmsKeyId = NULL,
  IpAddressType = NULL,
  MultiAZ = NULL
)
}
\arguments{
\item{ClusterIdentifier}{[required] The unique identifier of the cluster to be modified.

Example: \code{examplecluster}}

\item{ClusterType}{The new cluster type.

When you submit your cluster resize request, your existing cluster goes
into a read-only mode. After Amazon Redshift provisions a new cluster
based on your resize requirements, there will be outage for a period
while the old cluster is deleted and your connection is switched to the
new cluster. You can use \code{\link[=redshift_describe_resize]{describe_resize}}
to track the progress of the resize request.

Valid Values: \code{multi-node | single-node}}

\item{NodeType}{The new node type of the cluster. If you specify a new node type, you
must also specify the number of nodes parameter.

For more information about resizing clusters, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/managing-cluster-operations.html}{Resizing Clusters in Amazon Redshift}
in the \emph{Amazon Redshift Cluster Management Guide}.

Valid Values: \code{ds2.xlarge} | \code{ds2.8xlarge} | \code{dc1.large} | \code{dc1.8xlarge}
| \code{dc2.large} | \code{dc2.8xlarge} | \code{ra3.xlplus} | \code{ra3.4xlarge} |
\code{ra3.16xlarge}}

\item{NumberOfNodes}{The new number of nodes of the cluster. If you specify a new number of
nodes, you must also specify the node type parameter.

For more information about resizing clusters, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/managing-cluster-operations.html}{Resizing Clusters in Amazon Redshift}
in the \emph{Amazon Redshift Cluster Management Guide}.

Valid Values: Integer greater than \code{0}.}

\item{ClusterSecurityGroups}{A list of cluster security groups to be authorized on this cluster. This
change is asynchronously applied as soon as possible.

Security groups currently associated with the cluster, and not in the
list of groups to apply, will be revoked from the cluster.

Constraints:
\itemize{
\item Must be 1 to 255 alphanumeric characters or hyphens
\item First character must be a letter
\item Cannot end with a hyphen or contain two consecutive hyphens
}}

\item{VpcSecurityGroupIds}{A list of virtual private cloud (VPC) security groups to be associated
with the cluster. This change is asynchronously applied as soon as
possible.}

\item{MasterUserPassword}{The new password for the cluster admin user. This change is
asynchronously applied as soon as possible. Between the time of the
request and the completion of the request, the \code{MasterUserPassword}
element exists in the \code{PendingModifiedValues} element of the operation
response.

You can't use \code{MasterUserPassword} if \code{ManageMasterPassword} is \code{true}.

Operations never return the password, so this operation provides a way
to regain access to the admin user account for a cluster if the password
is lost.

Default: Uses existing setting.

Constraints:
\itemize{
\item Must be between 8 and 64 characters in length.
\item Must contain at least one uppercase letter.
\item Must contain at least one lowercase letter.
\item Must contain one number.
\item Can be any printable ASCII character (ASCII code 33-126) except \verb{\\'}
(single quote), \verb{\\"} (double quote), \verb{\\}, \code{/}, or \code{@}.
}}

\item{ClusterParameterGroupName}{The name of the cluster parameter group to apply to this cluster. This
change is applied only after the cluster is rebooted. To reboot a
cluster use \code{\link[=redshift_reboot_cluster]{reboot_cluster}}.

Default: Uses existing setting.

Constraints: The cluster parameter group must be in the same parameter
group family that matches the cluster version.}

\item{AutomatedSnapshotRetentionPeriod}{The number of days that automated snapshots are retained. If the value
is 0, automated snapshots are disabled. Even if automated snapshots are
disabled, you can still create manual snapshots when you want with
\code{\link[=redshift_create_cluster_snapshot]{create_cluster_snapshot}}.

If you decrease the automated snapshot retention period from its current
value, existing automated snapshots that fall outside of the new
retention period will be immediately deleted.

You can't disable automated snapshots for RA3 node types. Set the
automated retention period from 1-35 days.

Default: Uses existing setting.

Constraints: Must be a value from 0 to 35.}

\item{ManualSnapshotRetentionPeriod}{The default for number of days that a newly created manual snapshot is
retained. If the value is -1, the manual snapshot is retained
indefinitely. This value doesn't retroactively change the retention
periods of existing manual snapshots.

The value must be either -1 or an integer between 1 and 3,653.

The default value is -1.}

\item{PreferredMaintenanceWindow}{The weekly time range (in UTC) during which system maintenance can
occur, if necessary. If system maintenance is necessary during the
window, it may result in an outage.

This maintenance window change is made immediately. If the new
maintenance window indicates the current time, there must be at least
120 minutes between the current time and end of the window in order to
ensure that pending changes are applied.

Default: Uses existing setting.

Format: ddd:hh24:mi-ddd:hh24:mi, for example \code{wed:07:30-wed:08:00}.

Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun

Constraints: Must be at least 30 minutes.}

\item{ClusterVersion}{The new version number of the Amazon Redshift engine to upgrade to.

For major version upgrades, if a non-default cluster parameter group is
currently in use, a new cluster parameter group in the cluster parameter
group family for the new version must be specified. The new cluster
parameter group can be the default for that cluster parameter group
family. For more information about parameters and parameter groups, go
to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html}{Amazon Redshift Parameter Groups}
in the \emph{Amazon Redshift Cluster Management Guide}.

Example: \code{1.0}}

\item{AllowVersionUpgrade}{If \code{true}, major version upgrades will be applied automatically to the
cluster during the maintenance window.

Default: \code{false}}

\item{HsmClientCertificateIdentifier}{Specifies the name of the HSM client certificate the Amazon Redshift
cluster uses to retrieve the data encryption keys stored in an HSM.}

\item{HsmConfigurationIdentifier}{Specifies the name of the HSM configuration that contains the
information the Amazon Redshift cluster can use to retrieve and store
keys in an HSM.}

\item{NewClusterIdentifier}{The new identifier for the cluster.

Constraints:
\itemize{
\item Must contain from 1 to 63 alphanumeric characters or hyphens.
\item Alphabetic characters must be lowercase.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
\item Must be unique for all clusters within an Amazon Web Services
account.
}

Example: \code{examplecluster}}

\item{PubliclyAccessible}{If \code{true}, the cluster can be accessed from a public network. Only
clusters in VPCs can be set to be publicly available.}

\item{ElasticIp}{The Elastic IP (EIP) address for the cluster.

Constraints: The cluster must be provisioned in EC2-VPC and
publicly-accessible through an Internet gateway. For more information
about provisioning clusters in EC2-VPC, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-clusters.html#cluster-platforms}{Supported Platforms to Launch Your Cluster}
in the Amazon Redshift Cluster Management Guide.}

\item{EnhancedVpcRouting}{An option that specifies whether to create the cluster with enhanced VPC
routing enabled. To create a cluster that uses enhanced VPC routing, the
cluster must be in a VPC. For more information, see \href{https://docs.aws.amazon.com/redshift/latest/mgmt/enhanced-vpc-routing.html}{Enhanced VPC Routing}
in the Amazon Redshift Cluster Management Guide.

If this option is \code{true}, enhanced VPC routing is enabled.

Default: false}

\item{MaintenanceTrackName}{The name for the maintenance track that you want to assign for the
cluster. This name change is asynchronous. The new track name stays in
the \code{PendingModifiedValues} for the cluster until the next maintenance
window. When the maintenance track changes, the cluster is switched to
the latest cluster release available for the maintenance track. At this
point, the maintenance track name is applied.}

\item{Encrypted}{Indicates whether the cluster is encrypted. If the value is encrypted
(true) and you provide a value for the \code{KmsKeyId} parameter, we encrypt
the cluster with the provided \code{KmsKeyId}. If you don't provide a
\code{KmsKeyId}, we encrypt with the default key.

If the value is not encrypted (false), then the cluster is decrypted.}

\item{KmsKeyId}{The Key Management Service (KMS) key ID of the encryption key that you
want to use to encrypt data in the cluster.}

\item{AvailabilityZoneRelocation}{The option to enable relocation for an Amazon Redshift cluster between
Availability Zones after the cluster modification is complete.}

\item{AvailabilityZone}{The option to initiate relocation for an Amazon Redshift cluster to the
target Availability Zone.}

\item{Port}{The option to change the port of an Amazon Redshift cluster.}

\item{ManageMasterPassword}{If \code{true}, Amazon Redshift uses Secrets Manager to manage this cluster's
admin credentials. You can't use \code{MasterUserPassword} if
\code{ManageMasterPassword} is true. If \code{ManageMasterPassword} is false or
not set, Amazon Redshift uses \code{MasterUserPassword} for the admin user
account's password.}

\item{MasterPasswordSecretKmsKeyId}{The ID of the Key Management Service (KMS) key used to encrypt and store
the cluster's admin credentials secret. You can only use this parameter
if \code{ManageMasterPassword} is true.}

\item{IpAddressType}{The IP address types that the cluster supports. Possible values are
\code{ipv4} and \code{dualstack}.}

\item{MultiAZ}{If true and the cluster is currently only deployed in a single
Availability Zone, the cluster will be modified to be deployed in two
Availability Zones.}
}
\description{
Modifies the settings for a cluster.

See \url{https://www.paws-r-sdk.com/docs/redshift_modify_cluster/} for full documentation.
}
\keyword{internal}
