% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdbelastic_operations.R
\name{docdbelastic_restore_cluster_from_snapshot}
\alias{docdbelastic_restore_cluster_from_snapshot}
\title{Restores a Elastic DocumentDB cluster from a snapshot}
\usage{
docdbelastic_restore_cluster_from_snapshot(
  clusterName,
  kmsKeyId = NULL,
  snapshotArn,
  subnetIds = NULL,
  tags = NULL,
  vpcSecurityGroupIds = NULL
)
}
\arguments{
\item{clusterName}{[required] The name of the Elastic DocumentDB cluster.}

\item{kmsKeyId}{The KMS key identifier to use to encrypt the new Elastic DocumentDB
cluster.

The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
encryption key. If you are creating a cluster using the same Amazon
account that owns this KMS encryption key, you can use the KMS key alias
instead of the ARN as the KMS encryption key.

If an encryption key is not specified here, Elastic DocumentDB uses the
default encryption key that KMS creates for your account. Your account
has a different default encryption key for each Amazon Region.}

\item{snapshotArn}{[required] The arn of the Elastic DocumentDB snapshot.}

\item{subnetIds}{The Amazon EC2 subnet IDs for the Elastic DocumentDB cluster.}

\item{tags}{A list of the tag names to be assigned to the restored DB cluster, in
the form of an array of key-value pairs in which the key is the tag name
and the value is the key value.}

\item{vpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with the Elastic
DocumentDB cluster.}
}
\description{
Restores a Elastic DocumentDB cluster from a snapshot.

See \url{https://www.paws-r-sdk.com/docs/docdbelastic_restore_cluster_from_snapshot/} for full documentation.
}
\keyword{internal}
