% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_create_cluster_parameter_group}
\alias{redshift_create_cluster_parameter_group}
\title{Creates an Amazon Redshift parameter group}
\usage{
redshift_create_cluster_parameter_group(
  ParameterGroupName,
  ParameterGroupFamily,
  Description,
  Tags = NULL
)
}
\arguments{
\item{ParameterGroupName}{[required] The name of the cluster parameter group.

Constraints:
\itemize{
\item Must be 1 to 255 alphanumeric characters or hyphens
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
\item Must be unique withing your Amazon Web Services account.
}

This value is stored as a lower-case string.}

\item{ParameterGroupFamily}{[required] The Amazon Redshift engine version to which the cluster parameter group
applies. The cluster engine version determines the set of parameters.

To get a list of valid parameter group family names, you can call
\code{\link[=redshift_describe_cluster_parameter_groups]{describe_cluster_parameter_groups}}.
By default, Amazon Redshift returns a list of all the parameter groups
that are owned by your Amazon Web Services account, including the
default parameter groups for each Amazon Redshift engine version. The
parameter group family names associated with the default parameter
groups provide you the valid values. For example, a valid family name is
"redshift-1.0".}

\item{Description}{[required] A description of the parameter group.}

\item{Tags}{A list of tag instances.}
}
\description{
Creates an Amazon Redshift parameter group.

See \url{https://paws-r.github.io/docs/redshift/create_cluster_parameter_group.html} for full documentation.
}
\keyword{internal}
