% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_create_custom_db_engine_version}
\alias{rds_create_custom_db_engine_version}
\title{Creates a custom DB engine version (CEV)}
\usage{
rds_create_custom_db_engine_version(
  Engine,
  EngineVersion,
  DatabaseInstallationFilesS3BucketName,
  DatabaseInstallationFilesS3Prefix = NULL,
  KMSKeyId,
  Description = NULL,
  Manifest,
  Tags = NULL
)
}
\arguments{
\item{Engine}{[required] The database engine to use for your custom engine version (CEV). The
only supported value is \code{custom-oracle-ee}.}

\item{EngineVersion}{[required] The name of your CEV. The name format is \verb{19.customized_string }. For
example, a valid name is \verb{19.my_cev1}. This setting is required for RDS
Custom for Oracle, but optional for Amazon RDS. The combination of
\code{Engine} and \code{EngineVersion} is unique per customer per Region.}

\item{DatabaseInstallationFilesS3BucketName}{[required] The name of an Amazon S3 bucket that contains database installation
files for your CEV. For example, a valid bucket name is
\code{my-custom-installation-files}.}

\item{DatabaseInstallationFilesS3Prefix}{The Amazon S3 directory that contains the database installation files
for your CEV. For example, a valid bucket name is \code{123456789012/cev1}.
If this setting isn't specified, no prefix is assumed.}

\item{KMSKeyId}{[required] The Amazon Web Services KMS key identifier for an encrypted CEV. A
symmetric KMS key is required for RDS Custom, but optional for Amazon
RDS.

If you have an existing symmetric KMS key in your account, you can use
it with RDS Custom. No further action is necessary. If you don't already
have a symmetric KMS key in your account, follow the instructions in
\href{https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk}{Creating symmetric KMS keys}
in the \emph{Amazon Web Services Key Management Service Developer Guide}.

You can choose the same symmetric key when you create a CEV and a DB
instance, or choose different keys.}

\item{Description}{An optional description of your CEV.}

\item{Manifest}{[required] The CEV manifest, which is a JSON document that describes the
installation .zip files stored in Amazon S3. Specify the name/value
pairs in a file or a quoted string. RDS Custom applies the patches in
the order in which they are listed.

The following JSON fields are valid:

\strong{MediaImportTemplateVersion}

Version of the CEV manifest. The date is in the format \code{YYYY-MM-DD}.

\strong{databaseInstallationFileNames}

Ordered list of installation files for the CEV.

\strong{opatchFileNames}

Ordered list of OPatch installers used for the Oracle DB engine.

\strong{psuRuPatchFileNames}

The PSU and RU patches for this CEV.

\strong{OtherPatchFileNames}

The patches that are not in the list of PSU and RU patches. Amazon RDS
applies these patches after applying the PSU and RU patches.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest}{Creating the CEV manifest}
in the \emph{Amazon RDS User Guide}.}

\item{Tags}{}
}
\description{
Creates a custom DB engine version (CEV). A CEV is a binary volume snapshot of a database engine and specific AMI. The supported engines are the following:

See \url{https://paws-r.github.io/docs/rds/create_custom_db_engine_version.html} for full documentation.
}
\keyword{internal}
