% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qldb_operations.R
\name{qldb_get_block}
\alias{qldb_get_block}
\title{Returns a block object at a specified address in a journal}
\usage{
qldb_get_block(Name, BlockAddress, DigestTipAddress = NULL)
}
\arguments{
\item{Name}{[required] The name of the ledger.}

\item{BlockAddress}{[required] The location of the block that you want to request. An address is an
Amazon Ion structure that has two fields: \code{strandId} and \code{sequenceNo}.

For example: \verb{\{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14\}}.}

\item{DigestTipAddress}{The latest block location covered by the digest for which to request a
proof. An address is an Amazon Ion structure that has two fields:
\code{strandId} and \code{sequenceNo}.

For example: \verb{\{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49\}}.}
}
\description{
Returns a block object at a specified address in a journal. Also returns a proof of the specified block for verification if \code{DigestTipAddress} is provided.

See \url{https://paws-r.github.io/docs/qldb/get_block.html} for full documentation.
}
\keyword{internal}
