% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_modify_db_cluster_endpoint}
\alias{neptune_modify_db_cluster_endpoint}
\title{Modifies the properties of an endpoint in an Amazon Neptune DB cluster}
\usage{
neptune_modify_db_cluster_endpoint(
  DBClusterEndpointIdentifier,
  EndpointType = NULL,
  StaticMembers = NULL,
  ExcludedMembers = NULL
)
}
\arguments{
\item{DBClusterEndpointIdentifier}{[required] The identifier of the endpoint to modify. This parameter is stored as a
lowercase string.}

\item{EndpointType}{The type of the endpoint. One of: \code{READER}, \code{WRITER}, \code{ANY}.}

\item{StaticMembers}{List of DB instance identifiers that are part of the custom endpoint
group.}

\item{ExcludedMembers}{List of DB instance identifiers that aren't part of the custom endpoint
group. All other eligible instances are reachable through the custom
endpoint. Only relevant if the list of static members is empty.}
}
\description{
Modifies the properties of an endpoint in an Amazon Neptune DB cluster.

See \url{https://paws-r.github.io/docs/neptune/modify_db_cluster_endpoint.html} for full documentation.
}
\keyword{internal}
