% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_create_db_cluster}
\alias{neptune_create_db_cluster}
\title{Creates a new Amazon Neptune DB cluster}
\usage{
neptune_create_db_cluster(
  AvailabilityZones = NULL,
  BackupRetentionPeriod = NULL,
  CharacterSetName = NULL,
  CopyTagsToSnapshot = NULL,
  DatabaseName = NULL,
  DBClusterIdentifier,
  DBClusterParameterGroupName = NULL,
  VpcSecurityGroupIds = NULL,
  DBSubnetGroupName = NULL,
  Engine,
  EngineVersion = NULL,
  Port = NULL,
  MasterUsername = NULL,
  MasterUserPassword = NULL,
  OptionGroupName = NULL,
  PreferredBackupWindow = NULL,
  PreferredMaintenanceWindow = NULL,
  ReplicationSourceIdentifier = NULL,
  Tags = NULL,
  StorageEncrypted = NULL,
  KmsKeyId = NULL,
  PreSignedUrl = NULL,
  EnableIAMDatabaseAuthentication = NULL,
  EnableCloudwatchLogsExports = NULL,
  DeletionProtection = NULL,
  GlobalClusterIdentifier = NULL
)
}
\arguments{
\item{AvailabilityZones}{A list of EC2 Availability Zones that instances in the DB cluster can be
created in.}

\item{BackupRetentionPeriod}{The number of days for which automated backups are retained. You must
specify a minimum value of 1.

Default: 1

Constraints:
\itemize{
\item Must be a value from 1 to 35
}}

\item{CharacterSetName}{\emph{(Not supported by Neptune)}}

\item{CopyTagsToSnapshot}{\emph{If set to true, tags are copied to any snapshot of the DB cluster that
is created.}}

\item{DatabaseName}{The name for your database of up to 64 alpha-numeric characters. If you
do not provide a name, Amazon Neptune will not create a database in the
DB cluster you are creating.}

\item{DBClusterIdentifier}{[required] The DB cluster identifier. This parameter is stored as a lowercase
string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster1}}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to associate with this DB
cluster. If this argument is omitted, the default is used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing
DBClusterParameterGroup.
}}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with this DB cluster.}

\item{DBSubnetGroupName}{A DB subnet group to associate with this DB cluster.

Constraints: Must match the name of an existing DBSubnetGroup. Must not
be default.

Example: \code{mySubnetgroup}}

\item{Engine}{[required] The name of the database engine to be used for this DB cluster.

Valid Values: \code{neptune}}

\item{EngineVersion}{The version number of the database engine to use for the new DB cluster.

Example: \verb{1.0.2.1}}

\item{Port}{The port number on which the instances in the DB cluster accept
connections.

Default: \code{8182}}

\item{MasterUsername}{Not supported by Neptune.}

\item{MasterUserPassword}{Not supported by Neptune.}

\item{OptionGroupName}{\emph{(Not supported by Neptune)}}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled using the \code{BackupRetentionPeriod}
parameter.

The default is a 30-minute window selected at random from an 8-hour
block of time for each Amazon Region. To see the time blocks available,
see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/}{Adjusting the Preferred Maintenance Window} in the
\emph{Amazon Neptune User Guide.}

Constraints:
\itemize{
\item Must be in the format \code{hh24:mi-hh24:mi}.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}

\item{PreferredMaintenanceWindow}{The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

The default is a 30-minute window selected at random from an 8-hour
block of time for each Amazon Region, occurring on a random day of the
week. To see the time blocks available, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/}{Adjusting the Preferred Maintenance Window} in the
\emph{Amazon Neptune User Guide.}

Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

Constraints: Minimum 30-minute window.}

\item{ReplicationSourceIdentifier}{The Amazon Resource Name (ARN) of the source DB instance or DB cluster
if this DB cluster is created as a Read Replica.}

\item{Tags}{The tags to assign to the new DB cluster.}

\item{StorageEncrypted}{Specifies whether the DB cluster is encrypted.}

\item{KmsKeyId}{The Amazon KMS key identifier for an encrypted DB cluster.

The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
encryption key. If you are creating a DB cluster with the same Amazon
account that owns the KMS encryption key used to encrypt the new DB
cluster, then you can use the KMS key alias instead of the ARN for the
KMS encryption key.

If an encryption key is not specified in \code{KmsKeyId}:
\itemize{
\item If \code{ReplicationSourceIdentifier} identifies an encrypted source,
then Amazon Neptune will use the encryption key used to encrypt the
source. Otherwise, Amazon Neptune will use your default encryption
key.
\item If the \code{StorageEncrypted} parameter is true and
\code{ReplicationSourceIdentifier} is not specified, then Amazon Neptune
will use your default encryption key.
}

Amazon KMS creates the default encryption key for your Amazon account.
Your Amazon account has a different default encryption key for each
Amazon Region.

If you create a Read Replica of an encrypted DB cluster in another
Amazon Region, you must set \code{KmsKeyId} to a KMS key ID that is valid in
the destination Amazon Region. This key is used to encrypt the Read
Replica in that Amazon Region.}

\item{PreSignedUrl}{This parameter is not currently supported.}

\item{EnableIAMDatabaseAuthentication}{If set to \code{true}, enables Amazon Identity and Access Management (IAM)
authentication for the entire DB cluster (this cannot be set at an
instance level).

Default: \code{false}.}

\item{EnableCloudwatchLogsExports}{The list of log types that need to be enabled for exporting to
CloudWatch Logs.}

\item{DeletionProtection}{A value that indicates whether the DB cluster has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection is enabled.}

\item{GlobalClusterIdentifier}{The ID of the Neptune global database to which this new DB cluster
should be added.}
}
\description{
Creates a new Amazon Neptune DB cluster.

See \url{https://paws-r.github.io/docs/neptune/create_db_cluster.html} for full documentation.
}
\keyword{internal}
