% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_search_databases_by_lf_tags}
\alias{lakeformation_search_databases_by_lf_tags}
\title{This operation allows a search on DATABASE resources by TagCondition}
\usage{
lakeformation_search_databases_by_lf_tags(
  NextToken = NULL,
  MaxResults = NULL,
  CatalogId = NULL,
  Expression
)
}
\arguments{
\item{NextToken}{A continuation token, if this is not the first call to retrieve this
list.}

\item{MaxResults}{The maximum number of results to return.}

\item{CatalogId}{The identifier for the Data Catalog. By default, the account ID. The
Data Catalog is the persistent metadata store. It contains database
definitions, table definitions, and other control information to manage
your Lake Formation environment.}

\item{Expression}{[required] A list of conditions (\code{LFTag} structures) to search for in database
resources.}
}
\description{
This operation allows a search on \code{DATABASE} resources by \code{TagCondition}. This operation is used by admins who want to grant user permissions on certain \code{TagConditions}. Before making a grant, the admin can use \code{SearchDatabasesByTags} to find all resources where the given \code{TagConditions} are valid to verify whether the returned resources can be shared.

See \url{https://paws-r.github.io/docs/lakeformation/search_databases_by_lf_tags.html} for full documentation.
}
\keyword{internal}
