% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_get_table_objects}
\alias{lakeformation_get_table_objects}
\title{Returns the set of Amazon S3 objects that make up the specified governed
table}
\usage{
lakeformation_get_table_objects(
  CatalogId = NULL,
  DatabaseName,
  TableName,
  TransactionId = NULL,
  QueryAsOfTime = NULL,
  PartitionPredicate = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{CatalogId}{The catalog containing the governed table. Defaults to the caller’s
account.}

\item{DatabaseName}{[required] The database containing the governed table.}

\item{TableName}{[required] The governed table for which to retrieve objects.}

\item{TransactionId}{The transaction ID at which to read the governed table contents. If this
transaction has aborted, an error is returned. If not set, defaults to
the most recent committed transaction. Cannot be specified along with
\code{QueryAsOfTime}.}

\item{QueryAsOfTime}{The time as of when to read the governed table contents. If not set, the
most recent transaction commit time is used. Cannot be specified along
with \code{TransactionId}.}

\item{PartitionPredicate}{A predicate to filter the objects returned based on the partition keys
defined in the governed table.
\itemize{
\item The comparison operators supported are: =, \>, \<, \>=, \<=
\item The logical operators supported are: AND
\item The data types supported are integer, long, date(yyyy-MM-dd),
timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd HH:mm:ss"), string
and decimal.
}}

\item{MaxResults}{Specifies how many values to return in a page.}

\item{NextToken}{A continuation token if this is not the first call to retrieve these
objects.}
}
\description{
Returns the set of Amazon S3 objects that make up the specified governed table. A transaction ID or timestamp can be specified for time-travel queries.

See \url{https://paws-r.github.io/docs/lakeformation/get_table_objects.html} for full documentation.
}
\keyword{internal}
