% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_describe_event_categories}
\alias{docdb_describe_event_categories}
\title{Displays a list of categories for all event source types, or, if
specified, for a specified source type}
\usage{
docdb_describe_event_categories(SourceType, Filters)
}
\arguments{
\item{SourceType}{The type of source that is generating the events.

Valid values: \code{db-instance}, \code{db-parameter-group}, \code{db-security-group},
\code{db-snapshot}}

\item{Filters}{This parameter is not currently supported.}
}
\value{
A list with the following syntax:\preformatted{list(
  EventCategoriesMapList = list(
    list(
      SourceType = "string",
      EventCategories = list(
        "string"
      )
    )
  )
)
}
}
\description{
Displays a list of categories for all event source types, or, if
specified, for a specified source type.
}
\section{Request syntax}{
\preformatted{svc$describe_event_categories(
  SourceType = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
