% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_parameters}
\alias{rds_describe_db_parameters}
\title{Returns the detailed parameter list for a particular DB parameter group}
\usage{
rds_describe_db_parameters(DBParameterGroupName, Source, Filters,
  MaxRecords, Marker)
}
\arguments{
\item{DBParameterGroupName}{[required] The name of a specific DB parameter group to return details for.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DBParameterGroup.
}}

\item{Source}{The parameter types to return.

Default: All parameter types returned

Valid Values: \code{user | system | engine-default}}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{DescribeDBParameters} request. If this parameter is specified, the
response includes only records beyond the marker, up to the value
specified by \code{MaxRecords}.}
}
\description{
Returns the detailed parameter list for a particular DB parameter group.
}
\section{Request syntax}{
\preformatted{svc$describe_db_parameters(
  DBParameterGroupName = "string",
  Source = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
