% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_db_snapshots}
\alias{rds_describe_db_snapshots}
\title{Returns information about DB snapshots}
\usage{
rds_describe_db_snapshots(DBInstanceIdentifier, DBSnapshotIdentifier,
  SnapshotType, Filters, MaxRecords, Marker, IncludeShared, IncludePublic,
  DbiResourceId)
}
\arguments{
\item{DBInstanceIdentifier}{The ID of the DB instance to retrieve the list of DB snapshots for. This
parameter can't be used in conjunction with \code{DBSnapshotIdentifier}.
This parameter is not case-sensitive.

Constraints:
\itemize{
\item If supplied, must match the identifier of an existing DBInstance.
}}

\item{DBSnapshotIdentifier}{A specific DB snapshot identifier to describe. This parameter can't be
used in conjunction with \code{DBInstanceIdentifier}. This value is stored as
a lowercase string.

Constraints:
\itemize{
\item If supplied, must match the identifier of an existing DBSnapshot.
\item If this identifier is for an automated snapshot, the \code{SnapshotType}
parameter must also be specified.
}}

\item{SnapshotType}{The type of snapshots to be returned. You can specify one of the
following values:
\itemize{
\item \code{automated} - Return all DB snapshots that have been automatically
taken by Amazon RDS for my AWS account.
\item \code{manual} - Return all DB snapshots that have been taken by my AWS
account.
\item \code{shared} - Return all manual DB snapshots that have been shared to
my AWS account.
\item \code{public} - Return all DB snapshots that have been marked as public.
\item \code{awsbackup} - Return the DB snapshots managed by the AWS Backup
service.

For information about AWS Backup, see the \href{https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html}{AWS Backup DeveloperGuide.}

The \code{awsbackup} type does not apply to Aurora.
}

If you don't specify a \code{SnapshotType} value, then both automated and
manual snapshots are returned. Shared and public DB snapshots are not
included in the returned results by default. You can include shared
snapshots with these results by setting the \code{IncludeShared} parameter to
\code{true}. You can include public snapshots with these results by setting
the \code{IncludePublic} parameter to \code{true}.

The \code{IncludeShared} and \code{IncludePublic} parameters don't apply for
\code{SnapshotType} values of \code{manual} or \code{automated}. The \code{IncludePublic}
parameter doesn't apply when \code{SnapshotType} is set to \code{shared}. The
\code{IncludeShared} parameter doesn't apply when \code{SnapshotType} is set to
\code{public}.}

\item{Filters}{This parameter is not currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that the remaining
results can be retrieved.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous
\code{DescribeDBSnapshots} request. If this parameter is specified, the
response includes only records beyond the marker, up to the value
specified by \code{MaxRecords}.}

\item{IncludeShared}{True to include shared manual DB snapshots from other AWS accounts that
this AWS account has been given permission to copy or restore, and
otherwise false. The default is \code{false}.

You can give an AWS account permission to restore a manual DB snapshot
from another AWS account by using the ModifyDBSnapshotAttribute API
action.}

\item{IncludePublic}{True to include manual DB snapshots that are public and can be copied or
restored by any AWS account, and otherwise false. The default is false.

You can share a manual DB snapshot as public by using the
ModifyDBSnapshotAttribute API.}

\item{DbiResourceId}{A specific DB resource ID to describe.}
}
\description{
Returns information about DB snapshots. This API action supports
pagination.
}
\section{Request syntax}{
\preformatted{svc$describe_db_snapshots(
  DBInstanceIdentifier = "string",
  DBSnapshotIdentifier = "string",
  SnapshotType = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxRecords = 123,
  Marker = "string",
  IncludeShared = TRUE|FALSE,
  IncludePublic = TRUE|FALSE,
  DbiResourceId = "string"
)
}
}

\keyword{internal}
