# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include rds_service.R
NULL

#' Associates an Identity and Access Management (IAM) role from an Amazon
#' Aurora DB cluster
#'
#' Associates an Identity and Access Management (IAM) role from an Amazon
#' Aurora DB cluster. For more information, see [Authorizing Amazon Aurora
#' MySQL to Access Other AWS Services on Your
#' Behalf](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Integrating.Authorizing.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_add_role_to_db_cluster(DBClusterIdentifier, RoleArn)
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to associate the IAM role with.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to associate with the
#' Aurora DB cluster, for example
#' `arn:aws:iam::123456789012:role/AuroraAccessRole`.
#'
#' @section Request syntax:
#' ```
#' svc$add_role_to_db_cluster(
#'   DBClusterIdentifier = "string",
#'   RoleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_add_role_to_db_cluster
rds_add_role_to_db_cluster <- function(DBClusterIdentifier, RoleArn) {
  op <- new_operation(
    name = "AddRoleToDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$add_role_to_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, RoleArn = RoleArn)
  output <- .rds$add_role_to_db_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$add_role_to_db_cluster <- rds_add_role_to_db_cluster

#' Associates an AWS Identity and Access Management (IAM) role with a DB
#' instance
#'
#' Associates an AWS Identity and Access Management (IAM) role with a DB
#' instance.
#'
#' @usage
#' rds_add_role_to_db_instance(DBInstanceIdentifier, RoleArn, FeatureName)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The name of the DB instance to associate the IAM role with.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to associate with the DB
#' instance, for example `arn:aws:iam::123456789012:role/AccessRole`.
#' @param FeatureName &#91;required&#93; The name of the feature for the DB instance that the IAM role is to be
#' associated with. For the list of supported feature names, see
#' DBEngineVersion.
#'
#' @section Request syntax:
#' ```
#' svc$add_role_to_db_instance(
#'   DBInstanceIdentifier = "string",
#'   RoleArn = "string",
#'   FeatureName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_add_role_to_db_instance
rds_add_role_to_db_instance <- function(DBInstanceIdentifier, RoleArn, FeatureName) {
  op <- new_operation(
    name = "AddRoleToDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$add_role_to_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, RoleArn = RoleArn, FeatureName = FeatureName)
  output <- .rds$add_role_to_db_instance_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$add_role_to_db_instance <- rds_add_role_to_db_instance

#' Adds a source identifier to an existing RDS event notification
#' subscription
#'
#' Adds a source identifier to an existing RDS event notification
#' subscription.
#'
#' @usage
#' rds_add_source_identifier_to_subscription(SubscriptionName,
#'   SourceIdentifier)
#'
#' @param SubscriptionName &#91;required&#93; The name of the RDS event notification subscription you want to add a
#' source identifier to.
#' @param SourceIdentifier &#91;required&#93; The identifier of the event source to be added.
#' 
#' Constraints:
#' 
#' -   If the source type is a DB instance, then a `DBInstanceIdentifier`
#'     must be supplied.
#' 
#' -   If the source type is a DB security group, a `DBSecurityGroupName`
#'     must be supplied.
#' 
#' -   If the source type is a DB parameter group, a `DBParameterGroupName`
#'     must be supplied.
#' 
#' -   If the source type is a DB snapshot, a `DBSnapshotIdentifier` must
#'     be supplied.
#'
#' @section Request syntax:
#' ```
#' svc$add_source_identifier_to_subscription(
#'   SubscriptionName = "string",
#'   SourceIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_add_source_identifier_to_subscription
rds_add_source_identifier_to_subscription <- function(SubscriptionName, SourceIdentifier) {
  op <- new_operation(
    name = "AddSourceIdentifierToSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$add_source_identifier_to_subscription_input(SubscriptionName = SubscriptionName, SourceIdentifier = SourceIdentifier)
  output <- .rds$add_source_identifier_to_subscription_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$add_source_identifier_to_subscription <- rds_add_source_identifier_to_subscription

#' Adds metadata tags to an Amazon RDS resource
#'
#' Adds metadata tags to an Amazon RDS resource. These tags can also be
#' used with cost allocation reporting to track cost associated with Amazon
#' RDS resources, or used in a Condition statement in an IAM policy for
#' Amazon RDS.
#' 
#' For an overview on tagging Amazon RDS resources, see [Tagging Amazon RDS
#' Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html).
#'
#' @usage
#' rds_add_tags_to_resource(ResourceName, Tags)
#'
#' @param ResourceName &#91;required&#93; The Amazon RDS resource that the tags are added to. This value is an
#' Amazon Resource Name (ARN). For information about creating an ARN, see
#' [Constructing an RDS Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
#' @param Tags &#91;required&#93; The tags to be assigned to the Amazon RDS resource.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags_to_resource(
#'   ResourceName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_add_tags_to_resource
rds_add_tags_to_resource <- function(ResourceName, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$add_tags_to_resource_input(ResourceName = ResourceName, Tags = Tags)
  output <- .rds$add_tags_to_resource_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$add_tags_to_resource <- rds_add_tags_to_resource

#' Applies a pending maintenance action to a resource (for example, to a DB
#' instance)
#'
#' Applies a pending maintenance action to a resource (for example, to a DB
#' instance).
#'
#' @usage
#' rds_apply_pending_maintenance_action(ResourceIdentifier, ApplyAction,
#'   OptInType)
#'
#' @param ResourceIdentifier &#91;required&#93; The RDS Amazon Resource Name (ARN) of the resource that the pending
#' maintenance action applies to. For information about creating an ARN,
#' see [Constructing an RDS Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing).
#' @param ApplyAction &#91;required&#93; The pending maintenance action to apply to this resource.
#' 
#' Valid values: `system-update`, `db-upgrade`
#' @param OptInType &#91;required&#93; A value that specifies the type of opt-in request, or undoes an opt-in
#' request. An opt-in request of type `immediate` can\'t be undone.
#' 
#' Valid values:
#' 
#' -   `immediate` - Apply the maintenance action immediately.
#' 
#' -   `next-maintenance` - Apply the maintenance action during the next
#'     maintenance window for the resource.
#' 
#' -   `undo-opt-in` - Cancel any existing `next-maintenance` opt-in
#'     requests.
#'
#' @section Request syntax:
#' ```
#' svc$apply_pending_maintenance_action(
#'   ResourceIdentifier = "string",
#'   ApplyAction = "string",
#'   OptInType = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_apply_pending_maintenance_action
rds_apply_pending_maintenance_action <- function(ResourceIdentifier, ApplyAction, OptInType) {
  op <- new_operation(
    name = "ApplyPendingMaintenanceAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$apply_pending_maintenance_action_input(ResourceIdentifier = ResourceIdentifier, ApplyAction = ApplyAction, OptInType = OptInType)
  output <- .rds$apply_pending_maintenance_action_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$apply_pending_maintenance_action <- rds_apply_pending_maintenance_action

#' Enables ingress to a DBSecurityGroup using one of two forms of
#' authorization
#'
#' Enables ingress to a DBSecurityGroup using one of two forms of
#' authorization. First, EC2 or VPC security groups can be added to the
#' DBSecurityGroup if the application using the database is running on EC2
#' or VPC instances. Second, IP ranges are available if the application
#' accessing your database is running on the Internet. Required parameters
#' for this API are one of CIDR range, EC2SecurityGroupId for VPC, or
#' (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or
#' EC2SecurityGroupId for non-VPC).
#' 
#' You can\'t authorize ingress from an EC2 security group in one AWS
#' Region to an Amazon RDS DB instance in another. You can\'t authorize
#' ingress from a VPC security group in one VPC to an Amazon RDS DB
#' instance in another.
#' 
#' For an overview of CIDR ranges, go to the [Wikipedia
#' Tutorial](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
#'
#' @usage
#' rds_authorize_db_security_group_ingress(DBSecurityGroupName, CIDRIP,
#'   EC2SecurityGroupName, EC2SecurityGroupId, EC2SecurityGroupOwnerId)
#'
#' @param DBSecurityGroupName &#91;required&#93; The name of the DB security group to add authorization to.
#' @param CIDRIP The IP range to authorize.
#' @param EC2SecurityGroupName Name of the EC2 security group to authorize. For VPC DB security groups,
#' `EC2SecurityGroupId` must be provided. Otherwise,
#' `EC2SecurityGroupOwnerId` and either `EC2SecurityGroupName` or
#' `EC2SecurityGroupId` must be provided.
#' @param EC2SecurityGroupId Id of the EC2 security group to authorize. For VPC DB security groups,
#' `EC2SecurityGroupId` must be provided. Otherwise,
#' `EC2SecurityGroupOwnerId` and either `EC2SecurityGroupName` or
#' `EC2SecurityGroupId` must be provided.
#' @param EC2SecurityGroupOwnerId AWS account number of the owner of the EC2 security group specified in
#' the `EC2SecurityGroupName` parameter. The AWS Access Key ID is not an
#' acceptable value. For VPC DB security groups, `EC2SecurityGroupId` must
#' be provided. Otherwise, `EC2SecurityGroupOwnerId` and either
#' `EC2SecurityGroupName` or `EC2SecurityGroupId` must be provided.
#'
#' @section Request syntax:
#' ```
#' svc$authorize_db_security_group_ingress(
#'   DBSecurityGroupName = "string",
#'   CIDRIP = "string",
#'   EC2SecurityGroupName = "string",
#'   EC2SecurityGroupId = "string",
#'   EC2SecurityGroupOwnerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_authorize_db_security_group_ingress
rds_authorize_db_security_group_ingress <- function(DBSecurityGroupName, CIDRIP = NULL, EC2SecurityGroupName = NULL, EC2SecurityGroupId = NULL, EC2SecurityGroupOwnerId = NULL) {
  op <- new_operation(
    name = "AuthorizeDBSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$authorize_db_security_group_ingress_input(DBSecurityGroupName = DBSecurityGroupName, CIDRIP = CIDRIP, EC2SecurityGroupName = EC2SecurityGroupName, EC2SecurityGroupId = EC2SecurityGroupId, EC2SecurityGroupOwnerId = EC2SecurityGroupOwnerId)
  output <- .rds$authorize_db_security_group_ingress_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$authorize_db_security_group_ingress <- rds_authorize_db_security_group_ingress

#' Backtracks a DB cluster to a specific time, without creating a new DB
#' cluster
#'
#' Backtracks a DB cluster to a specific time, without creating a new DB
#' cluster.
#' 
#' For more information on backtracking, see [Backtracking an Aurora DB
#' Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_backtrack_db_cluster(DBClusterIdentifier, BacktrackTo, Force,
#'   UseEarliestTimeOnPointInTimeUnavailable)
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the DB cluster to be backtracked. This
#' parameter is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 alphanumeric characters or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1`
#' @param BacktrackTo &#91;required&#93; The timestamp of the time to backtrack the DB cluster to, specified in
#' ISO 8601 format. For more information about ISO 8601, see the [ISO8601
#' Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
#' 
#' If the specified time is not a consistent time for the DB cluster,
#' Aurora automatically chooses the nearest possible consistent time for
#' the DB cluster.
#' 
#' Constraints:
#' 
#' -   Must contain a valid ISO 8601 timestamp.
#' 
#' -   Can\'t contain a timestamp set in the future.
#' 
#' Example: `2017-07-08T18:00Z`
#' @param Force A value that, if specified, forces the DB cluster to backtrack when
#' binary logging is enabled. Otherwise, an error occurs when binary
#' logging is enabled.
#' @param UseEarliestTimeOnPointInTimeUnavailable If *BacktrackTo* is set to a timestamp earlier than the earliest
#' backtrack time, this value backtracks the DB cluster to the earliest
#' possible backtrack time. Otherwise, an error occurs.
#'
#' @section Request syntax:
#' ```
#' svc$backtrack_db_cluster(
#'   DBClusterIdentifier = "string",
#'   BacktrackTo = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Force = TRUE|FALSE,
#'   UseEarliestTimeOnPointInTimeUnavailable = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_backtrack_db_cluster
rds_backtrack_db_cluster <- function(DBClusterIdentifier, BacktrackTo, Force = NULL, UseEarliestTimeOnPointInTimeUnavailable = NULL) {
  op <- new_operation(
    name = "BacktrackDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$backtrack_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, BacktrackTo = BacktrackTo, Force = Force, UseEarliestTimeOnPointInTimeUnavailable = UseEarliestTimeOnPointInTimeUnavailable)
  output <- .rds$backtrack_db_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$backtrack_db_cluster <- rds_backtrack_db_cluster

#' Copies the specified DB cluster parameter group
#'
#' Copies the specified DB cluster parameter group.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_copy_db_cluster_parameter_group(
#'   SourceDBClusterParameterGroupIdentifier,
#'   TargetDBClusterParameterGroupIdentifier,
#'   TargetDBClusterParameterGroupDescription, Tags)
#'
#' @param SourceDBClusterParameterGroupIdentifier &#91;required&#93; The identifier or Amazon Resource Name (ARN) for the source DB cluster
#' parameter group. For information about creating an ARN, see
#' [Constructing an ARN for Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
#' in the *Amazon Aurora User Guide*.
#' 
#' Constraints:
#' 
#' -   Must specify a valid DB cluster parameter group.
#' 
#' -   If the source DB cluster parameter group is in the same AWS Region
#'     as the copy, specify a valid DB parameter group identifier, for
#'     example `my-db-cluster-param-group`, or a valid ARN.
#' 
#' -   If the source DB parameter group is in a different AWS Region than
#'     the copy, specify a valid DB cluster parameter group ARN, for
#'     example
#'     `arn:aws:rds:us-east-1:123456789012:cluster-pg:custom-cluster-group1`.
#' @param TargetDBClusterParameterGroupIdentifier &#91;required&#93; The identifier for the copied DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Can\'t be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-cluster-param-group1`
#' @param TargetDBClusterParameterGroupDescription &#91;required&#93; A description for the copied DB cluster parameter group.
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$copy_db_cluster_parameter_group(
#'   SourceDBClusterParameterGroupIdentifier = "string",
#'   TargetDBClusterParameterGroupIdentifier = "string",
#'   TargetDBClusterParameterGroupDescription = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_copy_db_cluster_parameter_group
rds_copy_db_cluster_parameter_group <- function(SourceDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$copy_db_cluster_parameter_group_input(SourceDBClusterParameterGroupIdentifier = SourceDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupIdentifier = TargetDBClusterParameterGroupIdentifier, TargetDBClusterParameterGroupDescription = TargetDBClusterParameterGroupDescription, Tags = Tags)
  output <- .rds$copy_db_cluster_parameter_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$copy_db_cluster_parameter_group <- rds_copy_db_cluster_parameter_group

#' Copies a snapshot of a DB cluster
#'
#' Copies a snapshot of a DB cluster.
#' 
#' To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
#' `SourceDBClusterSnapshotIdentifier` must be the Amazon Resource Name
#' (ARN) of the shared DB cluster snapshot.
#' 
#' You can copy an encrypted DB cluster snapshot from another AWS Region.
#' In that case, the AWS Region where you call the `CopyDBClusterSnapshot`
#' action is the destination AWS Region for the encrypted DB cluster
#' snapshot to be copied to. To copy an encrypted DB cluster snapshot from
#' another AWS Region, you must provide the following values:
#' 
#' -   `KmsKeyId` - The AWS Key Management System (AWS KMS) key identifier
#'     for the key to use to encrypt the copy of the DB cluster snapshot in
#'     the destination AWS Region.
#' 
#' -   `PreSignedUrl` - A URL that contains a Signature Version 4 signed
#'     request for the `CopyDBClusterSnapshot` action to be called in the
#'     source AWS Region where the DB cluster snapshot is copied from. The
#'     pre-signed URL must be a valid request for the
#'     `CopyDBClusterSnapshot` API action that can be executed in the
#'     source AWS Region that contains the encrypted DB cluster snapshot to
#'     be copied.
#' 
#'     The pre-signed URL request must contain the following parameter
#'     values:
#' 
#'     -   `KmsKeyId` - The KMS key identifier for the key to use to
#'         encrypt the copy of the DB cluster snapshot in the destination
#'         AWS Region. This is the same identifier for both the
#'         `CopyDBClusterSnapshot` action that is called in the destination
#'         AWS Region, and the action contained in the pre-signed URL.
#' 
#'     -   `DestinationRegion` - The name of the AWS Region that the DB
#'         cluster snapshot will be created in.
#' 
#'     -   `SourceDBClusterSnapshotIdentifier` - The DB cluster snapshot
#'         identifier for the encrypted DB cluster snapshot to be copied.
#'         This identifier must be in the Amazon Resource Name (ARN) format
#'         for the source AWS Region. For example, if you are copying an
#'         encrypted DB cluster snapshot from the us-west-2 AWS Region,
#'         then your `SourceDBClusterSnapshotIdentifier` looks like the
#'         following example:
#'         `arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115`.
#' 
#'     To learn how to generate a Signature Version 4 signed request, see
#'     [Authenticating Requests: Using Query Parameters (AWS Signature
#'     Version 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#'     and [Signature Version 4 Signing
#'     Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#' 
#' -   `TargetDBClusterSnapshotIdentifier` - The identifier for the new
#'     copy of the DB cluster snapshot in the destination AWS Region.
#' 
#' -   `SourceDBClusterSnapshotIdentifier` - The DB cluster snapshot
#'     identifier for the encrypted DB cluster snapshot to be copied. This
#'     identifier must be in the ARN format for the source AWS Region and
#'     is the same value as the `SourceDBClusterSnapshotIdentifier` in the
#'     pre-signed URL.
#' 
#' To cancel the copy operation once it is in progress, delete the target
#' DB cluster snapshot identified by `TargetDBClusterSnapshotIdentifier`
#' while that DB cluster snapshot is in \"copying\" status.
#' 
#' For more information on copying encrypted DB cluster snapshots from one
#' AWS Region to another, see [Copying a
#' Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_copy_db_cluster_snapshot(SourceDBClusterSnapshotIdentifier,
#'   TargetDBClusterSnapshotIdentifier, KmsKeyId, PreSignedUrl, CopyTags,
#'   Tags, SourceRegion)
#'
#' @param SourceDBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot to copy. This parameter is not
#' case-sensitive.
#' 
#' You can\'t copy an encrypted, shared DB cluster snapshot from one AWS
#' Region to another.
#' 
#' Constraints:
#' 
#' -   Must specify a valid system snapshot in the \"available\" state.
#' 
#' -   If the source snapshot is in the same AWS Region as the copy,
#'     specify a valid DB snapshot identifier.
#' 
#' -   If the source snapshot is in a different AWS Region than the copy,
#'     specify a valid DB cluster snapshot ARN. For more information, go to
#'     [Copying Snapshots Across AWS
#'     Regions](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html#USER_CopySnapshot.AcrossRegions)
#'     in the *Amazon Aurora User Guide.*
#' 
#' Example: `my-cluster-snapshot1`
#' @param TargetDBClusterSnapshotIdentifier &#91;required&#93; The identifier of the new DB cluster snapshot to create from the source
#' DB cluster snapshot. This parameter is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster-snapshot2`
#' @param KmsKeyId The AWS AWS KMS key ID for an encrypted DB cluster snapshot. The KMS key
#' ID is the Amazon Resource Name (ARN), KMS key identifier, or the KMS key
#' alias for the KMS encryption key.
#' 
#' If you copy an encrypted DB cluster snapshot from your AWS account, you
#' can specify a value for `KmsKeyId` to encrypt the copy with a new KMS
#' encryption key. If you don\'t specify a value for `KmsKeyId`, then the
#' copy of the DB cluster snapshot is encrypted with the same KMS key as
#' the source DB cluster snapshot.
#' 
#' If you copy an encrypted DB cluster snapshot that is shared from another
#' AWS account, then you must specify a value for `KmsKeyId`.
#' 
#' To copy an encrypted DB cluster snapshot to another AWS Region, you must
#' set `KmsKeyId` to the KMS key ID you want to use to encrypt the copy of
#' the DB cluster snapshot in the destination AWS Region. KMS encryption
#' keys are specific to the AWS Region that they are created in, and you
#' can\'t use encryption keys from one AWS Region in another AWS Region.
#' 
#' If you copy an unencrypted DB cluster snapshot and specify a value for
#' the `KmsKeyId` parameter, an error is returned.
#' @param PreSignedUrl The URL that contains a Signature Version 4 signed request for the
#' `CopyDBClusterSnapshot` API action in the AWS Region that contains the
#' source DB cluster snapshot to copy. The `PreSignedUrl` parameter must be
#' used when copying an encrypted DB cluster snapshot from another AWS
#' Region.
#' 
#' The pre-signed URL must be a valid request for the
#' `CopyDBSClusterSnapshot` API action that can be executed in the source
#' AWS Region that contains the encrypted DB cluster snapshot to be copied.
#' The pre-signed URL request must contain the following parameter values:
#' 
#' -   `KmsKeyId` - The AWS KMS key identifier for the key to use to
#'     encrypt the copy of the DB cluster snapshot in the destination AWS
#'     Region. This is the same identifier for both the
#'     `CopyDBClusterSnapshot` action that is called in the destination AWS
#'     Region, and the action contained in the pre-signed URL.
#' 
#' -   `DestinationRegion` - The name of the AWS Region that the DB cluster
#'     snapshot will be created in.
#' 
#' -   `SourceDBClusterSnapshotIdentifier` - The DB cluster snapshot
#'     identifier for the encrypted DB cluster snapshot to be copied. This
#'     identifier must be in the Amazon Resource Name (ARN) format for the
#'     source AWS Region. For example, if you are copying an encrypted DB
#'     cluster snapshot from the us-west-2 AWS Region, then your
#'     `SourceDBClusterSnapshotIdentifier` looks like the following
#'     example:
#'     `arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115`.
#' 
#' To learn how to generate a Signature Version 4 signed request, see
#' [Authenticating Requests: Using Query Parameters (AWS Signature Version
#' 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#' and [Signature Version 4 Signing
#' Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#' 
#' If you supply a value for this operation\'s `SourceRegion` parameter, a
#' pre-signed URL will be calculated on your behalf.
#' @param CopyTags True to copy all tags from the source DB cluster snapshot to the target
#' DB cluster snapshot, and otherwise false. The default is false.
#' @param Tags 
#' @param SourceRegion The ID of the region that contains the snapshot to be copied.
#'
#' @section Request syntax:
#' ```
#' svc$copy_db_cluster_snapshot(
#'   SourceDBClusterSnapshotIdentifier = "string",
#'   TargetDBClusterSnapshotIdentifier = "string",
#'   KmsKeyId = "string",
#'   PreSignedUrl = "string",
#'   CopyTags = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   SourceRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_copy_db_cluster_snapshot
rds_copy_db_cluster_snapshot <- function(SourceDBClusterSnapshotIdentifier, TargetDBClusterSnapshotIdentifier, KmsKeyId = NULL, PreSignedUrl = NULL, CopyTags = NULL, Tags = NULL, SourceRegion = NULL) {
  op <- new_operation(
    name = "CopyDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$copy_db_cluster_snapshot_input(SourceDBClusterSnapshotIdentifier = SourceDBClusterSnapshotIdentifier, TargetDBClusterSnapshotIdentifier = TargetDBClusterSnapshotIdentifier, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, CopyTags = CopyTags, Tags = Tags, SourceRegion = SourceRegion)
  output <- .rds$copy_db_cluster_snapshot_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$copy_db_cluster_snapshot <- rds_copy_db_cluster_snapshot

#' Copies the specified DB parameter group
#'
#' Copies the specified DB parameter group.
#'
#' @usage
#' rds_copy_db_parameter_group(SourceDBParameterGroupIdentifier,
#'   TargetDBParameterGroupIdentifier, TargetDBParameterGroupDescription,
#'   Tags)
#'
#' @param SourceDBParameterGroupIdentifier &#91;required&#93; The identifier or ARN for the source DB parameter group. For information
#' about creating an ARN, see [Constructing an ARN for Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
#' in the *Amazon RDS User Guide*.
#' 
#' Constraints:
#' 
#' -   Must specify a valid DB parameter group.
#' 
#' -   Must specify a valid DB parameter group identifier, for example
#'     `my-db-param-group`, or a valid ARN.
#' @param TargetDBParameterGroupIdentifier &#91;required&#93; The identifier for the copied DB parameter group.
#' 
#' Constraints:
#' 
#' -   Can\'t be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-db-parameter-group`
#' @param TargetDBParameterGroupDescription &#91;required&#93; A description for the copied DB parameter group.
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$copy_db_parameter_group(
#'   SourceDBParameterGroupIdentifier = "string",
#'   TargetDBParameterGroupIdentifier = "string",
#'   TargetDBParameterGroupDescription = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_copy_db_parameter_group
rds_copy_db_parameter_group <- function(SourceDBParameterGroupIdentifier, TargetDBParameterGroupIdentifier, TargetDBParameterGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CopyDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$copy_db_parameter_group_input(SourceDBParameterGroupIdentifier = SourceDBParameterGroupIdentifier, TargetDBParameterGroupIdentifier = TargetDBParameterGroupIdentifier, TargetDBParameterGroupDescription = TargetDBParameterGroupDescription, Tags = Tags)
  output <- .rds$copy_db_parameter_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$copy_db_parameter_group <- rds_copy_db_parameter_group

#' Copies the specified DB snapshot
#'
#' Copies the specified DB snapshot. The source DB snapshot must be in the
#' \"available\" state.
#' 
#' You can copy a snapshot from one AWS Region to another. In that case,
#' the AWS Region where you call the `CopyDBSnapshot` action is the
#' destination AWS Region for the DB snapshot copy.
#' 
#' For more information about copying snapshots, see [Copying a DB
#' Snapshot](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopyDBSnapshot.html)
#' in the *Amazon RDS User Guide.*
#'
#' @usage
#' rds_copy_db_snapshot(SourceDBSnapshotIdentifier,
#'   TargetDBSnapshotIdentifier, KmsKeyId, Tags, CopyTags, PreSignedUrl,
#'   OptionGroupName, SourceRegion)
#'
#' @param SourceDBSnapshotIdentifier &#91;required&#93; The identifier for the source DB snapshot.
#' 
#' If the source snapshot is in the same AWS Region as the copy, specify a
#' valid DB snapshot identifier. For example, you might specify
#' `rds:mysql-instance1-snapshot-20130805`.
#' 
#' If the source snapshot is in a different AWS Region than the copy,
#' specify a valid DB snapshot ARN. For example, you might specify
#' `arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805`.
#' 
#' If you are copying from a shared manual DB snapshot, this parameter must
#' be the Amazon Resource Name (ARN) of the shared DB snapshot.
#' 
#' If you are copying an encrypted snapshot this parameter must be in the
#' ARN format for the source AWS Region, and must match the
#' `SourceDBSnapshotIdentifier` in the `PreSignedUrl` parameter.
#' 
#' Constraints:
#' 
#' -   Must specify a valid system snapshot in the \"available\" state.
#' 
#' Example: `rds:mydb-2012-04-02-00-01`
#' 
#' Example:
#' `arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805`
#' @param TargetDBSnapshotIdentifier &#91;required&#93; The identifier for the copy of the snapshot.
#' 
#' Constraints:
#' 
#' -   Can\'t be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-db-snapshot`
#' @param KmsKeyId The AWS KMS key ID for an encrypted DB snapshot. The KMS key ID is the
#' Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for
#' the KMS encryption key.
#' 
#' If you copy an encrypted DB snapshot from your AWS account, you can
#' specify a value for this parameter to encrypt the copy with a new KMS
#' encryption key. If you don\'t specify a value for this parameter, then
#' the copy of the DB snapshot is encrypted with the same KMS key as the
#' source DB snapshot.
#' 
#' If you copy an encrypted DB snapshot that is shared from another AWS
#' account, then you must specify a value for this parameter.
#' 
#' If you specify this parameter when you copy an unencrypted snapshot, the
#' copy is encrypted.
#' 
#' If you copy an encrypted snapshot to a different AWS Region, then you
#' must specify a KMS key for the destination AWS Region. KMS encryption
#' keys are specific to the AWS Region that they are created in, and you
#' can\'t use encryption keys from one AWS Region in another AWS Region.
#' @param Tags 
#' @param CopyTags True to copy all tags from the source DB snapshot to the target DB
#' snapshot, and otherwise false. The default is false.
#' @param PreSignedUrl The URL that contains a Signature Version 4 signed request for the
#' `CopyDBSnapshot` API action in the source AWS Region that contains the
#' source DB snapshot to copy.
#' 
#' You must specify this parameter when you copy an encrypted DB snapshot
#' from another AWS Region by using the Amazon RDS API. You can specify the
#' `--source-region` option instead of this parameter when you copy an
#' encrypted DB snapshot from another AWS Region by using the AWS CLI.
#' 
#' The presigned URL must be a valid request for the `CopyDBSnapshot` API
#' action that can be executed in the source AWS Region that contains the
#' encrypted DB snapshot to be copied. The presigned URL request must
#' contain the following parameter values:
#' 
#' -   `DestinationRegion` - The AWS Region that the encrypted DB snapshot
#'     is copied to. This AWS Region is the same one where the
#'     `CopyDBSnapshot` action is called that contains this presigned URL.
#' 
#'     For example, if you copy an encrypted DB snapshot from the us-west-2
#'     AWS Region to the us-east-1 AWS Region, then you call the
#'     `CopyDBSnapshot` action in the us-east-1 AWS Region and provide a
#'     presigned URL that contains a call to the `CopyDBSnapshot` action in
#'     the us-west-2 AWS Region. For this example, the `DestinationRegion`
#'     in the presigned URL must be set to the us-east-1 AWS Region.
#' 
#' -   `KmsKeyId` - The AWS KMS key identifier for the key to use to
#'     encrypt the copy of the DB snapshot in the destination AWS Region.
#'     This is the same identifier for both the `CopyDBSnapshot` action
#'     that is called in the destination AWS Region, and the action
#'     contained in the presigned URL.
#' 
#' -   `SourceDBSnapshotIdentifier` - The DB snapshot identifier for the
#'     encrypted snapshot to be copied. This identifier must be in the
#'     Amazon Resource Name (ARN) format for the source AWS Region. For
#'     example, if you are copying an encrypted DB snapshot from the
#'     us-west-2 AWS Region, then your `SourceDBSnapshotIdentifier` looks
#'     like the following example:
#'     `arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115`.
#' 
#' To learn how to generate a Signature Version 4 signed request, see
#' [Authenticating Requests: Using Query Parameters (AWS Signature Version
#' 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#' and [Signature Version 4 Signing
#' Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#' 
#' If you supply a value for this operation\'s `SourceRegion` parameter, a
#' pre-signed URL will be calculated on your behalf.
#' @param OptionGroupName The name of an option group to associate with the copy of the snapshot.
#' 
#' Specify this option if you are copying a snapshot from one AWS Region to
#' another, and your DB instance uses a nondefault option group. If your
#' source DB instance uses Transparent Data Encryption for Oracle or
#' Microsoft SQL Server, you must specify this option when copying across
#' AWS Regions. For more information, see [Option Group
#' Considerations](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopySnapshot.Options)
#' in the *Amazon RDS User Guide.*
#' @param SourceRegion The ID of the region that contains the snapshot to be copied.
#'
#' @section Request syntax:
#' ```
#' svc$copy_db_snapshot(
#'   SourceDBSnapshotIdentifier = "string",
#'   TargetDBSnapshotIdentifier = "string",
#'   KmsKeyId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   CopyTags = TRUE|FALSE,
#'   PreSignedUrl = "string",
#'   OptionGroupName = "string",
#'   SourceRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_copy_db_snapshot
rds_copy_db_snapshot <- function(SourceDBSnapshotIdentifier, TargetDBSnapshotIdentifier, KmsKeyId = NULL, Tags = NULL, CopyTags = NULL, PreSignedUrl = NULL, OptionGroupName = NULL, SourceRegion = NULL) {
  op <- new_operation(
    name = "CopyDBSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$copy_db_snapshot_input(SourceDBSnapshotIdentifier = SourceDBSnapshotIdentifier, TargetDBSnapshotIdentifier = TargetDBSnapshotIdentifier, KmsKeyId = KmsKeyId, Tags = Tags, CopyTags = CopyTags, PreSignedUrl = PreSignedUrl, OptionGroupName = OptionGroupName, SourceRegion = SourceRegion)
  output <- .rds$copy_db_snapshot_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$copy_db_snapshot <- rds_copy_db_snapshot

#' Copies the specified option group
#'
#' Copies the specified option group.
#'
#' @usage
#' rds_copy_option_group(SourceOptionGroupIdentifier,
#'   TargetOptionGroupIdentifier, TargetOptionGroupDescription, Tags)
#'
#' @param SourceOptionGroupIdentifier &#91;required&#93; The identifier or ARN for the source option group. For information about
#' creating an ARN, see [Constructing an ARN for Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
#' in the *Amazon RDS User Guide*.
#' 
#' Constraints:
#' 
#' -   Must specify a valid option group.
#' 
#' -   If the source option group is in the same AWS Region as the copy,
#'     specify a valid option group identifier, for example
#'     `my-option-group`, or a valid ARN.
#' 
#' -   If the source option group is in a different AWS Region than the
#'     copy, specify a valid option group ARN, for example
#'     `arn:aws:rds:us-west-2:123456789012:og:special-options`.
#' @param TargetOptionGroupIdentifier &#91;required&#93; The identifier for the copied option group.
#' 
#' Constraints:
#' 
#' -   Can\'t be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-option-group`
#' @param TargetOptionGroupDescription &#91;required&#93; The description for the copied option group.
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$copy_option_group(
#'   SourceOptionGroupIdentifier = "string",
#'   TargetOptionGroupIdentifier = "string",
#'   TargetOptionGroupDescription = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_copy_option_group
rds_copy_option_group <- function(SourceOptionGroupIdentifier, TargetOptionGroupIdentifier, TargetOptionGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CopyOptionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$copy_option_group_input(SourceOptionGroupIdentifier = SourceOptionGroupIdentifier, TargetOptionGroupIdentifier = TargetOptionGroupIdentifier, TargetOptionGroupDescription = TargetOptionGroupDescription, Tags = Tags)
  output <- .rds$copy_option_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$copy_option_group <- rds_copy_option_group

#' Creates a new Amazon Aurora DB cluster
#'
#' Creates a new Amazon Aurora DB cluster.
#' 
#' You can use the `ReplicationSourceIdentifier` parameter to create the DB
#' cluster as a Read Replica of another DB cluster or Amazon RDS MySQL DB
#' instance. For cross-region replication where the DB cluster identified
#' by `ReplicationSourceIdentifier` is encrypted, you must also specify the
#' `PreSignedUrl` parameter.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_create_db_cluster(AvailabilityZones, BackupRetentionPeriod,
#'   CharacterSetName, DatabaseName, DBClusterIdentifier,
#'   DBClusterParameterGroupName, VpcSecurityGroupIds, DBSubnetGroupName,
#'   Engine, EngineVersion, Port, MasterUsername, MasterUserPassword,
#'   OptionGroupName, PreferredBackupWindow, PreferredMaintenanceWindow,
#'   ReplicationSourceIdentifier, Tags, StorageEncrypted, KmsKeyId,
#'   PreSignedUrl, EnableIAMDatabaseAuthentication, BacktrackWindow,
#'   EnableCloudwatchLogsExports, EngineMode, ScalingConfiguration,
#'   DeletionProtection, GlobalClusterIdentifier, CopyTagsToSnapshot,
#'   SourceRegion)
#'
#' @param AvailabilityZones A list of EC2 Availability Zones that instances in the DB cluster can be
#' created in. For information on AWS Regions and Availability Zones, see
#' [Choosing the Regions and Availability
#' Zones](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.RegionsAndAvailabilityZones.html)
#' in the *Amazon Aurora User Guide*.
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. You must
#' specify a minimum value of 1.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35
#' @param CharacterSetName A value that indicates that the DB cluster should be associated with the
#' specified CharacterSet.
#' @param DatabaseName The name for your database of up to 64 alpha-numeric characters. If you
#' do not provide a name, Amazon RDS will not create a database in the DB
#' cluster you are creating.
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1`
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB
#' cluster. If this argument is omitted, `default.aurora5.6` is used.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DB cluster parameter
#'     group.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB cluster.
#' @param DBSubnetGroupName A DB subnet group to associate with this DB cluster.
#' 
#' Constraints: Must match the name of an existing DBSubnetGroup. Must not
#' be default.
#' 
#' Example: `mySubnetgroup`
#' @param Engine &#91;required&#93; The name of the database engine to be used for this DB cluster.
#' 
#' Valid Values: `aurora` (for MySQL 5.6-compatible Aurora), `aurora-mysql`
#' (for MySQL 5.7-compatible Aurora), and `aurora-postgresql`
#' @param EngineVersion The version number of the database engine to use.
#' 
#' **Aurora MySQL**
#' 
#' Example: `5.6.10a`, `5.7.12`
#' 
#' **Aurora PostgreSQL**
#' 
#' Example: `9.6.3`
#' @param Port The port number on which the instances in the DB cluster accept
#' connections.
#' 
#' Default: `3306` if engine is set as aurora or `5432` if set to
#' aurora-postgresql.
#' @param MasterUsername The name of the master user for the DB cluster.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 16 letters or numbers.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t be a reserved word for the chosen database engine.
#' @param MasterUserPassword The password for the master database user. This password can contain any
#' printable ASCII character except \"/\", \"\"\", or \"@\".
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' @param OptionGroupName A value that indicates that the DB cluster should be associated with the
#' specified option group.
#' 
#' Permanent options can\'t be removed from an option group. The option
#' group can\'t be removed from a DB cluster once it is associated with a
#' DB cluster.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region. To see the time blocks available, see
#' [Adjusting the Preferred DB Cluster Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora)
#' in the *Amazon Aurora User Guide.*
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week. To see the time blocks available, see [Adjusting the Preferred DB
#' Cluster Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora)
#' in the *Amazon Aurora User Guide.*
#' 
#' Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' Constraints: Minimum 30-minute window.
#' @param ReplicationSourceIdentifier The Amazon Resource Name (ARN) of the source DB instance or DB cluster
#' if this DB cluster is created as a Read Replica.
#' @param Tags 
#' @param StorageEncrypted Specifies whether the DB cluster is encrypted.
#' @param KmsKeyId The AWS KMS key identifier for an encrypted DB cluster.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are creating a DB cluster with the same AWS
#' account that owns the KMS encryption key used to encrypt the new DB
#' cluster, then you can use the KMS key alias instead of the ARN for the
#' KMS encryption key.
#' 
#' If an encryption key is not specified in `KmsKeyId`:
#' 
#' -   If `ReplicationSourceIdentifier` identifies an encrypted source,
#'     then Amazon RDS will use the encryption key used to encrypt the
#'     source. Otherwise, Amazon RDS will use your default encryption key.
#' 
#' -   If the `StorageEncrypted` parameter is true and
#'     `ReplicationSourceIdentifier` is not specified, then Amazon RDS will
#'     use your default encryption key.
#' 
#' AWS KMS creates the default encryption key for your AWS account. Your
#' AWS account has a different default encryption key for each AWS Region.
#' 
#' If you create a Read Replica of an encrypted DB cluster in another AWS
#' Region, you must set `KmsKeyId` to a KMS key ID that is valid in the
#' destination AWS Region. This key is used to encrypt the Read Replica in
#' that AWS Region.
#' @param PreSignedUrl A URL that contains a Signature Version 4 signed request for the
#' `CreateDBCluster` action to be called in the source AWS Region where the
#' DB cluster is replicated from. You only need to specify `PreSignedUrl`
#' when you are performing cross-region replication from an encrypted DB
#' cluster.
#' 
#' The pre-signed URL must be a valid request for the `CreateDBCluster` API
#' action that can be executed in the source AWS Region that contains the
#' encrypted DB cluster to be copied.
#' 
#' The pre-signed URL request must contain the following parameter values:
#' 
#' -   `KmsKeyId` - The AWS KMS key identifier for the key to use to
#'     encrypt the copy of the DB cluster in the destination AWS Region.
#'     This should refer to the same KMS key for both the `CreateDBCluster`
#'     action that is called in the destination AWS Region, and the action
#'     contained in the pre-signed URL.
#' 
#' -   `DestinationRegion` - The name of the AWS Region that Aurora Read
#'     Replica will be created in.
#' 
#' -   `ReplicationSourceIdentifier` - The DB cluster identifier for the
#'     encrypted DB cluster to be copied. This identifier must be in the
#'     Amazon Resource Name (ARN) format for the source AWS Region. For
#'     example, if you are copying an encrypted DB cluster from the
#'     us-west-2 AWS Region, then your `ReplicationSourceIdentifier` would
#'     look like Example:
#'     `arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1`.
#' 
#' To learn how to generate a Signature Version 4 signed request, see
#' [Authenticating Requests: Using Query Parameters (AWS Signature Version
#' 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#' and [Signature Version 4 Signing
#' Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#' 
#' If you supply a value for this operation\'s `SourceRegion` parameter, a
#' pre-signed URL will be calculated on your behalf.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param BacktrackWindow The target backtrack window, in seconds. To disable backtracking, set
#' this value to 0.
#' 
#' Default: 0
#' 
#' Constraints:
#' 
#' -   If specified, this value must be set to a number from 0 to 259,200
#'     (72 hours).
#' @param EnableCloudwatchLogsExports The list of log types that need to be enabled for exporting to
#' CloudWatch Logs. The values in the list depend on the DB engine being
#' used. For more information, see [Publishing Database Logs to Amazon
#' CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon Aurora User Guide*.
#' @param EngineMode The DB engine mode of the DB cluster, either `provisioned`,
#' `serverless`, `parallelquery`, or `global`.
#' @param ScalingConfiguration For DB clusters in `serverless` DB engine mode, the scaling properties
#' of the DB cluster.
#' @param DeletionProtection Indicates if the DB cluster should have deletion protection enabled. The
#' database can\'t be deleted when this value is set to true. The default
#' is false.
#' @param GlobalClusterIdentifier The global cluster ID of an Aurora cluster that becomes the primary
#' cluster in the new global database cluster.
#' @param CopyTagsToSnapshot True to copy all tags from the DB cluster to snapshots of the DB
#' cluster, and otherwise false. The default is false.
#' @param SourceRegion The ID of the region that contains the source for the read replica.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_cluster(
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   BackupRetentionPeriod = 123,
#'   CharacterSetName = "string",
#'   DatabaseName = "string",
#'   DBClusterIdentifier = "string",
#'   DBClusterParameterGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   DBSubnetGroupName = "string",
#'   Engine = "string",
#'   EngineVersion = "string",
#'   Port = 123,
#'   MasterUsername = "string",
#'   MasterUserPassword = "string",
#'   OptionGroupName = "string",
#'   PreferredBackupWindow = "string",
#'   PreferredMaintenanceWindow = "string",
#'   ReplicationSourceIdentifier = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   StorageEncrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   PreSignedUrl = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   BacktrackWindow = 123,
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   EngineMode = "string",
#'   ScalingConfiguration = list(
#'     MinCapacity = 123,
#'     MaxCapacity = 123,
#'     AutoPause = TRUE|FALSE,
#'     SecondsUntilAutoPause = 123
#'   ),
#'   DeletionProtection = TRUE|FALSE,
#'   GlobalClusterIdentifier = "string",
#'   CopyTagsToSnapshot = TRUE|FALSE,
#'   SourceRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_db_cluster
rds_create_db_cluster <- function(AvailabilityZones = NULL, BackupRetentionPeriod = NULL, CharacterSetName = NULL, DatabaseName = NULL, DBClusterIdentifier, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, DBSubnetGroupName = NULL, Engine, EngineVersion = NULL, Port = NULL, MasterUsername = NULL, MasterUserPassword = NULL, OptionGroupName = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, ReplicationSourceIdentifier = NULL, Tags = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, PreSignedUrl = NULL, EnableIAMDatabaseAuthentication = NULL, BacktrackWindow = NULL, EnableCloudwatchLogsExports = NULL, EngineMode = NULL, ScalingConfiguration = NULL, DeletionProtection = NULL, GlobalClusterIdentifier = NULL, CopyTagsToSnapshot = NULL, SourceRegion = NULL) {
  op <- new_operation(
    name = "CreateDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_cluster_input(AvailabilityZones = AvailabilityZones, BackupRetentionPeriod = BackupRetentionPeriod, CharacterSetName = CharacterSetName, DatabaseName = DatabaseName, DBClusterIdentifier = DBClusterIdentifier, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, DBSubnetGroupName = DBSubnetGroupName, Engine = Engine, EngineVersion = EngineVersion, Port = Port, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, OptionGroupName = OptionGroupName, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, ReplicationSourceIdentifier = ReplicationSourceIdentifier, Tags = Tags, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, BacktrackWindow = BacktrackWindow, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, EngineMode = EngineMode, ScalingConfiguration = ScalingConfiguration, DeletionProtection = DeletionProtection, GlobalClusterIdentifier = GlobalClusterIdentifier, CopyTagsToSnapshot = CopyTagsToSnapshot, SourceRegion = SourceRegion)
  output <- .rds$create_db_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_cluster <- rds_create_db_cluster

#' Creates a new custom endpoint and associates it with an Amazon Aurora DB
#' cluster
#'
#' Creates a new custom endpoint and associates it with an Amazon Aurora DB
#' cluster.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_create_db_cluster_endpoint(DBClusterIdentifier,
#'   DBClusterEndpointIdentifier, EndpointType, StaticMembers,
#'   ExcludedMembers)
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the DB cluster associated with the
#' endpoint. This parameter is stored as a lowercase string.
#' @param DBClusterEndpointIdentifier &#91;required&#93; The identifier to use for the new endpoint. This parameter is stored as
#' a lowercase string.
#' @param EndpointType &#91;required&#93; The type of the endpoint. One of: `READER`, `ANY`.
#' @param StaticMembers List of DB instance identifiers that are part of the custom endpoint
#' group.
#' @param ExcludedMembers List of DB instance identifiers that aren\'t part of the custom endpoint
#' group. All other eligible instances are reachable through the custom
#' endpoint. Only relevant if the list of static members is empty.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_cluster_endpoint(
#'   DBClusterIdentifier = "string",
#'   DBClusterEndpointIdentifier = "string",
#'   EndpointType = "string",
#'   StaticMembers = list(
#'     "string"
#'   ),
#'   ExcludedMembers = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_db_cluster_endpoint
rds_create_db_cluster_endpoint <- function(DBClusterIdentifier, DBClusterEndpointIdentifier, EndpointType, StaticMembers = NULL, ExcludedMembers = NULL) {
  op <- new_operation(
    name = "CreateDBClusterEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_cluster_endpoint_input(DBClusterIdentifier = DBClusterIdentifier, DBClusterEndpointIdentifier = DBClusterEndpointIdentifier, EndpointType = EndpointType, StaticMembers = StaticMembers, ExcludedMembers = ExcludedMembers)
  output <- .rds$create_db_cluster_endpoint_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_cluster_endpoint <- rds_create_db_cluster_endpoint

#' Creates a new DB cluster parameter group
#'
#' Creates a new DB cluster parameter group.
#' 
#' Parameters in a DB cluster parameter group apply to all of the instances
#' in a DB cluster.
#' 
#' A DB cluster parameter group is initially created with the default
#' parameters for the database engine used by instances in the DB cluster.
#' To provide custom values for any of the parameters, you must modify the
#' group after creating it using ModifyDBClusterParameterGroup. Once
#' you\'ve created a DB cluster parameter group, you need to associate it
#' with your DB cluster using ModifyDBCluster. When you associate a new DB
#' cluster parameter group with a running DB cluster, you need to reboot
#' the DB instances in the DB cluster without failover for the new DB
#' cluster parameter group and associated settings to take effect.
#' 
#' After you create a DB cluster parameter group, you should wait at least
#' 5 minutes before creating your first DB cluster that uses that DB
#' cluster parameter group as the default parameter group. This allows
#' Amazon RDS to fully complete the create action before the DB cluster
#' parameter group is used as the default for a new DB cluster. This is
#' especially important for parameters that are critical when creating the
#' default database for a DB cluster, such as the character set for the
#' default database defined by the `character_set_database` parameter. You
#' can use the *Parameter Groups* option of the [Amazon RDS
#' console](https://console.aws.amazon.com/rds/) or the
#' DescribeDBClusterParameters command to verify that your DB cluster
#' parameter group has been created or modified.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_create_db_cluster_parameter_group(DBClusterParameterGroupName,
#'   DBParameterGroupFamily, Description, Tags)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DB cluster parameter group.
#' 
#' This value is stored as a lowercase string.
#' @param DBParameterGroupFamily &#91;required&#93; The DB cluster parameter group family name. A DB cluster parameter group
#' can be associated with one and only one DB cluster parameter group
#' family, and can be applied only to a DB cluster running a database
#' engine and engine version compatible with that DB cluster parameter
#' group family.
#' 
#' **Aurora MySQL**
#' 
#' Example: `aurora5.6`, `aurora-mysql5.7`
#' 
#' **Aurora PostgreSQL**
#' 
#' Example: `aurora-postgresql9.6`
#' @param Description &#91;required&#93; The description for the DB cluster parameter group.
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$create_db_cluster_parameter_group(
#'   DBClusterParameterGroupName = "string",
#'   DBParameterGroupFamily = "string",
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_db_cluster_parameter_group
rds_create_db_cluster_parameter_group <- function(DBClusterParameterGroupName, DBParameterGroupFamily, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, DBParameterGroupFamily = DBParameterGroupFamily, Description = Description, Tags = Tags)
  output <- .rds$create_db_cluster_parameter_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_cluster_parameter_group <- rds_create_db_cluster_parameter_group

#' Creates a snapshot of a DB cluster
#'
#' Creates a snapshot of a DB cluster. For more information on Amazon
#' Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_create_db_cluster_snapshot(DBClusterSnapshotIdentifier,
#'   DBClusterIdentifier, Tags)
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot. This parameter is stored as a
#' lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1-snapshot1`
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the DB cluster to create a snapshot for. This
#' parameter is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' 
#' Example: `my-cluster1`
#' @param Tags The tags to be assigned to the DB cluster snapshot.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_cluster_snapshot(
#'   DBClusterSnapshotIdentifier = "string",
#'   DBClusterIdentifier = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_db_cluster_snapshot
rds_create_db_cluster_snapshot <- function(DBClusterSnapshotIdentifier, DBClusterIdentifier, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_cluster_snapshot_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, DBClusterIdentifier = DBClusterIdentifier, Tags = Tags)
  output <- .rds$create_db_cluster_snapshot_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_cluster_snapshot <- rds_create_db_cluster_snapshot

#' Creates a new DB instance
#'
#' Creates a new DB instance.
#'
#' @usage
#' rds_create_db_instance(DBName, DBInstanceIdentifier, AllocatedStorage,
#'   DBInstanceClass, Engine, MasterUsername, MasterUserPassword,
#'   DBSecurityGroups, VpcSecurityGroupIds, AvailabilityZone,
#'   DBSubnetGroupName, PreferredMaintenanceWindow, DBParameterGroupName,
#'   BackupRetentionPeriod, PreferredBackupWindow, Port, MultiAZ,
#'   EngineVersion, AutoMinorVersionUpgrade, LicenseModel, Iops,
#'   OptionGroupName, CharacterSetName, PubliclyAccessible, Tags,
#'   DBClusterIdentifier, StorageType, TdeCredentialArn,
#'   TdeCredentialPassword, StorageEncrypted, KmsKeyId, Domain,
#'   CopyTagsToSnapshot, MonitoringInterval, MonitoringRoleArn,
#'   DomainIAMRoleName, PromotionTier, Timezone,
#'   EnableIAMDatabaseAuthentication, EnablePerformanceInsights,
#'   PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod,
#'   EnableCloudwatchLogsExports, ProcessorFeatures, DeletionProtection)
#'
#' @param DBName The meaning of this parameter differs according to the database engine
#' you use.
#' 
#' Type: String
#' 
#' **MySQL**
#' 
#' The name of the database to create when the DB instance is created. If
#' this parameter is not specified, no database is created in the DB
#' instance.
#' 
#' Constraints:
#' 
#' -   Must contain 1 to 64 letters or numbers.
#' 
#' -   Can\'t be a word reserved by the specified database engine
#' 
#' **MariaDB**
#' 
#' The name of the database to create when the DB instance is created. If
#' this parameter is not specified, no database is created in the DB
#' instance.
#' 
#' Constraints:
#' 
#' -   Must contain 1 to 64 letters or numbers.
#' 
#' -   Can\'t be a word reserved by the specified database engine
#' 
#' **PostgreSQL**
#' 
#' The name of the database to create when the DB instance is created. If
#' this parameter is not specified, the default \"postgres\" database is
#' created in the DB instance.
#' 
#' Constraints:
#' 
#' -   Must contain 1 to 63 letters, numbers, or underscores.
#' 
#' -   Must begin with a letter or an underscore. Subsequent characters can
#'     be letters, underscores, or digits (0-9).
#' 
#' -   Can\'t be a word reserved by the specified database engine
#' 
#' **Oracle**
#' 
#' The Oracle System ID (SID) of the created DB instance. If you specify
#' `null`, the default value `ORCL` is used. You can\'t specify the string
#' NULL, or any other reserved word, for `DBName`.
#' 
#' Default: `ORCL`
#' 
#' Constraints:
#' 
#' -   Can\'t be longer than 8 characters
#' 
#' **SQL Server**
#' 
#' Not applicable. Must be null.
#' 
#' **Amazon Aurora**
#' 
#' The name of the database to create when the primary instance of the DB
#' cluster is created. If this parameter is not specified, no database is
#' created in the DB instance.
#' 
#' Constraints:
#' 
#' -   Must contain 1 to 64 letters or numbers.
#' 
#' -   Can\'t be a word reserved by the specified database engine
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param AllocatedStorage The amount of storage (in gibibytes) to allocate for the DB instance.
#' 
#' Type: Integer
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. Aurora cluster volumes automatically grow as the amount
#' of data in your database increases, though you are only charged for the
#' space that you use in an Aurora cluster volume.
#' 
#' **MySQL**
#' 
#' Constraints to the amount of storage for each storage type are the
#' following:
#' 
#' -   General Purpose (SSD) storage (gp2): Must be an integer from 20
#'     to 32768.
#' 
#' -   Provisioned IOPS storage (io1): Must be an integer from 100
#'     to 32768.
#' 
#' -   Magnetic storage (standard): Must be an integer from 5 to 3072.
#' 
#' **MariaDB**
#' 
#' Constraints to the amount of storage for each storage type are the
#' following:
#' 
#' -   General Purpose (SSD) storage (gp2): Must be an integer from 20
#'     to 32768.
#' 
#' -   Provisioned IOPS storage (io1): Must be an integer from 100
#'     to 32768.
#' 
#' -   Magnetic storage (standard): Must be an integer from 5 to 3072.
#' 
#' **PostgreSQL**
#' 
#' Constraints to the amount of storage for each storage type are the
#' following:
#' 
#' -   General Purpose (SSD) storage (gp2): Must be an integer from 20
#'     to 32768.
#' 
#' -   Provisioned IOPS storage (io1): Must be an integer from 100
#'     to 32768.
#' 
#' -   Magnetic storage (standard): Must be an integer from 5 to 3072.
#' 
#' **Oracle**
#' 
#' Constraints to the amount of storage for each storage type are the
#' following:
#' 
#' -   General Purpose (SSD) storage (gp2): Must be an integer from 20
#'     to 32768.
#' 
#' -   Provisioned IOPS storage (io1): Must be an integer from 100
#'     to 32768.
#' 
#' -   Magnetic storage (standard): Must be an integer from 10 to 3072.
#' 
#' **SQL Server**
#' 
#' Constraints to the amount of storage for each storage type are the
#' following:
#' 
#' -   General Purpose (SSD) storage (gp2):
#' 
#'     -   Enterprise and Standard editions: Must be an integer from 200
#'         to 16384.
#' 
#'     -   Web and Express editions: Must be an integer from 20 to 16384.
#' 
#' -   Provisioned IOPS storage (io1):
#' 
#'     -   Enterprise and Standard editions: Must be an integer from 200
#'         to 16384.
#' 
#'     -   Web and Express editions: Must be an integer from 100 to 16384.
#' 
#' -   Magnetic storage (standard):
#' 
#'     -   Enterprise and Standard editions: Must be an integer from 200
#'         to 1024.
#' 
#'     -   Web and Express editions: Must be an integer from 20 to 1024.
#' @param DBInstanceClass &#91;required&#93; The compute and memory capacity of the DB instance, for example,
#' `db.m4.large`. Not all DB instance classes are available in all AWS
#' Regions, or for all database engines. For the full list of DB instance
#' classes, and availability for your engine, see [DB Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide.*
#' @param Engine &#91;required&#93; The name of the database engine to be used for this instance.
#' 
#' Not every database engine is available for every AWS Region.
#' 
#' Valid Values:
#' 
#' -   `aurora` (for MySQL 5.6-compatible Aurora)
#' 
#' -   `aurora-mysql` (for MySQL 5.7-compatible Aurora)
#' 
#' -   `aurora-postgresql`
#' 
#' -   `mariadb`
#' 
#' -   `mysql`
#' 
#' -   `oracle-ee`
#' 
#' -   `oracle-se2`
#' 
#' -   `oracle-se1`
#' 
#' -   `oracle-se`
#' 
#' -   `postgres`
#' 
#' -   `sqlserver-ee`
#' 
#' -   `sqlserver-se`
#' 
#' -   `sqlserver-ex`
#' 
#' -   `sqlserver-web`
#' @param MasterUsername The name for the master user.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The name for the master user is managed by the DB
#' cluster. For more information, see CreateDBCluster.
#' 
#' **MariaDB**
#' 
#' Constraints:
#' 
#' -   Required for MariaDB.
#' 
#' -   Must be 1 to 16 letters or numbers.
#' 
#' -   Can\'t be a reserved word for the chosen database engine.
#' 
#' **Microsoft SQL Server**
#' 
#' Constraints:
#' 
#' -   Required for SQL Server.
#' 
#' -   Must be 1 to 128 letters or numbers.
#' 
#' -   The first character must be a letter.
#' 
#' -   Can\'t be a reserved word for the chosen database engine.
#' 
#' **MySQL**
#' 
#' Constraints:
#' 
#' -   Required for MySQL.
#' 
#' -   Must be 1 to 16 letters or numbers.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t be a reserved word for the chosen database engine.
#' 
#' **Oracle**
#' 
#' Constraints:
#' 
#' -   Required for Oracle.
#' 
#' -   Must be 1 to 30 letters or numbers.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t be a reserved word for the chosen database engine.
#' 
#' **PostgreSQL**
#' 
#' Constraints:
#' 
#' -   Required for PostgreSQL.
#' 
#' -   Must be 1 to 63 letters or numbers.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t be a reserved word for the chosen database engine.
#' @param MasterUserPassword The password for the master user. The password can include any printable
#' ASCII character except \"/\", \"\"\", or \"@\".
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The password for the master user is managed by the DB
#' cluster. For more information, see CreateDBCluster.
#' 
#' **MariaDB**
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' 
#' **Microsoft SQL Server**
#' 
#' Constraints: Must contain from 8 to 128 characters.
#' 
#' **MySQL**
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' 
#' **Oracle**
#' 
#' Constraints: Must contain from 8 to 30 characters.
#' 
#' **PostgreSQL**
#' 
#' Constraints: Must contain from 8 to 128 characters.
#' @param DBSecurityGroups A list of DB security groups to associate with this DB instance.
#' 
#' Default: The default DB security group for the database engine.
#' @param VpcSecurityGroupIds A list of Amazon EC2 VPC security groups to associate with this DB
#' instance.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The associated list of EC2 VPC security groups is
#' managed by the DB cluster. For more information, see CreateDBCluster.
#' 
#' Default: The default EC2 VPC security group for the DB subnet group\'s
#' VPC.
#' @param AvailabilityZone The EC2 Availability Zone that the DB instance is created in. For
#' information on AWS Regions and Availability Zones, see [Regions and
#' Availability
#' Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
#' 
#' Default: A random, system-chosen Availability Zone in the endpoint\'s
#' AWS Region.
#' 
#' Example: `us-east-1d`
#' 
#' Constraint: The AvailabilityZone parameter can\'t be specified if the
#' MultiAZ parameter is set to `true`. The specified Availability Zone must
#' be in the same AWS Region as the current endpoint.
#' @param DBSubnetGroupName A DB subnet group to associate with this DB instance.
#' 
#' If there is no DB subnet group, then it is a non-VPC DB instance.
#' @param PreferredMaintenanceWindow The time range each week during which system maintenance can occur, in
#' Universal Coordinated Time (UTC). For more information, see [Amazon RDS
#' Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week.
#' 
#' Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' Constraints: Minimum 30-minute window.
#' @param DBParameterGroupName The name of the DB parameter group to associate with this DB instance.
#' If this argument is omitted, the default DBParameterGroup for the
#' specified engine is used.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. Setting
#' this parameter to a positive number enables backups. Setting this
#' parameter to 0 disables automated backups.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The retention period for automated backups is managed by
#' the DB cluster. For more information, see CreateDBCluster.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 0 to 35
#' 
#' -   Can\'t be set to 0 if the DB instance is a source to Read Replicas
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled, using the `BackupRetentionPeriod`
#' parameter. For more information, see [The Backup
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow)
#' in the *Amazon RDS User Guide*.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The daily time range for creating automated backups is
#' managed by the DB cluster. For more information, see CreateDBCluster.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region. To see the time blocks available, see
#' [Adjusting the Preferred DB Instance Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow)
#' in the *Amazon RDS User Guide*.
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param Port The port number on which the database accepts connections.
#' 
#' **MySQL**
#' 
#' Default: `3306`
#' 
#' Valid Values: `1150-65535`
#' 
#' Type: Integer
#' 
#' **MariaDB**
#' 
#' Default: `3306`
#' 
#' Valid Values: `1150-65535`
#' 
#' Type: Integer
#' 
#' **PostgreSQL**
#' 
#' Default: `5432`
#' 
#' Valid Values: `1150-65535`
#' 
#' Type: Integer
#' 
#' **Oracle**
#' 
#' Default: `1521`
#' 
#' Valid Values: `1150-65535`
#' 
#' **SQL Server**
#' 
#' Default: `1433`
#' 
#' Valid Values: `1150-65535` except for `1434`, `3389`, `47001`, `49152`,
#' and `49152` through `49156`.
#' 
#' **Amazon Aurora**
#' 
#' Default: `3306`
#' 
#' Valid Values: `1150-65535`
#' 
#' Type: Integer
#' @param MultiAZ A value that specifies whether the DB instance is a Multi-AZ deployment.
#' You can\'t set the AvailabilityZone parameter if the MultiAZ parameter
#' is set to true.
#' @param EngineVersion The version number of the database engine to use.
#' 
#' For a list of valid engine versions, call DescribeDBEngineVersions.
#' 
#' The following are the database engines and links to information about
#' the major and minor versions that are available with Amazon RDS. Not
#' every database engine is available for every AWS Region.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The version number of the database engine to be used by
#' the DB instance is managed by the DB cluster. For more information, see
#' CreateDBCluster.
#' 
#' **MariaDB**
#' 
#' See [MariaDB on Amazon RDS
#' Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MariaDB.html#MariaDB.Concepts.VersionMgmt)
#' in the *Amazon RDS User Guide.*
#' 
#' **Microsoft SQL Server**
#' 
#' See [Version and Feature Support on Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.FeatureSupport)
#' in the *Amazon RDS User Guide.*
#' 
#' **MySQL**
#' 
#' See [MySQL on Amazon RDS
#' Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_MySQL.html#MySQL.Concepts.VersionMgmt)
#' in the *Amazon RDS User Guide.*
#' 
#' **Oracle**
#' 
#' See [Oracle Database Engine Release
#' Notes](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.PatchComposition.html)
#' in the *Amazon RDS User Guide.*
#' 
#' **PostgreSQL**
#' 
#' See [Supported PostgreSQL Database
#' Versions](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_PostgreSQL.html#PostgreSQL.Concepts.General.DBVersions)
#' in the *Amazon RDS User Guide.*
#' @param AutoMinorVersionUpgrade Indicates that minor engine upgrades are applied automatically to the DB
#' instance during the maintenance window.
#' 
#' Default: `true`
#' @param LicenseModel License model information for this DB instance.
#' 
#' Valid values: `license-included` \\| `bring-your-own-license` \\|
#' `general-public-license`
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' be initially allocated for the DB instance. For information about valid
#' Iops values, see see [Amazon RDS Provisioned IOPS Storage to Improve
#' Performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS)
#' in the *Amazon RDS User Guide*.
#' 
#' Constraints: Must be a multiple between 1 and 50 of the storage amount
#' for the DB instance.
#' @param OptionGroupName Indicates that the DB instance should be associated with the specified
#' option group.
#' 
#' Permanent options, such as the TDE option for Oracle Advanced Security
#' TDE, can\'t be removed from an option group, and that option group
#' can\'t be removed from a DB instance once it is associated with a DB
#' instance
#' @param CharacterSetName For supported engines, indicates that the DB instance should be
#' associated with the specified CharacterSet.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The character set is managed by the DB cluster. For more
#' information, see CreateDBCluster.
#' @param PubliclyAccessible Specifies the accessibility options for the DB instance. A value of true
#' specifies an Internet-facing instance with a publicly resolvable DNS
#' name, which resolves to a public IP address. A value of false specifies
#' an internal instance with a DNS name that resolves to a private IP
#' address.
#' 
#' Default: The default behavior varies depending on whether
#' `DBSubnetGroupName` is specified.
#' 
#' If `DBSubnetGroupName` is not specified, and `PubliclyAccessible` is not
#' specified, the following applies:
#' 
#' -   If the default VPC in the target region doesn't have an Internet
#'     gateway attached to it, the DB instance is private.
#' 
#' -   If the default VPC in the target region has an Internet gateway
#'     attached to it, the DB instance is public.
#' 
#' If `DBSubnetGroupName` is specified, and `PubliclyAccessible` is not
#' specified, the following applies:
#' 
#' -   If the subnets are part of a VPC that doesn't have an Internet
#'     gateway attached to it, the DB instance is private.
#' 
#' -   If the subnets are part of a VPC that has an Internet gateway
#'     attached to it, the DB instance is public.
#' @param Tags 
#' @param DBClusterIdentifier The identifier of the DB cluster that the instance will belong to.
#' 
#' For information on creating a DB cluster, see CreateDBCluster.
#' 
#' Type: String
#' @param StorageType Specifies the storage type to be associated with the DB instance.
#' 
#' Valid values: `standard | gp2 | io1`
#' 
#' If you specify `io1`, you must also include a value for the `Iops`
#' parameter.
#' 
#' Default: `io1` if the `Iops` parameter is specified, otherwise
#' `standard`
#' @param TdeCredentialArn The ARN from the key store with which to associate the instance for TDE
#' encryption.
#' @param TdeCredentialPassword The password for the given ARN from the key store in order to access the
#' device.
#' @param StorageEncrypted Specifies whether the DB instance is encrypted.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The encryption for DB instances is managed by the DB
#' cluster. For more information, see CreateDBCluster.
#' 
#' Default: false
#' @param KmsKeyId The AWS KMS key identifier for an encrypted DB instance.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are creating a DB instance with the same AWS
#' account that owns the KMS encryption key used to encrypt the new DB
#' instance, then you can use the KMS key alias instead of the ARN for the
#' KM encryption key.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The KMS key identifier is managed by the DB cluster. For
#' more information, see CreateDBCluster.
#' 
#' If the `StorageEncrypted` parameter is true, and you do not specify a
#' value for the `KmsKeyId` parameter, then Amazon RDS will use your
#' default encryption key. AWS KMS creates the default encryption key for
#' your AWS account. Your AWS account has a different default encryption
#' key for each AWS Region.
#' @param Domain Specify the Active Directory Domain to create the instance in.
#' @param CopyTagsToSnapshot True to copy all tags from the DB instance to snapshots of the DB
#' instance, and otherwise false. The default is false.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. Copying tags to snapshots is managed by the DB cluster.
#' Setting this value for an Aurora DB instance has no effect on the DB
#' cluster setting. For more information, see CreateDBCluster.
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the DB instance. To disable collecting
#' Enhanced Monitoring metrics, specify 0. The default is 0.
#' 
#' If `MonitoringRoleArn` is specified, then you must also set
#' `MonitoringInterval` to a value other than 0.
#' 
#' Valid Values: `0, 1, 5, 10, 15, 30, 60`
#' @param MonitoringRoleArn The ARN for the IAM role that permits RDS to send enhanced monitoring
#' metrics to Amazon CloudWatch Logs. For example,
#' `arn:aws:iam:123456789012:role/emaccess`. For information on creating a
#' monitoring role, go to [Setting Up and Enabling Enhanced
#' Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling)
#' in the *Amazon RDS User Guide*.
#' 
#' If `MonitoringInterval` is set to a value other than 0, then you must
#' supply a `MonitoringRoleArn` value.
#' @param DomainIAMRoleName Specify the name of the IAM role to be used when making API calls to the
#' Directory Service.
#' @param PromotionTier A value that specifies the order in which an Aurora Replica is promoted
#' to the primary instance after a failure of the existing primary
#' instance. For more information, see [Fault Tolerance for an Aurora DB
#' Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance)
#' in the *Amazon Aurora User Guide*.
#' 
#' Default: 1
#' 
#' Valid Values: 0 - 15
#' @param Timezone The time zone of the DB instance. The time zone parameter is currently
#' supported only by [Microsoft SQL
#' Server](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_SQLServer.html#SQLServer.Concepts.General.TimeZone).
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' You can enable IAM database authentication for the following database
#' engines:
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. Mapping AWS IAM accounts to database accounts is managed
#' by the DB cluster. For more information, see CreateDBCluster.
#' 
#' **MySQL**
#' 
#' -   For MySQL 5.6, minor version 5.6.34 or higher
#' 
#' -   For MySQL 5.7, minor version 5.7.16 or higher
#' 
#' Default: `false`
#' @param EnablePerformanceInsights True to enable Performance Insights for the DB instance, and otherwise
#' false.
#' 
#' For more information, see [Using Amazon Performance
#' Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)
#' in the *Amazon Relational Database Service User Guide*.
#' @param PerformanceInsightsKMSKeyId The AWS KMS key identifier for encryption of Performance Insights data.
#' The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or
#' the KMS key alias for the KMS encryption key.
#' @param PerformanceInsightsRetentionPeriod The amount of time, in days, to retain Performance Insights data. Valid
#' values are 7 or 731 (2 years).
#' @param EnableCloudwatchLogsExports The list of log types that need to be enabled for exporting to
#' CloudWatch Logs. The values in the list depend on the DB engine being
#' used. For more information, see [Publishing Database Logs to Amazon
#' CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon Relational Database Service User Guide*.
#' @param ProcessorFeatures The number of CPU cores and the number of threads per core for the DB
#' instance class of the DB instance.
#' @param DeletionProtection Indicates if the DB instance should have deletion protection enabled.
#' The database can\'t be deleted when this value is set to true. The
#' default is false. For more information, see [Deleting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_db_instance(
#'   DBName = "string",
#'   DBInstanceIdentifier = "string",
#'   AllocatedStorage = 123,
#'   DBInstanceClass = "string",
#'   Engine = "string",
#'   MasterUsername = "string",
#'   MasterUserPassword = "string",
#'   DBSecurityGroups = list(
#'     "string"
#'   ),
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   AvailabilityZone = "string",
#'   DBSubnetGroupName = "string",
#'   PreferredMaintenanceWindow = "string",
#'   DBParameterGroupName = "string",
#'   BackupRetentionPeriod = 123,
#'   PreferredBackupWindow = "string",
#'   Port = 123,
#'   MultiAZ = TRUE|FALSE,
#'   EngineVersion = "string",
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   LicenseModel = "string",
#'   Iops = 123,
#'   OptionGroupName = "string",
#'   CharacterSetName = "string",
#'   PubliclyAccessible = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   DBClusterIdentifier = "string",
#'   StorageType = "string",
#'   TdeCredentialArn = "string",
#'   TdeCredentialPassword = "string",
#'   StorageEncrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   Domain = "string",
#'   CopyTagsToSnapshot = TRUE|FALSE,
#'   MonitoringInterval = 123,
#'   MonitoringRoleArn = "string",
#'   DomainIAMRoleName = "string",
#'   PromotionTier = 123,
#'   Timezone = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   EnablePerformanceInsights = TRUE|FALSE,
#'   PerformanceInsightsKMSKeyId = "string",
#'   PerformanceInsightsRetentionPeriod = 123,
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   ProcessorFeatures = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   DeletionProtection = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_db_instance
rds_create_db_instance <- function(DBName = NULL, DBInstanceIdentifier, AllocatedStorage = NULL, DBInstanceClass, Engine, MasterUsername = NULL, MasterUserPassword = NULL, DBSecurityGroups = NULL, VpcSecurityGroupIds = NULL, AvailabilityZone = NULL, DBSubnetGroupName = NULL, PreferredMaintenanceWindow = NULL, DBParameterGroupName = NULL, BackupRetentionPeriod = NULL, PreferredBackupWindow = NULL, Port = NULL, MultiAZ = NULL, EngineVersion = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, Iops = NULL, OptionGroupName = NULL, CharacterSetName = NULL, PubliclyAccessible = NULL, Tags = NULL, DBClusterIdentifier = NULL, StorageType = NULL, TdeCredentialArn = NULL, TdeCredentialPassword = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, Domain = NULL, CopyTagsToSnapshot = NULL, MonitoringInterval = NULL, MonitoringRoleArn = NULL, DomainIAMRoleName = NULL, PromotionTier = NULL, Timezone = NULL, EnableIAMDatabaseAuthentication = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, PerformanceInsightsRetentionPeriod = NULL, EnableCloudwatchLogsExports = NULL, ProcessorFeatures = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "CreateDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_instance_input(DBName = DBName, DBInstanceIdentifier = DBInstanceIdentifier, AllocatedStorage = AllocatedStorage, DBInstanceClass = DBInstanceClass, Engine = Engine, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, DBSecurityGroups = DBSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, AvailabilityZone = AvailabilityZone, DBSubnetGroupName = DBSubnetGroupName, PreferredMaintenanceWindow = PreferredMaintenanceWindow, DBParameterGroupName = DBParameterGroupName, BackupRetentionPeriod = BackupRetentionPeriod, PreferredBackupWindow = PreferredBackupWindow, Port = Port, MultiAZ = MultiAZ, EngineVersion = EngineVersion, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, Iops = Iops, OptionGroupName = OptionGroupName, CharacterSetName = CharacterSetName, PubliclyAccessible = PubliclyAccessible, Tags = Tags, DBClusterIdentifier = DBClusterIdentifier, StorageType = StorageType, TdeCredentialArn = TdeCredentialArn, TdeCredentialPassword = TdeCredentialPassword, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, Domain = Domain, CopyTagsToSnapshot = CopyTagsToSnapshot, MonitoringInterval = MonitoringInterval, MonitoringRoleArn = MonitoringRoleArn, DomainIAMRoleName = DomainIAMRoleName, PromotionTier = PromotionTier, Timezone = Timezone, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod = PerformanceInsightsRetentionPeriod, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, ProcessorFeatures = ProcessorFeatures, DeletionProtection = DeletionProtection)
  output <- .rds$create_db_instance_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_instance <- rds_create_db_instance

#' Creates a new DB instance that acts as a Read Replica for an existing
#' source DB instance
#'
#' Creates a new DB instance that acts as a Read Replica for an existing
#' source DB instance. You can create a Read Replica for a DB instance
#' running MySQL, MariaDB, or PostgreSQL. For more information, see
#' [Working with PostgreSQL, MySQL, and MariaDB Read
#' Replicas](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html)
#' in the *Amazon RDS User Guide*.
#' 
#' Amazon Aurora doesn\'t support this action. You must call the
#' `CreateDBInstance` action to create a DB instance for an Aurora DB
#' cluster.
#' 
#' All Read Replica DB instances are created with backups disabled. All
#' other DB instance attributes (including DB security groups and DB
#' parameter groups) are inherited from the source DB instance, except as
#' specified following.
#' 
#' Your source DB instance must have backup retention enabled.
#'
#' @usage
#' rds_create_db_instance_read_replica(DBInstanceIdentifier,
#'   SourceDBInstanceIdentifier, DBInstanceClass, AvailabilityZone, Port,
#'   MultiAZ, AutoMinorVersionUpgrade, Iops, OptionGroupName,
#'   PubliclyAccessible, Tags, DBSubnetGroupName, VpcSecurityGroupIds,
#'   StorageType, CopyTagsToSnapshot, MonitoringInterval, MonitoringRoleArn,
#'   KmsKeyId, PreSignedUrl, EnableIAMDatabaseAuthentication,
#'   EnablePerformanceInsights, PerformanceInsightsKMSKeyId,
#'   PerformanceInsightsRetentionPeriod, EnableCloudwatchLogsExports,
#'   ProcessorFeatures, UseDefaultProcessorFeatures, DeletionProtection,
#'   SourceRegion)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier of the Read Replica. This identifier is the
#' unique key that identifies a DB instance. This parameter is stored as a
#' lowercase string.
#' @param SourceDBInstanceIdentifier &#91;required&#93; The identifier of the DB instance that will act as the source for the
#' Read Replica. Each DB instance can have up to five Read Replicas.
#' 
#' Constraints:
#' 
#' -   Must be the identifier of an existing MySQL, MariaDB, or PostgreSQL
#'     DB instance.
#' 
#' -   Can specify a DB instance that is a MySQL Read Replica only if the
#'     source is running MySQL 5.6 or later.
#' 
#' -   Can specify a DB instance that is a PostgreSQL DB instance only if
#'     the source is running PostgreSQL 9.3.5 or later (9.4.7 and higher
#'     for cross-region replication).
#' 
#' -   The specified DB instance must have automatic backups enabled, its
#'     backup retention period must be greater than 0.
#' 
#' -   If the source DB instance is in the same AWS Region as the Read
#'     Replica, specify a valid DB instance identifier.
#' 
#' -   If the source DB instance is in a different AWS Region than the Read
#'     Replica, specify a valid DB instance ARN. For more information, go
#'     to [Constructing an ARN for Amazon
#'     RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
#'     in the *Amazon RDS User Guide*.
#' @param DBInstanceClass The compute and memory capacity of the Read Replica, for example,
#' `db.m4.large`. Not all DB instance classes are available in all AWS
#' Regions, or for all database engines. For the full list of DB instance
#' classes, and availability for your engine, see [DB Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Default: Inherits from the source DB instance.
#' @param AvailabilityZone The Amazon EC2 Availability Zone that the Read Replica is created in.
#' 
#' Default: A random, system-chosen Availability Zone in the endpoint\'s
#' AWS Region.
#' 
#' Example: `us-east-1d`
#' @param Port The port number that the DB instance uses for connections.
#' 
#' Default: Inherits from the source DB instance
#' 
#' Valid Values: `1150-65535`
#' @param MultiAZ Specifies whether the Read Replica is in a Multi-AZ deployment.
#' 
#' You can create a Read Replica as a Multi-AZ DB instance. RDS creates a
#' standby of your replica in another Availability Zone for failover
#' support for the replica. Creating your Read Replica as a Multi-AZ DB
#' instance is independent of whether the source database is a Multi-AZ DB
#' instance.
#' @param AutoMinorVersionUpgrade Indicates that minor engine upgrades are applied automatically to the
#' Read Replica during the maintenance window.
#' 
#' Default: Inherits from the source DB instance
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' be initially allocated for the DB instance.
#' @param OptionGroupName The option group the DB instance is associated with. If omitted, the
#' default option group for the engine specified is used.
#' @param PubliclyAccessible Specifies the accessibility options for the DB instance. A value of true
#' specifies an Internet-facing instance with a publicly resolvable DNS
#' name, which resolves to a public IP address. A value of false specifies
#' an internal instance with a DNS name that resolves to a private IP
#' address. For more information, see CreateDBInstance.
#' @param Tags 
#' @param DBSubnetGroupName Specifies a DB subnet group for the DB instance. The new DB instance is
#' created in the VPC associated with the DB subnet group. If no DB subnet
#' group is specified, then the new DB instance is not created in a VPC.
#' 
#' Constraints:
#' 
#' -   Can only be specified if the source DB instance identifier specifies
#'     a DB instance in another AWS Region.
#' 
#' -   If supplied, must match the name of an existing DBSubnetGroup.
#' 
#' -   The specified DB subnet group must be in the same AWS Region in
#'     which the operation is running.
#' 
#' -   All Read Replicas in one AWS Region that are created from the same
#'     source DB instance must either:\\>
#' 
#'     -   Specify DB subnet groups from the same VPC. All these Read
#'         Replicas are created in the same VPC.
#' 
#'     -   Not specify a DB subnet group. All these Read Replicas are
#'         created outside of any VPC.
#' 
#' Example: `mySubnetgroup`
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with the Read Replica.
#' 
#' Default: The default EC2 VPC security group for the DB subnet group\'s
#' VPC.
#' @param StorageType Specifies the storage type to be associated with the Read Replica.
#' 
#' Valid values: `standard | gp2 | io1`
#' 
#' If you specify `io1`, you must also include a value for the `Iops`
#' parameter.
#' 
#' Default: `io1` if the `Iops` parameter is specified, otherwise
#' `standard`
#' @param CopyTagsToSnapshot True to copy all tags from the Read Replica to snapshots of the Read
#' Replica, and otherwise false. The default is false.
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the Read Replica. To disable collecting
#' Enhanced Monitoring metrics, specify 0. The default is 0.
#' 
#' If `MonitoringRoleArn` is specified, then you must also set
#' `MonitoringInterval` to a value other than 0.
#' 
#' Valid Values: `0, 1, 5, 10, 15, 30, 60`
#' @param MonitoringRoleArn The ARN for the IAM role that permits RDS to send enhanced monitoring
#' metrics to Amazon CloudWatch Logs. For example,
#' `arn:aws:iam:123456789012:role/emaccess`. For information on creating a
#' monitoring role, go to [To create an IAM role for Amazon RDS Enhanced
#' Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole)
#' in the *Amazon RDS User Guide*.
#' 
#' If `MonitoringInterval` is set to a value other than 0, then you must
#' supply a `MonitoringRoleArn` value.
#' @param KmsKeyId The AWS KMS key ID for an encrypted Read Replica. The KMS key ID is the
#' Amazon Resource Name (ARN), KMS key identifier, or the KMS key alias for
#' the KMS encryption key.
#' 
#' If you create an encrypted Read Replica in the same AWS Region as the
#' source DB instance, then you do not have to specify a value for this
#' parameter. The Read Replica is encrypted with the same KMS key as the
#' source DB instance.
#' 
#' If you create an encrypted Read Replica in a different AWS Region, then
#' you must specify a KMS key for the destination AWS Region. KMS
#' encryption keys are specific to the AWS Region that they are created in,
#' and you can\'t use encryption keys from one AWS Region in another AWS
#' Region.
#' 
#' You can\'t create an encrypted Read Replica from an unencrypted DB
#' instance.
#' @param PreSignedUrl The URL that contains a Signature Version 4 signed request for the
#' `CreateDBInstanceReadReplica` API action in the source AWS Region that
#' contains the source DB instance.
#' 
#' You must specify this parameter when you create an encrypted Read
#' Replica from another AWS Region by using the Amazon RDS API. You can
#' specify the `--source-region` option instead of this parameter when you
#' create an encrypted Read Replica from another AWS Region by using the
#' AWS CLI.
#' 
#' The presigned URL must be a valid request for the
#' `CreateDBInstanceReadReplica` API action that can be executed in the
#' source AWS Region that contains the encrypted source DB instance. The
#' presigned URL request must contain the following parameter values:
#' 
#' -   `DestinationRegion` - The AWS Region that the encrypted Read Replica
#'     is created in. This AWS Region is the same one where the
#'     `CreateDBInstanceReadReplica` action is called that contains this
#'     presigned URL.
#' 
#'     For example, if you create an encrypted DB instance in the us-west-1
#'     AWS Region, from a source DB instance in the us-east-2 AWS Region,
#'     then you call the `CreateDBInstanceReadReplica` action in the
#'     us-east-1 AWS Region and provide a presigned URL that contains a
#'     call to the `CreateDBInstanceReadReplica` action in the us-west-2
#'     AWS Region. For this example, the `DestinationRegion` in the
#'     presigned URL must be set to the us-east-1 AWS Region.
#' 
#' -   `KmsKeyId` - The AWS KMS key identifier for the key to use to
#'     encrypt the Read Replica in the destination AWS Region. This is the
#'     same identifier for both the `CreateDBInstanceReadReplica` action
#'     that is called in the destination AWS Region, and the action
#'     contained in the presigned URL.
#' 
#' -   `SourceDBInstanceIdentifier` - The DB instance identifier for the
#'     encrypted DB instance to be replicated. This identifier must be in
#'     the Amazon Resource Name (ARN) format for the source AWS Region. For
#'     example, if you are creating an encrypted Read Replica from a DB
#'     instance in the us-west-2 AWS Region, then your
#'     `SourceDBInstanceIdentifier` looks like the following example:
#'     `arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115`.
#' 
#' To learn how to generate a Signature Version 4 signed request, see
#' [Authenticating Requests: Using Query Parameters (AWS Signature Version
#' 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#' and [Signature Version 4 Signing
#' Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#' 
#' If you supply a value for this operation\'s `SourceRegion` parameter, a
#' pre-signed URL will be calculated on your behalf.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' You can enable IAM database authentication for the following database
#' engines
#' 
#' -   For MySQL 5.6, minor version 5.6.34 or higher
#' 
#' -   For MySQL 5.7, minor version 5.7.16 or higher
#' 
#' -   Aurora MySQL 5.6 or higher
#' 
#' Default: `false`
#' @param EnablePerformanceInsights True to enable Performance Insights for the read replica, and otherwise
#' false.
#' 
#' For more information, see [Using Amazon Performance
#' Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)
#' in the *Amazon RDS User Guide*.
#' @param PerformanceInsightsKMSKeyId The AWS KMS key identifier for encryption of Performance Insights data.
#' The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or
#' the KMS key alias for the KMS encryption key.
#' @param PerformanceInsightsRetentionPeriod The amount of time, in days, to retain Performance Insights data. Valid
#' values are 7 or 731 (2 years).
#' @param EnableCloudwatchLogsExports The list of logs that the new DB instance is to export to CloudWatch
#' Logs. The values in the list depend on the DB engine being used. For
#' more information, see [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon RDS User Guide*.
#' @param ProcessorFeatures The number of CPU cores and the number of threads per core for the DB
#' instance class of the DB instance.
#' @param UseDefaultProcessorFeatures A value that specifies that the DB instance class of the DB instance
#' uses its default processor features.
#' @param DeletionProtection Indicates if the DB instance should have deletion protection enabled.
#' The database can\'t be deleted when this value is set to true. The
#' default is false. For more information, see [Deleting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
#' @param SourceRegion The ID of the region that contains the source for the read replica.
#'
#' @section Request syntax:
#' ```
#' svc$create_db_instance_read_replica(
#'   DBInstanceIdentifier = "string",
#'   SourceDBInstanceIdentifier = "string",
#'   DBInstanceClass = "string",
#'   AvailabilityZone = "string",
#'   Port = 123,
#'   MultiAZ = TRUE|FALSE,
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   Iops = 123,
#'   OptionGroupName = "string",
#'   PubliclyAccessible = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   DBSubnetGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   StorageType = "string",
#'   CopyTagsToSnapshot = TRUE|FALSE,
#'   MonitoringInterval = 123,
#'   MonitoringRoleArn = "string",
#'   KmsKeyId = "string",
#'   PreSignedUrl = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   EnablePerformanceInsights = TRUE|FALSE,
#'   PerformanceInsightsKMSKeyId = "string",
#'   PerformanceInsightsRetentionPeriod = 123,
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   ProcessorFeatures = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   UseDefaultProcessorFeatures = TRUE|FALSE,
#'   DeletionProtection = TRUE|FALSE,
#'   SourceRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_db_instance_read_replica
rds_create_db_instance_read_replica <- function(DBInstanceIdentifier, SourceDBInstanceIdentifier, DBInstanceClass = NULL, AvailabilityZone = NULL, Port = NULL, MultiAZ = NULL, AutoMinorVersionUpgrade = NULL, Iops = NULL, OptionGroupName = NULL, PubliclyAccessible = NULL, Tags = NULL, DBSubnetGroupName = NULL, VpcSecurityGroupIds = NULL, StorageType = NULL, CopyTagsToSnapshot = NULL, MonitoringInterval = NULL, MonitoringRoleArn = NULL, KmsKeyId = NULL, PreSignedUrl = NULL, EnableIAMDatabaseAuthentication = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, PerformanceInsightsRetentionPeriod = NULL, EnableCloudwatchLogsExports = NULL, ProcessorFeatures = NULL, UseDefaultProcessorFeatures = NULL, DeletionProtection = NULL, SourceRegion = NULL) {
  op <- new_operation(
    name = "CreateDBInstanceReadReplica",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_instance_read_replica_input(DBInstanceIdentifier = DBInstanceIdentifier, SourceDBInstanceIdentifier = SourceDBInstanceIdentifier, DBInstanceClass = DBInstanceClass, AvailabilityZone = AvailabilityZone, Port = Port, MultiAZ = MultiAZ, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, Iops = Iops, OptionGroupName = OptionGroupName, PubliclyAccessible = PubliclyAccessible, Tags = Tags, DBSubnetGroupName = DBSubnetGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, StorageType = StorageType, CopyTagsToSnapshot = CopyTagsToSnapshot, MonitoringInterval = MonitoringInterval, MonitoringRoleArn = MonitoringRoleArn, KmsKeyId = KmsKeyId, PreSignedUrl = PreSignedUrl, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod = PerformanceInsightsRetentionPeriod, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, ProcessorFeatures = ProcessorFeatures, UseDefaultProcessorFeatures = UseDefaultProcessorFeatures, DeletionProtection = DeletionProtection, SourceRegion = SourceRegion)
  output <- .rds$create_db_instance_read_replica_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_instance_read_replica <- rds_create_db_instance_read_replica

#' Creates a new DB parameter group
#'
#' Creates a new DB parameter group.
#' 
#' A DB parameter group is initially created with the default parameters
#' for the database engine used by the DB instance. To provide custom
#' values for any of the parameters, you must modify the group after
#' creating it using *ModifyDBParameterGroup*. Once you\'ve created a DB
#' parameter group, you need to associate it with your DB instance using
#' *ModifyDBInstance*. When you associate a new DB parameter group with a
#' running DB instance, you need to reboot the DB instance without failover
#' for the new DB parameter group and associated settings to take effect.
#' 
#' After you create a DB parameter group, you should wait at least 5
#' minutes before creating your first DB instance that uses that DB
#' parameter group as the default parameter group. This allows Amazon RDS
#' to fully complete the create action before the parameter group is used
#' as the default for a new DB instance. This is especially important for
#' parameters that are critical when creating the default database for a DB
#' instance, such as the character set for the default database defined by
#' the `character_set_database` parameter. You can use the *Parameter
#' Groups* option of the [Amazon RDS
#' console](https://console.aws.amazon.com/rds/) or the
#' *DescribeDBParameters* command to verify that your DB parameter group
#' has been created or modified.
#'
#' @usage
#' rds_create_db_parameter_group(DBParameterGroupName,
#'   DBParameterGroupFamily, Description, Tags)
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' This value is stored as a lowercase string.
#' @param DBParameterGroupFamily &#91;required&#93; The DB parameter group family name. A DB parameter group can be
#' associated with one and only one DB parameter group family, and can be
#' applied only to a DB instance running a database engine and engine
#' version compatible with that DB parameter group family.
#' 
#' To list all of the available parameter group families, use the following
#' command:
#' 
#' `aws rds describe-db-engine-versions --query "DBEngineVersions\\[\\].DBParameterGroupFamily"`
#' 
#' The output contains duplicates.
#' @param Description &#91;required&#93; The description for the DB parameter group.
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$create_db_parameter_group(
#'   DBParameterGroupName = "string",
#'   DBParameterGroupFamily = "string",
#'   Description = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_db_parameter_group
rds_create_db_parameter_group <- function(DBParameterGroupName, DBParameterGroupFamily, Description, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName, DBParameterGroupFamily = DBParameterGroupFamily, Description = Description, Tags = Tags)
  output <- .rds$create_db_parameter_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_parameter_group <- rds_create_db_parameter_group

#' Creates a new DB security group
#'
#' Creates a new DB security group. DB security groups control access to a
#' DB instance.
#' 
#' A DB security group controls access to EC2-Classic DB instances that are
#' not in a VPC.
#'
#' @usage
#' rds_create_db_security_group(DBSecurityGroupName,
#'   DBSecurityGroupDescription, Tags)
#'
#' @param DBSecurityGroupName &#91;required&#93; The name for the DB security group. This value is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' -   Must not be \"Default\"
#' 
#' Example: `mysecuritygroup`
#' @param DBSecurityGroupDescription &#91;required&#93; The description for the DB security group.
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$create_db_security_group(
#'   DBSecurityGroupName = "string",
#'   DBSecurityGroupDescription = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_db_security_group
rds_create_db_security_group <- function(DBSecurityGroupName, DBSecurityGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_security_group_input(DBSecurityGroupName = DBSecurityGroupName, DBSecurityGroupDescription = DBSecurityGroupDescription, Tags = Tags)
  output <- .rds$create_db_security_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_security_group <- rds_create_db_security_group

#' Creates a DBSnapshot
#'
#' Creates a DBSnapshot. The source DBInstance must be in \"available\"
#' state.
#'
#' @usage
#' rds_create_db_snapshot(DBSnapshotIdentifier, DBInstanceIdentifier, Tags)
#'
#' @param DBSnapshotIdentifier &#91;required&#93; The identifier for the DB snapshot.
#' 
#' Constraints:
#' 
#' -   Can\'t be null, empty, or blank
#' 
#' -   Must contain from 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-snapshot-id`
#' @param DBInstanceIdentifier &#91;required&#93; The identifier of the DB instance that you want to create the snapshot
#' of.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$create_db_snapshot(
#'   DBSnapshotIdentifier = "string",
#'   DBInstanceIdentifier = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_db_snapshot
rds_create_db_snapshot <- function(DBSnapshotIdentifier, DBInstanceIdentifier, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_snapshot_input(DBSnapshotIdentifier = DBSnapshotIdentifier, DBInstanceIdentifier = DBInstanceIdentifier, Tags = Tags)
  output <- .rds$create_db_snapshot_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_snapshot <- rds_create_db_snapshot

#' Creates a new DB subnet group
#'
#' Creates a new DB subnet group. DB subnet groups must contain at least
#' one subnet in at least two AZs in the AWS Region.
#'
#' @usage
#' rds_create_db_subnet_group(DBSubnetGroupName, DBSubnetGroupDescription,
#'   SubnetIds, Tags)
#'
#' @param DBSubnetGroupName &#91;required&#93; The name for the DB subnet group. This value is stored as a lowercase
#' string.
#' 
#' Constraints: Must contain no more than 255 letters, numbers, periods,
#' underscores, spaces, or hyphens. Must not be default.
#' 
#' Example: `mySubnetgroup`
#' @param DBSubnetGroupDescription &#91;required&#93; The description for the DB subnet group.
#' @param SubnetIds &#91;required&#93; The EC2 Subnet IDs for the DB subnet group.
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$create_db_subnet_group(
#'   DBSubnetGroupName = "string",
#'   DBSubnetGroupDescription = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_db_subnet_group
rds_create_db_subnet_group <- function(DBSubnetGroupName, DBSubnetGroupDescription, SubnetIds, Tags = NULL) {
  op <- new_operation(
    name = "CreateDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName, DBSubnetGroupDescription = DBSubnetGroupDescription, SubnetIds = SubnetIds, Tags = Tags)
  output <- .rds$create_db_subnet_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_db_subnet_group <- rds_create_db_subnet_group

#' Creates an RDS event notification subscription
#'
#' Creates an RDS event notification subscription. This action requires a
#' topic ARN (Amazon Resource Name) created by either the RDS console, the
#' SNS console, or the SNS API. To obtain an ARN with SNS, you must create
#' a topic in Amazon SNS and subscribe to the topic. The ARN is displayed
#' in the SNS console.
#' 
#' You can specify the type of source (SourceType) you want to be notified
#' of, provide a list of RDS sources (SourceIds) that triggers the events,
#' and provide a list of event categories (EventCategories) for events you
#' want to be notified of. For example, you can specify SourceType =
#' db-instance, SourceIds = mydbinstance1, mydbinstance2 and
#' EventCategories = Availability, Backup.
#' 
#' If you specify both the SourceType and SourceIds, such as SourceType =
#' db-instance and SourceIdentifier = myDBInstance1, you are notified of
#' all the db-instance events for the specified source. If you specify a
#' SourceType but do not specify a SourceIdentifier, you receive notice of
#' the events for that source type for all your RDS sources. If you do not
#' specify either the SourceType nor the SourceIdentifier, you are notified
#' of events generated from all RDS sources belonging to your customer
#' account.
#'
#' @usage
#' rds_create_event_subscription(SubscriptionName, SnsTopicArn, SourceType,
#'   EventCategories, SourceIds, Enabled, Tags)
#'
#' @param SubscriptionName &#91;required&#93; The name of the subscription.
#' 
#' Constraints: The name must be less than 255 characters.
#' @param SnsTopicArn &#91;required&#93; The Amazon Resource Name (ARN) of the SNS topic created for event
#' notification. The ARN is created by Amazon SNS when you create a topic
#' and subscribe to it.
#' @param SourceType The type of source that is generating the events. For example, if you
#' want to be notified of events generated by a DB instance, you would set
#' this parameter to db-instance. if this value is not specified, all
#' events are returned.
#' 
#' Valid values: `db-instance` \\| `db-cluster` \\| `db-parameter-group` \\|
#' `db-security-group` \\| `db-snapshot` \\| `db-cluster-snapshot`
#' @param EventCategories A list of event categories for a SourceType that you want to subscribe
#' to. You can see a list of the categories for a given SourceType in the
#' [Events](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
#' topic in the *Amazon RDS User Guide* or by using the
#' **DescribeEventCategories** action.
#' @param SourceIds The list of identifiers of the event sources for which events are
#' returned. If not specified, then all sources are included in the
#' response. An identifier must begin with a letter and must contain only
#' ASCII letters, digits, and hyphens; it can\'t end with a hyphen or
#' contain two consecutive hyphens.
#' 
#' Constraints:
#' 
#' -   If SourceIds are supplied, SourceType must also be provided.
#' 
#' -   If the source type is a DB instance, then a `DBInstanceIdentifier`
#'     must be supplied.
#' 
#' -   If the source type is a DB security group, a `DBSecurityGroupName`
#'     must be supplied.
#' 
#' -   If the source type is a DB parameter group, a `DBParameterGroupName`
#'     must be supplied.
#' 
#' -   If the source type is a DB snapshot, a `DBSnapshotIdentifier` must
#'     be supplied.
#' @param Enabled A Boolean value; set to **true** to activate the subscription, set to
#' **false** to create the subscription but not active it.
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$create_event_subscription(
#'   SubscriptionName = "string",
#'   SnsTopicArn = "string",
#'   SourceType = "string",
#'   EventCategories = list(
#'     "string"
#'   ),
#'   SourceIds = list(
#'     "string"
#'   ),
#'   Enabled = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_event_subscription
rds_create_event_subscription <- function(SubscriptionName, SnsTopicArn, SourceType = NULL, EventCategories = NULL, SourceIds = NULL, Enabled = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_event_subscription_input(SubscriptionName = SubscriptionName, SnsTopicArn = SnsTopicArn, SourceType = SourceType, EventCategories = EventCategories, SourceIds = SourceIds, Enabled = Enabled, Tags = Tags)
  output <- .rds$create_event_subscription_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_event_subscription <- rds_create_event_subscription

#' Creates an Aurora global database spread across multiple regions
#'
#' Creates an Aurora global database spread across multiple regions. The
#' global database contains a single primary cluster with read-write
#' capability, and a read-only secondary cluster that receives data from
#' the primary cluster through high-speed replication performed by the
#' Aurora storage subsystem.
#' 
#' You can create a global database that is initially empty, and then add a
#' primary cluster and a secondary cluster to it. Or you can specify an
#' existing Aurora cluster during the create operation, and this cluster
#' becomes the primary cluster of the global database.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_create_global_cluster(GlobalClusterIdentifier,
#'   SourceDBClusterIdentifier, Engine, EngineVersion, DeletionProtection,
#'   DatabaseName, StorageEncrypted)
#'
#' @param GlobalClusterIdentifier The cluster identifier of the new global database cluster.
#' @param SourceDBClusterIdentifier The Amazon Resource Name (ARN) to use as the primary cluster of the
#' global database. This parameter is optional.
#' @param Engine Provides the name of the database engine to be used for this DB cluster.
#' @param EngineVersion The engine version of the Aurora global database.
#' @param DeletionProtection The deletion protection setting for the new global database. The global
#' database can\'t be deleted when this value is set to true.
#' @param DatabaseName The name for your database of up to 64 alpha-numeric characters. If you
#' do not provide a name, Amazon Aurora will not create a database in the
#' global database cluster you are creating.
#' @param StorageEncrypted The storage encryption setting for the new global database cluster.
#'
#' @section Request syntax:
#' ```
#' svc$create_global_cluster(
#'   GlobalClusterIdentifier = "string",
#'   SourceDBClusterIdentifier = "string",
#'   Engine = "string",
#'   EngineVersion = "string",
#'   DeletionProtection = TRUE|FALSE,
#'   DatabaseName = "string",
#'   StorageEncrypted = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_global_cluster
rds_create_global_cluster <- function(GlobalClusterIdentifier = NULL, SourceDBClusterIdentifier = NULL, Engine = NULL, EngineVersion = NULL, DeletionProtection = NULL, DatabaseName = NULL, StorageEncrypted = NULL) {
  op <- new_operation(
    name = "CreateGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, SourceDBClusterIdentifier = SourceDBClusterIdentifier, Engine = Engine, EngineVersion = EngineVersion, DeletionProtection = DeletionProtection, DatabaseName = DatabaseName, StorageEncrypted = StorageEncrypted)
  output <- .rds$create_global_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_global_cluster <- rds_create_global_cluster

#' Creates a new option group
#'
#' Creates a new option group. You can create up to 20 option groups.
#'
#' @usage
#' rds_create_option_group(OptionGroupName, EngineName, MajorEngineVersion,
#'   OptionGroupDescription, Tags)
#'
#' @param OptionGroupName &#91;required&#93; Specifies the name of the option group to be created.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `myoptiongroup`
#' @param EngineName &#91;required&#93; Specifies the name of the engine that this option group should be
#' associated with.
#' @param MajorEngineVersion &#91;required&#93; Specifies the major version of the engine that this option group should
#' be associated with.
#' @param OptionGroupDescription &#91;required&#93; The description of the option group.
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$create_option_group(
#'   OptionGroupName = "string",
#'   EngineName = "string",
#'   MajorEngineVersion = "string",
#'   OptionGroupDescription = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_create_option_group
rds_create_option_group <- function(OptionGroupName, EngineName, MajorEngineVersion, OptionGroupDescription, Tags = NULL) {
  op <- new_operation(
    name = "CreateOptionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$create_option_group_input(OptionGroupName = OptionGroupName, EngineName = EngineName, MajorEngineVersion = MajorEngineVersion, OptionGroupDescription = OptionGroupDescription, Tags = Tags)
  output <- .rds$create_option_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$create_option_group <- rds_create_option_group

#' The DeleteDBCluster action deletes a previously provisioned DB cluster
#'
#' The DeleteDBCluster action deletes a previously provisioned DB cluster.
#' When you delete a DB cluster, all automated backups for that DB cluster
#' are deleted and can\'t be recovered. Manual DB cluster snapshots of the
#' specified DB cluster are not deleted.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_delete_db_cluster(DBClusterIdentifier, SkipFinalSnapshot,
#'   FinalDBSnapshotIdentifier)
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier for the DB cluster to be deleted. This
#' parameter isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match an existing DBClusterIdentifier.
#' @param SkipFinalSnapshot Determines whether a final DB cluster snapshot is created before the DB
#' cluster is deleted. If `true` is specified, no DB cluster snapshot is
#' created. If `false` is specified, a DB cluster snapshot is created
#' before the DB cluster is deleted.
#' 
#' You must specify a `FinalDBSnapshotIdentifier` parameter if
#' `SkipFinalSnapshot` is `false`.
#' 
#' Default: `false`
#' @param FinalDBSnapshotIdentifier The DB cluster snapshot identifier of the new DB cluster snapshot
#' created when `SkipFinalSnapshot` is set to `false`.
#' 
#' Specifying this parameter and also setting the `SkipFinalShapshot`
#' parameter to true results in an error.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_cluster(
#'   DBClusterIdentifier = "string",
#'   SkipFinalSnapshot = TRUE|FALSE,
#'   FinalDBSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_cluster
rds_delete_db_cluster <- function(DBClusterIdentifier, SkipFinalSnapshot = NULL, FinalDBSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "DeleteDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, SkipFinalSnapshot = SkipFinalSnapshot, FinalDBSnapshotIdentifier = FinalDBSnapshotIdentifier)
  output <- .rds$delete_db_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_cluster <- rds_delete_db_cluster

#' Deletes a custom endpoint and removes it from an Amazon Aurora DB
#' cluster
#'
#' Deletes a custom endpoint and removes it from an Amazon Aurora DB
#' cluster.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_delete_db_cluster_endpoint(DBClusterEndpointIdentifier)
#'
#' @param DBClusterEndpointIdentifier &#91;required&#93; The identifier associated with the custom endpoint. This parameter is
#' stored as a lowercase string.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_cluster_endpoint(
#'   DBClusterEndpointIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_cluster_endpoint
rds_delete_db_cluster_endpoint <- function(DBClusterEndpointIdentifier) {
  op <- new_operation(
    name = "DeleteDBClusterEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_cluster_endpoint_input(DBClusterEndpointIdentifier = DBClusterEndpointIdentifier)
  output <- .rds$delete_db_cluster_endpoint_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_cluster_endpoint <- rds_delete_db_cluster_endpoint

#' Deletes a specified DB cluster parameter group
#'
#' Deletes a specified DB cluster parameter group. The DB cluster parameter
#' group to be deleted can\'t be associated with any DB clusters.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_delete_db_cluster_parameter_group(DBClusterParameterGroupName)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group.
#' 
#' Constraints:
#' 
#' -   Must be the name of an existing DB cluster parameter group.
#' 
#' -   You can\'t delete a default DB cluster parameter group.
#' 
#' -   Can\'t be associated with any DB clusters.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_cluster_parameter_group(
#'   DBClusterParameterGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_cluster_parameter_group
rds_delete_db_cluster_parameter_group <- function(DBClusterParameterGroupName) {
  op <- new_operation(
    name = "DeleteDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName)
  output <- .rds$delete_db_cluster_parameter_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_cluster_parameter_group <- rds_delete_db_cluster_parameter_group

#' Deletes a DB cluster snapshot
#'
#' Deletes a DB cluster snapshot. If the snapshot is being copied, the copy
#' operation is terminated.
#' 
#' The DB cluster snapshot must be in the `available` state to be deleted.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_delete_db_cluster_snapshot(DBClusterSnapshotIdentifier)
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier of the DB cluster snapshot to delete.
#' 
#' Constraints: Must be the name of an existing DB cluster snapshot in the
#' `available` state.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_cluster_snapshot(
#'   DBClusterSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_cluster_snapshot
rds_delete_db_cluster_snapshot <- function(DBClusterSnapshotIdentifier) {
  op <- new_operation(
    name = "DeleteDBClusterSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_cluster_snapshot_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier)
  output <- .rds$delete_db_cluster_snapshot_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_cluster_snapshot <- rds_delete_db_cluster_snapshot

#' The DeleteDBInstance action deletes a previously provisioned DB instance
#'
#' The DeleteDBInstance action deletes a previously provisioned DB
#' instance. When you delete a DB instance, all automated backups for that
#' instance are deleted and can\'t be recovered. Manual DB snapshots of the
#' DB instance to be deleted by `DeleteDBInstance` are not deleted.
#' 
#' If you request a final DB snapshot the status of the Amazon RDS DB
#' instance is `deleting` until the DB snapshot is created. The API action
#' `DescribeDBInstance` is used to monitor the status of this operation.
#' The action can\'t be canceled or reverted once submitted.
#' 
#' Note that when a DB instance is in a failure state and has a status of
#' `failed`, `incompatible-restore`, or `incompatible-network`, you can
#' only delete it when the `SkipFinalSnapshot` parameter is set to `true`.
#' 
#' If the specified DB instance is part of an Amazon Aurora DB cluster, you
#' can\'t delete the DB instance if both of the following conditions are
#' true:
#' 
#' -   The DB cluster is a Read Replica of another Amazon Aurora DB
#'     cluster.
#' 
#' -   The DB instance is the only instance in the DB cluster.
#' 
#' To delete a DB instance in this case, first call the
#' PromoteReadReplicaDBCluster API action to promote the DB cluster so
#' it\'s no longer a Read Replica. After the promotion completes, then call
#' the `DeleteDBInstance` API action to delete the final instance in the DB
#' cluster.
#'
#' @usage
#' rds_delete_db_instance(DBInstanceIdentifier, SkipFinalSnapshot,
#'   FinalDBSnapshotIdentifier, DeleteAutomatedBackups)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier for the DB instance to be deleted. This
#' parameter isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DB instance.
#' @param SkipFinalSnapshot A value that indicates whether a final DB snapshot is created before the
#' DB instance is deleted. If `true` is specified, no DB snapshot is
#' created. If `false` is specified, a DB snapshot is created before the DB
#' instance is deleted.
#' 
#' When a DB instance is in a failure state and has a status of `failed`,
#' `incompatible-restore`, or `incompatible-network`, you can only delete
#' it when the `SkipFinalSnapshot` parameter is set to `true`.
#' 
#' Specify `true` when deleting a Read Replica.
#' 
#' The `FinalDBSnapshotIdentifier` parameter must be specified if
#' `SkipFinalSnapshot` is `false`.
#' 
#' Default: `false`
#' @param FinalDBSnapshotIdentifier The `DBSnapshotIdentifier` of the new DB snapshot created when
#' `SkipFinalSnapshot` is set to `false`.
#' 
#' Specifying this parameter and also setting the `SkipFinalShapshot`
#' parameter to `true` results in an error.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters or numbers.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' 
#' -   Can\'t be specified when deleting a Read Replica.
#' @param DeleteAutomatedBackups A value that indicates whether to remove automated backups immediately
#' after the DB instance is deleted. This parameter isn\'t case-sensitive.
#' This parameter defaults to `true`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_instance(
#'   DBInstanceIdentifier = "string",
#'   SkipFinalSnapshot = TRUE|FALSE,
#'   FinalDBSnapshotIdentifier = "string",
#'   DeleteAutomatedBackups = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_instance
rds_delete_db_instance <- function(DBInstanceIdentifier, SkipFinalSnapshot = NULL, FinalDBSnapshotIdentifier = NULL, DeleteAutomatedBackups = NULL) {
  op <- new_operation(
    name = "DeleteDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, SkipFinalSnapshot = SkipFinalSnapshot, FinalDBSnapshotIdentifier = FinalDBSnapshotIdentifier, DeleteAutomatedBackups = DeleteAutomatedBackups)
  output <- .rds$delete_db_instance_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_instance <- rds_delete_db_instance

#' Deletes automated backups based on the source instance's DbiResourceId
#' value or the restorable instance's resource ID
#'
#' Deletes automated backups based on the source instance\'s
#' `DbiResourceId` value or the restorable instance\'s resource ID.
#'
#' @usage
#' rds_delete_db_instance_automated_backup(DbiResourceId)
#'
#' @param DbiResourceId &#91;required&#93; The identifier for the source DB instance, which can\'t be changed and
#' which is unique to an AWS Region.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_instance_automated_backup(
#'   DbiResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_instance_automated_backup
rds_delete_db_instance_automated_backup <- function(DbiResourceId) {
  op <- new_operation(
    name = "DeleteDBInstanceAutomatedBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_instance_automated_backup_input(DbiResourceId = DbiResourceId)
  output <- .rds$delete_db_instance_automated_backup_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_instance_automated_backup <- rds_delete_db_instance_automated_backup

#' Deletes a specified DB parameter group
#'
#' Deletes a specified DB parameter group. The DB parameter group to be
#' deleted can\'t be associated with any DB instances.
#'
#' @usage
#' rds_delete_db_parameter_group(DBParameterGroupName)
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   Must be the name of an existing DB parameter group
#' 
#' -   You can\'t delete a default DB parameter group
#' 
#' -   Can\'t be associated with any DB instances
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_parameter_group(
#'   DBParameterGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_parameter_group
rds_delete_db_parameter_group <- function(DBParameterGroupName) {
  op <- new_operation(
    name = "DeleteDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName)
  output <- .rds$delete_db_parameter_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_parameter_group <- rds_delete_db_parameter_group

#' Deletes a DB security group
#'
#' Deletes a DB security group.
#' 
#' The specified DB security group must not be associated with any DB
#' instances.
#'
#' @usage
#' rds_delete_db_security_group(DBSecurityGroupName)
#'
#' @param DBSecurityGroupName &#91;required&#93; The name of the DB security group to delete.
#' 
#' You can\'t delete the default DB security group.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' -   Must not be \"Default\"
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_security_group(
#'   DBSecurityGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_security_group
rds_delete_db_security_group <- function(DBSecurityGroupName) {
  op <- new_operation(
    name = "DeleteDBSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_security_group_input(DBSecurityGroupName = DBSecurityGroupName)
  output <- .rds$delete_db_security_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_security_group <- rds_delete_db_security_group

#' Deletes a DB snapshot
#'
#' Deletes a DB snapshot. If the snapshot is being copied, the copy
#' operation is terminated.
#' 
#' The DB snapshot must be in the `available` state to be deleted.
#'
#' @usage
#' rds_delete_db_snapshot(DBSnapshotIdentifier)
#'
#' @param DBSnapshotIdentifier &#91;required&#93; The DB snapshot identifier.
#' 
#' Constraints: Must be the name of an existing DB snapshot in the
#' `available` state.
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_snapshot(
#'   DBSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_snapshot
rds_delete_db_snapshot <- function(DBSnapshotIdentifier) {
  op <- new_operation(
    name = "DeleteDBSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_snapshot_input(DBSnapshotIdentifier = DBSnapshotIdentifier)
  output <- .rds$delete_db_snapshot_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_snapshot <- rds_delete_db_snapshot

#' Deletes a DB subnet group
#'
#' Deletes a DB subnet group.
#' 
#' The specified database subnet group must not be associated with any DB
#' instances.
#'
#' @usage
#' rds_delete_db_subnet_group(DBSubnetGroupName)
#'
#' @param DBSubnetGroupName &#91;required&#93; The name of the database subnet group to delete.
#' 
#' You can\'t delete the default subnet group.
#' 
#' Constraints:
#' 
#' Constraints: Must match the name of an existing DBSubnetGroup. Must not
#' be default.
#' 
#' Example: `mySubnetgroup`
#'
#' @section Request syntax:
#' ```
#' svc$delete_db_subnet_group(
#'   DBSubnetGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_db_subnet_group
rds_delete_db_subnet_group <- function(DBSubnetGroupName) {
  op <- new_operation(
    name = "DeleteDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName)
  output <- .rds$delete_db_subnet_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_db_subnet_group <- rds_delete_db_subnet_group

#' Deletes an RDS event notification subscription
#'
#' Deletes an RDS event notification subscription.
#'
#' @usage
#' rds_delete_event_subscription(SubscriptionName)
#'
#' @param SubscriptionName &#91;required&#93; The name of the RDS event notification subscription you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_event_subscription(
#'   SubscriptionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_event_subscription
rds_delete_event_subscription <- function(SubscriptionName) {
  op <- new_operation(
    name = "DeleteEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_event_subscription_input(SubscriptionName = SubscriptionName)
  output <- .rds$delete_event_subscription_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_event_subscription <- rds_delete_event_subscription

#' Deletes a global database cluster
#'
#' Deletes a global database cluster. The primary and secondary clusters
#' must already be detached or destroyed first.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_delete_global_cluster(GlobalClusterIdentifier)
#'
#' @param GlobalClusterIdentifier &#91;required&#93; The cluster identifier of the global database cluster being deleted.
#'
#' @section Request syntax:
#' ```
#' svc$delete_global_cluster(
#'   GlobalClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_global_cluster
rds_delete_global_cluster <- function(GlobalClusterIdentifier) {
  op <- new_operation(
    name = "DeleteGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier)
  output <- .rds$delete_global_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_global_cluster <- rds_delete_global_cluster

#' Deletes an existing option group
#'
#' Deletes an existing option group.
#'
#' @usage
#' rds_delete_option_group(OptionGroupName)
#'
#' @param OptionGroupName &#91;required&#93; The name of the option group to be deleted.
#' 
#' You can\'t delete default option groups.
#'
#' @section Request syntax:
#' ```
#' svc$delete_option_group(
#'   OptionGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_delete_option_group
rds_delete_option_group <- function(OptionGroupName) {
  op <- new_operation(
    name = "DeleteOptionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$delete_option_group_input(OptionGroupName = OptionGroupName)
  output <- .rds$delete_option_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$delete_option_group <- rds_delete_option_group

#' Lists all of the attributes for a customer account
#'
#' Lists all of the attributes for a customer account. The attributes
#' include Amazon RDS quotas for the account, such as the number of DB
#' instances allowed. The description for a quota includes the quota name,
#' current usage toward that quota, and the quota\'s maximum value.
#' 
#' This command doesn\'t take any parameters.
#'
#' @usage
#' rds_describe_account_attributes()
#'
#' @section Request syntax:
#' ```
#' svc$describe_account_attributes()
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_account_attributes
rds_describe_account_attributes <- function() {
  op <- new_operation(
    name = "DescribeAccountAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_account_attributes_input()
  output <- .rds$describe_account_attributes_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_account_attributes <- rds_describe_account_attributes

#' Lists the set of CA certificates provided by Amazon RDS for this AWS
#' account
#'
#' Lists the set of CA certificates provided by Amazon RDS for this AWS
#' account.
#'
#' @usage
#' rds_describe_certificates(CertificateIdentifier, Filters, MaxRecords,
#'   Marker)
#'
#' @param CertificateIdentifier The user-supplied certificate identifier. If this parameter is
#' specified, information for only the identified certificate is returned.
#' This parameter isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match an existing CertificateIdentifier.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous DescribeCertificates
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_certificates(
#'   CertificateIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_certificates
rds_describe_certificates <- function(CertificateIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_certificates_input(CertificateIdentifier = CertificateIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_certificates_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_certificates <- rds_describe_certificates

#' Returns information about backtracks for a DB cluster
#'
#' Returns information about backtracks for a DB cluster.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_describe_db_cluster_backtracks(DBClusterIdentifier,
#'   BacktrackIdentifier, Filters, MaxRecords, Marker)
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the DB cluster to be described. This
#' parameter is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 alphanumeric characters or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1`
#' @param BacktrackIdentifier If specified, this value is the backtrack identifier of the backtrack to
#' be described.
#' 
#' Constraints:
#' 
#' -   Must contain a valid universally unique identifier (UUID). For more
#'     information about UUIDs, see [A Universally Unique Identifier (UUID)
#'     URN Namespace](http://www.ietf.org/rfc/rfc4122.txt).
#' 
#' Example: `123e4567-e89b-12d3-a456-426655440000`
#' @param Filters A filter that specifies one or more DB clusters to describe. Supported
#' filters include the following:
#' 
#' -   `db-cluster-backtrack-id` - Accepts backtrack identifiers. The
#'     results list includes information about only the backtracks
#'     identified by these identifiers.
#' 
#' -   `db-cluster-backtrack-status` - Accepts any of the following
#'     backtrack status values:
#' 
#'     -   `applying`
#' 
#'     -   `completed`
#' 
#'     -   `failed`
#' 
#'     -   `pending`
#' 
#'     The results list includes information about only the backtracks
#'     identified by these values. For more information about backtrack
#'     status values, see DBClusterBacktrack.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeDBClusterBacktracks request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_backtracks(
#'   DBClusterIdentifier = "string",
#'   BacktrackIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_backtracks
rds_describe_db_cluster_backtracks <- function(DBClusterIdentifier, BacktrackIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterBacktracks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_cluster_backtracks_input(DBClusterIdentifier = DBClusterIdentifier, BacktrackIdentifier = BacktrackIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_cluster_backtracks_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_backtracks <- rds_describe_db_cluster_backtracks

#' Returns information about endpoints for an Amazon Aurora DB cluster
#'
#' Returns information about endpoints for an Amazon Aurora DB cluster.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_describe_db_cluster_endpoints(DBClusterIdentifier,
#'   DBClusterEndpointIdentifier, Filters, MaxRecords, Marker)
#'
#' @param DBClusterIdentifier The DB cluster identifier of the DB cluster associated with the
#' endpoint. This parameter is stored as a lowercase string.
#' @param DBClusterEndpointIdentifier The identifier of the endpoint to describe. This parameter is stored as
#' a lowercase string.
#' @param Filters A set of name-value pairs that define which endpoints to include in the
#' output. The filters are specified as name-value pairs, in the format
#' `Name=<i>endpoint_type</i>,Values=<i>endpoint_type1</i>,<i>endpoint_type2</i>,...`.
#' `Name` can be one of: `db-cluster-endpoint-type`,
#' `db-cluster-endpoint-custom-type`, `db-cluster-endpoint-id`,
#' `db-cluster-endpoint-status`. `Values` for the
#' ` db-cluster-endpoint-type` filter can be one or more of: `reader`,
#' `writer`, `custom`. `Values` for the `db-cluster-endpoint-custom-type`
#' filter can be one or more of: `reader`, `any`. `Values` for the
#' `db-cluster-endpoint-status` filter can be one or more of: `available`,
#' `creating`, `deleting`, `modifying`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeDBClusterEndpoints request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_endpoints(
#'   DBClusterIdentifier = "string",
#'   DBClusterEndpointIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_endpoints
rds_describe_db_cluster_endpoints <- function(DBClusterIdentifier = NULL, DBClusterEndpointIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_cluster_endpoints_input(DBClusterIdentifier = DBClusterIdentifier, DBClusterEndpointIdentifier = DBClusterEndpointIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_cluster_endpoints_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_endpoints <- rds_describe_db_cluster_endpoints

#' Returns a list of DBClusterParameterGroup descriptions
#'
#' Returns a list of `DBClusterParameterGroup` descriptions. If a
#' `DBClusterParameterGroupName` parameter is specified, the list will
#' contain only the description of the specified DB cluster parameter
#' group.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_describe_db_cluster_parameter_groups(DBClusterParameterGroupName,
#'   Filters, MaxRecords, Marker)
#'
#' @param DBClusterParameterGroupName The name of a specific DB cluster parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBClusterParameterGroups` request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_parameter_groups(
#'   DBClusterParameterGroupName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_parameter_groups
rds_describe_db_cluster_parameter_groups <- function(DBClusterParameterGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_cluster_parameter_groups_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_cluster_parameter_groups_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_parameter_groups <- rds_describe_db_cluster_parameter_groups

#' Returns the detailed parameter list for a particular DB cluster
#' parameter group
#'
#' Returns the detailed parameter list for a particular DB cluster
#' parameter group.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_describe_db_cluster_parameters(DBClusterParameterGroupName, Source,
#'   Filters, MaxRecords, Marker)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of a specific DB cluster parameter group to return parameter
#' details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param Source A value that indicates to return only parameters for a specific source.
#' Parameter sources can be `engine`, `service`, or `customer`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBClusterParameters` request. If this parameter is specified,
#' the response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_parameters(
#'   DBClusterParameterGroupName = "string",
#'   Source = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_parameters
rds_describe_db_cluster_parameters <- function(DBClusterParameterGroupName, Source = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_cluster_parameters_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Source = Source, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_cluster_parameters_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_parameters <- rds_describe_db_cluster_parameters

#' Returns a list of DB cluster snapshot attribute names and values for a
#' manual DB cluster snapshot
#'
#' Returns a list of DB cluster snapshot attribute names and values for a
#' manual DB cluster snapshot.
#' 
#' When sharing snapshots with other AWS accounts,
#' `DescribeDBClusterSnapshotAttributes` returns the `restore` attribute
#' and a list of IDs for the AWS accounts that are authorized to copy or
#' restore the manual DB cluster snapshot. If `all` is included in the list
#' of values for the `restore` attribute, then the manual DB cluster
#' snapshot is public and can be copied or restored by all AWS accounts.
#' 
#' To add or remove access for an AWS account to copy or restore a manual
#' DB cluster snapshot, or to make the manual DB cluster snapshot public or
#' private, use the ModifyDBClusterSnapshotAttribute API action.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_describe_db_cluster_snapshot_attributes(DBClusterSnapshotIdentifier)
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier for the DB cluster snapshot to describe the attributes
#' for.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_snapshot_attributes(
#'   DBClusterSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_snapshot_attributes
rds_describe_db_cluster_snapshot_attributes <- function(DBClusterSnapshotIdentifier) {
  op <- new_operation(
    name = "DescribeDBClusterSnapshotAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_cluster_snapshot_attributes_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier)
  output <- .rds$describe_db_cluster_snapshot_attributes_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_snapshot_attributes <- rds_describe_db_cluster_snapshot_attributes

#' Returns information about DB cluster snapshots
#'
#' Returns information about DB cluster snapshots. This API action supports
#' pagination.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_describe_db_cluster_snapshots(DBClusterIdentifier,
#'   DBClusterSnapshotIdentifier, SnapshotType, Filters, MaxRecords, Marker,
#'   IncludeShared, IncludePublic)
#'
#' @param DBClusterIdentifier The ID of the DB cluster to retrieve the list of DB cluster snapshots
#' for. This parameter can\'t be used in conjunction with the
#' `DBClusterSnapshotIdentifier` parameter. This parameter is not
#' case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing DBCluster.
#' @param DBClusterSnapshotIdentifier A specific DB cluster snapshot identifier to describe. This parameter
#' can\'t be used in conjunction with the `DBClusterIdentifier` parameter.
#' This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing
#'     DBClusterSnapshot.
#' 
#' -   If this identifier is for an automated snapshot, the `SnapshotType`
#'     parameter must also be specified.
#' @param SnapshotType The type of DB cluster snapshots to be returned. You can specify one of
#' the following values:
#' 
#' -   `automated` - Return all DB cluster snapshots that have been
#'     automatically taken by Amazon RDS for my AWS account.
#' 
#' -   `manual` - Return all DB cluster snapshots that have been taken by
#'     my AWS account.
#' 
#' -   `shared` - Return all manual DB cluster snapshots that have been
#'     shared to my AWS account.
#' 
#' -   `public` - Return all DB cluster snapshots that have been marked as
#'     public.
#' 
#' If you don\'t specify a `SnapshotType` value, then both automated and
#' manual DB cluster snapshots are returned. You can include shared DB
#' cluster snapshots with these results by setting the `IncludeShared`
#' parameter to `true`. You can include public DB cluster snapshots with
#' these results by setting the `IncludePublic` parameter to `true`.
#' 
#' The `IncludeShared` and `IncludePublic` parameters don\'t apply for
#' `SnapshotType` values of `manual` or `automated`. The `IncludePublic`
#' parameter doesn\'t apply when `SnapshotType` is set to `shared`. The
#' `IncludeShared` parameter doesn\'t apply when `SnapshotType` is set to
#' `public`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBClusterSnapshots` request. If this parameter is specified,
#' the response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#' @param IncludeShared True to include shared manual DB cluster snapshots from other AWS
#' accounts that this AWS account has been given permission to copy or
#' restore, and otherwise false. The default is `false`.
#' 
#' You can give an AWS account permission to restore a manual DB cluster
#' snapshot from another AWS account by the
#' ModifyDBClusterSnapshotAttribute API action.
#' @param IncludePublic True to include manual DB cluster snapshots that are public and can be
#' copied or restored by any AWS account, and otherwise false. The default
#' is `false`. The default is false.
#' 
#' You can share a manual DB cluster snapshot as public by using the
#' ModifyDBClusterSnapshotAttribute API action.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_cluster_snapshots(
#'   DBClusterIdentifier = "string",
#'   DBClusterSnapshotIdentifier = "string",
#'   SnapshotType = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string",
#'   IncludeShared = TRUE|FALSE,
#'   IncludePublic = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_cluster_snapshots
rds_describe_db_cluster_snapshots <- function(DBClusterIdentifier = NULL, DBClusterSnapshotIdentifier = NULL, SnapshotType = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, IncludeShared = NULL, IncludePublic = NULL) {
  op <- new_operation(
    name = "DescribeDBClusterSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_cluster_snapshots_input(DBClusterIdentifier = DBClusterIdentifier, DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, SnapshotType = SnapshotType, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, IncludeShared = IncludeShared, IncludePublic = IncludePublic)
  output <- .rds$describe_db_cluster_snapshots_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_cluster_snapshots <- rds_describe_db_cluster_snapshots

#' Returns information about provisioned Aurora DB clusters
#'
#' Returns information about provisioned Aurora DB clusters. This API
#' supports pagination.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_describe_db_clusters(DBClusterIdentifier, Filters, MaxRecords,
#'   Marker)
#'
#' @param DBClusterIdentifier The user-supplied DB cluster identifier. If this parameter is specified,
#' information from only the specific DB cluster is returned. This
#' parameter isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match an existing DBClusterIdentifier.
#' @param Filters A filter that specifies one or more DB clusters to describe.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list will only include
#'     information about the DB clusters identified by these ARNs.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous DescribeDBClusters
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_clusters(
#'   DBClusterIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_clusters
rds_describe_db_clusters <- function(DBClusterIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_clusters_input(DBClusterIdentifier = DBClusterIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_clusters_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_clusters <- rds_describe_db_clusters

#' Returns a list of the available DB engines
#'
#' Returns a list of the available DB engines.
#'
#' @usage
#' rds_describe_db_engine_versions(Engine, EngineVersion,
#'   DBParameterGroupFamily, Filters, MaxRecords, Marker, DefaultOnly,
#'   ListSupportedCharacterSets, ListSupportedTimezones)
#'
#' @param Engine The database engine to return.
#' @param EngineVersion The database engine version to return.
#' 
#' Example: `5.1.49`
#' @param DBParameterGroupFamily The name of a specific DB parameter group family to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match an existing DBParameterGroupFamily.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more than
#' the `MaxRecords` value is available, a pagination token called a marker
#' is included in the response so that the following results can be
#' retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#' @param DefaultOnly Indicates that only the default version of the specified engine or
#' engine and major version combination is returned.
#' @param ListSupportedCharacterSets If this parameter is specified and the requested engine supports the
#' `CharacterSetName` parameter for `CreateDBInstance`, the response
#' includes a list of supported character sets for each engine version.
#' @param ListSupportedTimezones If this parameter is specified and the requested engine supports the
#' `TimeZone` parameter for `CreateDBInstance`, the response includes a
#' list of supported time zones for each engine version.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_engine_versions(
#'   Engine = "string",
#'   EngineVersion = "string",
#'   DBParameterGroupFamily = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string",
#'   DefaultOnly = TRUE|FALSE,
#'   ListSupportedCharacterSets = TRUE|FALSE,
#'   ListSupportedTimezones = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_engine_versions
rds_describe_db_engine_versions <- function(Engine = NULL, EngineVersion = NULL, DBParameterGroupFamily = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, DefaultOnly = NULL, ListSupportedCharacterSets = NULL, ListSupportedTimezones = NULL) {
  op <- new_operation(
    name = "DescribeDBEngineVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_engine_versions_input(Engine = Engine, EngineVersion = EngineVersion, DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, DefaultOnly = DefaultOnly, ListSupportedCharacterSets = ListSupportedCharacterSets, ListSupportedTimezones = ListSupportedTimezones)
  output <- .rds$describe_db_engine_versions_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_engine_versions <- rds_describe_db_engine_versions

#' Displays backups for both current and deleted instances
#'
#' Displays backups for both current and deleted instances. For example,
#' use this operation to find details about automated backups for
#' previously deleted instances. Current instances with retention periods
#' greater than zero (0) are returned for both the
#' `DescribeDBInstanceAutomatedBackups` and `DescribeDBInstances`
#' operations.
#' 
#' All parameters are optional.
#'
#' @usage
#' rds_describe_db_instance_automated_backups(DbiResourceId,
#'   DBInstanceIdentifier, Filters, MaxRecords, Marker)
#'
#' @param DbiResourceId The resource ID of the DB instance that is the source of the automated
#' backup. This parameter isn\'t case-sensitive.
#' @param DBInstanceIdentifier (Optional) The user-supplied instance identifier. If this parameter is
#' specified, it must match the identifier of an existing DB instance. It
#' returns information from the specific DB instance\' automated backup.
#' This parameter isn\'t case-sensitive.
#' @param Filters A filter that specifies which resources to return based on status.
#' 
#' Supported filters are the following:
#' 
#' -   `status`
#' 
#'     -   `active` - automated backups for current instances
#' 
#'     -   `retained` - automated backups for deleted instances
#' 
#'     -   `creating` - automated backups that are waiting for the first
#'         automated snapshot to be available
#' 
#' -   `db-instance-id` - Accepts DB instance identifiers and Amazon
#'     Resource Names (ARNs) for DB instances. The results list includes
#'     only information about the DB instance automated backupss identified
#'     by these ARNs.
#' 
#' -   `dbi-resource-id` - Accepts DB instance resource identifiers and DB
#'     Amazon Resource Names (ARNs) for DB instances. The results list
#'     includes only information about the DB instance resources identified
#'     by these ARNs.
#' 
#' Returns all resources by default. The status for each resource is
#' specified in the response.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' @param Marker The pagination token provided in the previous request. If this parameter
#' is specified the response includes only records beyond the marker, up to
#' `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_instance_automated_backups(
#'   DbiResourceId = "string",
#'   DBInstanceIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_instance_automated_backups
rds_describe_db_instance_automated_backups <- function(DbiResourceId = NULL, DBInstanceIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBInstanceAutomatedBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_instance_automated_backups_input(DbiResourceId = DbiResourceId, DBInstanceIdentifier = DBInstanceIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_instance_automated_backups_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_instance_automated_backups <- rds_describe_db_instance_automated_backups

#' Returns information about provisioned RDS instances
#'
#' Returns information about provisioned RDS instances. This API supports
#' pagination.
#'
#' @usage
#' rds_describe_db_instances(DBInstanceIdentifier, Filters, MaxRecords,
#'   Marker)
#'
#' @param DBInstanceIdentifier The user-supplied instance identifier. If this parameter is specified,
#' information from only the specific DB instance is returned. This
#' parameter isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing DBInstance.
#' @param Filters A filter that specifies one or more DB instances to describe.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list will only include
#'     information about the DB instances associated with the DB clusters
#'     identified by these ARNs.
#' 
#' -   `db-instance-id` - Accepts DB instance identifiers and DB instance
#'     Amazon Resource Names (ARNs). The results list will only include
#'     information about the DB instances identified by these ARNs.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBInstances` request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_instances(
#'   DBInstanceIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_instances
rds_describe_db_instances <- function(DBInstanceIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_instances_input(DBInstanceIdentifier = DBInstanceIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_instances_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_instances <- rds_describe_db_instances

#' Returns a list of DB log files for the DB instance
#'
#' Returns a list of DB log files for the DB instance.
#'
#' @usage
#' rds_describe_db_log_files(DBInstanceIdentifier, FilenameContains,
#'   FileLastWritten, FileSize, Filters, MaxRecords, Marker)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The customer-assigned name of the DB instance that contains the log
#' files you want to list.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param FilenameContains Filters the available log files for log file names that contain the
#' specified string.
#' @param FileLastWritten Filters the available log files for files written since the specified
#' date, in POSIX timestamp format with milliseconds.
#' @param FileSize Filters the available log files for files larger than the specified
#' size.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified MaxRecords value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' @param Marker The pagination token provided in the previous request. If this parameter
#' is specified the response includes only records beyond the marker, up to
#' MaxRecords.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_log_files(
#'   DBInstanceIdentifier = "string",
#'   FilenameContains = "string",
#'   FileLastWritten = 123,
#'   FileSize = 123,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_log_files
rds_describe_db_log_files <- function(DBInstanceIdentifier, FilenameContains = NULL, FileLastWritten = NULL, FileSize = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBLogFiles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_log_files_input(DBInstanceIdentifier = DBInstanceIdentifier, FilenameContains = FilenameContains, FileLastWritten = FileLastWritten, FileSize = FileSize, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_log_files_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_log_files <- rds_describe_db_log_files

#' Returns a list of DBParameterGroup descriptions
#'
#' Returns a list of `DBParameterGroup` descriptions. If a
#' `DBParameterGroupName` is specified, the list will contain only the
#' description of the specified DB parameter group.
#'
#' @usage
#' rds_describe_db_parameter_groups(DBParameterGroupName, Filters,
#'   MaxRecords, Marker)
#'
#' @param DBParameterGroupName The name of a specific DB parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBParameterGroups` request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_parameter_groups(
#'   DBParameterGroupName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_parameter_groups
rds_describe_db_parameter_groups <- function(DBParameterGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBParameterGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_parameter_groups_input(DBParameterGroupName = DBParameterGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_parameter_groups_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_parameter_groups <- rds_describe_db_parameter_groups

#' Returns the detailed parameter list for a particular DB parameter group
#'
#' Returns the detailed parameter list for a particular DB parameter group.
#'
#' @usage
#' rds_describe_db_parameters(DBParameterGroupName, Source, Filters,
#'   MaxRecords, Marker)
#'
#' @param DBParameterGroupName &#91;required&#93; The name of a specific DB parameter group to return details for.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DBParameterGroup.
#' @param Source The parameter types to return.
#' 
#' Default: All parameter types returned
#' 
#' Valid Values: `user | system | engine-default`
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBParameters` request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_parameters(
#'   DBParameterGroupName = "string",
#'   Source = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_parameters
rds_describe_db_parameters <- function(DBParameterGroupName, Source = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_parameters_input(DBParameterGroupName = DBParameterGroupName, Source = Source, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_parameters_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_parameters <- rds_describe_db_parameters

#' Returns a list of DBSecurityGroup descriptions
#'
#' Returns a list of `DBSecurityGroup` descriptions. If a
#' `DBSecurityGroupName` is specified, the list will contain only the
#' descriptions of the specified DB security group.
#'
#' @usage
#' rds_describe_db_security_groups(DBSecurityGroupName, Filters,
#'   MaxRecords, Marker)
#'
#' @param DBSecurityGroupName The name of the DB security group to return details for.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBSecurityGroups` request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_security_groups(
#'   DBSecurityGroupName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_security_groups
rds_describe_db_security_groups <- function(DBSecurityGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBSecurityGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_security_groups_input(DBSecurityGroupName = DBSecurityGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_security_groups_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_security_groups <- rds_describe_db_security_groups

#' Returns a list of DB snapshot attribute names and values for a manual DB
#' snapshot
#'
#' Returns a list of DB snapshot attribute names and values for a manual DB
#' snapshot.
#' 
#' When sharing snapshots with other AWS accounts,
#' `DescribeDBSnapshotAttributes` returns the `restore` attribute and a
#' list of IDs for the AWS accounts that are authorized to copy or restore
#' the manual DB snapshot. If `all` is included in the list of values for
#' the `restore` attribute, then the manual DB snapshot is public and can
#' be copied or restored by all AWS accounts.
#' 
#' To add or remove access for an AWS account to copy or restore a manual
#' DB snapshot, or to make the manual DB snapshot public or private, use
#' the ModifyDBSnapshotAttribute API action.
#'
#' @usage
#' rds_describe_db_snapshot_attributes(DBSnapshotIdentifier)
#'
#' @param DBSnapshotIdentifier &#91;required&#93; The identifier for the DB snapshot to describe the attributes for.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_snapshot_attributes(
#'   DBSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_snapshot_attributes
rds_describe_db_snapshot_attributes <- function(DBSnapshotIdentifier) {
  op <- new_operation(
    name = "DescribeDBSnapshotAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_snapshot_attributes_input(DBSnapshotIdentifier = DBSnapshotIdentifier)
  output <- .rds$describe_db_snapshot_attributes_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_snapshot_attributes <- rds_describe_db_snapshot_attributes

#' Returns information about DB snapshots
#'
#' Returns information about DB snapshots. This API action supports
#' pagination.
#'
#' @usage
#' rds_describe_db_snapshots(DBInstanceIdentifier, DBSnapshotIdentifier,
#'   SnapshotType, Filters, MaxRecords, Marker, IncludeShared, IncludePublic,
#'   DbiResourceId)
#'
#' @param DBInstanceIdentifier The ID of the DB instance to retrieve the list of DB snapshots for. This
#' parameter can\'t be used in conjunction with `DBSnapshotIdentifier`.
#' This parameter is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing DBInstance.
#' @param DBSnapshotIdentifier A specific DB snapshot identifier to describe. This parameter can\'t be
#' used in conjunction with `DBInstanceIdentifier`. This value is stored as
#' a lowercase string.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the identifier of an existing DBSnapshot.
#' 
#' -   If this identifier is for an automated snapshot, the `SnapshotType`
#'     parameter must also be specified.
#' @param SnapshotType The type of snapshots to be returned. You can specify one of the
#' following values:
#' 
#' -   `automated` - Return all DB snapshots that have been automatically
#'     taken by Amazon RDS for my AWS account.
#' 
#' -   `manual` - Return all DB snapshots that have been taken by my AWS
#'     account.
#' 
#' -   `shared` - Return all manual DB snapshots that have been shared to
#'     my AWS account.
#' 
#' -   `public` - Return all DB snapshots that have been marked as public.
#' 
#' -   `awsbackup` - Return the DB snapshots managed by the AWS Backup
#'     service.
#' 
#'     For information about AWS Backup, see the [*AWS Backup Developer
#'     Guide.*](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html)
#' 
#'     The `awsbackup` type does not apply to Aurora.
#' 
#' If you don\'t specify a `SnapshotType` value, then both automated and
#' manual snapshots are returned. Shared and public DB snapshots are not
#' included in the returned results by default. You can include shared
#' snapshots with these results by setting the `IncludeShared` parameter to
#' `true`. You can include public snapshots with these results by setting
#' the `IncludePublic` parameter to `true`.
#' 
#' The `IncludeShared` and `IncludePublic` parameters don\'t apply for
#' `SnapshotType` values of `manual` or `automated`. The `IncludePublic`
#' parameter doesn\'t apply when `SnapshotType` is set to `shared`. The
#' `IncludeShared` parameter doesn\'t apply when `SnapshotType` is set to
#' `public`.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeDBSnapshots` request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#' @param IncludeShared True to include shared manual DB snapshots from other AWS accounts that
#' this AWS account has been given permission to copy or restore, and
#' otherwise false. The default is `false`.
#' 
#' You can give an AWS account permission to restore a manual DB snapshot
#' from another AWS account by using the ModifyDBSnapshotAttribute API
#' action.
#' @param IncludePublic True to include manual DB snapshots that are public and can be copied or
#' restored by any AWS account, and otherwise false. The default is false.
#' 
#' You can share a manual DB snapshot as public by using the
#' ModifyDBSnapshotAttribute API.
#' @param DbiResourceId A specific DB resource ID to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_snapshots(
#'   DBInstanceIdentifier = "string",
#'   DBSnapshotIdentifier = "string",
#'   SnapshotType = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string",
#'   IncludeShared = TRUE|FALSE,
#'   IncludePublic = TRUE|FALSE,
#'   DbiResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_snapshots
rds_describe_db_snapshots <- function(DBInstanceIdentifier = NULL, DBSnapshotIdentifier = NULL, SnapshotType = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL, IncludeShared = NULL, IncludePublic = NULL, DbiResourceId = NULL) {
  op <- new_operation(
    name = "DescribeDBSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_snapshots_input(DBInstanceIdentifier = DBInstanceIdentifier, DBSnapshotIdentifier = DBSnapshotIdentifier, SnapshotType = SnapshotType, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker, IncludeShared = IncludeShared, IncludePublic = IncludePublic, DbiResourceId = DbiResourceId)
  output <- .rds$describe_db_snapshots_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_snapshots <- rds_describe_db_snapshots

#' Returns a list of DBSubnetGroup descriptions
#'
#' Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is
#' specified, the list will contain only the descriptions of the specified
#' DBSubnetGroup.
#' 
#' For an overview of CIDR ranges, go to the [Wikipedia
#' Tutorial](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
#'
#' @usage
#' rds_describe_db_subnet_groups(DBSubnetGroupName, Filters, MaxRecords,
#'   Marker)
#'
#' @param DBSubnetGroupName The name of the DB subnet group to return details for.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeDBSubnetGroups request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_db_subnet_groups(
#'   DBSubnetGroupName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_db_subnet_groups
rds_describe_db_subnet_groups <- function(DBSubnetGroupName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeDBSubnetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_db_subnet_groups_input(DBSubnetGroupName = DBSubnetGroupName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_db_subnet_groups_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_db_subnet_groups <- rds_describe_db_subnet_groups

#' Returns the default engine and system parameter information for the
#' cluster database engine
#'
#' Returns the default engine and system parameter information for the
#' cluster database engine.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#'
#' @usage
#' rds_describe_engine_default_cluster_parameters(DBParameterGroupFamily,
#'   Filters, MaxRecords, Marker)
#'
#' @param DBParameterGroupFamily &#91;required&#93; The name of the DB cluster parameter group family to return engine
#' parameter information for.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeEngineDefaultClusterParameters` request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_engine_default_cluster_parameters(
#'   DBParameterGroupFamily = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_engine_default_cluster_parameters
rds_describe_engine_default_cluster_parameters <- function(DBParameterGroupFamily, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEngineDefaultClusterParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_engine_default_cluster_parameters_input(DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_engine_default_cluster_parameters_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_engine_default_cluster_parameters <- rds_describe_engine_default_cluster_parameters

#' Returns the default engine and system parameter information for the
#' specified database engine
#'
#' Returns the default engine and system parameter information for the
#' specified database engine.
#'
#' @usage
#' rds_describe_engine_default_parameters(DBParameterGroupFamily, Filters,
#'   MaxRecords, Marker)
#'
#' @param DBParameterGroupFamily &#91;required&#93; The name of the DB parameter group family.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' `DescribeEngineDefaultParameters` request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_engine_default_parameters(
#'   DBParameterGroupFamily = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_engine_default_parameters
rds_describe_engine_default_parameters <- function(DBParameterGroupFamily, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEngineDefaultParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_engine_default_parameters_input(DBParameterGroupFamily = DBParameterGroupFamily, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_engine_default_parameters_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_engine_default_parameters <- rds_describe_engine_default_parameters

#' Displays a list of categories for all event source types, or, if
#' specified, for a specified source type
#'
#' Displays a list of categories for all event source types, or, if
#' specified, for a specified source type. You can see a list of the event
#' categories and source types in the
#' [Events](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
#' topic in the *Amazon RDS User Guide.*
#'
#' @usage
#' rds_describe_event_categories(SourceType, Filters)
#'
#' @param SourceType The type of source that is generating the events.
#' 
#' Valid values: db-instance \\| db-parameter-group \\| db-security-group \\|
#' db-snapshot
#' @param Filters This parameter is not currently supported.
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_categories(
#'   SourceType = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_event_categories
rds_describe_event_categories <- function(SourceType = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeEventCategories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_event_categories_input(SourceType = SourceType, Filters = Filters)
  output <- .rds$describe_event_categories_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_event_categories <- rds_describe_event_categories

#' Lists all the subscription descriptions for a customer account
#'
#' Lists all the subscription descriptions for a customer account. The
#' description for a subscription includes SubscriptionName, SNSTopicARN,
#' CustomerID, SourceType, SourceID, CreationTime, and Status.
#' 
#' If you specify a SubscriptionName, lists the description for that
#' subscription.
#'
#' @usage
#' rds_describe_event_subscriptions(SubscriptionName, Filters, MaxRecords,
#'   Marker)
#'
#' @param SubscriptionName The name of the RDS event notification subscription you want to
#' describe.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeOrderableDBInstanceOptions request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords` .
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_subscriptions(
#'   SubscriptionName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_event_subscriptions
rds_describe_event_subscriptions <- function(SubscriptionName = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEventSubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_event_subscriptions_input(SubscriptionName = SubscriptionName, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_event_subscriptions_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_event_subscriptions <- rds_describe_event_subscriptions

#' Returns events related to DB instances, DB security groups, DB
#' snapshots, and DB parameter groups for the past 14 days
#'
#' Returns events related to DB instances, DB security groups, DB
#' snapshots, and DB parameter groups for the past 14 days. Events specific
#' to a particular DB instance, DB security group, database snapshot, or DB
#' parameter group can be obtained by providing the name as a parameter. By
#' default, the past hour of events are returned.
#'
#' @usage
#' rds_describe_events(SourceIdentifier, SourceType, StartTime, EndTime,
#'   Duration, EventCategories, Filters, MaxRecords, Marker)
#'
#' @param SourceIdentifier The identifier of the event source for which events are returned. If not
#' specified, then all sources are included in the response.
#' 
#' Constraints:
#' 
#' -   If SourceIdentifier is supplied, SourceType must also be provided.
#' 
#' -   If the source type is `DBInstance`, then a `DBInstanceIdentifier`
#'     must be supplied.
#' 
#' -   If the source type is `DBSecurityGroup`, a `DBSecurityGroupName`
#'     must be supplied.
#' 
#' -   If the source type is `DBParameterGroup`, a `DBParameterGroupName`
#'     must be supplied.
#' 
#' -   If the source type is `DBSnapshot`, a `DBSnapshotIdentifier` must be
#'     supplied.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' @param SourceType The event source to retrieve events for. If no value is specified, all
#' events are returned.
#' @param StartTime The beginning of the time interval to retrieve events for, specified in
#' ISO 8601 format. For more information about ISO 8601, go to the [ISO8601
#' Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
#' 
#' Example: 2009-07-08T18:00Z
#' @param EndTime The end of the time interval for which to retrieve events, specified in
#' ISO 8601 format. For more information about ISO 8601, go to the [ISO8601
#' Wikipedia page.](http://en.wikipedia.org/wiki/ISO_8601)
#' 
#' Example: 2009-07-08T18:00Z
#' @param Duration The number of minutes to retrieve events for.
#' 
#' Default: 60
#' @param EventCategories A list of event categories that trigger notifications for a event
#' notification subscription.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous DescribeEvents
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_events(
#'   SourceIdentifier = "string",
#'   SourceType = "db-instance"|"db-parameter-group"|"db-security-group"|"db-snapshot"|"db-cluster"|"db-cluster-snapshot",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Duration = 123,
#'   EventCategories = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_events
rds_describe_events <- function(SourceIdentifier = NULL, SourceType = NULL, StartTime = NULL, EndTime = NULL, Duration = NULL, EventCategories = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_events_input(SourceIdentifier = SourceIdentifier, SourceType = SourceType, StartTime = StartTime, EndTime = EndTime, Duration = Duration, EventCategories = EventCategories, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_events_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_events <- rds_describe_events

#' Returns information about Aurora global database clusters
#'
#' Returns information about Aurora global database clusters. This API
#' supports pagination.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_describe_global_clusters(GlobalClusterIdentifier, Filters,
#'   MaxRecords, Marker)
#'
#' @param GlobalClusterIdentifier The user-supplied DB cluster identifier. If this parameter is specified,
#' information from only the specific DB cluster is returned. This
#' parameter isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   If supplied, must match an existing DBClusterIdentifier.
#' @param Filters A filter that specifies one or more global DB clusters to describe.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list will only include
#'     information about the DB clusters identified by these ARNs.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeGlobalClusters request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_global_clusters(
#'   GlobalClusterIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_global_clusters
rds_describe_global_clusters <- function(GlobalClusterIdentifier = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeGlobalClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_global_clusters_input(GlobalClusterIdentifier = GlobalClusterIdentifier, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_global_clusters_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_global_clusters <- rds_describe_global_clusters

#' Describes all available options
#'
#' Describes all available options.
#'
#' @usage
#' rds_describe_option_group_options(EngineName, MajorEngineVersion,
#'   Filters, MaxRecords, Marker)
#'
#' @param EngineName &#91;required&#93; A required parameter. Options available for the given engine name are
#' described.
#' @param MajorEngineVersion If specified, filters the results to include only options for the
#' specified major engine version.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_option_group_options(
#'   EngineName = "string",
#'   MajorEngineVersion = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_option_group_options
rds_describe_option_group_options <- function(EngineName, MajorEngineVersion = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeOptionGroupOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_option_group_options_input(EngineName = EngineName, MajorEngineVersion = MajorEngineVersion, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_option_group_options_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_option_group_options <- rds_describe_option_group_options

#' Describes the available option groups
#'
#' Describes the available option groups.
#'
#' @usage
#' rds_describe_option_groups(OptionGroupName, Filters, Marker, MaxRecords,
#'   EngineName, MajorEngineVersion)
#'
#' @param OptionGroupName The name of the option group to describe. Can\'t be supplied together
#' with EngineName or MajorEngineVersion.
#' @param Filters This parameter is not currently supported.
#' @param Marker An optional pagination token provided by a previous DescribeOptionGroups
#' request. If this parameter is specified, the response includes only
#' records beyond the marker, up to the value specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param EngineName Filters the list of option groups to only include groups associated with
#' a specific database engine.
#' @param MajorEngineVersion Filters the list of option groups to only include groups associated with
#' a specific database engine version. If specified, then EngineName must
#' also be specified.
#'
#' @section Request syntax:
#' ```
#' svc$describe_option_groups(
#'   OptionGroupName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   Marker = "string",
#'   MaxRecords = 123,
#'   EngineName = "string",
#'   MajorEngineVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_option_groups
rds_describe_option_groups <- function(OptionGroupName = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL, EngineName = NULL, MajorEngineVersion = NULL) {
  op <- new_operation(
    name = "DescribeOptionGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_option_groups_input(OptionGroupName = OptionGroupName, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords, EngineName = EngineName, MajorEngineVersion = MajorEngineVersion)
  output <- .rds$describe_option_groups_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_option_groups <- rds_describe_option_groups

#' Returns a list of orderable DB instance options for the specified engine
#'
#' Returns a list of orderable DB instance options for the specified
#' engine.
#'
#' @usage
#' rds_describe_orderable_db_instance_options(Engine, EngineVersion,
#'   DBInstanceClass, LicenseModel, Vpc, Filters, MaxRecords, Marker)
#'
#' @param Engine &#91;required&#93; The name of the engine to retrieve DB instance options for.
#' @param EngineVersion The engine version filter value. Specify this parameter to show only the
#' available offerings matching the specified engine version.
#' @param DBInstanceClass The DB instance class filter value. Specify this parameter to show only
#' the available offerings matching the specified DB instance class.
#' @param LicenseModel The license model filter value. Specify this parameter to show only the
#' available offerings matching the specified license model.
#' @param Vpc The VPC filter value. Specify this parameter to show only the available
#' VPC or non-VPC offerings.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeOrderableDBInstanceOptions request. If this parameter is
#' specified, the response includes only records beyond the marker, up to
#' the value specified by `MaxRecords` .
#'
#' @section Request syntax:
#' ```
#' svc$describe_orderable_db_instance_options(
#'   Engine = "string",
#'   EngineVersion = "string",
#'   DBInstanceClass = "string",
#'   LicenseModel = "string",
#'   Vpc = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_orderable_db_instance_options
rds_describe_orderable_db_instance_options <- function(Engine, EngineVersion = NULL, DBInstanceClass = NULL, LicenseModel = NULL, Vpc = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeOrderableDBInstanceOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_orderable_db_instance_options_input(Engine = Engine, EngineVersion = EngineVersion, DBInstanceClass = DBInstanceClass, LicenseModel = LicenseModel, Vpc = Vpc, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_orderable_db_instance_options_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_orderable_db_instance_options <- rds_describe_orderable_db_instance_options

#' Returns a list of resources (for example, DB instances) that have at
#' least one pending maintenance action
#'
#' Returns a list of resources (for example, DB instances) that have at
#' least one pending maintenance action.
#'
#' @usage
#' rds_describe_pending_maintenance_actions(ResourceIdentifier, Filters,
#'   Marker, MaxRecords)
#'
#' @param ResourceIdentifier The ARN of a resource to return pending maintenance actions for.
#' @param Filters A filter that specifies one or more resources to return pending
#' maintenance actions for.
#' 
#' Supported filters:
#' 
#' -   `db-cluster-id` - Accepts DB cluster identifiers and DB cluster
#'     Amazon Resource Names (ARNs). The results list will only include
#'     pending maintenance actions for the DB clusters identified by these
#'     ARNs.
#' 
#' -   `db-instance-id` - Accepts DB instance identifiers and DB instance
#'     ARNs. The results list will only include pending maintenance actions
#'     for the DB instances identified by these ARNs.
#' @param Marker An optional pagination token provided by a previous
#' `DescribePendingMaintenanceActions` request. If this parameter is
#' specified, the response includes only records beyond the marker, up to a
#' number of records specified by `MaxRecords`.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#'
#' @section Request syntax:
#' ```
#' svc$describe_pending_maintenance_actions(
#'   ResourceIdentifier = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   Marker = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_pending_maintenance_actions
rds_describe_pending_maintenance_actions <- function(ResourceIdentifier = NULL, Filters = NULL, Marker = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribePendingMaintenanceActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_pending_maintenance_actions_input(ResourceIdentifier = ResourceIdentifier, Filters = Filters, Marker = Marker, MaxRecords = MaxRecords)
  output <- .rds$describe_pending_maintenance_actions_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_pending_maintenance_actions <- rds_describe_pending_maintenance_actions

#' Returns information about reserved DB instances for this account, or
#' about a specified reserved DB instance
#'
#' Returns information about reserved DB instances for this account, or
#' about a specified reserved DB instance.
#'
#' @usage
#' rds_describe_reserved_db_instances(ReservedDBInstanceId,
#'   ReservedDBInstancesOfferingId, DBInstanceClass, Duration,
#'   ProductDescription, OfferingType, MultiAZ, Filters, MaxRecords, Marker)
#'
#' @param ReservedDBInstanceId The reserved DB instance identifier filter value. Specify this parameter
#' to show only the reservation that matches the specified reservation ID.
#' @param ReservedDBInstancesOfferingId The offering identifier filter value. Specify this parameter to show
#' only purchased reservations matching the specified offering identifier.
#' @param DBInstanceClass The DB instance class filter value. Specify this parameter to show only
#' those reservations matching the specified DB instances class.
#' @param Duration The duration filter value, specified in years or seconds. Specify this
#' parameter to show only reservations for this duration.
#' 
#' Valid Values: `1 | 3 | 31536000 | 94608000`
#' @param ProductDescription The product description filter value. Specify this parameter to show
#' only those reservations matching the specified product description.
#' @param OfferingType The offering type filter value. Specify this parameter to show only the
#' available offerings matching the specified offering type.
#' 
#' Valid Values: `"Partial Upfront" | "All Upfront" | "No Upfront" `
#' @param MultiAZ The Multi-AZ filter value. Specify this parameter to show only those
#' reservations matching the specified Multi-AZ parameter.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more than
#' the `MaxRecords` value is available, a pagination token called a marker
#' is included in the response so that the following results can be
#' retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_db_instances(
#'   ReservedDBInstanceId = "string",
#'   ReservedDBInstancesOfferingId = "string",
#'   DBInstanceClass = "string",
#'   Duration = "string",
#'   ProductDescription = "string",
#'   OfferingType = "string",
#'   MultiAZ = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_reserved_db_instances
rds_describe_reserved_db_instances <- function(ReservedDBInstanceId = NULL, ReservedDBInstancesOfferingId = NULL, DBInstanceClass = NULL, Duration = NULL, ProductDescription = NULL, OfferingType = NULL, MultiAZ = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeReservedDBInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_reserved_db_instances_input(ReservedDBInstanceId = ReservedDBInstanceId, ReservedDBInstancesOfferingId = ReservedDBInstancesOfferingId, DBInstanceClass = DBInstanceClass, Duration = Duration, ProductDescription = ProductDescription, OfferingType = OfferingType, MultiAZ = MultiAZ, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_reserved_db_instances_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_reserved_db_instances <- rds_describe_reserved_db_instances

#' Lists available reserved DB instance offerings
#'
#' Lists available reserved DB instance offerings.
#'
#' @usage
#' rds_describe_reserved_db_instances_offerings(
#'   ReservedDBInstancesOfferingId, DBInstanceClass, Duration,
#'   ProductDescription, OfferingType, MultiAZ, Filters, MaxRecords, Marker)
#'
#' @param ReservedDBInstancesOfferingId The offering identifier filter value. Specify this parameter to show
#' only the available offering that matches the specified reservation
#' identifier.
#' 
#' Example: `438012d3-4052-4cc7-b2e3-8d3372e0e706`
#' @param DBInstanceClass The DB instance class filter value. Specify this parameter to show only
#' the available offerings matching the specified DB instance class.
#' @param Duration Duration filter value, specified in years or seconds. Specify this
#' parameter to show only reservations for this duration.
#' 
#' Valid Values: `1 | 3 | 31536000 | 94608000`
#' @param ProductDescription Product description filter value. Specify this parameter to show only
#' the available offerings that contain the specified product description.
#' 
#' The results show offerings that partially match the filter value.
#' @param OfferingType The offering type filter value. Specify this parameter to show only the
#' available offerings matching the specified offering type.
#' 
#' Valid Values: `"Partial Upfront" | "All Upfront" | "No Upfront" `
#' @param MultiAZ The Multi-AZ filter value. Specify this parameter to show only the
#' available offerings matching the specified Multi-AZ parameter.
#' @param Filters This parameter is not currently supported.
#' @param MaxRecords The maximum number of records to include in the response. If more than
#' the `MaxRecords` value is available, a pagination token called a marker
#' is included in the response so that the following results can be
#' retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous request. If this
#' parameter is specified, the response includes only records beyond the
#' marker, up to the value specified by `MaxRecords`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_db_instances_offerings(
#'   ReservedDBInstancesOfferingId = "string",
#'   DBInstanceClass = "string",
#'   Duration = "string",
#'   ProductDescription = "string",
#'   OfferingType = "string",
#'   MultiAZ = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_reserved_db_instances_offerings
rds_describe_reserved_db_instances_offerings <- function(ReservedDBInstancesOfferingId = NULL, DBInstanceClass = NULL, Duration = NULL, ProductDescription = NULL, OfferingType = NULL, MultiAZ = NULL, Filters = NULL, MaxRecords = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeReservedDBInstancesOfferings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_reserved_db_instances_offerings_input(ReservedDBInstancesOfferingId = ReservedDBInstancesOfferingId, DBInstanceClass = DBInstanceClass, Duration = Duration, ProductDescription = ProductDescription, OfferingType = OfferingType, MultiAZ = MultiAZ, Filters = Filters, MaxRecords = MaxRecords, Marker = Marker)
  output <- .rds$describe_reserved_db_instances_offerings_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_reserved_db_instances_offerings <- rds_describe_reserved_db_instances_offerings

#' Returns a list of the source AWS Regions where the current AWS Region
#' can create a Read Replica or copy a DB snapshot from
#'
#' Returns a list of the source AWS Regions where the current AWS Region
#' can create a Read Replica or copy a DB snapshot from. This API action
#' supports pagination.
#'
#' @usage
#' rds_describe_source_regions(RegionName, MaxRecords, Marker, Filters)
#'
#' @param RegionName The source AWS Region name. For example, `us-east-1`.
#' 
#' Constraints:
#' 
#' -   Must specify a valid AWS Region name.
#' @param MaxRecords The maximum number of records to include in the response. If more
#' records exist than the specified `MaxRecords` value, a pagination token
#' called a marker is included in the response so that the remaining
#' results can be retrieved.
#' 
#' Default: 100
#' 
#' Constraints: Minimum 20, maximum 100.
#' @param Marker An optional pagination token provided by a previous
#' DescribeSourceRegions request. If this parameter is specified, the
#' response includes only records beyond the marker, up to the value
#' specified by `MaxRecords`.
#' @param Filters This parameter is not currently supported.
#'
#' @section Request syntax:
#' ```
#' svc$describe_source_regions(
#'   RegionName = "string",
#'   MaxRecords = 123,
#'   Marker = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_source_regions
rds_describe_source_regions <- function(RegionName = NULL, MaxRecords = NULL, Marker = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeSourceRegions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_source_regions_input(RegionName = RegionName, MaxRecords = MaxRecords, Marker = Marker, Filters = Filters)
  output <- .rds$describe_source_regions_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_source_regions <- rds_describe_source_regions

#' You can call DescribeValidDBInstanceModifications to learn what
#' modifications you can make to your DB instance
#'
#' You can call DescribeValidDBInstanceModifications to learn what
#' modifications you can make to your DB instance. You can use this
#' information when you call ModifyDBInstance.
#'
#' @usage
#' rds_describe_valid_db_instance_modifications(DBInstanceIdentifier)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The customer identifier or the ARN of your DB instance.
#'
#' @section Request syntax:
#' ```
#' svc$describe_valid_db_instance_modifications(
#'   DBInstanceIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_describe_valid_db_instance_modifications
rds_describe_valid_db_instance_modifications <- function(DBInstanceIdentifier) {
  op <- new_operation(
    name = "DescribeValidDBInstanceModifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$describe_valid_db_instance_modifications_input(DBInstanceIdentifier = DBInstanceIdentifier)
  output <- .rds$describe_valid_db_instance_modifications_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$describe_valid_db_instance_modifications <- rds_describe_valid_db_instance_modifications

#' Downloads all or a portion of the specified log file, up to 1 MB in size
#'
#' Downloads all or a portion of the specified log file, up to 1 MB in
#' size.
#'
#' @usage
#' rds_download_db_log_file_portion(DBInstanceIdentifier, LogFileName,
#'   Marker, NumberOfLines)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The customer-assigned name of the DB instance that contains the log
#' files you want to list.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param LogFileName &#91;required&#93; The name of the log file to be downloaded.
#' @param Marker The pagination token provided in the previous request or \"0\". If the
#' Marker parameter is specified the response includes only records beyond
#' the marker until the end of the file or up to NumberOfLines.
#' @param NumberOfLines The number of lines to download. If the number of lines specified
#' results in a file over 1 MB in size, the file is truncated at 1 MB in
#' size.
#' 
#' If the NumberOfLines parameter is specified, then the block of lines
#' returned can be from the beginning or the end of the log file, depending
#' on the value of the Marker parameter.
#' 
#' -   If neither Marker or NumberOfLines are specified, the entire log
#'     file is returned up to a maximum of 10000 lines, starting with the
#'     most recent log entries first.
#' 
#' -   If NumberOfLines is specified and Marker is not specified, then the
#'     most recent lines from the end of the log file are returned.
#' 
#' -   If Marker is specified as \"0\", then the specified number of lines
#'     from the beginning of the log file are returned.
#' 
#' -   You can download the log file in blocks of lines by specifying the
#'     size of the block using the NumberOfLines parameter, and by
#'     specifying a value of \"0\" for the Marker parameter in your first
#'     request. Include the Marker value returned in the response as the
#'     Marker value for the next request, continuing until the
#'     AdditionalDataPending response element returns false.
#'
#' @section Request syntax:
#' ```
#' svc$download_db_log_file_portion(
#'   DBInstanceIdentifier = "string",
#'   LogFileName = "string",
#'   Marker = "string",
#'   NumberOfLines = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_download_db_log_file_portion
rds_download_db_log_file_portion <- function(DBInstanceIdentifier, LogFileName, Marker = NULL, NumberOfLines = NULL) {
  op <- new_operation(
    name = "DownloadDBLogFilePortion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$download_db_log_file_portion_input(DBInstanceIdentifier = DBInstanceIdentifier, LogFileName = LogFileName, Marker = Marker, NumberOfLines = NumberOfLines)
  output <- .rds$download_db_log_file_portion_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$download_db_log_file_portion <- rds_download_db_log_file_portion

#' Forces a failover for a DB cluster
#'
#' Forces a failover for a DB cluster.
#' 
#' A failover for a DB cluster promotes one of the Aurora Replicas
#' (read-only instances) in the DB cluster to be the primary instance (the
#' cluster writer).
#' 
#' Amazon Aurora will automatically fail over to an Aurora Replica, if one
#' exists, when the primary instance fails. You can force a failover when
#' you want to simulate a failure of a primary instance for testing.
#' Because each instance in a DB cluster has its own endpoint address, you
#' will need to clean up and re-establish any existing connections that use
#' those endpoint addresses when the failover is complete.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_failover_db_cluster(DBClusterIdentifier, TargetDBInstanceIdentifier)
#'
#' @param DBClusterIdentifier &#91;required&#93; A DB cluster identifier to force a failover for. This parameter is not
#' case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' @param TargetDBInstanceIdentifier The name of the instance to promote to the primary instance.
#' 
#' You must specify the instance identifier for an Aurora Replica in the DB
#' cluster. For example, `mydbcluster-replica1`.
#'
#' @section Request syntax:
#' ```
#' svc$failover_db_cluster(
#'   DBClusterIdentifier = "string",
#'   TargetDBInstanceIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_failover_db_cluster
rds_failover_db_cluster <- function(DBClusterIdentifier, TargetDBInstanceIdentifier = NULL) {
  op <- new_operation(
    name = "FailoverDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$failover_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, TargetDBInstanceIdentifier = TargetDBInstanceIdentifier)
  output <- .rds$failover_db_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$failover_db_cluster <- rds_failover_db_cluster

#' Lists all tags on an Amazon RDS resource
#'
#' Lists all tags on an Amazon RDS resource.
#' 
#' For an overview on tagging an Amazon RDS resource, see [Tagging Amazon
#' RDS
#' Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html)
#' in the *Amazon RDS User Guide*.
#'
#' @usage
#' rds_list_tags_for_resource(ResourceName, Filters)
#'
#' @param ResourceName &#91;required&#93; The Amazon RDS resource with tags to be listed. This value is an Amazon
#' Resource Name (ARN). For information about creating an ARN, see
#' [Constructing an ARN for Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
#' in the *Amazon RDS User Guide*.
#' @param Filters This parameter is not currently supported.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceName = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_list_tags_for_resource
rds_list_tags_for_resource <- function(ResourceName, Filters = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$list_tags_for_resource_input(ResourceName = ResourceName, Filters = Filters)
  output <- .rds$list_tags_for_resource_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$list_tags_for_resource <- rds_list_tags_for_resource

#' Set the capacity of an Aurora Serverless DB cluster to a specific value
#'
#' Set the capacity of an Aurora Serverless DB cluster to a specific value.
#' 
#' Aurora Serverless scales seamlessly based on the workload on the DB
#' cluster. In some cases, the capacity might not scale fast enough to meet
#' a sudden change in workload, such as a large number of new transactions.
#' Call `ModifyCurrentDBClusterCapacity` to set the capacity explicitly.
#' 
#' After this call sets the DB cluster capacity, Aurora Serverless can
#' automatically scale the DB cluster based on the cooldown period for
#' scaling up and the cooldown period for scaling down.
#' 
#' For more information about Aurora Serverless, see [Using Amazon Aurora
#' Serverless](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' If you call `ModifyCurrentDBClusterCapacity` with the default
#' `TimeoutAction`, connections that prevent Aurora Serverless from finding
#' a scaling point might be dropped. For more information about scaling
#' points, see [Autoscaling for Aurora
#' Serverless](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling)
#' in the *Amazon Aurora User Guide*.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_modify_current_db_cluster_capacity(DBClusterIdentifier, Capacity,
#'   SecondsBeforeTimeout, TimeoutAction)
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier for the cluster being modified. This parameter
#' is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DB cluster.
#' @param Capacity The DB cluster capacity.
#' 
#' Constraints:
#' 
#' -   Value must be `2`, `4`, `8`, `16`, `32`, `64`, `128`, or `256`.
#' @param SecondsBeforeTimeout The amount of time, in seconds, that Aurora Serverless tries to find a
#' scaling point to perform seamless scaling before enforcing the timeout
#' action. The default is 300.
#' 
#' -   Value must be from 10 through 600.
#' @param TimeoutAction The action to take when the timeout is reached, either
#' `ForceApplyCapacityChange` or `RollbackCapacityChange`.
#' 
#' `ForceApplyCapacityChange`, the default, sets the capacity to the
#' specified value as soon as possible.
#' 
#' `RollbackCapacityChange` ignores the capacity change if a scaling point
#' is not found in the timeout period.
#'
#' @section Request syntax:
#' ```
#' svc$modify_current_db_cluster_capacity(
#'   DBClusterIdentifier = "string",
#'   Capacity = 123,
#'   SecondsBeforeTimeout = 123,
#'   TimeoutAction = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_current_db_cluster_capacity
rds_modify_current_db_cluster_capacity <- function(DBClusterIdentifier, Capacity = NULL, SecondsBeforeTimeout = NULL, TimeoutAction = NULL) {
  op <- new_operation(
    name = "ModifyCurrentDBClusterCapacity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_current_db_cluster_capacity_input(DBClusterIdentifier = DBClusterIdentifier, Capacity = Capacity, SecondsBeforeTimeout = SecondsBeforeTimeout, TimeoutAction = TimeoutAction)
  output <- .rds$modify_current_db_cluster_capacity_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_current_db_cluster_capacity <- rds_modify_current_db_cluster_capacity

#' Modify a setting for an Amazon Aurora DB cluster
#'
#' Modify a setting for an Amazon Aurora DB cluster. You can change one or
#' more database configuration parameters by specifying these parameters
#' and the new values in the request. For more information on Amazon
#' Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_modify_db_cluster(DBClusterIdentifier, NewDBClusterIdentifier,
#'   ApplyImmediately, BackupRetentionPeriod, DBClusterParameterGroupName,
#'   VpcSecurityGroupIds, Port, MasterUserPassword, OptionGroupName,
#'   PreferredBackupWindow, PreferredMaintenanceWindow,
#'   EnableIAMDatabaseAuthentication, BacktrackWindow,
#'   CloudwatchLogsExportConfiguration, EngineVersion, ScalingConfiguration,
#'   DeletionProtection, EnableHttpEndpoint, CopyTagsToSnapshot)
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier for the cluster being modified. This parameter
#' is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' @param NewDBClusterIdentifier The new DB cluster identifier for the DB cluster when renaming a DB
#' cluster. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   The first character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-cluster2`
#' @param ApplyImmediately A value that specifies whether the modifications in this request and any
#' pending modifications are asynchronously applied as soon as possible,
#' regardless of the `PreferredMaintenanceWindow` setting for the DB
#' cluster. If this parameter is set to `false`, changes to the DB cluster
#' are applied during the next maintenance window.
#' 
#' The `ApplyImmediately` parameter only affects the
#' `EnableIAMDatabaseAuthentication`, `MasterUserPassword`, and
#' `NewDBClusterIdentifier` values. If you set the `ApplyImmediately`
#' parameter value to false, then changes to the
#' `EnableIAMDatabaseAuthentication`, `MasterUserPassword`, and
#' `NewDBClusterIdentifier` values are applied during the next maintenance
#' window. All other changes are applied immediately, regardless of the
#' value of the `ApplyImmediately` parameter.
#' 
#' Default: `false`
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. You must
#' specify a minimum value of 1.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to use for the DB cluster.
#' @param VpcSecurityGroupIds A list of VPC security groups that the DB cluster will belong to.
#' @param Port The port number on which the DB cluster accepts connections.
#' 
#' Constraints: Value must be `1150-65535`
#' 
#' Default: The same port as the original DB cluster.
#' @param MasterUserPassword The new password for the master database user. This password can contain
#' any printable ASCII character except \"/\", \"\"\", or \"@\".
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' @param OptionGroupName A value that indicates that the DB cluster should be associated with the
#' specified option group. Changing this parameter doesn\'t result in an
#' outage except in the following case, and the change is applied during
#' the next maintenance window unless the `ApplyImmediately` parameter is
#' set to `true` for this request. If the parameter change results in an
#' option group that enables OEM, this change can cause a brief
#' (sub-second) period during which new connections are rejected but
#' existing connections are not interrupted.
#' 
#' Permanent options can\'t be removed from an option group. The option
#' group can\'t be removed from a DB cluster once it is associated with a
#' DB cluster.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled, using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region. To see the time blocks available, see
#' [Adjusting the Preferred DB Cluster Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora)
#' in the *Amazon Aurora User Guide.*
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week. To see the time blocks available, see [Adjusting the Preferred DB
#' Cluster Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora)
#' in the *Amazon Aurora User Guide.*
#' 
#' Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' Constraints: Minimum 30-minute window.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param BacktrackWindow The target backtrack window, in seconds. To disable backtracking, set
#' this value to 0.
#' 
#' Default: 0
#' 
#' Constraints:
#' 
#' -   If specified, this value must be set to a number from 0 to 259,200
#'     (72 hours).
#' @param CloudwatchLogsExportConfiguration The configuration setting for the log types to be enabled for export to
#' CloudWatch Logs for a specific DB cluster.
#' @param EngineVersion The version number of the database engine to which you want to upgrade.
#' Changing this parameter results in an outage. The change is applied
#' during the next maintenance window unless the ApplyImmediately parameter
#' is set to true.
#' 
#' For a list of valid engine versions, see CreateDBCluster, or call
#' DescribeDBEngineVersions.
#' @param ScalingConfiguration The scaling properties of the DB cluster. You can only modify scaling
#' properties for DB clusters in `serverless` DB engine mode.
#' @param DeletionProtection Indicates if the DB cluster has deletion protection enabled. The
#' database can\'t be deleted when this value is set to true.
#' @param EnableHttpEndpoint HTTP endpoint functionality is in beta for Aurora Serverless and is
#' subject to change.
#' 
#' A value that indicates whether to enable the HTTP endpoint for an Aurora
#' Serverless DB cluster. By default, the HTTP endpoint is disabled.
#' 
#' When enabled, the HTTP endpoint provides a connectionless web service
#' API for running SQL queries on the Aurora Serverless DB cluster. You can
#' also query your database from inside the RDS console with the query
#' editor.
#' 
#' For more information about Aurora Serverless, see [Using Amazon Aurora
#' Serverless](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
#' in the *Amazon Aurora User Guide*.
#' @param CopyTagsToSnapshot True to copy all tags from the DB cluster to snapshots of the DB
#' cluster, and otherwise false. The default is false.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_cluster(
#'   DBClusterIdentifier = "string",
#'   NewDBClusterIdentifier = "string",
#'   ApplyImmediately = TRUE|FALSE,
#'   BackupRetentionPeriod = 123,
#'   DBClusterParameterGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   Port = 123,
#'   MasterUserPassword = "string",
#'   OptionGroupName = "string",
#'   PreferredBackupWindow = "string",
#'   PreferredMaintenanceWindow = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   BacktrackWindow = 123,
#'   CloudwatchLogsExportConfiguration = list(
#'     EnableLogTypes = list(
#'       "string"
#'     ),
#'     DisableLogTypes = list(
#'       "string"
#'     )
#'   ),
#'   EngineVersion = "string",
#'   ScalingConfiguration = list(
#'     MinCapacity = 123,
#'     MaxCapacity = 123,
#'     AutoPause = TRUE|FALSE,
#'     SecondsUntilAutoPause = 123
#'   ),
#'   DeletionProtection = TRUE|FALSE,
#'   EnableHttpEndpoint = TRUE|FALSE,
#'   CopyTagsToSnapshot = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_cluster
rds_modify_db_cluster <- function(DBClusterIdentifier, NewDBClusterIdentifier = NULL, ApplyImmediately = NULL, BackupRetentionPeriod = NULL, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, Port = NULL, MasterUserPassword = NULL, OptionGroupName = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, EnableIAMDatabaseAuthentication = NULL, BacktrackWindow = NULL, CloudwatchLogsExportConfiguration = NULL, EngineVersion = NULL, ScalingConfiguration = NULL, DeletionProtection = NULL, EnableHttpEndpoint = NULL, CopyTagsToSnapshot = NULL) {
  op <- new_operation(
    name = "ModifyDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, NewDBClusterIdentifier = NewDBClusterIdentifier, ApplyImmediately = ApplyImmediately, BackupRetentionPeriod = BackupRetentionPeriod, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Port = Port, MasterUserPassword = MasterUserPassword, OptionGroupName = OptionGroupName, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, BacktrackWindow = BacktrackWindow, CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration, EngineVersion = EngineVersion, ScalingConfiguration = ScalingConfiguration, DeletionProtection = DeletionProtection, EnableHttpEndpoint = EnableHttpEndpoint, CopyTagsToSnapshot = CopyTagsToSnapshot)
  output <- .rds$modify_db_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_cluster <- rds_modify_db_cluster

#' Modifies the properties of an endpoint in an Amazon Aurora DB cluster
#'
#' Modifies the properties of an endpoint in an Amazon Aurora DB cluster.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_modify_db_cluster_endpoint(DBClusterEndpointIdentifier,
#'   EndpointType, StaticMembers, ExcludedMembers)
#'
#' @param DBClusterEndpointIdentifier &#91;required&#93; The identifier of the endpoint to modify. This parameter is stored as a
#' lowercase string.
#' @param EndpointType The type of the endpoint. One of: `READER`, `ANY`.
#' @param StaticMembers List of DB instance identifiers that are part of the custom endpoint
#' group.
#' @param ExcludedMembers List of DB instance identifiers that aren\'t part of the custom endpoint
#' group. All other eligible instances are reachable through the custom
#' endpoint. Only relevant if the list of static members is empty.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_cluster_endpoint(
#'   DBClusterEndpointIdentifier = "string",
#'   EndpointType = "string",
#'   StaticMembers = list(
#'     "string"
#'   ),
#'   ExcludedMembers = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_cluster_endpoint
rds_modify_db_cluster_endpoint <- function(DBClusterEndpointIdentifier, EndpointType = NULL, StaticMembers = NULL, ExcludedMembers = NULL) {
  op <- new_operation(
    name = "ModifyDBClusterEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_cluster_endpoint_input(DBClusterEndpointIdentifier = DBClusterEndpointIdentifier, EndpointType = EndpointType, StaticMembers = StaticMembers, ExcludedMembers = ExcludedMembers)
  output <- .rds$modify_db_cluster_endpoint_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_cluster_endpoint <- rds_modify_db_cluster_endpoint

#' Modifies the parameters of a DB cluster parameter group
#'
#' Modifies the parameters of a DB cluster parameter group. To modify more
#' than one parameter, submit a list of the following: `ParameterName`,
#' `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be
#' modified in a single request.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' Changes to dynamic parameters are applied immediately. Changes to static
#' parameters require a reboot without failover to the DB cluster
#' associated with the parameter group before the change can take effect.
#' 
#' After you create a DB cluster parameter group, you should wait at least
#' 5 minutes before creating your first DB cluster that uses that DB
#' cluster parameter group as the default parameter group. This allows
#' Amazon RDS to fully complete the create action before the parameter
#' group is used as the default for a new DB cluster. This is especially
#' important for parameters that are critical when creating the default
#' database for a DB cluster, such as the character set for the default
#' database defined by the `character_set_database` parameter. You can use
#' the *Parameter Groups* option of the [Amazon RDS
#' console](https://console.aws.amazon.com/rds/) or the
#' DescribeDBClusterParameters command to verify that your DB cluster
#' parameter group has been created or modified.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_modify_db_cluster_parameter_group(DBClusterParameterGroupName,
#'   Parameters)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group to modify.
#' @param Parameters &#91;required&#93; A list of parameters in the DB cluster parameter group to modify.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_cluster_parameter_group(
#'   DBClusterParameterGroupName = "string",
#'   Parameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string",
#'       Description = "string",
#'       Source = "string",
#'       ApplyType = "string",
#'       DataType = "string",
#'       AllowedValues = "string",
#'       IsModifiable = TRUE|FALSE,
#'       MinimumEngineVersion = "string",
#'       ApplyMethod = "immediate"|"pending-reboot",
#'       SupportedEngineModes = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_cluster_parameter_group
rds_modify_db_cluster_parameter_group <- function(DBClusterParameterGroupName, Parameters) {
  op <- new_operation(
    name = "ModifyDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, Parameters = Parameters)
  output <- .rds$modify_db_cluster_parameter_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_cluster_parameter_group <- rds_modify_db_cluster_parameter_group

#' Adds an attribute and values to, or removes an attribute and values
#' from, a manual DB cluster snapshot
#'
#' Adds an attribute and values to, or removes an attribute and values
#' from, a manual DB cluster snapshot.
#' 
#' To share a manual DB cluster snapshot with other AWS accounts, specify
#' `restore` as the `AttributeName` and use the `ValuesToAdd` parameter to
#' add a list of IDs of the AWS accounts that are authorized to restore the
#' manual DB cluster snapshot. Use the value `all` to make the manual DB
#' cluster snapshot public, which means that it can be copied or restored
#' by all AWS accounts. Do not add the `all` value for any manual DB
#' cluster snapshots that contain private information that you don\'t want
#' available to all AWS accounts. If a manual DB cluster snapshot is
#' encrypted, it can be shared, but only by specifying a list of authorized
#' AWS account IDs for the `ValuesToAdd` parameter. You can\'t use `all` as
#' a value for that parameter in this case.
#' 
#' To view which AWS accounts have access to copy or restore a manual DB
#' cluster snapshot, or whether a manual DB cluster snapshot public or
#' private, use the DescribeDBClusterSnapshotAttributes API action.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_modify_db_cluster_snapshot_attribute(DBClusterSnapshotIdentifier,
#'   AttributeName, ValuesToAdd, ValuesToRemove)
#'
#' @param DBClusterSnapshotIdentifier &#91;required&#93; The identifier for the DB cluster snapshot to modify the attributes for.
#' @param AttributeName &#91;required&#93; The name of the DB cluster snapshot attribute to modify.
#' 
#' To manage authorization for other AWS accounts to copy or restore a
#' manual DB cluster snapshot, set this value to `restore`.
#' @param ValuesToAdd A list of DB cluster snapshot attributes to add to the attribute
#' specified by `AttributeName`.
#' 
#' To authorize other AWS accounts to copy or restore a manual DB cluster
#' snapshot, set this list to include one or more AWS account IDs, or `all`
#' to make the manual DB cluster snapshot restorable by any AWS account. Do
#' not add the `all` value for any manual DB cluster snapshots that contain
#' private information that you don\'t want available to all AWS accounts.
#' @param ValuesToRemove A list of DB cluster snapshot attributes to remove from the attribute
#' specified by `AttributeName`.
#' 
#' To remove authorization for other AWS accounts to copy or restore a
#' manual DB cluster snapshot, set this list to include one or more AWS
#' account identifiers, or `all` to remove authorization for any AWS
#' account to copy or restore the DB cluster snapshot. If you specify
#' `all`, an AWS account whose account ID is explicitly added to the
#' `restore` attribute can still copy or restore a manual DB cluster
#' snapshot.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_cluster_snapshot_attribute(
#'   DBClusterSnapshotIdentifier = "string",
#'   AttributeName = "string",
#'   ValuesToAdd = list(
#'     "string"
#'   ),
#'   ValuesToRemove = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_cluster_snapshot_attribute
rds_modify_db_cluster_snapshot_attribute <- function(DBClusterSnapshotIdentifier, AttributeName, ValuesToAdd = NULL, ValuesToRemove = NULL) {
  op <- new_operation(
    name = "ModifyDBClusterSnapshotAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_cluster_snapshot_attribute_input(DBClusterSnapshotIdentifier = DBClusterSnapshotIdentifier, AttributeName = AttributeName, ValuesToAdd = ValuesToAdd, ValuesToRemove = ValuesToRemove)
  output <- .rds$modify_db_cluster_snapshot_attribute_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_cluster_snapshot_attribute <- rds_modify_db_cluster_snapshot_attribute

#' Modifies settings for a DB instance
#'
#' Modifies settings for a DB instance. You can change one or more database
#' configuration parameters by specifying these parameters and the new
#' values in the request. To learn what modifications you can make to your
#' DB instance, call DescribeValidDBInstanceModifications before you call
#' ModifyDBInstance.
#'
#' @usage
#' rds_modify_db_instance(DBInstanceIdentifier, AllocatedStorage,
#'   DBInstanceClass, DBSubnetGroupName, DBSecurityGroups,
#'   VpcSecurityGroupIds, ApplyImmediately, MasterUserPassword,
#'   DBParameterGroupName, BackupRetentionPeriod, PreferredBackupWindow,
#'   PreferredMaintenanceWindow, MultiAZ, EngineVersion,
#'   AllowMajorVersionUpgrade, AutoMinorVersionUpgrade, LicenseModel, Iops,
#'   OptionGroupName, NewDBInstanceIdentifier, StorageType, TdeCredentialArn,
#'   TdeCredentialPassword, CACertificateIdentifier, Domain,
#'   CopyTagsToSnapshot, MonitoringInterval, DBPortNumber,
#'   PubliclyAccessible, MonitoringRoleArn, DomainIAMRoleName, PromotionTier,
#'   EnableIAMDatabaseAuthentication, EnablePerformanceInsights,
#'   PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod,
#'   CloudwatchLogsExportConfiguration, ProcessorFeatures,
#'   UseDefaultProcessorFeatures, DeletionProtection)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param AllocatedStorage The new amount of storage (in gibibytes) to allocate for the DB
#' instance.
#' 
#' For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be
#' at least 10\% greater than the current value. Values that are not at
#' least 10\% greater than the existing value are rounded up so that they
#' are 10\% greater than the current value.
#' 
#' For the valid values for allocated storage for each engine, see
#' CreateDBInstance.
#' @param DBInstanceClass The new compute and memory capacity of the DB instance, for example,
#' `db.m4.large`. Not all DB instance classes are available in all AWS
#' Regions, or for all database engines. For the full list of DB instance
#' classes, and availability for your engine, see [DB Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide.*
#' 
#' If you modify the DB instance class, an outage occurs during the change.
#' The change is applied during the next maintenance window, unless
#' `ApplyImmediately` is specified as `true` for this request.
#' 
#' Default: Uses existing setting
#' @param DBSubnetGroupName The new DB subnet group for the DB instance. You can use this parameter
#' to move your DB instance to a different VPC. If your DB instance is not
#' in a VPC, you can also use this parameter to move your DB instance into
#' a VPC. For more information, see [Updating the VPC for a DB
#' Instance](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC)
#' in the *Amazon RDS User Guide.*
#' 
#' Changing the subnet group causes an outage during the change. The change
#' is applied during the next maintenance window, unless you specify `true`
#' for the `ApplyImmediately` parameter.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mySubnetGroup`
#' @param DBSecurityGroups A list of DB security groups to authorize on this DB instance. Changing
#' this setting doesn\'t result in an outage and the change is
#' asynchronously applied as soon as possible.
#' 
#' Constraints:
#' 
#' -   If supplied, must match existing DBSecurityGroups.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to authorize on this DB instance. This
#' change is asynchronously applied as soon as possible.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The associated list of EC2 VPC security groups is
#' managed by the DB cluster. For more information, see ModifyDBCluster.
#' 
#' Constraints:
#' 
#' -   If supplied, must match existing VpcSecurityGroupIds.
#' @param ApplyImmediately Specifies whether the modifications in this request and any pending
#' modifications are asynchronously applied as soon as possible, regardless
#' of the `PreferredMaintenanceWindow` setting for the DB instance.
#' 
#' If this parameter is set to `false`, changes to the DB instance are
#' applied during the next maintenance window. Some parameter changes can
#' cause an outage and are applied on the next call to RebootDBInstance, or
#' the next failure reboot. Review the table of parameters in [Modifying a
#' DB Instance and Using the Apply Immediately
#' Parameter](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html)
#' in the *Amazon RDS User Guide.* to see the impact that setting
#' `ApplyImmediately` to `true` or `false` has for each modified parameter
#' and to determine when the changes are applied.
#' 
#' Default: `false`
#' @param MasterUserPassword The new password for the master user. The password can include any
#' printable ASCII character except \"/\", \"\"\", or \"@\".
#' 
#' Changing this parameter doesn\'t result in an outage and the change is
#' asynchronously applied as soon as possible. Between the time of the
#' request and the completion of the request, the `MasterUserPassword`
#' element exists in the `PendingModifiedValues` element of the operation
#' response.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The password for the master user is managed by the DB
#' cluster. For more information, see ModifyDBCluster.
#' 
#' Default: Uses existing setting
#' 
#' **MariaDB**
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' 
#' **Microsoft SQL Server**
#' 
#' Constraints: Must contain from 8 to 128 characters.
#' 
#' **MySQL**
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' 
#' **Oracle**
#' 
#' Constraints: Must contain from 8 to 30 characters.
#' 
#' **PostgreSQL**
#' 
#' Constraints: Must contain from 8 to 128 characters.
#' 
#' Amazon RDS API actions never return the password, so this action
#' provides a way to regain access to a primary instance user if the
#' password is lost. This includes restoring privileges that might have
#' been accidentally revoked.
#' @param DBParameterGroupName The name of the DB parameter group to apply to the DB instance. Changing
#' this setting doesn\'t result in an outage. The parameter group name
#' itself is changed immediately, but the actual parameter changes are not
#' applied until you reboot the instance without failover. The db instance
#' will NOT be rebooted automatically and the parameter changes will NOT be
#' applied during the next maintenance window.
#' 
#' Default: Uses existing setting
#' 
#' Constraints: The DB parameter group must be in the same DB parameter
#' group family as this DB instance.
#' @param BackupRetentionPeriod The number of days to retain automated backups. Setting this parameter
#' to a positive number enables backups. Setting this parameter to 0
#' disables automated backups.
#' 
#' Changing this parameter can result in an outage if you change from 0 to
#' a non-zero value or from a non-zero value to 0. These changes are
#' applied during the next maintenance window unless the `ApplyImmediately`
#' parameter is set to `true` for this request. If you change the parameter
#' from one non-zero value to another non-zero value, the change is
#' asynchronously applied as soon as possible.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The retention period for automated backups is managed by
#' the DB cluster. For more information, see ModifyDBCluster.
#' 
#' Default: Uses existing setting
#' 
#' Constraints:
#' 
#' -   Must be a value from 0 to 35
#' 
#' -   Can be specified for a MySQL Read Replica only if the source is
#'     running MySQL 5.6 or later
#' 
#' -   Can be specified for a PostgreSQL Read Replica only if the source is
#'     running PostgreSQL 9.3.5
#' 
#' -   Can\'t be set to 0 if the DB instance is a source to Read Replicas
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled, as determined by the
#' `BackupRetentionPeriod` parameter. Changing this parameter doesn\'t
#' result in an outage and the change is asynchronously applied as soon as
#' possible.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. The daily time range for creating automated backups is
#' managed by the DB cluster. For more information, see ModifyDBCluster.
#' 
#' Constraints:
#' 
#' -   Must be in the format hh24:mi-hh24:mi
#' 
#' -   Must be in Universal Time Coordinated (UTC)
#' 
#' -   Must not conflict with the preferred maintenance window
#' 
#' -   Must be at least 30 minutes
#' @param PreferredMaintenanceWindow The weekly time range (in UTC) during which system maintenance can
#' occur, which might result in an outage. Changing this parameter doesn\'t
#' result in an outage, except in the following situation, and the change
#' is asynchronously applied as soon as possible. If there are pending
#' actions that cause a reboot, and the maintenance window is changed to
#' include the current time, then changing this parameter will cause a
#' reboot of the DB instance. If moving this window to the current time,
#' there must be at least 30 minutes between the current time and end of
#' the window to ensure pending changes are applied.
#' 
#' Default: Uses existing setting
#' 
#' Format: ddd:hh24:mi-ddd:hh24:mi
#' 
#' Valid Days: Mon \\| Tue \\| Wed \\| Thu \\| Fri \\| Sat \\| Sun
#' 
#' Constraints: Must be at least 30 minutes
#' @param MultiAZ Specifies if the DB instance is a Multi-AZ deployment. Changing this
#' parameter doesn\'t result in an outage and the change is applied during
#' the next maintenance window unless the `ApplyImmediately` parameter is
#' set to `true` for this request.
#' @param EngineVersion The version number of the database engine to upgrade to. Changing this
#' parameter results in an outage and the change is applied during the next
#' maintenance window unless the `ApplyImmediately` parameter is set to
#' `true` for this request.
#' 
#' For major version upgrades, if a nondefault DB parameter group is
#' currently in use, a new DB parameter group in the DB parameter group
#' family for the new engine version must be specified. The new DB
#' parameter group can be the default for that DB parameter group family.
#' 
#' For information about valid engine versions, see CreateDBInstance, or
#' call DescribeDBEngineVersions.
#' @param AllowMajorVersionUpgrade Indicates that major version upgrades are allowed. Changing this
#' parameter doesn\'t result in an outage and the change is asynchronously
#' applied as soon as possible.
#' 
#' Constraints: This parameter must be set to true when specifying a value
#' for the EngineVersion parameter that is a different major version than
#' the DB instance\'s current version.
#' @param AutoMinorVersionUpgrade Indicates that minor version upgrades are applied automatically to the
#' DB instance during the maintenance window. Changing this parameter
#' doesn\'t result in an outage except in the following case and the change
#' is asynchronously applied as soon as possible. An outage will result if
#' this parameter is set to `true` during the maintenance window, and a
#' newer minor version is available, and RDS has enabled auto patching for
#' that engine version.
#' @param LicenseModel The license model for the DB instance.
#' 
#' Valid values: `license-included` \\| `bring-your-own-license` \\|
#' `general-public-license`
#' @param Iops The new Provisioned IOPS (I/O operations per second) value for the RDS
#' instance.
#' 
#' Changing this setting doesn\'t result in an outage and the change is
#' applied during the next maintenance window unless the `ApplyImmediately`
#' parameter is set to `true` for this request. If you are migrating from
#' Provisioned IOPS to standard storage, set this value to 0. The DB
#' instance will require a reboot for the change in storage type to take
#' effect.
#' 
#' If you choose to migrate your DB instance from using standard storage to
#' using Provisioned IOPS, or from using Provisioned IOPS to using standard
#' storage, the process can take time. The duration of the migration
#' depends on several factors such as database load, storage size, storage
#' type (standard or Provisioned IOPS), amount of IOPS provisioned (if
#' any), and the number of prior scale storage operations. Typical
#' migration times are under 24 hours, but the process can take up to
#' several days in some cases. During the migration, the DB instance is
#' available for use, but might experience performance degradation. While
#' the migration takes place, nightly backups for the instance are
#' suspended. No other Amazon RDS operations can take place for the
#' instance, including modifying the instance, rebooting the instance,
#' deleting the instance, creating a Read Replica for the instance, and
#' creating a DB snapshot of the instance.
#' 
#' Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL, the value
#' supplied must be at least 10\% greater than the current value. Values
#' that are not at least 10\% greater than the existing value are rounded up
#' so that they are 10\% greater than the current value.
#' 
#' Default: Uses existing setting
#' @param OptionGroupName Indicates that the DB instance should be associated with the specified
#' option group. Changing this parameter doesn\'t result in an outage
#' except in the following case and the change is applied during the next
#' maintenance window unless the `ApplyImmediately` parameter is set to
#' `true` for this request. If the parameter change results in an option
#' group that enables OEM, this change can cause a brief (sub-second)
#' period during which new connections are rejected but existing
#' connections are not interrupted.
#' 
#' Permanent options, such as the TDE option for Oracle Advanced Security
#' TDE, can\'t be removed from an option group, and that option group
#' can\'t be removed from a DB instance once it is associated with a DB
#' instance
#' @param NewDBInstanceIdentifier The new DB instance identifier for the DB instance when renaming a DB
#' instance. When you change the DB instance identifier, an instance reboot
#' will occur immediately if you set `Apply Immediately` to true, or will
#' occur during the next maintenance window if `Apply Immediately` to
#' false. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   The first character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param StorageType Specifies the storage type to be associated with the DB instance.
#' 
#' If you specify Provisioned IOPS (`io1`), you must also include a value
#' for the `Iops` parameter.
#' 
#' If you choose to migrate your DB instance from using standard storage to
#' using Provisioned IOPS, or from using Provisioned IOPS to using standard
#' storage, the process can take time. The duration of the migration
#' depends on several factors such as database load, storage size, storage
#' type (standard or Provisioned IOPS), amount of IOPS provisioned (if
#' any), and the number of prior scale storage operations. Typical
#' migration times are under 24 hours, but the process can take up to
#' several days in some cases. During the migration, the DB instance is
#' available for use, but might experience performance degradation. While
#' the migration takes place, nightly backups for the instance are
#' suspended. No other Amazon RDS operations can take place for the
#' instance, including modifying the instance, rebooting the instance,
#' deleting the instance, creating a Read Replica for the instance, and
#' creating a DB snapshot of the instance.
#' 
#' Valid values: `standard | gp2 | io1`
#' 
#' Default: `io1` if the `Iops` parameter is specified, otherwise
#' `standard`
#' @param TdeCredentialArn The ARN from the key store with which to associate the instance for TDE
#' encryption.
#' @param TdeCredentialPassword The password for the given ARN from the key store in order to access the
#' device.
#' @param CACertificateIdentifier Indicates the certificate that needs to be associated with the instance.
#' @param Domain The Active Directory Domain to move the instance to. Specify `none` to
#' remove the instance from its current domain. The domain must be created
#' prior to this operation. Currently only a Microsoft SQL Server instance
#' can be created in a Active Directory Domain.
#' @param CopyTagsToSnapshot True to copy all tags from the DB instance to snapshots of the DB
#' instance, and otherwise false. The default is false.
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. Copying tags to snapshots is managed by the DB cluster.
#' Setting this value for an Aurora DB instance has no effect on the DB
#' cluster setting. For more information, see ModifyDBCluster.
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the DB instance. To disable collecting
#' Enhanced Monitoring metrics, specify 0. The default is 0.
#' 
#' If `MonitoringRoleArn` is specified, then you must also set
#' `MonitoringInterval` to a value other than 0.
#' 
#' Valid Values: `0, 1, 5, 10, 15, 30, 60`
#' @param DBPortNumber The port number on which the database accepts connections.
#' 
#' The value of the `DBPortNumber` parameter must not match any of the port
#' values specified for options in the option group for the DB instance.
#' 
#' Your database will restart when you change the `DBPortNumber` value
#' regardless of the value of the `ApplyImmediately` parameter.
#' 
#' **MySQL**
#' 
#' Default: `3306`
#' 
#' Valid Values: `1150-65535`
#' 
#' **MariaDB**
#' 
#' Default: `3306`
#' 
#' Valid Values: `1150-65535`
#' 
#' **PostgreSQL**
#' 
#' Default: `5432`
#' 
#' Valid Values: `1150-65535`
#' 
#' Type: Integer
#' 
#' **Oracle**
#' 
#' Default: `1521`
#' 
#' Valid Values: `1150-65535`
#' 
#' **SQL Server**
#' 
#' Default: `1433`
#' 
#' Valid Values: `1150-65535` except for `1434`, `3389`, `47001`, `49152`,
#' and `49152` through `49156`.
#' 
#' **Amazon Aurora**
#' 
#' Default: `3306`
#' 
#' Valid Values: `1150-65535`
#' @param PubliclyAccessible Boolean value that indicates if the DB instance has a publicly
#' resolvable DNS name. Set to `True` to make the DB instance
#' Internet-facing with a publicly resolvable DNS name, which resolves to a
#' public IP address. Set to `False` to make the DB instance internal with
#' a DNS name that resolves to a private IP address.
#' 
#' `PubliclyAccessible` only applies to DB instances in a VPC. The DB
#' instance must be part of a public subnet and `PubliclyAccessible` must
#' be true in order for it to be publicly accessible.
#' 
#' Changes to the `PubliclyAccessible` parameter are applied immediately
#' regardless of the value of the `ApplyImmediately` parameter.
#' 
#' Default: false
#' @param MonitoringRoleArn The ARN for the IAM role that permits RDS to send enhanced monitoring
#' metrics to Amazon CloudWatch Logs. For example,
#' `arn:aws:iam:123456789012:role/emaccess`. For information on creating a
#' monitoring role, go to [To create an IAM role for Amazon RDS Enhanced
#' Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole)
#' in the *Amazon RDS User Guide.*
#' 
#' If `MonitoringInterval` is set to a value other than 0, then you must
#' supply a `MonitoringRoleArn` value.
#' @param DomainIAMRoleName The name of the IAM role to use when making API calls to the Directory
#' Service.
#' @param PromotionTier A value that specifies the order in which an Aurora Replica is promoted
#' to the primary instance after a failure of the existing primary
#' instance. For more information, see [Fault Tolerance for an Aurora DB
#' Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance)
#' in the *Amazon Aurora User Guide*.
#' 
#' Default: 1
#' 
#' Valid Values: 0 - 15
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' You can enable IAM database authentication for the following database
#' engines
#' 
#' **Amazon Aurora**
#' 
#' Not applicable. Mapping AWS IAM accounts to database accounts is managed
#' by the DB cluster. For more information, see ModifyDBCluster.
#' 
#' **MySQL**
#' 
#' -   For MySQL 5.6, minor version 5.6.34 or higher
#' 
#' -   For MySQL 5.7, minor version 5.7.16 or higher
#' 
#' Default: `false`
#' @param EnablePerformanceInsights True to enable Performance Insights for the DB instance, and otherwise
#' false.
#' 
#' For more information, see [Using Amazon Performance
#' Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)
#' in the *Amazon Relational Database Service User Guide*.
#' @param PerformanceInsightsKMSKeyId The AWS KMS key identifier for encryption of Performance Insights data.
#' The KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or
#' the KMS key alias for the KMS encryption key.
#' @param PerformanceInsightsRetentionPeriod The amount of time, in days, to retain Performance Insights data. Valid
#' values are 7 or 731 (2 years).
#' @param CloudwatchLogsExportConfiguration The configuration setting for the log types to be enabled for export to
#' CloudWatch Logs for a specific DB instance.
#' 
#' A change to the `CloudwatchLogsExportConfiguration` parameter is always
#' applied to the DB instance immediately. Therefore, the
#' `ApplyImmediately` parameter has no effect.
#' @param ProcessorFeatures The number of CPU cores and the number of threads per core for the DB
#' instance class of the DB instance.
#' @param UseDefaultProcessorFeatures A value that specifies that the DB instance class of the DB instance
#' uses its default processor features.
#' @param DeletionProtection Indicates if the DB instance has deletion protection enabled. The
#' database can\'t be deleted when this value is set to true. For more
#' information, see [Deleting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_instance(
#'   DBInstanceIdentifier = "string",
#'   AllocatedStorage = 123,
#'   DBInstanceClass = "string",
#'   DBSubnetGroupName = "string",
#'   DBSecurityGroups = list(
#'     "string"
#'   ),
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   ApplyImmediately = TRUE|FALSE,
#'   MasterUserPassword = "string",
#'   DBParameterGroupName = "string",
#'   BackupRetentionPeriod = 123,
#'   PreferredBackupWindow = "string",
#'   PreferredMaintenanceWindow = "string",
#'   MultiAZ = TRUE|FALSE,
#'   EngineVersion = "string",
#'   AllowMajorVersionUpgrade = TRUE|FALSE,
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   LicenseModel = "string",
#'   Iops = 123,
#'   OptionGroupName = "string",
#'   NewDBInstanceIdentifier = "string",
#'   StorageType = "string",
#'   TdeCredentialArn = "string",
#'   TdeCredentialPassword = "string",
#'   CACertificateIdentifier = "string",
#'   Domain = "string",
#'   CopyTagsToSnapshot = TRUE|FALSE,
#'   MonitoringInterval = 123,
#'   DBPortNumber = 123,
#'   PubliclyAccessible = TRUE|FALSE,
#'   MonitoringRoleArn = "string",
#'   DomainIAMRoleName = "string",
#'   PromotionTier = 123,
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   EnablePerformanceInsights = TRUE|FALSE,
#'   PerformanceInsightsKMSKeyId = "string",
#'   PerformanceInsightsRetentionPeriod = 123,
#'   CloudwatchLogsExportConfiguration = list(
#'     EnableLogTypes = list(
#'       "string"
#'     ),
#'     DisableLogTypes = list(
#'       "string"
#'     )
#'   ),
#'   ProcessorFeatures = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   UseDefaultProcessorFeatures = TRUE|FALSE,
#'   DeletionProtection = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_instance
rds_modify_db_instance <- function(DBInstanceIdentifier, AllocatedStorage = NULL, DBInstanceClass = NULL, DBSubnetGroupName = NULL, DBSecurityGroups = NULL, VpcSecurityGroupIds = NULL, ApplyImmediately = NULL, MasterUserPassword = NULL, DBParameterGroupName = NULL, BackupRetentionPeriod = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, MultiAZ = NULL, EngineVersion = NULL, AllowMajorVersionUpgrade = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, Iops = NULL, OptionGroupName = NULL, NewDBInstanceIdentifier = NULL, StorageType = NULL, TdeCredentialArn = NULL, TdeCredentialPassword = NULL, CACertificateIdentifier = NULL, Domain = NULL, CopyTagsToSnapshot = NULL, MonitoringInterval = NULL, DBPortNumber = NULL, PubliclyAccessible = NULL, MonitoringRoleArn = NULL, DomainIAMRoleName = NULL, PromotionTier = NULL, EnableIAMDatabaseAuthentication = NULL, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, PerformanceInsightsRetentionPeriod = NULL, CloudwatchLogsExportConfiguration = NULL, ProcessorFeatures = NULL, UseDefaultProcessorFeatures = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "ModifyDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, AllocatedStorage = AllocatedStorage, DBInstanceClass = DBInstanceClass, DBSubnetGroupName = DBSubnetGroupName, DBSecurityGroups = DBSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, ApplyImmediately = ApplyImmediately, MasterUserPassword = MasterUserPassword, DBParameterGroupName = DBParameterGroupName, BackupRetentionPeriod = BackupRetentionPeriod, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, MultiAZ = MultiAZ, EngineVersion = EngineVersion, AllowMajorVersionUpgrade = AllowMajorVersionUpgrade, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, Iops = Iops, OptionGroupName = OptionGroupName, NewDBInstanceIdentifier = NewDBInstanceIdentifier, StorageType = StorageType, TdeCredentialArn = TdeCredentialArn, TdeCredentialPassword = TdeCredentialPassword, CACertificateIdentifier = CACertificateIdentifier, Domain = Domain, CopyTagsToSnapshot = CopyTagsToSnapshot, MonitoringInterval = MonitoringInterval, DBPortNumber = DBPortNumber, PubliclyAccessible = PubliclyAccessible, MonitoringRoleArn = MonitoringRoleArn, DomainIAMRoleName = DomainIAMRoleName, PromotionTier = PromotionTier, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod = PerformanceInsightsRetentionPeriod, CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration, ProcessorFeatures = ProcessorFeatures, UseDefaultProcessorFeatures = UseDefaultProcessorFeatures, DeletionProtection = DeletionProtection)
  output <- .rds$modify_db_instance_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_instance <- rds_modify_db_instance

#' Modifies the parameters of a DB parameter group
#'
#' Modifies the parameters of a DB parameter group. To modify more than one
#' parameter, submit a list of the following: `ParameterName`,
#' `ParameterValue`, and `ApplyMethod`. A maximum of 20 parameters can be
#' modified in a single request.
#' 
#' Changes to dynamic parameters are applied immediately. Changes to static
#' parameters require a reboot without failover to the DB instance
#' associated with the parameter group before the change can take effect.
#' 
#' After you modify a DB parameter group, you should wait at least 5
#' minutes before creating your first DB instance that uses that DB
#' parameter group as the default parameter group. This allows Amazon RDS
#' to fully complete the modify action before the parameter group is used
#' as the default for a new DB instance. This is especially important for
#' parameters that are critical when creating the default database for a DB
#' instance, such as the character set for the default database defined by
#' the `character_set_database` parameter. You can use the *Parameter
#' Groups* option of the [Amazon RDS
#' console](https://console.aws.amazon.com/rds/) or the
#' *DescribeDBParameters* command to verify that your DB parameter group
#' has been created or modified.
#'
#' @usage
#' rds_modify_db_parameter_group(DBParameterGroupName, Parameters)
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DBParameterGroup.
#' @param Parameters &#91;required&#93; An array of parameter names, values, and the apply method for the
#' parameter update. At least one parameter name, value, and apply method
#' must be supplied; subsequent arguments are optional. A maximum of 20
#' parameters can be modified in a single request.
#' 
#' Valid Values (for the application method): `immediate | pending-reboot`
#' 
#' You can use the immediate value with dynamic parameters only. You can
#' use the pending-reboot value for both dynamic and static parameters, and
#' changes are applied when you reboot the DB instance without failover.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_parameter_group(
#'   DBParameterGroupName = "string",
#'   Parameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string",
#'       Description = "string",
#'       Source = "string",
#'       ApplyType = "string",
#'       DataType = "string",
#'       AllowedValues = "string",
#'       IsModifiable = TRUE|FALSE,
#'       MinimumEngineVersion = "string",
#'       ApplyMethod = "immediate"|"pending-reboot",
#'       SupportedEngineModes = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_parameter_group
rds_modify_db_parameter_group <- function(DBParameterGroupName, Parameters) {
  op <- new_operation(
    name = "ModifyDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName, Parameters = Parameters)
  output <- .rds$modify_db_parameter_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_parameter_group <- rds_modify_db_parameter_group

#' Updates a manual DB snapshot, which can be encrypted or not encrypted,
#' with a new engine version
#'
#' Updates a manual DB snapshot, which can be encrypted or not encrypted,
#' with a new engine version.
#' 
#' Amazon RDS supports upgrading DB snapshots for MySQL and Oracle.
#'
#' @usage
#' rds_modify_db_snapshot(DBSnapshotIdentifier, EngineVersion,
#'   OptionGroupName)
#'
#' @param DBSnapshotIdentifier &#91;required&#93; The identifier of the DB snapshot to modify.
#' @param EngineVersion The engine version to upgrade the DB snapshot to.
#' 
#' The following are the database engines and engine versions that are
#' available when you upgrade a DB snapshot.
#' 
#' **MySQL**
#' 
#' -   `5.5.46` (supported for 5.1 DB snapshots)
#' 
#' **Oracle**
#' 
#' -   `12.1.0.2.v8` (supported for 12.1.0.1 DB snapshots)
#' 
#' -   `11.2.0.4.v12` (supported for 11.2.0.2 DB snapshots)
#' 
#' -   `11.2.0.4.v11` (supported for 11.2.0.3 DB snapshots)
#' @param OptionGroupName The option group to identify with the upgraded DB snapshot.
#' 
#' You can specify this parameter when you upgrade an Oracle DB snapshot.
#' The same option group considerations apply when upgrading a DB snapshot
#' as when upgrading a DB instance. For more information, see [Option Group
#' Considerations](http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Oracle.html#USER_UpgradeDBInstance.Oracle.OGPG.OG)
#' in the *Amazon RDS User Guide.*
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_snapshot(
#'   DBSnapshotIdentifier = "string",
#'   EngineVersion = "string",
#'   OptionGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_snapshot
rds_modify_db_snapshot <- function(DBSnapshotIdentifier, EngineVersion = NULL, OptionGroupName = NULL) {
  op <- new_operation(
    name = "ModifyDBSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_snapshot_input(DBSnapshotIdentifier = DBSnapshotIdentifier, EngineVersion = EngineVersion, OptionGroupName = OptionGroupName)
  output <- .rds$modify_db_snapshot_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_snapshot <- rds_modify_db_snapshot

#' Adds an attribute and values to, or removes an attribute and values
#' from, a manual DB snapshot
#'
#' Adds an attribute and values to, or removes an attribute and values
#' from, a manual DB snapshot.
#' 
#' To share a manual DB snapshot with other AWS accounts, specify `restore`
#' as the `AttributeName` and use the `ValuesToAdd` parameter to add a list
#' of IDs of the AWS accounts that are authorized to restore the manual DB
#' snapshot. Uses the value `all` to make the manual DB snapshot public,
#' which means it can be copied or restored by all AWS accounts. Do not add
#' the `all` value for any manual DB snapshots that contain private
#' information that you don\'t want available to all AWS accounts. If the
#' manual DB snapshot is encrypted, it can be shared, but only by
#' specifying a list of authorized AWS account IDs for the `ValuesToAdd`
#' parameter. You can\'t use `all` as a value for that parameter in this
#' case.
#' 
#' To view which AWS accounts have access to copy or restore a manual DB
#' snapshot, or whether a manual DB snapshot public or private, use the
#' DescribeDBSnapshotAttributes API action.
#'
#' @usage
#' rds_modify_db_snapshot_attribute(DBSnapshotIdentifier, AttributeName,
#'   ValuesToAdd, ValuesToRemove)
#'
#' @param DBSnapshotIdentifier &#91;required&#93; The identifier for the DB snapshot to modify the attributes for.
#' @param AttributeName &#91;required&#93; The name of the DB snapshot attribute to modify.
#' 
#' To manage authorization for other AWS accounts to copy or restore a
#' manual DB snapshot, set this value to `restore`.
#' @param ValuesToAdd A list of DB snapshot attributes to add to the attribute specified by
#' `AttributeName`.
#' 
#' To authorize other AWS accounts to copy or restore a manual snapshot,
#' set this list to include one or more AWS account IDs, or `all` to make
#' the manual DB snapshot restorable by any AWS account. Do not add the
#' `all` value for any manual DB snapshots that contain private information
#' that you don\'t want available to all AWS accounts.
#' @param ValuesToRemove A list of DB snapshot attributes to remove from the attribute specified
#' by `AttributeName`.
#' 
#' To remove authorization for other AWS accounts to copy or restore a
#' manual snapshot, set this list to include one or more AWS account
#' identifiers, or `all` to remove authorization for any AWS account to
#' copy or restore the DB snapshot. If you specify `all`, an AWS account
#' whose account ID is explicitly added to the `restore` attribute can
#' still copy or restore the manual DB snapshot.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_snapshot_attribute(
#'   DBSnapshotIdentifier = "string",
#'   AttributeName = "string",
#'   ValuesToAdd = list(
#'     "string"
#'   ),
#'   ValuesToRemove = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_snapshot_attribute
rds_modify_db_snapshot_attribute <- function(DBSnapshotIdentifier, AttributeName, ValuesToAdd = NULL, ValuesToRemove = NULL) {
  op <- new_operation(
    name = "ModifyDBSnapshotAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_snapshot_attribute_input(DBSnapshotIdentifier = DBSnapshotIdentifier, AttributeName = AttributeName, ValuesToAdd = ValuesToAdd, ValuesToRemove = ValuesToRemove)
  output <- .rds$modify_db_snapshot_attribute_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_snapshot_attribute <- rds_modify_db_snapshot_attribute

#' Modifies an existing DB subnet group
#'
#' Modifies an existing DB subnet group. DB subnet groups must contain at
#' least one subnet in at least two AZs in the AWS Region.
#'
#' @usage
#' rds_modify_db_subnet_group(DBSubnetGroupName, DBSubnetGroupDescription,
#'   SubnetIds)
#'
#' @param DBSubnetGroupName &#91;required&#93; The name for the DB subnet group. This value is stored as a lowercase
#' string. You can\'t modify the default subnet group.
#' 
#' Constraints: Must match the name of an existing DBSubnetGroup. Must not
#' be default.
#' 
#' Example: `mySubnetgroup`
#' @param DBSubnetGroupDescription The description for the DB subnet group.
#' @param SubnetIds &#91;required&#93; The EC2 subnet IDs for the DB subnet group.
#'
#' @section Request syntax:
#' ```
#' svc$modify_db_subnet_group(
#'   DBSubnetGroupName = "string",
#'   DBSubnetGroupDescription = "string",
#'   SubnetIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_db_subnet_group
rds_modify_db_subnet_group <- function(DBSubnetGroupName, DBSubnetGroupDescription = NULL, SubnetIds) {
  op <- new_operation(
    name = "ModifyDBSubnetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_db_subnet_group_input(DBSubnetGroupName = DBSubnetGroupName, DBSubnetGroupDescription = DBSubnetGroupDescription, SubnetIds = SubnetIds)
  output <- .rds$modify_db_subnet_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_db_subnet_group <- rds_modify_db_subnet_group

#' Modifies an existing RDS event notification subscription
#'
#' Modifies an existing RDS event notification subscription. Note that you
#' can\'t modify the source identifiers using this call; to change source
#' identifiers for a subscription, use the
#' AddSourceIdentifierToSubscription and
#' RemoveSourceIdentifierFromSubscription calls.
#' 
#' You can see a list of the event categories for a given SourceType in the
#' [Events](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
#' topic in the *Amazon RDS User Guide* or by using the
#' **DescribeEventCategories** action.
#'
#' @usage
#' rds_modify_event_subscription(SubscriptionName, SnsTopicArn, SourceType,
#'   EventCategories, Enabled)
#'
#' @param SubscriptionName &#91;required&#93; The name of the RDS event notification subscription.
#' @param SnsTopicArn The Amazon Resource Name (ARN) of the SNS topic created for event
#' notification. The ARN is created by Amazon SNS when you create a topic
#' and subscribe to it.
#' @param SourceType The type of source that is generating the events. For example, if you
#' want to be notified of events generated by a DB instance, you would set
#' this parameter to db-instance. if this value is not specified, all
#' events are returned.
#' 
#' Valid values: db-instance \\| db-parameter-group \\| db-security-group \\|
#' db-snapshot
#' @param EventCategories A list of event categories for a SourceType that you want to subscribe
#' to. You can see a list of the categories for a given SourceType in the
#' [Events](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html)
#' topic in the *Amazon RDS User Guide* or by using the
#' **DescribeEventCategories** action.
#' @param Enabled A Boolean value; set to **true** to activate the subscription.
#'
#' @section Request syntax:
#' ```
#' svc$modify_event_subscription(
#'   SubscriptionName = "string",
#'   SnsTopicArn = "string",
#'   SourceType = "string",
#'   EventCategories = list(
#'     "string"
#'   ),
#'   Enabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_event_subscription
rds_modify_event_subscription <- function(SubscriptionName, SnsTopicArn = NULL, SourceType = NULL, EventCategories = NULL, Enabled = NULL) {
  op <- new_operation(
    name = "ModifyEventSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_event_subscription_input(SubscriptionName = SubscriptionName, SnsTopicArn = SnsTopicArn, SourceType = SourceType, EventCategories = EventCategories, Enabled = Enabled)
  output <- .rds$modify_event_subscription_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_event_subscription <- rds_modify_event_subscription

#' Modify a setting for an Amazon Aurora global cluster
#'
#' Modify a setting for an Amazon Aurora global cluster. You can change one
#' or more database configuration parameters by specifying these parameters
#' and the new values in the request. For more information on Amazon
#' Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_modify_global_cluster(GlobalClusterIdentifier,
#'   NewGlobalClusterIdentifier, DeletionProtection)
#'
#' @param GlobalClusterIdentifier The DB cluster identifier for the global cluster being modified. This
#' parameter is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing global database cluster.
#' @param NewGlobalClusterIdentifier The new cluster identifier for the global database cluster when
#' modifying a global database cluster. This value is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   The first character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-cluster2`
#' @param DeletionProtection Indicates if the global database cluster has deletion protection
#' enabled. The global database cluster can\'t be deleted when this value
#' is set to true.
#'
#' @section Request syntax:
#' ```
#' svc$modify_global_cluster(
#'   GlobalClusterIdentifier = "string",
#'   NewGlobalClusterIdentifier = "string",
#'   DeletionProtection = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_global_cluster
rds_modify_global_cluster <- function(GlobalClusterIdentifier = NULL, NewGlobalClusterIdentifier = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "ModifyGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, NewGlobalClusterIdentifier = NewGlobalClusterIdentifier, DeletionProtection = DeletionProtection)
  output <- .rds$modify_global_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_global_cluster <- rds_modify_global_cluster

#' Modifies an existing option group
#'
#' Modifies an existing option group.
#'
#' @usage
#' rds_modify_option_group(OptionGroupName, OptionsToInclude,
#'   OptionsToRemove, ApplyImmediately)
#'
#' @param OptionGroupName &#91;required&#93; The name of the option group to be modified.
#' 
#' Permanent options, such as the TDE option for Oracle Advanced Security
#' TDE, can\'t be removed from an option group, and that option group
#' can\'t be removed from a DB instance once it is associated with a DB
#' instance
#' @param OptionsToInclude Options in this list are added to the option group or, if already
#' present, the specified configuration is used to update the existing
#' configuration.
#' @param OptionsToRemove Options in this list are removed from the option group.
#' @param ApplyImmediately Indicates whether the changes should be applied immediately, or during
#' the next maintenance window for each instance associated with the option
#' group.
#'
#' @section Request syntax:
#' ```
#' svc$modify_option_group(
#'   OptionGroupName = "string",
#'   OptionsToInclude = list(
#'     list(
#'       OptionName = "string",
#'       Port = 123,
#'       OptionVersion = "string",
#'       DBSecurityGroupMemberships = list(
#'         "string"
#'       ),
#'       VpcSecurityGroupMemberships = list(
#'         "string"
#'       ),
#'       OptionSettings = list(
#'         list(
#'           Name = "string",
#'           Value = "string",
#'           DefaultValue = "string",
#'           Description = "string",
#'           ApplyType = "string",
#'           DataType = "string",
#'           AllowedValues = "string",
#'           IsModifiable = TRUE|FALSE,
#'           IsCollection = TRUE|FALSE
#'         )
#'       )
#'     )
#'   ),
#'   OptionsToRemove = list(
#'     "string"
#'   ),
#'   ApplyImmediately = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_modify_option_group
rds_modify_option_group <- function(OptionGroupName, OptionsToInclude = NULL, OptionsToRemove = NULL, ApplyImmediately = NULL) {
  op <- new_operation(
    name = "ModifyOptionGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$modify_option_group_input(OptionGroupName = OptionGroupName, OptionsToInclude = OptionsToInclude, OptionsToRemove = OptionsToRemove, ApplyImmediately = ApplyImmediately)
  output <- .rds$modify_option_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$modify_option_group <- rds_modify_option_group

#' Promotes a Read Replica DB instance to a standalone DB instance
#'
#' Promotes a Read Replica DB instance to a standalone DB instance.
#' 
#' -   Backup duration is a function of the amount of changes to the
#'     database since the previous backup. If you plan to promote a Read
#'     Replica to a standalone instance, we recommend that you enable
#'     backups and complete at least one backup prior to promotion. In
#'     addition, a Read Replica cannot be promoted to a standalone instance
#'     when it is in the `backing-up` status. If you have enabled backups
#'     on your Read Replica, configure the automated backup window so that
#'     daily backups do not interfere with Read Replica promotion.
#' 
#' -   This command doesn\'t apply to Aurora MySQL and Aurora PostgreSQL.
#'
#' @usage
#' rds_promote_read_replica(DBInstanceIdentifier, BackupRetentionPeriod,
#'   PreferredBackupWindow)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This value is stored as a lowercase string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing Read Replica DB instance.
#' 
#' Example: `mydbinstance`
#' @param BackupRetentionPeriod The number of days to retain automated backups. Setting this parameter
#' to a positive number enables backups. Setting this parameter to 0
#' disables automated backups.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 0 to 8
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled, using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region. To see the time blocks available, see
#' [Adjusting the Preferred Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AdjustingTheMaintenanceWindow.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#'
#' @section Request syntax:
#' ```
#' svc$promote_read_replica(
#'   DBInstanceIdentifier = "string",
#'   BackupRetentionPeriod = 123,
#'   PreferredBackupWindow = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_promote_read_replica
rds_promote_read_replica <- function(DBInstanceIdentifier, BackupRetentionPeriod = NULL, PreferredBackupWindow = NULL) {
  op <- new_operation(
    name = "PromoteReadReplica",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$promote_read_replica_input(DBInstanceIdentifier = DBInstanceIdentifier, BackupRetentionPeriod = BackupRetentionPeriod, PreferredBackupWindow = PreferredBackupWindow)
  output <- .rds$promote_read_replica_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$promote_read_replica <- rds_promote_read_replica

#' Promotes a Read Replica DB cluster to a standalone DB cluster
#'
#' Promotes a Read Replica DB cluster to a standalone DB cluster.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_promote_read_replica_db_cluster(DBClusterIdentifier)
#'
#' @param DBClusterIdentifier &#91;required&#93; The identifier of the DB cluster Read Replica to promote. This parameter
#' is not case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster Read Replica.
#' 
#' Example: `my-cluster-replica1`
#'
#' @section Request syntax:
#' ```
#' svc$promote_read_replica_db_cluster(
#'   DBClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_promote_read_replica_db_cluster
rds_promote_read_replica_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "PromoteReadReplicaDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$promote_read_replica_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .rds$promote_read_replica_db_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$promote_read_replica_db_cluster <- rds_promote_read_replica_db_cluster

#' Purchases a reserved DB instance offering
#'
#' Purchases a reserved DB instance offering.
#'
#' @usage
#' rds_purchase_reserved_db_instances_offering(
#'   ReservedDBInstancesOfferingId, ReservedDBInstanceId, DBInstanceCount,
#'   Tags)
#'
#' @param ReservedDBInstancesOfferingId &#91;required&#93; The ID of the Reserved DB instance offering to purchase.
#' 
#' Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
#' @param ReservedDBInstanceId Customer-specified identifier to track this reservation.
#' 
#' Example: myreservationID
#' @param DBInstanceCount The number of instances to reserve.
#' 
#' Default: `1`
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$purchase_reserved_db_instances_offering(
#'   ReservedDBInstancesOfferingId = "string",
#'   ReservedDBInstanceId = "string",
#'   DBInstanceCount = 123,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_purchase_reserved_db_instances_offering
rds_purchase_reserved_db_instances_offering <- function(ReservedDBInstancesOfferingId, ReservedDBInstanceId = NULL, DBInstanceCount = NULL, Tags = NULL) {
  op <- new_operation(
    name = "PurchaseReservedDBInstancesOffering",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$purchase_reserved_db_instances_offering_input(ReservedDBInstancesOfferingId = ReservedDBInstancesOfferingId, ReservedDBInstanceId = ReservedDBInstanceId, DBInstanceCount = DBInstanceCount, Tags = Tags)
  output <- .rds$purchase_reserved_db_instances_offering_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$purchase_reserved_db_instances_offering <- rds_purchase_reserved_db_instances_offering

#' You might need to reboot your DB instance, usually for maintenance
#' reasons
#'
#' You might need to reboot your DB instance, usually for maintenance
#' reasons. For example, if you make certain modifications, or if you
#' change the DB parameter group associated with the DB instance, you must
#' reboot the instance for the changes to take effect.
#' 
#' Rebooting a DB instance restarts the database engine service. Rebooting
#' a DB instance results in a momentary outage, during which the DB
#' instance status is set to rebooting.
#' 
#' For more information about rebooting, see [Rebooting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_RebootInstance.html)
#' in the *Amazon RDS User Guide.*
#'
#' @usage
#' rds_reboot_db_instance(DBInstanceIdentifier, ForceFailover)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBInstance.
#' @param ForceFailover When `true`, the reboot is conducted through a MultiAZ failover.
#' 
#' Constraint: You can\'t specify `true` if the instance is not configured
#' for MultiAZ.
#'
#' @section Request syntax:
#' ```
#' svc$reboot_db_instance(
#'   DBInstanceIdentifier = "string",
#'   ForceFailover = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_reboot_db_instance
rds_reboot_db_instance <- function(DBInstanceIdentifier, ForceFailover = NULL) {
  op <- new_operation(
    name = "RebootDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$reboot_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, ForceFailover = ForceFailover)
  output <- .rds$reboot_db_instance_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$reboot_db_instance <- rds_reboot_db_instance

#' Detaches an Aurora secondary cluster from an Aurora global database
#' cluster
#'
#' Detaches an Aurora secondary cluster from an Aurora global database
#' cluster. The cluster becomes a standalone cluster with read-write
#' capability instead of being read-only and receiving data from a primary
#' cluster in a different region.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_remove_from_global_cluster(GlobalClusterIdentifier,
#'   DbClusterIdentifier)
#'
#' @param GlobalClusterIdentifier The cluster identifier to detach from the Aurora global database
#' cluster.
#' @param DbClusterIdentifier The Amazon Resource Name (ARN) identifying the cluster that was detached
#' from the Aurora global database cluster.
#'
#' @section Request syntax:
#' ```
#' svc$remove_from_global_cluster(
#'   GlobalClusterIdentifier = "string",
#'   DbClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_remove_from_global_cluster
rds_remove_from_global_cluster <- function(GlobalClusterIdentifier = NULL, DbClusterIdentifier = NULL) {
  op <- new_operation(
    name = "RemoveFromGlobalCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$remove_from_global_cluster_input(GlobalClusterIdentifier = GlobalClusterIdentifier, DbClusterIdentifier = DbClusterIdentifier)
  output <- .rds$remove_from_global_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$remove_from_global_cluster <- rds_remove_from_global_cluster

#' Disassociates an AWS Identity and Access Management (IAM) role from an
#' Amazon Aurora DB cluster
#'
#' Disassociates an AWS Identity and Access Management (IAM) role from an
#' Amazon Aurora DB cluster. For more information, see [Authorizing Amazon
#' Aurora MySQL to Access Other AWS Services on Your
#' Behalf](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Integrating.Authorizing.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_remove_role_from_db_cluster(DBClusterIdentifier, RoleArn)
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to disassociate the IAM role from.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to disassociate from the
#' Aurora DB cluster, for example
#' `arn:aws:iam::123456789012:role/AuroraAccessRole`.
#'
#' @section Request syntax:
#' ```
#' svc$remove_role_from_db_cluster(
#'   DBClusterIdentifier = "string",
#'   RoleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_remove_role_from_db_cluster
rds_remove_role_from_db_cluster <- function(DBClusterIdentifier, RoleArn) {
  op <- new_operation(
    name = "RemoveRoleFromDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$remove_role_from_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier, RoleArn = RoleArn)
  output <- .rds$remove_role_from_db_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$remove_role_from_db_cluster <- rds_remove_role_from_db_cluster

#' Disassociates an AWS Identity and Access Management (IAM) role from a DB
#' instance
#'
#' Disassociates an AWS Identity and Access Management (IAM) role from a DB
#' instance.
#'
#' @usage
#' rds_remove_role_from_db_instance(DBInstanceIdentifier, RoleArn,
#'   FeatureName)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The name of the DB instance to disassociate the IAM role from.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to disassociate from the
#' DB instance, for example `arn:aws:iam::123456789012:role/AccessRole`.
#' @param FeatureName &#91;required&#93; The name of the feature for the DB instance that the IAM role is to be
#' disassociated from. For the list of supported feature names, see
#' DBEngineVersion.
#'
#' @section Request syntax:
#' ```
#' svc$remove_role_from_db_instance(
#'   DBInstanceIdentifier = "string",
#'   RoleArn = "string",
#'   FeatureName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_remove_role_from_db_instance
rds_remove_role_from_db_instance <- function(DBInstanceIdentifier, RoleArn, FeatureName) {
  op <- new_operation(
    name = "RemoveRoleFromDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$remove_role_from_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, RoleArn = RoleArn, FeatureName = FeatureName)
  output <- .rds$remove_role_from_db_instance_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$remove_role_from_db_instance <- rds_remove_role_from_db_instance

#' Removes a source identifier from an existing RDS event notification
#' subscription
#'
#' Removes a source identifier from an existing RDS event notification
#' subscription.
#'
#' @usage
#' rds_remove_source_identifier_from_subscription(SubscriptionName,
#'   SourceIdentifier)
#'
#' @param SubscriptionName &#91;required&#93; The name of the RDS event notification subscription you want to remove a
#' source identifier from.
#' @param SourceIdentifier &#91;required&#93; The source identifier to be removed from the subscription, such as the
#' **DB instance identifier** for a DB instance or the name of a security
#' group.
#'
#' @section Request syntax:
#' ```
#' svc$remove_source_identifier_from_subscription(
#'   SubscriptionName = "string",
#'   SourceIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_remove_source_identifier_from_subscription
rds_remove_source_identifier_from_subscription <- function(SubscriptionName, SourceIdentifier) {
  op <- new_operation(
    name = "RemoveSourceIdentifierFromSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$remove_source_identifier_from_subscription_input(SubscriptionName = SubscriptionName, SourceIdentifier = SourceIdentifier)
  output <- .rds$remove_source_identifier_from_subscription_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$remove_source_identifier_from_subscription <- rds_remove_source_identifier_from_subscription

#' Removes metadata tags from an Amazon RDS resource
#'
#' Removes metadata tags from an Amazon RDS resource.
#' 
#' For an overview on tagging an Amazon RDS resource, see [Tagging Amazon
#' RDS
#' Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html)
#' in the *Amazon RDS User Guide.*
#'
#' @usage
#' rds_remove_tags_from_resource(ResourceName, TagKeys)
#'
#' @param ResourceName &#91;required&#93; The Amazon RDS resource that the tags are removed from. This value is an
#' Amazon Resource Name (ARN). For information about creating an ARN, see
#' [Constructing an ARN for Amazon
#' RDS](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.ARN.html#USER_Tagging.ARN.Constructing)
#' in the *Amazon RDS User Guide.*
#' @param TagKeys &#91;required&#93; The tag key (name) of the tag to be removed.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags_from_resource(
#'   ResourceName = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_remove_tags_from_resource
rds_remove_tags_from_resource <- function(ResourceName, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$remove_tags_from_resource_input(ResourceName = ResourceName, TagKeys = TagKeys)
  output <- .rds$remove_tags_from_resource_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$remove_tags_from_resource <- rds_remove_tags_from_resource

#' Modifies the parameters of a DB cluster parameter group to the default
#' value
#'
#' Modifies the parameters of a DB cluster parameter group to the default
#' value. To reset specific parameters submit a list of the following:
#' `ParameterName` and `ApplyMethod`. To reset the entire DB cluster
#' parameter group, specify the `DBClusterParameterGroupName` and
#' `ResetAllParameters` parameters.
#' 
#' When resetting the entire group, dynamic parameters are updated
#' immediately and static parameters are set to `pending-reboot` to take
#' effect on the next DB instance restart or RebootDBInstance request. You
#' must call RebootDBInstance for every DB instance in your DB cluster that
#' you want the updated static parameter to apply to.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_reset_db_cluster_parameter_group(DBClusterParameterGroupName,
#'   ResetAllParameters, Parameters)
#'
#' @param DBClusterParameterGroupName &#91;required&#93; The name of the DB cluster parameter group to reset.
#' @param ResetAllParameters A value that is set to `true` to reset all parameters in the DB cluster
#' parameter group to their default values, and `false` otherwise. You
#' can\'t use this parameter if there is a list of parameter names
#' specified for the `Parameters` parameter.
#' @param Parameters A list of parameter names in the DB cluster parameter group to reset to
#' the default values. You can\'t use this parameter if the
#' `ResetAllParameters` parameter is set to `true`.
#'
#' @section Request syntax:
#' ```
#' svc$reset_db_cluster_parameter_group(
#'   DBClusterParameterGroupName = "string",
#'   ResetAllParameters = TRUE|FALSE,
#'   Parameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string",
#'       Description = "string",
#'       Source = "string",
#'       ApplyType = "string",
#'       DataType = "string",
#'       AllowedValues = "string",
#'       IsModifiable = TRUE|FALSE,
#'       MinimumEngineVersion = "string",
#'       ApplyMethod = "immediate"|"pending-reboot",
#'       SupportedEngineModes = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_reset_db_cluster_parameter_group
rds_reset_db_cluster_parameter_group <- function(DBClusterParameterGroupName, ResetAllParameters = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ResetDBClusterParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$reset_db_cluster_parameter_group_input(DBClusterParameterGroupName = DBClusterParameterGroupName, ResetAllParameters = ResetAllParameters, Parameters = Parameters)
  output <- .rds$reset_db_cluster_parameter_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$reset_db_cluster_parameter_group <- rds_reset_db_cluster_parameter_group

#' Modifies the parameters of a DB parameter group to the engine/system
#' default value
#'
#' Modifies the parameters of a DB parameter group to the engine/system
#' default value. To reset specific parameters, provide a list of the
#' following: `ParameterName` and `ApplyMethod`. To reset the entire DB
#' parameter group, specify the `DBParameterGroup` name and
#' `ResetAllParameters` parameters. When resetting the entire group,
#' dynamic parameters are updated immediately and static parameters are set
#' to `pending-reboot` to take effect on the next DB instance restart or
#' `RebootDBInstance` request.
#'
#' @usage
#' rds_reset_db_parameter_group(DBParameterGroupName, ResetAllParameters,
#'   Parameters)
#'
#' @param DBParameterGroupName &#91;required&#93; The name of the DB parameter group.
#' 
#' Constraints:
#' 
#' -   Must match the name of an existing DBParameterGroup.
#' @param ResetAllParameters Specifies whether (`true`) or not (`false`) to reset all parameters in
#' the DB parameter group to default values.
#' 
#' Default: `true`
#' @param Parameters To reset the entire DB parameter group, specify the `DBParameterGroup`
#' name and `ResetAllParameters` parameters. To reset specific parameters,
#' provide a list of the following: `ParameterName` and `ApplyMethod`. A
#' maximum of 20 parameters can be modified in a single request.
#' 
#' **MySQL**
#' 
#' Valid Values (for Apply method): `immediate` \\| `pending-reboot`
#' 
#' You can use the immediate value with dynamic parameters only. You can
#' use the `pending-reboot` value for both dynamic and static parameters,
#' and changes are applied when DB instance reboots.
#' 
#' **MariaDB**
#' 
#' Valid Values (for Apply method): `immediate` \\| `pending-reboot`
#' 
#' You can use the immediate value with dynamic parameters only. You can
#' use the `pending-reboot` value for both dynamic and static parameters,
#' and changes are applied when DB instance reboots.
#' 
#' **Oracle**
#' 
#' Valid Values (for Apply method): `pending-reboot`
#'
#' @section Request syntax:
#' ```
#' svc$reset_db_parameter_group(
#'   DBParameterGroupName = "string",
#'   ResetAllParameters = TRUE|FALSE,
#'   Parameters = list(
#'     list(
#'       ParameterName = "string",
#'       ParameterValue = "string",
#'       Description = "string",
#'       Source = "string",
#'       ApplyType = "string",
#'       DataType = "string",
#'       AllowedValues = "string",
#'       IsModifiable = TRUE|FALSE,
#'       MinimumEngineVersion = "string",
#'       ApplyMethod = "immediate"|"pending-reboot",
#'       SupportedEngineModes = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_reset_db_parameter_group
rds_reset_db_parameter_group <- function(DBParameterGroupName, ResetAllParameters = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "ResetDBParameterGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$reset_db_parameter_group_input(DBParameterGroupName = DBParameterGroupName, ResetAllParameters = ResetAllParameters, Parameters = Parameters)
  output <- .rds$reset_db_parameter_group_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$reset_db_parameter_group <- rds_reset_db_parameter_group

#' Creates an Amazon Aurora DB cluster from data stored in an Amazon S3
#' bucket
#'
#' Creates an Amazon Aurora DB cluster from data stored in an Amazon S3
#' bucket. Amazon RDS must be authorized to access the Amazon S3 bucket and
#' the data must be created using the Percona XtraBackup utility as
#' described in [Migrating Data to an Amazon Aurora MySQL DB
#' Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.html)
#' in the *Amazon Aurora User Guide*.
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_restore_db_cluster_from_s3(AvailabilityZones, BackupRetentionPeriod,
#'   CharacterSetName, DatabaseName, DBClusterIdentifier,
#'   DBClusterParameterGroupName, VpcSecurityGroupIds, DBSubnetGroupName,
#'   Engine, EngineVersion, Port, MasterUsername, MasterUserPassword,
#'   OptionGroupName, PreferredBackupWindow, PreferredMaintenanceWindow,
#'   Tags, StorageEncrypted, KmsKeyId, EnableIAMDatabaseAuthentication,
#'   SourceEngine, SourceEngineVersion, S3BucketName, S3Prefix,
#'   S3IngestionRoleArn, BacktrackWindow, EnableCloudwatchLogsExports,
#'   DeletionProtection, CopyTagsToSnapshot)
#'
#' @param AvailabilityZones A list of EC2 Availability Zones that instances in the restored DB
#' cluster can be created in.
#' @param BackupRetentionPeriod The number of days for which automated backups of the restored DB
#' cluster are retained. You must specify a minimum value of 1.
#' 
#' Default: 1
#' 
#' Constraints:
#' 
#' -   Must be a value from 1 to 35
#' @param CharacterSetName A value that indicates that the restored DB cluster should be associated
#' with the specified CharacterSet.
#' @param DatabaseName The database name for the restored DB cluster.
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to create from the source data in the Amazon
#' S3 bucket. This parameter is isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `my-cluster1`
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with the
#' restored DB cluster. If this argument is omitted, `default.aurora5.6` is
#' used.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing
#'     DBClusterParameterGroup.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with the restored DB
#' cluster.
#' @param DBSubnetGroupName A DB subnet group to associate with the restored DB cluster.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mySubnetgroup`
#' @param Engine &#91;required&#93; The name of the database engine to be used for the restored DB cluster.
#' 
#' Valid Values: `aurora`, `aurora-postgresql`
#' @param EngineVersion The version number of the database engine to use.
#' 
#' **Aurora MySQL**
#' 
#' Example: `5.6.10a`
#' 
#' **Aurora PostgreSQL**
#' 
#' Example: `9.6.3`
#' @param Port The port number on which the instances in the restored DB cluster accept
#' connections.
#' 
#' Default: `3306`
#' @param MasterUsername &#91;required&#93; The name of the master user for the restored DB cluster.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 16 letters or numbers.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t be a reserved word for the chosen database engine.
#' @param MasterUserPassword &#91;required&#93; The password for the master database user. This password can contain any
#' printable ASCII character except \"/\", \"\"\", or \"@\".
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' @param OptionGroupName A value that indicates that the restored DB cluster should be associated
#' with the specified option group.
#' 
#' Permanent options can\'t be removed from an option group. An option
#' group can\'t be removed from a DB cluster once it is associated with a
#' DB cluster.
#' @param PreferredBackupWindow The daily time range during which automated backups are created if
#' automated backups are enabled using the `BackupRetentionPeriod`
#' parameter.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region. To see the time blocks available, see
#' [Adjusting the Preferred Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora)
#' in the *Amazon Aurora User Guide.*
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param PreferredMaintenanceWindow The weekly time range during which system maintenance can occur, in
#' Universal Coordinated Time (UTC).
#' 
#' Format: `ddd:hh24:mi-ddd:hh24:mi`
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week. To see the time blocks available, see [Adjusting the Preferred
#' Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_UpgradeDBInstance.Maintenance.html#AdjustingTheMaintenanceWindow.Aurora)
#' in the *Amazon Aurora User Guide.*
#' 
#' Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' Constraints: Minimum 30-minute window.
#' @param Tags 
#' @param StorageEncrypted Specifies whether the restored DB cluster is encrypted.
#' @param KmsKeyId The AWS KMS key identifier for an encrypted DB cluster.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are creating a DB cluster with the same AWS
#' account that owns the KMS encryption key used to encrypt the new DB
#' cluster, then you can use the KMS key alias instead of the ARN for the
#' KM encryption key.
#' 
#' If the `StorageEncrypted` parameter is true, and you do not specify a
#' value for the `KmsKeyId` parameter, then Amazon RDS will use your
#' default encryption key. AWS KMS creates the default encryption key for
#' your AWS account. Your AWS account has a different default encryption
#' key for each AWS Region.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param SourceEngine &#91;required&#93; The identifier for the database engine that was backed up to create the
#' files stored in the Amazon S3 bucket.
#' 
#' Valid values: `mysql`
#' @param SourceEngineVersion &#91;required&#93; The version of the database that the backup files were created from.
#' 
#' MySQL version 5.5 and 5.6 are supported.
#' 
#' Example: `5.6.22`
#' @param S3BucketName &#91;required&#93; The name of the Amazon S3 bucket that contains the data used to create
#' the Amazon Aurora DB cluster.
#' @param S3Prefix The prefix for all of the file names that contain the data used to
#' create the Amazon Aurora DB cluster. If you do not specify a
#' **SourceS3Prefix** value, then the Amazon Aurora DB cluster is created
#' by using all of the files in the Amazon S3 bucket.
#' @param S3IngestionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the AWS Identity and Access Management
#' (IAM) role that authorizes Amazon RDS to access the Amazon S3 bucket on
#' your behalf.
#' @param BacktrackWindow The target backtrack window, in seconds. To disable backtracking, set
#' this value to 0.
#' 
#' Default: 0
#' 
#' Constraints:
#' 
#' -   If specified, this value must be set to a number from 0 to 259,200
#'     (72 hours).
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB cluster is to export to CloudWatch
#' Logs. The values in the list depend on the DB engine being used. For
#' more information, see [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon Aurora User Guide*.
#' @param DeletionProtection Indicates if the DB cluster should have deletion protection enabled. The
#' database can\'t be deleted when this value is set to true. The default
#' is false.
#' @param CopyTagsToSnapshot True to copy all tags from the restored DB cluster to snapshots of the
#' restored DB cluster, and otherwise false. The default is false.
#'
#' @section Request syntax:
#' ```
#' svc$restore_db_cluster_from_s3(
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   BackupRetentionPeriod = 123,
#'   CharacterSetName = "string",
#'   DatabaseName = "string",
#'   DBClusterIdentifier = "string",
#'   DBClusterParameterGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   DBSubnetGroupName = "string",
#'   Engine = "string",
#'   EngineVersion = "string",
#'   Port = 123,
#'   MasterUsername = "string",
#'   MasterUserPassword = "string",
#'   OptionGroupName = "string",
#'   PreferredBackupWindow = "string",
#'   PreferredMaintenanceWindow = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   StorageEncrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   SourceEngine = "string",
#'   SourceEngineVersion = "string",
#'   S3BucketName = "string",
#'   S3Prefix = "string",
#'   S3IngestionRoleArn = "string",
#'   BacktrackWindow = 123,
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   DeletionProtection = TRUE|FALSE,
#'   CopyTagsToSnapshot = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_restore_db_cluster_from_s3
rds_restore_db_cluster_from_s3 <- function(AvailabilityZones = NULL, BackupRetentionPeriod = NULL, CharacterSetName = NULL, DatabaseName = NULL, DBClusterIdentifier, DBClusterParameterGroupName = NULL, VpcSecurityGroupIds = NULL, DBSubnetGroupName = NULL, Engine, EngineVersion = NULL, Port = NULL, MasterUsername, MasterUserPassword, OptionGroupName = NULL, PreferredBackupWindow = NULL, PreferredMaintenanceWindow = NULL, Tags = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, EnableIAMDatabaseAuthentication = NULL, SourceEngine, SourceEngineVersion, S3BucketName, S3Prefix = NULL, S3IngestionRoleArn, BacktrackWindow = NULL, EnableCloudwatchLogsExports = NULL, DeletionProtection = NULL, CopyTagsToSnapshot = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterFromS3",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$restore_db_cluster_from_s3_input(AvailabilityZones = AvailabilityZones, BackupRetentionPeriod = BackupRetentionPeriod, CharacterSetName = CharacterSetName, DatabaseName = DatabaseName, DBClusterIdentifier = DBClusterIdentifier, DBClusterParameterGroupName = DBClusterParameterGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, DBSubnetGroupName = DBSubnetGroupName, Engine = Engine, EngineVersion = EngineVersion, Port = Port, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, OptionGroupName = OptionGroupName, PreferredBackupWindow = PreferredBackupWindow, PreferredMaintenanceWindow = PreferredMaintenanceWindow, Tags = Tags, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, SourceEngine = SourceEngine, SourceEngineVersion = SourceEngineVersion, S3BucketName = S3BucketName, S3Prefix = S3Prefix, S3IngestionRoleArn = S3IngestionRoleArn, BacktrackWindow = BacktrackWindow, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DeletionProtection = DeletionProtection, CopyTagsToSnapshot = CopyTagsToSnapshot)
  output <- .rds$restore_db_cluster_from_s3_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$restore_db_cluster_from_s3 <- rds_restore_db_cluster_from_s3

#' Creates a new DB cluster from a DB snapshot or DB cluster snapshot
#'
#' Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
#' 
#' If a DB snapshot is specified, the target DB cluster is created from the
#' source DB snapshot with a default configuration and default security
#' group.
#' 
#' If a DB cluster snapshot is specified, the target DB cluster is created
#' from the source DB cluster restore point with the same configuration as
#' the original source DB cluster, except that the new DB cluster is
#' created with the default security group.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_restore_db_cluster_from_snapshot(AvailabilityZones,
#'   DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion, Port,
#'   DBSubnetGroupName, DatabaseName, OptionGroupName, VpcSecurityGroupIds,
#'   Tags, KmsKeyId, EnableIAMDatabaseAuthentication, BacktrackWindow,
#'   EnableCloudwatchLogsExports, EngineMode, ScalingConfiguration,
#'   DBClusterParameterGroupName, DeletionProtection, CopyTagsToSnapshot)
#'
#' @param AvailabilityZones Provides the list of Amazon EC2 Availability Zones that instances in the
#' restored DB cluster can be created in.
#' @param DBClusterIdentifier &#91;required&#93; The name of the DB cluster to create from the DB snapshot or DB cluster
#' snapshot. This parameter isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-snapshot-id`
#' @param SnapshotIdentifier &#91;required&#93; The identifier for the DB snapshot or DB cluster snapshot to restore
#' from.
#' 
#' You can use either the name or the Amazon Resource Name (ARN) to specify
#' a DB cluster snapshot. However, you can use only the ARN to specify a DB
#' snapshot.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing Snapshot.
#' @param Engine &#91;required&#93; The database engine to use for the new DB cluster.
#' 
#' Default: The same as source
#' 
#' Constraint: Must be compatible with the engine of the source
#' @param EngineVersion The version of the database engine to use for the new DB cluster.
#' @param Port The port number on which the new DB cluster accepts connections.
#' 
#' Constraints: This value must be `1150-65535`
#' 
#' Default: The same port as the original DB cluster.
#' @param DBSubnetGroupName The name of the DB subnet group to use for the new DB cluster.
#' 
#' Constraints: If supplied, must match the name of an existing DB subnet
#' group.
#' 
#' Example: `mySubnetgroup`
#' @param DatabaseName The database name for the restored DB cluster.
#' @param OptionGroupName The name of the option group to use for the restored DB cluster.
#' @param VpcSecurityGroupIds A list of VPC security groups that the new DB cluster will belong to.
#' @param Tags The tags to be assigned to the restored DB cluster.
#' @param KmsKeyId The AWS KMS key identifier to use when restoring an encrypted DB cluster
#' from a DB snapshot or DB cluster snapshot.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are restoring a DB cluster with the same AWS
#' account that owns the KMS encryption key used to encrypt the new DB
#' cluster, then you can use the KMS key alias instead of the ARN for the
#' KMS encryption key.
#' 
#' If you don\'t specify a value for the `KmsKeyId` parameter, then the
#' following occurs:
#' 
#' -   If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is
#'     encrypted, then the restored DB cluster is encrypted using the KMS
#'     key that was used to encrypt the DB snapshot or DB cluster snapshot.
#' 
#' -   If the DB snapshot or DB cluster snapshot in `SnapshotIdentifier` is
#'     not encrypted, then the restored DB cluster is not encrypted.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param BacktrackWindow The target backtrack window, in seconds. To disable backtracking, set
#' this value to 0.
#' 
#' Default: 0
#' 
#' Constraints:
#' 
#' -   If specified, this value must be set to a number from 0 to 259,200
#'     (72 hours).
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB cluster is to export to Amazon
#' CloudWatch Logs. The values in the list depend on the DB engine being
#' used. For more information, see [Publishing Database Logs to Amazon
#' CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon Aurora User Guide*.
#' @param EngineMode The DB engine mode of the DB cluster, either `provisioned`,
#' `serverless`, or `parallelquery`.
#' @param ScalingConfiguration For DB clusters in `serverless` DB engine mode, the scaling properties
#' of the DB cluster.
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB
#' cluster. If this argument is omitted, the default DB cluster parameter
#' group for the specified engine is used.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing default DB cluster
#'     parameter group.
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' @param DeletionProtection Indicates if the DB cluster should have deletion protection enabled. The
#' database can\'t be deleted when this value is set to true. The default
#' is false.
#' @param CopyTagsToSnapshot True to copy all tags from the restored DB cluster to snapshots of the
#' restored DB cluster, and otherwise false. The default is false.
#'
#' @section Request syntax:
#' ```
#' svc$restore_db_cluster_from_snapshot(
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   DBClusterIdentifier = "string",
#'   SnapshotIdentifier = "string",
#'   Engine = "string",
#'   EngineVersion = "string",
#'   Port = 123,
#'   DBSubnetGroupName = "string",
#'   DatabaseName = "string",
#'   OptionGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   KmsKeyId = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   BacktrackWindow = 123,
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   EngineMode = "string",
#'   ScalingConfiguration = list(
#'     MinCapacity = 123,
#'     MaxCapacity = 123,
#'     AutoPause = TRUE|FALSE,
#'     SecondsUntilAutoPause = 123
#'   ),
#'   DBClusterParameterGroupName = "string",
#'   DeletionProtection = TRUE|FALSE,
#'   CopyTagsToSnapshot = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_restore_db_cluster_from_snapshot
rds_restore_db_cluster_from_snapshot <- function(AvailabilityZones = NULL, DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion = NULL, Port = NULL, DBSubnetGroupName = NULL, DatabaseName = NULL, OptionGroupName = NULL, VpcSecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, EnableIAMDatabaseAuthentication = NULL, BacktrackWindow = NULL, EnableCloudwatchLogsExports = NULL, EngineMode = NULL, ScalingConfiguration = NULL, DBClusterParameterGroupName = NULL, DeletionProtection = NULL, CopyTagsToSnapshot = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$restore_db_cluster_from_snapshot_input(AvailabilityZones = AvailabilityZones, DBClusterIdentifier = DBClusterIdentifier, SnapshotIdentifier = SnapshotIdentifier, Engine = Engine, EngineVersion = EngineVersion, Port = Port, DBSubnetGroupName = DBSubnetGroupName, DatabaseName = DatabaseName, OptionGroupName = OptionGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, BacktrackWindow = BacktrackWindow, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, EngineMode = EngineMode, ScalingConfiguration = ScalingConfiguration, DBClusterParameterGroupName = DBClusterParameterGroupName, DeletionProtection = DeletionProtection, CopyTagsToSnapshot = CopyTagsToSnapshot)
  output <- .rds$restore_db_cluster_from_snapshot_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$restore_db_cluster_from_snapshot <- rds_restore_db_cluster_from_snapshot

#' Restores a DB cluster to an arbitrary point in time
#'
#' Restores a DB cluster to an arbitrary point in time. Users can restore
#' to any point in time before `LatestRestorableTime` for up to
#' `BackupRetentionPeriod` days. The target DB cluster is created from the
#' source DB cluster with the same configuration as the original DB
#' cluster, except that the new DB cluster is created with the default DB
#' security group.
#' 
#' This action only restores the DB cluster, not the DB instances for that
#' DB cluster. You must invoke the CreateDBInstance action to create DB
#' instances for the restored DB cluster, specifying the identifier of the
#' restored DB cluster in `DBClusterIdentifier`. You can create DB
#' instances only after the `RestoreDBClusterToPointInTime` action has
#' completed and the DB cluster is available.
#' 
#' For more information on Amazon Aurora, see [What Is Amazon
#' Aurora?](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_restore_db_cluster_to_point_in_time(DBClusterIdentifier,
#'   RestoreType, SourceDBClusterIdentifier, RestoreToTime,
#'   UseLatestRestorableTime, Port, DBSubnetGroupName, OptionGroupName,
#'   VpcSecurityGroupIds, Tags, KmsKeyId, EnableIAMDatabaseAuthentication,
#'   BacktrackWindow, EnableCloudwatchLogsExports,
#'   DBClusterParameterGroupName, DeletionProtection, CopyTagsToSnapshot)
#'
#' @param DBClusterIdentifier &#91;required&#93; The name of the new DB cluster to be created.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' @param RestoreType The type of restore to be performed. You can specify one of the
#' following values:
#' 
#' -   `full-copy` - The new DB cluster is restored as a full copy of the
#'     source DB cluster.
#' 
#' -   `copy-on-write` - The new DB cluster is restored as a clone of the
#'     source DB cluster.
#' 
#' Constraints: You can\'t specify `copy-on-write` if the engine version of
#' the source DB cluster is earlier than 1.11.
#' 
#' If you don\'t specify a `RestoreType` value, then the new DB cluster is
#' restored as a full copy of the source DB cluster.
#' @param SourceDBClusterIdentifier &#91;required&#93; The identifier of the source DB cluster from which to restore.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBCluster.
#' @param RestoreToTime The date and time to restore the DB cluster to.
#' 
#' Valid Values: Value must be a time in Universal Coordinated Time (UTC)
#' format
#' 
#' Constraints:
#' 
#' -   Must be before the latest restorable time for the DB instance
#' 
#' -   Must be specified if `UseLatestRestorableTime` parameter is not
#'     provided
#' 
#' -   Can\'t be specified if `UseLatestRestorableTime` parameter is true
#' 
#' -   Can\'t be specified if `RestoreType` parameter is `copy-on-write`
#' 
#' Example: `2015-03-07T23:45:00Z`
#' @param UseLatestRestorableTime A value that is set to `true` to restore the DB cluster to the latest
#' restorable backup time, and `false` otherwise.
#' 
#' Default: `false`
#' 
#' Constraints: Can\'t be specified if `RestoreToTime` parameter is
#' provided.
#' @param Port The port number on which the new DB cluster accepts connections.
#' 
#' Constraints: A value from `1150-65535`.
#' 
#' Default: The default port for the engine.
#' @param DBSubnetGroupName The DB subnet group name to use for the new DB cluster.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mySubnetgroup`
#' @param OptionGroupName The name of the option group for the new DB cluster.
#' @param VpcSecurityGroupIds A list of VPC security groups that the new DB cluster belongs to.
#' @param Tags 
#' @param KmsKeyId The AWS KMS key identifier to use when restoring an encrypted DB cluster
#' from an encrypted DB cluster.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are restoring a DB cluster with the same AWS
#' account that owns the KMS encryption key used to encrypt the new DB
#' cluster, then you can use the KMS key alias instead of the ARN for the
#' KMS encryption key.
#' 
#' You can restore to a new DB cluster and encrypt the new DB cluster with
#' a KMS key that is different than the KMS key used to encrypt the source
#' DB cluster. The new DB cluster is encrypted with the KMS key identified
#' by the `KmsKeyId` parameter.
#' 
#' If you don\'t specify a value for the `KmsKeyId` parameter, then the
#' following occurs:
#' 
#' -   If the DB cluster is encrypted, then the restored DB cluster is
#'     encrypted using the KMS key that was used to encrypt the source DB
#'     cluster.
#' 
#' -   If the DB cluster is not encrypted, then the restored DB cluster is
#'     not encrypted.
#' 
#' If `DBClusterIdentifier` refers to a DB cluster that is not encrypted,
#' then the restore request is rejected.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param BacktrackWindow The target backtrack window, in seconds. To disable backtracking, set
#' this value to 0.
#' 
#' Default: 0
#' 
#' Constraints:
#' 
#' -   If specified, this value must be set to a number from 0 to 259,200
#'     (72 hours).
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB cluster is to export to CloudWatch
#' Logs. The values in the list depend on the DB engine being used. For
#' more information, see [Publishing Database Logs to Amazon CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon Aurora User Guide*.
#' @param DBClusterParameterGroupName The name of the DB cluster parameter group to associate with this DB
#' cluster. If this argument is omitted, the default DB cluster parameter
#' group for the specified engine is used.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DB cluster parameter
#'     group.
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' @param DeletionProtection Indicates if the DB cluster should have deletion protection enabled. The
#' database can\'t be deleted when this value is set to true. The default
#' is false.
#' @param CopyTagsToSnapshot True to copy all tags from the restored DB cluster to snapshots of the
#' restored DB cluster, and otherwise false. The default is false.
#'
#' @section Request syntax:
#' ```
#' svc$restore_db_cluster_to_point_in_time(
#'   DBClusterIdentifier = "string",
#'   RestoreType = "string",
#'   SourceDBClusterIdentifier = "string",
#'   RestoreToTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   UseLatestRestorableTime = TRUE|FALSE,
#'   Port = 123,
#'   DBSubnetGroupName = "string",
#'   OptionGroupName = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   KmsKeyId = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   BacktrackWindow = 123,
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   DBClusterParameterGroupName = "string",
#'   DeletionProtection = TRUE|FALSE,
#'   CopyTagsToSnapshot = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_restore_db_cluster_to_point_in_time
rds_restore_db_cluster_to_point_in_time <- function(DBClusterIdentifier, RestoreType = NULL, SourceDBClusterIdentifier, RestoreToTime = NULL, UseLatestRestorableTime = NULL, Port = NULL, DBSubnetGroupName = NULL, OptionGroupName = NULL, VpcSecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, EnableIAMDatabaseAuthentication = NULL, BacktrackWindow = NULL, EnableCloudwatchLogsExports = NULL, DBClusterParameterGroupName = NULL, DeletionProtection = NULL, CopyTagsToSnapshot = NULL) {
  op <- new_operation(
    name = "RestoreDBClusterToPointInTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$restore_db_cluster_to_point_in_time_input(DBClusterIdentifier = DBClusterIdentifier, RestoreType = RestoreType, SourceDBClusterIdentifier = SourceDBClusterIdentifier, RestoreToTime = RestoreToTime, UseLatestRestorableTime = UseLatestRestorableTime, Port = Port, DBSubnetGroupName = DBSubnetGroupName, OptionGroupName = OptionGroupName, VpcSecurityGroupIds = VpcSecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, BacktrackWindow = BacktrackWindow, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, DBClusterParameterGroupName = DBClusterParameterGroupName, DeletionProtection = DeletionProtection, CopyTagsToSnapshot = CopyTagsToSnapshot)
  output <- .rds$restore_db_cluster_to_point_in_time_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$restore_db_cluster_to_point_in_time <- rds_restore_db_cluster_to_point_in_time

#' Creates a new DB instance from a DB snapshot
#'
#' Creates a new DB instance from a DB snapshot. The target database is
#' created from the source database restore point with the most of original
#' configuration with the default security group and the default DB
#' parameter group. By default, the new DB instance is created as a
#' single-AZ deployment except when the instance is a SQL Server instance
#' that has an option group that is associated with mirroring; in this
#' case, the instance becomes a mirrored AZ deployment and not a single-AZ
#' deployment.
#' 
#' If your intent is to replace your original DB instance with the new,
#' restored DB instance, then rename your original DB instance before you
#' call the RestoreDBInstanceFromDBSnapshot action. RDS doesn\'t allow two
#' DB instances with the same name. Once you have renamed your original DB
#' instance with a different identifier, then you can pass the original
#' name of the DB instance as the DBInstanceIdentifier in the call to the
#' RestoreDBInstanceFromDBSnapshot action. The result is that you will
#' replace the original DB instance with the DB instance created from the
#' snapshot.
#' 
#' If you are restoring from a shared manual DB snapshot, the
#' `DBSnapshotIdentifier` must be the ARN of the shared DB snapshot.
#' 
#' This command doesn\'t apply to Aurora MySQL and Aurora PostgreSQL. For
#' Aurora, use RestoreDBClusterFromSnapshot.
#'
#' @usage
#' rds_restore_db_instance_from_db_snapshot(DBInstanceIdentifier,
#'   DBSnapshotIdentifier, DBInstanceClass, Port, AvailabilityZone,
#'   DBSubnetGroupName, MultiAZ, PubliclyAccessible, AutoMinorVersionUpgrade,
#'   LicenseModel, DBName, Engine, Iops, OptionGroupName, Tags, StorageType,
#'   TdeCredentialArn, TdeCredentialPassword, VpcSecurityGroupIds, Domain,
#'   CopyTagsToSnapshot, DomainIAMRoleName, EnableIAMDatabaseAuthentication,
#'   EnableCloudwatchLogsExports, ProcessorFeatures,
#'   UseDefaultProcessorFeatures, DBParameterGroupName, DeletionProtection)
#'
#' @param DBInstanceIdentifier &#91;required&#93; Name of the DB instance to create from the DB snapshot. This parameter
#' isn\'t case-sensitive.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 numbers, letters, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' 
#' Example: `my-snapshot-id`
#' @param DBSnapshotIdentifier &#91;required&#93; The identifier for the DB snapshot to restore from.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DBSnapshot.
#' 
#' -   If you are restoring from a shared manual DB snapshot, the
#'     `DBSnapshotIdentifier` must be the ARN of the shared DB snapshot.
#' @param DBInstanceClass The compute and memory capacity of the Amazon RDS DB instance, for
#' example, `db.m4.large`. Not all DB instance classes are available in all
#' AWS Regions, or for all database engines. For the full list of DB
#' instance classes, and availability for your engine, see [DB Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Default: The same DBInstanceClass as the original DB instance.
#' @param Port The port number on which the database accepts connections.
#' 
#' Default: The same port as the original DB instance
#' 
#' Constraints: Value must be `1150-65535`
#' @param AvailabilityZone The EC2 Availability Zone that the DB instance is created in.
#' 
#' Default: A random, system-chosen Availability Zone.
#' 
#' Constraint: You can\'t specify the AvailabilityZone parameter if the
#' MultiAZ parameter is set to `true`.
#' 
#' Example: `us-east-1a`
#' @param DBSubnetGroupName The DB subnet group name to use for the new instance.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mySubnetgroup`
#' @param MultiAZ Specifies if the DB instance is a Multi-AZ deployment.
#' 
#' Constraint: You can\'t specify the AvailabilityZone parameter if the
#' MultiAZ parameter is set to `true`.
#' @param PubliclyAccessible Specifies the accessibility options for the DB instance. A value of true
#' specifies an Internet-facing instance with a publicly resolvable DNS
#' name, which resolves to a public IP address. A value of false specifies
#' an internal instance with a DNS name that resolves to a private IP
#' address. For more information, see CreateDBInstance.
#' @param AutoMinorVersionUpgrade Indicates that minor version upgrades are applied automatically to the
#' DB instance during the maintenance window.
#' @param LicenseModel License model information for the restored DB instance.
#' 
#' Default: Same as source.
#' 
#' Valid values: `license-included` \\| `bring-your-own-license` \\|
#' `general-public-license`
#' @param DBName The database name for the restored DB instance.
#' 
#' This parameter doesn\'t apply to the MySQL, PostgreSQL, or MariaDB
#' engines.
#' @param Engine The database engine to use for the new instance.
#' 
#' Default: The same as source
#' 
#' Constraint: Must be compatible with the engine of the source. For
#' example, you can restore a MariaDB 10.1 DB instance from a MySQL 5.6
#' snapshot.
#' 
#' Valid Values:
#' 
#' -   `mariadb`
#' 
#' -   `mysql`
#' 
#' -   `oracle-ee`
#' 
#' -   `oracle-se2`
#' 
#' -   `oracle-se1`
#' 
#' -   `oracle-se`
#' 
#' -   `postgres`
#' 
#' -   `sqlserver-ee`
#' 
#' -   `sqlserver-se`
#' 
#' -   `sqlserver-ex`
#' 
#' -   `sqlserver-web`
#' @param Iops Specifies the amount of provisioned IOPS for the DB instance, expressed
#' in I/O operations per second. If this parameter is not specified, the
#' IOPS value is taken from the backup. If this parameter is set to 0, the
#' new instance is converted to a non-PIOPS instance. The conversion takes
#' additional time, though your DB instance is available for connections
#' before the conversion starts.
#' 
#' The provisioned IOPS value must follow the requirements for your
#' database engine. For more information, see [Amazon RDS Provisioned IOPS
#' Storage to Improve
#' Performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS)
#' in the *Amazon RDS User Guide.*
#' 
#' Constraints: Must be an integer greater than 1000.
#' @param OptionGroupName The name of the option group to be used for the restored DB instance.
#' 
#' Permanent options, such as the TDE option for Oracle Advanced Security
#' TDE, can\'t be removed from an option group, and that option group
#' can\'t be removed from a DB instance once it is associated with a DB
#' instance
#' @param Tags 
#' @param StorageType Specifies the storage type to be associated with the DB instance.
#' 
#' Valid values: `standard | gp2 | io1`
#' 
#' If you specify `io1`, you must also include a value for the `Iops`
#' parameter.
#' 
#' Default: `io1` if the `Iops` parameter is specified, otherwise
#' `standard`
#' @param TdeCredentialArn The ARN from the key store with which to associate the instance for TDE
#' encryption.
#' @param TdeCredentialPassword The password for the given ARN from the key store in order to access the
#' device.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB instance.
#' 
#' Default: The default EC2 VPC security group for the DB subnet group\'s
#' VPC.
#' @param Domain Specify the Active Directory Domain to restore the instance in.
#' @param CopyTagsToSnapshot True to copy all tags from the restored DB instance to snapshots of the
#' restored DB instance, and otherwise false. The default is false.
#' @param DomainIAMRoleName Specify the name of the IAM role to be used when making API calls to the
#' Directory Service.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' You can enable IAM database authentication for the following database
#' engines
#' 
#' -   For MySQL 5.6, minor version 5.6.34 or higher
#' 
#' -   For MySQL 5.7, minor version 5.7.16 or higher
#' 
#' Default: `false`
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB instance is to export to
#' CloudWatch Logs. The values in the list depend on the DB engine being
#' used. For more information, see [Publishing Database Logs to Amazon
#' CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon Aurora User Guide*.
#' @param ProcessorFeatures The number of CPU cores and the number of threads per core for the DB
#' instance class of the DB instance.
#' @param UseDefaultProcessorFeatures A value that specifies that the DB instance class of the DB instance
#' uses its default processor features.
#' @param DBParameterGroupName The name of the DB parameter group to associate with this DB instance.
#' If this argument is omitted, the default DBParameterGroup for the
#' specified engine is used.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DBParameterGroup.
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' @param DeletionProtection Indicates if the DB instance should have deletion protection enabled.
#' The database can\'t be deleted when this value is set to true. The
#' default is false. For more information, see [Deleting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
#'
#' @section Request syntax:
#' ```
#' svc$restore_db_instance_from_db_snapshot(
#'   DBInstanceIdentifier = "string",
#'   DBSnapshotIdentifier = "string",
#'   DBInstanceClass = "string",
#'   Port = 123,
#'   AvailabilityZone = "string",
#'   DBSubnetGroupName = "string",
#'   MultiAZ = TRUE|FALSE,
#'   PubliclyAccessible = TRUE|FALSE,
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   LicenseModel = "string",
#'   DBName = "string",
#'   Engine = "string",
#'   Iops = 123,
#'   OptionGroupName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   StorageType = "string",
#'   TdeCredentialArn = "string",
#'   TdeCredentialPassword = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   Domain = "string",
#'   CopyTagsToSnapshot = TRUE|FALSE,
#'   DomainIAMRoleName = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   ProcessorFeatures = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   UseDefaultProcessorFeatures = TRUE|FALSE,
#'   DBParameterGroupName = "string",
#'   DeletionProtection = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_restore_db_instance_from_db_snapshot
rds_restore_db_instance_from_db_snapshot <- function(DBInstanceIdentifier, DBSnapshotIdentifier, DBInstanceClass = NULL, Port = NULL, AvailabilityZone = NULL, DBSubnetGroupName = NULL, MultiAZ = NULL, PubliclyAccessible = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, DBName = NULL, Engine = NULL, Iops = NULL, OptionGroupName = NULL, Tags = NULL, StorageType = NULL, TdeCredentialArn = NULL, TdeCredentialPassword = NULL, VpcSecurityGroupIds = NULL, Domain = NULL, CopyTagsToSnapshot = NULL, DomainIAMRoleName = NULL, EnableIAMDatabaseAuthentication = NULL, EnableCloudwatchLogsExports = NULL, ProcessorFeatures = NULL, UseDefaultProcessorFeatures = NULL, DBParameterGroupName = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "RestoreDBInstanceFromDBSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$restore_db_instance_from_db_snapshot_input(DBInstanceIdentifier = DBInstanceIdentifier, DBSnapshotIdentifier = DBSnapshotIdentifier, DBInstanceClass = DBInstanceClass, Port = Port, AvailabilityZone = AvailabilityZone, DBSubnetGroupName = DBSubnetGroupName, MultiAZ = MultiAZ, PubliclyAccessible = PubliclyAccessible, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, DBName = DBName, Engine = Engine, Iops = Iops, OptionGroupName = OptionGroupName, Tags = Tags, StorageType = StorageType, TdeCredentialArn = TdeCredentialArn, TdeCredentialPassword = TdeCredentialPassword, VpcSecurityGroupIds = VpcSecurityGroupIds, Domain = Domain, CopyTagsToSnapshot = CopyTagsToSnapshot, DomainIAMRoleName = DomainIAMRoleName, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, ProcessorFeatures = ProcessorFeatures, UseDefaultProcessorFeatures = UseDefaultProcessorFeatures, DBParameterGroupName = DBParameterGroupName, DeletionProtection = DeletionProtection)
  output <- .rds$restore_db_instance_from_db_snapshot_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$restore_db_instance_from_db_snapshot <- rds_restore_db_instance_from_db_snapshot

#' Amazon Relational Database Service (Amazon RDS) supports importing MySQL
#' databases by using backup files
#'
#' Amazon Relational Database Service (Amazon RDS) supports importing MySQL
#' databases by using backup files. You can create a backup of your
#' on-premises database, store it on Amazon Simple Storage Service (Amazon
#' S3), and then restore the backup file onto a new Amazon RDS DB instance
#' running MySQL. For more information, see [Importing Data into an Amazon
#' RDS MySQL DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html)
#' in the *Amazon RDS User Guide.*
#'
#' @usage
#' rds_restore_db_instance_from_s3(DBName, DBInstanceIdentifier,
#'   AllocatedStorage, DBInstanceClass, Engine, MasterUsername,
#'   MasterUserPassword, DBSecurityGroups, VpcSecurityGroupIds,
#'   AvailabilityZone, DBSubnetGroupName, PreferredMaintenanceWindow,
#'   DBParameterGroupName, BackupRetentionPeriod, PreferredBackupWindow,
#'   Port, MultiAZ, EngineVersion, AutoMinorVersionUpgrade, LicenseModel,
#'   Iops, OptionGroupName, PubliclyAccessible, Tags, StorageType,
#'   StorageEncrypted, KmsKeyId, CopyTagsToSnapshot, MonitoringInterval,
#'   MonitoringRoleArn, EnableIAMDatabaseAuthentication, SourceEngine,
#'   SourceEngineVersion, S3BucketName, S3Prefix, S3IngestionRoleArn,
#'   EnablePerformanceInsights, PerformanceInsightsKMSKeyId,
#'   PerformanceInsightsRetentionPeriod, EnableCloudwatchLogsExports,
#'   ProcessorFeatures, UseDefaultProcessorFeatures, DeletionProtection)
#'
#' @param DBName The name of the database to create when the DB instance is created.
#' Follow the naming rules specified in CreateDBInstance.
#' @param DBInstanceIdentifier &#91;required&#93; The DB instance identifier. This parameter is stored as a lowercase
#' string.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' 
#' Example: `mydbinstance`
#' @param AllocatedStorage The amount of storage (in gigabytes) to allocate initially for the DB
#' instance. Follow the allocation rules specified in CreateDBInstance.
#' 
#' Be sure to allocate enough memory for your new DB instance so that the
#' restore operation can succeed. You can also allocate additional memory
#' for future growth.
#' @param DBInstanceClass &#91;required&#93; The compute and memory capacity of the DB instance, for example,
#' `db.m4.large`. Not all DB instance classes are available in all AWS
#' Regions, or for all database engines. For the full list of DB instance
#' classes, and availability for your engine, see [DB Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Importing from Amazon S3 is not supported on the db.t2.micro DB instance
#' class.
#' @param Engine &#91;required&#93; The name of the database engine to be used for this instance.
#' 
#' Valid Values: `mysql`
#' @param MasterUsername The name for the master user.
#' 
#' Constraints:
#' 
#' -   Must be 1 to 16 letters or numbers.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t be a reserved word for the chosen database engine.
#' @param MasterUserPassword The password for the master user. The password can include any printable
#' ASCII character except \"/\", \"\"\", or \"@\".
#' 
#' Constraints: Must contain from 8 to 41 characters.
#' @param DBSecurityGroups A list of DB security groups to associate with this DB instance.
#' 
#' Default: The default DB security group for the database engine.
#' @param VpcSecurityGroupIds A list of VPC security groups to associate with this DB instance.
#' @param AvailabilityZone The Availability Zone that the DB instance is created in. For
#' information about AWS Regions and Availability Zones, see [Regions and
#' Availability
#' Zones](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Default: A random, system-chosen Availability Zone in the endpoint\'s
#' AWS Region.
#' 
#' Example: `us-east-1d`
#' 
#' Constraint: The AvailabilityZone parameter can\'t be specified if the
#' MultiAZ parameter is set to `true`. The specified Availability Zone must
#' be in the same AWS Region as the current endpoint.
#' @param DBSubnetGroupName A DB subnet group to associate with this DB instance.
#' @param PreferredMaintenanceWindow The time range each week during which system maintenance can occur, in
#' Universal Coordinated Time (UTC). For more information, see [Amazon RDS
#' Maintenance
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance)
#' in the *Amazon RDS User Guide.*
#' 
#' Constraints:
#' 
#' -   Must be in the format `ddd:hh24:mi-ddd:hh24:mi`.
#' 
#' -   Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred backup window.
#' 
#' -   Must be at least 30 minutes.
#' @param DBParameterGroupName The name of the DB parameter group to associate with this DB instance.
#' If this argument is omitted, the default parameter group for the
#' specified engine is used.
#' @param BackupRetentionPeriod The number of days for which automated backups are retained. Setting
#' this parameter to a positive number enables backups. For more
#' information, see CreateDBInstance.
#' @param PreferredBackupWindow The time range each day during which automated backups are created if
#' automated backups are enabled. For more information, see [The Backup
#' Window](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow)
#' in the *Amazon RDS User Guide.*
#' 
#' Constraints:
#' 
#' -   Must be in the format `hh24:mi-hh24:mi`.
#' 
#' -   Must be in Universal Coordinated Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param Port The port number on which the database accepts connections.
#' 
#' Type: Integer
#' 
#' Valid Values: `1150`-`65535`
#' 
#' Default: `3306`
#' @param MultiAZ Specifies whether the DB instance is a Multi-AZ deployment. If MultiAZ
#' is set to `true`, you can\'t set the AvailabilityZone parameter.
#' @param EngineVersion The version number of the database engine to use. Choose the latest
#' minor version of your database engine. For information about engine
#' versions, see CreateDBInstance, or call DescribeDBEngineVersions.
#' @param AutoMinorVersionUpgrade True to indicate that minor engine upgrades are applied automatically to
#' the DB instance during the maintenance window, and otherwise false.
#' 
#' Default: `true`
#' @param LicenseModel The license model for this DB instance. Use `general-public-license`.
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' allocate initially for the DB instance. For information about valid Iops
#' values, see see [Amazon RDS Provisioned IOPS Storage to Improve
#' Performance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS)
#' in the *Amazon RDS User Guide.*
#' @param OptionGroupName The name of the option group to associate with this DB instance. If this
#' argument is omitted, the default option group for the specified engine
#' is used.
#' @param PubliclyAccessible Specifies the accessibility options for the DB instance. A value of true
#' specifies an Internet-facing instance with a publicly resolvable DNS
#' name, which resolves to a public IP address. A value of false specifies
#' an internal instance with a DNS name that resolves to a private IP
#' address. For more information, see CreateDBInstance.
#' @param Tags A list of tags to associate with this DB instance. For more information,
#' see [Tagging Amazon RDS
#' Resources](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html)
#' in the *Amazon RDS User Guide.*
#' @param StorageType Specifies the storage type to be associated with the DB instance.
#' 
#' Valid values: `standard` \\| `gp2` \\| `io1`
#' 
#' If you specify `io1`, you must also include a value for the `Iops`
#' parameter.
#' 
#' Default: `io1` if the `Iops` parameter is specified; otherwise
#' `standard`
#' @param StorageEncrypted Specifies whether the new DB instance is encrypted or not.
#' @param KmsKeyId The AWS KMS key identifier for an encrypted DB instance.
#' 
#' The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
#' encryption key. If you are creating a DB instance with the same AWS
#' account that owns the KMS encryption key used to encrypt the new DB
#' instance, then you can use the KMS key alias instead of the ARN for the
#' KM encryption key.
#' 
#' If the `StorageEncrypted` parameter is true, and you do not specify a
#' value for the `KmsKeyId` parameter, then Amazon RDS will use your
#' default encryption key. AWS KMS creates the default encryption key for
#' your AWS account. Your AWS account has a different default encryption
#' key for each AWS Region.
#' @param CopyTagsToSnapshot True to copy all tags from the restored DB instance to snapshots of the
#' restored DB instance, and otherwise false.
#' 
#' Default: false.
#' @param MonitoringInterval The interval, in seconds, between points when Enhanced Monitoring
#' metrics are collected for the DB instance. To disable collecting
#' Enhanced Monitoring metrics, specify 0.
#' 
#' If `MonitoringRoleArn` is specified, then you must also set
#' `MonitoringInterval` to a value other than 0.
#' 
#' Valid Values: 0, 1, 5, 10, 15, 30, 60
#' 
#' Default: `0`
#' @param MonitoringRoleArn The ARN for the IAM role that permits RDS to send enhanced monitoring
#' metrics to Amazon CloudWatch Logs. For example,
#' `arn:aws:iam:123456789012:role/emaccess`. For information on creating a
#' monitoring role, see [Setting Up and Enabling Enhanced
#' Monitoring](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling)
#' in the *Amazon RDS User Guide.*
#' 
#' If `MonitoringInterval` is set to a value other than 0, then you must
#' supply a `MonitoringRoleArn` value.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' Default: `false`
#' @param SourceEngine &#91;required&#93; The name of the engine of your source database.
#' 
#' Valid Values: `mysql`
#' @param SourceEngineVersion &#91;required&#93; The engine version of your source database.
#' 
#' Valid Values: `5.6`
#' @param S3BucketName &#91;required&#93; The name of your Amazon S3 bucket that contains your database backup
#' file.
#' @param S3Prefix The prefix of your Amazon S3 bucket.
#' @param S3IngestionRoleArn &#91;required&#93; An AWS Identity and Access Management (IAM) role to allow Amazon RDS to
#' access your Amazon S3 bucket.
#' @param EnablePerformanceInsights True to enable Performance Insights for the DB instance, and otherwise
#' false.
#' 
#' For more information, see [Using Amazon Performance
#' Insights](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html)
#' in the *Amazon Relational Database Service User Guide*.
#' @param PerformanceInsightsKMSKeyId The AWS KMS key identifier for encryption of Performance Insights data.
#' The KMS key ID is the Amazon Resource Name (ARN), the KMS key
#' identifier, or the KMS key alias for the KMS encryption key.
#' @param PerformanceInsightsRetentionPeriod The amount of time, in days, to retain Performance Insights data. Valid
#' values are 7 or 731 (2 years).
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB instance is to export to
#' CloudWatch Logs. The values in the list depend on the DB engine being
#' used. For more information, see [Publishing Database Logs to Amazon
#' CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon RDS User Guide*.
#' @param ProcessorFeatures The number of CPU cores and the number of threads per core for the DB
#' instance class of the DB instance.
#' @param UseDefaultProcessorFeatures A value that specifies that the DB instance class of the DB instance
#' uses its default processor features.
#' @param DeletionProtection Indicates if the DB instance should have deletion protection enabled.
#' The database can\'t be deleted when this value is set to true. The
#' default is false. For more information, see [Deleting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
#'
#' @section Request syntax:
#' ```
#' svc$restore_db_instance_from_s3(
#'   DBName = "string",
#'   DBInstanceIdentifier = "string",
#'   AllocatedStorage = 123,
#'   DBInstanceClass = "string",
#'   Engine = "string",
#'   MasterUsername = "string",
#'   MasterUserPassword = "string",
#'   DBSecurityGroups = list(
#'     "string"
#'   ),
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   AvailabilityZone = "string",
#'   DBSubnetGroupName = "string",
#'   PreferredMaintenanceWindow = "string",
#'   DBParameterGroupName = "string",
#'   BackupRetentionPeriod = 123,
#'   PreferredBackupWindow = "string",
#'   Port = 123,
#'   MultiAZ = TRUE|FALSE,
#'   EngineVersion = "string",
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   LicenseModel = "string",
#'   Iops = 123,
#'   OptionGroupName = "string",
#'   PubliclyAccessible = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   StorageType = "string",
#'   StorageEncrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   CopyTagsToSnapshot = TRUE|FALSE,
#'   MonitoringInterval = 123,
#'   MonitoringRoleArn = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   SourceEngine = "string",
#'   SourceEngineVersion = "string",
#'   S3BucketName = "string",
#'   S3Prefix = "string",
#'   S3IngestionRoleArn = "string",
#'   EnablePerformanceInsights = TRUE|FALSE,
#'   PerformanceInsightsKMSKeyId = "string",
#'   PerformanceInsightsRetentionPeriod = 123,
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   ProcessorFeatures = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   UseDefaultProcessorFeatures = TRUE|FALSE,
#'   DeletionProtection = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_restore_db_instance_from_s3
rds_restore_db_instance_from_s3 <- function(DBName = NULL, DBInstanceIdentifier, AllocatedStorage = NULL, DBInstanceClass, Engine, MasterUsername = NULL, MasterUserPassword = NULL, DBSecurityGroups = NULL, VpcSecurityGroupIds = NULL, AvailabilityZone = NULL, DBSubnetGroupName = NULL, PreferredMaintenanceWindow = NULL, DBParameterGroupName = NULL, BackupRetentionPeriod = NULL, PreferredBackupWindow = NULL, Port = NULL, MultiAZ = NULL, EngineVersion = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, Iops = NULL, OptionGroupName = NULL, PubliclyAccessible = NULL, Tags = NULL, StorageType = NULL, StorageEncrypted = NULL, KmsKeyId = NULL, CopyTagsToSnapshot = NULL, MonitoringInterval = NULL, MonitoringRoleArn = NULL, EnableIAMDatabaseAuthentication = NULL, SourceEngine, SourceEngineVersion, S3BucketName, S3Prefix = NULL, S3IngestionRoleArn, EnablePerformanceInsights = NULL, PerformanceInsightsKMSKeyId = NULL, PerformanceInsightsRetentionPeriod = NULL, EnableCloudwatchLogsExports = NULL, ProcessorFeatures = NULL, UseDefaultProcessorFeatures = NULL, DeletionProtection = NULL) {
  op <- new_operation(
    name = "RestoreDBInstanceFromS3",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$restore_db_instance_from_s3_input(DBName = DBName, DBInstanceIdentifier = DBInstanceIdentifier, AllocatedStorage = AllocatedStorage, DBInstanceClass = DBInstanceClass, Engine = Engine, MasterUsername = MasterUsername, MasterUserPassword = MasterUserPassword, DBSecurityGroups = DBSecurityGroups, VpcSecurityGroupIds = VpcSecurityGroupIds, AvailabilityZone = AvailabilityZone, DBSubnetGroupName = DBSubnetGroupName, PreferredMaintenanceWindow = PreferredMaintenanceWindow, DBParameterGroupName = DBParameterGroupName, BackupRetentionPeriod = BackupRetentionPeriod, PreferredBackupWindow = PreferredBackupWindow, Port = Port, MultiAZ = MultiAZ, EngineVersion = EngineVersion, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, Iops = Iops, OptionGroupName = OptionGroupName, PubliclyAccessible = PubliclyAccessible, Tags = Tags, StorageType = StorageType, StorageEncrypted = StorageEncrypted, KmsKeyId = KmsKeyId, CopyTagsToSnapshot = CopyTagsToSnapshot, MonitoringInterval = MonitoringInterval, MonitoringRoleArn = MonitoringRoleArn, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, SourceEngine = SourceEngine, SourceEngineVersion = SourceEngineVersion, S3BucketName = S3BucketName, S3Prefix = S3Prefix, S3IngestionRoleArn = S3IngestionRoleArn, EnablePerformanceInsights = EnablePerformanceInsights, PerformanceInsightsKMSKeyId = PerformanceInsightsKMSKeyId, PerformanceInsightsRetentionPeriod = PerformanceInsightsRetentionPeriod, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, ProcessorFeatures = ProcessorFeatures, UseDefaultProcessorFeatures = UseDefaultProcessorFeatures, DeletionProtection = DeletionProtection)
  output <- .rds$restore_db_instance_from_s3_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$restore_db_instance_from_s3 <- rds_restore_db_instance_from_s3

#' Restores a DB instance to an arbitrary point in time
#'
#' Restores a DB instance to an arbitrary point in time. You can restore to
#' any point in time before the time identified by the LatestRestorableTime
#' property. You can restore to a point up to the number of days specified
#' by the BackupRetentionPeriod property.
#' 
#' The target database is created with most of the original configuration,
#' but in a system-selected Availability Zone, with the default security
#' group, the default subnet group, and the default DB parameter group. By
#' default, the new DB instance is created as a single-AZ deployment except
#' when the instance is a SQL Server instance that has an option group that
#' is associated with mirroring; in this case, the instance becomes a
#' mirrored deployment and not a single-AZ deployment.
#' 
#' This command doesn\'t apply to Aurora MySQL and Aurora PostgreSQL. For
#' Aurora, use RestoreDBClusterToPointInTime.
#'
#' @usage
#' rds_restore_db_instance_to_point_in_time(SourceDBInstanceIdentifier,
#'   TargetDBInstanceIdentifier, RestoreTime, UseLatestRestorableTime,
#'   DBInstanceClass, Port, AvailabilityZone, DBSubnetGroupName, MultiAZ,
#'   PubliclyAccessible, AutoMinorVersionUpgrade, LicenseModel, DBName,
#'   Engine, Iops, OptionGroupName, CopyTagsToSnapshot, Tags, StorageType,
#'   TdeCredentialArn, TdeCredentialPassword, VpcSecurityGroupIds, Domain,
#'   DomainIAMRoleName, EnableIAMDatabaseAuthentication,
#'   EnableCloudwatchLogsExports, ProcessorFeatures,
#'   UseDefaultProcessorFeatures, DBParameterGroupName, DeletionProtection,
#'   SourceDbiResourceId)
#'
#' @param SourceDBInstanceIdentifier The identifier of the source DB instance from which to restore.
#' 
#' Constraints:
#' 
#' -   Must match the identifier of an existing DB instance.
#' @param TargetDBInstanceIdentifier &#91;required&#93; The name of the new DB instance to be created.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 63 letters, numbers, or hyphens
#' 
#' -   First character must be a letter
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens
#' @param RestoreTime The date and time to restore from.
#' 
#' Valid Values: Value must be a time in Universal Coordinated Time (UTC)
#' format
#' 
#' Constraints:
#' 
#' -   Must be before the latest restorable time for the DB instance
#' 
#' -   Can\'t be specified if UseLatestRestorableTime parameter is true
#' 
#' Example: `2009-09-07T23:45:00Z`
#' @param UseLatestRestorableTime Specifies whether (`true`) or not (`false`) the DB instance is restored
#' from the latest backup time.
#' 
#' Default: `false`
#' 
#' Constraints: Can\'t be specified if RestoreTime parameter is provided.
#' @param DBInstanceClass The compute and memory capacity of the Amazon RDS DB instance, for
#' example, `db.m4.large`. Not all DB instance classes are available in all
#' AWS Regions, or for all database engines. For the full list of DB
#' instance classes, and availability for your engine, see [DB Instance
#' Class](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html)
#' in the *Amazon RDS User Guide.*
#' 
#' Default: The same DBInstanceClass as the original DB instance.
#' @param Port The port number on which the database accepts connections.
#' 
#' Constraints: Value must be `1150-65535`
#' 
#' Default: The same port as the original DB instance.
#' @param AvailabilityZone The EC2 Availability Zone that the DB instance is created in.
#' 
#' Default: A random, system-chosen Availability Zone.
#' 
#' Constraint: You can\'t specify the AvailabilityZone parameter if the
#' MultiAZ parameter is set to true.
#' 
#' Example: `us-east-1a`
#' @param DBSubnetGroupName The DB subnet group name to use for the new instance.
#' 
#' Constraints: If supplied, must match the name of an existing
#' DBSubnetGroup.
#' 
#' Example: `mySubnetgroup`
#' @param MultiAZ Specifies if the DB instance is a Multi-AZ deployment.
#' 
#' Constraint: You can\'t specify the AvailabilityZone parameter if the
#' MultiAZ parameter is set to `true`.
#' @param PubliclyAccessible Specifies the accessibility options for the DB instance. A value of true
#' specifies an Internet-facing instance with a publicly resolvable DNS
#' name, which resolves to a public IP address. A value of false specifies
#' an internal instance with a DNS name that resolves to a private IP
#' address. For more information, see CreateDBInstance.
#' @param AutoMinorVersionUpgrade Indicates that minor version upgrades are applied automatically to the
#' DB instance during the maintenance window.
#' @param LicenseModel License model information for the restored DB instance.
#' 
#' Default: Same as source.
#' 
#' Valid values: `license-included` \\| `bring-your-own-license` \\|
#' `general-public-license`
#' @param DBName The database name for the restored DB instance.
#' 
#' This parameter is not used for the MySQL or MariaDB engines.
#' @param Engine The database engine to use for the new instance.
#' 
#' Default: The same as source
#' 
#' Constraint: Must be compatible with the engine of the source
#' 
#' Valid Values:
#' 
#' -   `mariadb`
#' 
#' -   `mysql`
#' 
#' -   `oracle-ee`
#' 
#' -   `oracle-se2`
#' 
#' -   `oracle-se1`
#' 
#' -   `oracle-se`
#' 
#' -   `postgres`
#' 
#' -   `sqlserver-ee`
#' 
#' -   `sqlserver-se`
#' 
#' -   `sqlserver-ex`
#' 
#' -   `sqlserver-web`
#' @param Iops The amount of Provisioned IOPS (input/output operations per second) to
#' be initially allocated for the DB instance.
#' 
#' Constraints: Must be an integer greater than 1000.
#' 
#' **SQL Server**
#' 
#' Setting the IOPS value for the SQL Server database engine is not
#' supported.
#' @param OptionGroupName The name of the option group to be used for the restored DB instance.
#' 
#' Permanent options, such as the TDE option for Oracle Advanced Security
#' TDE, can\'t be removed from an option group, and that option group
#' can\'t be removed from a DB instance once it is associated with a DB
#' instance
#' @param CopyTagsToSnapshot True to copy all tags from the restored DB instance to snapshots of the
#' restored DB instance, and otherwise false. The default is false.
#' @param Tags 
#' @param StorageType Specifies the storage type to be associated with the DB instance.
#' 
#' Valid values: `standard | gp2 | io1`
#' 
#' If you specify `io1`, you must also include a value for the `Iops`
#' parameter.
#' 
#' Default: `io1` if the `Iops` parameter is specified, otherwise
#' `standard`
#' @param TdeCredentialArn The ARN from the key store with which to associate the instance for TDE
#' encryption.
#' @param TdeCredentialPassword The password for the given ARN from the key store in order to access the
#' device.
#' @param VpcSecurityGroupIds A list of EC2 VPC security groups to associate with this DB instance.
#' 
#' Default: The default EC2 VPC security group for the DB subnet group\'s
#' VPC.
#' @param Domain Specify the Active Directory Domain to restore the instance in.
#' @param DomainIAMRoleName Specify the name of the IAM role to be used when making API calls to the
#' Directory Service.
#' @param EnableIAMDatabaseAuthentication True to enable mapping of AWS Identity and Access Management (IAM)
#' accounts to database accounts, and otherwise false.
#' 
#' You can enable IAM database authentication for the following database
#' engines
#' 
#' -   For MySQL 5.6, minor version 5.6.34 or higher
#' 
#' -   For MySQL 5.7, minor version 5.7.16 or higher
#' 
#' Default: `false`
#' @param EnableCloudwatchLogsExports The list of logs that the restored DB instance is to export to
#' CloudWatch Logs. The values in the list depend on the DB engine being
#' used. For more information, see [Publishing Database Logs to Amazon
#' CloudWatch
#' Logs](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
#' in the *Amazon RDS User Guide*.
#' @param ProcessorFeatures The number of CPU cores and the number of threads per core for the DB
#' instance class of the DB instance.
#' @param UseDefaultProcessorFeatures A value that specifies that the DB instance class of the DB instance
#' uses its default processor features.
#' @param DBParameterGroupName The name of the DB parameter group to associate with this DB instance.
#' If this argument is omitted, the default DBParameterGroup for the
#' specified engine is used.
#' 
#' Constraints:
#' 
#' -   If supplied, must match the name of an existing DBParameterGroup.
#' 
#' -   Must be 1 to 255 letters, numbers, or hyphens.
#' 
#' -   First character must be a letter.
#' 
#' -   Can\'t end with a hyphen or contain two consecutive hyphens.
#' @param DeletionProtection Indicates if the DB instance should have deletion protection enabled.
#' The database can\'t be deleted when this value is set to true. The
#' default is false. For more information, see [Deleting a DB
#' Instance](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
#' @param SourceDbiResourceId The resource ID of the source DB instance from which to restore.
#'
#' @section Request syntax:
#' ```
#' svc$restore_db_instance_to_point_in_time(
#'   SourceDBInstanceIdentifier = "string",
#'   TargetDBInstanceIdentifier = "string",
#'   RestoreTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   UseLatestRestorableTime = TRUE|FALSE,
#'   DBInstanceClass = "string",
#'   Port = 123,
#'   AvailabilityZone = "string",
#'   DBSubnetGroupName = "string",
#'   MultiAZ = TRUE|FALSE,
#'   PubliclyAccessible = TRUE|FALSE,
#'   AutoMinorVersionUpgrade = TRUE|FALSE,
#'   LicenseModel = "string",
#'   DBName = "string",
#'   Engine = "string",
#'   Iops = 123,
#'   OptionGroupName = "string",
#'   CopyTagsToSnapshot = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   StorageType = "string",
#'   TdeCredentialArn = "string",
#'   TdeCredentialPassword = "string",
#'   VpcSecurityGroupIds = list(
#'     "string"
#'   ),
#'   Domain = "string",
#'   DomainIAMRoleName = "string",
#'   EnableIAMDatabaseAuthentication = TRUE|FALSE,
#'   EnableCloudwatchLogsExports = list(
#'     "string"
#'   ),
#'   ProcessorFeatures = list(
#'     list(
#'       Name = "string",
#'       Value = "string"
#'     )
#'   ),
#'   UseDefaultProcessorFeatures = TRUE|FALSE,
#'   DBParameterGroupName = "string",
#'   DeletionProtection = TRUE|FALSE,
#'   SourceDbiResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_restore_db_instance_to_point_in_time
rds_restore_db_instance_to_point_in_time <- function(SourceDBInstanceIdentifier = NULL, TargetDBInstanceIdentifier, RestoreTime = NULL, UseLatestRestorableTime = NULL, DBInstanceClass = NULL, Port = NULL, AvailabilityZone = NULL, DBSubnetGroupName = NULL, MultiAZ = NULL, PubliclyAccessible = NULL, AutoMinorVersionUpgrade = NULL, LicenseModel = NULL, DBName = NULL, Engine = NULL, Iops = NULL, OptionGroupName = NULL, CopyTagsToSnapshot = NULL, Tags = NULL, StorageType = NULL, TdeCredentialArn = NULL, TdeCredentialPassword = NULL, VpcSecurityGroupIds = NULL, Domain = NULL, DomainIAMRoleName = NULL, EnableIAMDatabaseAuthentication = NULL, EnableCloudwatchLogsExports = NULL, ProcessorFeatures = NULL, UseDefaultProcessorFeatures = NULL, DBParameterGroupName = NULL, DeletionProtection = NULL, SourceDbiResourceId = NULL) {
  op <- new_operation(
    name = "RestoreDBInstanceToPointInTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$restore_db_instance_to_point_in_time_input(SourceDBInstanceIdentifier = SourceDBInstanceIdentifier, TargetDBInstanceIdentifier = TargetDBInstanceIdentifier, RestoreTime = RestoreTime, UseLatestRestorableTime = UseLatestRestorableTime, DBInstanceClass = DBInstanceClass, Port = Port, AvailabilityZone = AvailabilityZone, DBSubnetGroupName = DBSubnetGroupName, MultiAZ = MultiAZ, PubliclyAccessible = PubliclyAccessible, AutoMinorVersionUpgrade = AutoMinorVersionUpgrade, LicenseModel = LicenseModel, DBName = DBName, Engine = Engine, Iops = Iops, OptionGroupName = OptionGroupName, CopyTagsToSnapshot = CopyTagsToSnapshot, Tags = Tags, StorageType = StorageType, TdeCredentialArn = TdeCredentialArn, TdeCredentialPassword = TdeCredentialPassword, VpcSecurityGroupIds = VpcSecurityGroupIds, Domain = Domain, DomainIAMRoleName = DomainIAMRoleName, EnableIAMDatabaseAuthentication = EnableIAMDatabaseAuthentication, EnableCloudwatchLogsExports = EnableCloudwatchLogsExports, ProcessorFeatures = ProcessorFeatures, UseDefaultProcessorFeatures = UseDefaultProcessorFeatures, DBParameterGroupName = DBParameterGroupName, DeletionProtection = DeletionProtection, SourceDbiResourceId = SourceDbiResourceId)
  output <- .rds$restore_db_instance_to_point_in_time_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$restore_db_instance_to_point_in_time <- rds_restore_db_instance_to_point_in_time

#' Revokes ingress from a DBSecurityGroup for previously authorized IP
#' ranges or EC2 or VPC Security Groups
#'
#' Revokes ingress from a DBSecurityGroup for previously authorized IP
#' ranges or EC2 or VPC Security Groups. Required parameters for this API
#' are one of CIDRIP, EC2SecurityGroupId for VPC, or
#' (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or
#' EC2SecurityGroupId).
#'
#' @usage
#' rds_revoke_db_security_group_ingress(DBSecurityGroupName, CIDRIP,
#'   EC2SecurityGroupName, EC2SecurityGroupId, EC2SecurityGroupOwnerId)
#'
#' @param DBSecurityGroupName &#91;required&#93; The name of the DB security group to revoke ingress from.
#' @param CIDRIP The IP range to revoke access from. Must be a valid CIDR range. If
#' `CIDRIP` is specified, `EC2SecurityGroupName`, `EC2SecurityGroupId` and
#' `EC2SecurityGroupOwnerId` can\'t be provided.
#' @param EC2SecurityGroupName The name of the EC2 security group to revoke access from. For VPC DB
#' security groups, `EC2SecurityGroupId` must be provided. Otherwise,
#' EC2SecurityGroupOwnerId and either `EC2SecurityGroupName` or
#' `EC2SecurityGroupId` must be provided.
#' @param EC2SecurityGroupId The id of the EC2 security group to revoke access from. For VPC DB
#' security groups, `EC2SecurityGroupId` must be provided. Otherwise,
#' EC2SecurityGroupOwnerId and either `EC2SecurityGroupName` or
#' `EC2SecurityGroupId` must be provided.
#' @param EC2SecurityGroupOwnerId The AWS Account Number of the owner of the EC2 security group specified
#' in the `EC2SecurityGroupName` parameter. The AWS Access Key ID is not an
#' acceptable value. For VPC DB security groups, `EC2SecurityGroupId` must
#' be provided. Otherwise, EC2SecurityGroupOwnerId and either
#' `EC2SecurityGroupName` or `EC2SecurityGroupId` must be provided.
#'
#' @section Request syntax:
#' ```
#' svc$revoke_db_security_group_ingress(
#'   DBSecurityGroupName = "string",
#'   CIDRIP = "string",
#'   EC2SecurityGroupName = "string",
#'   EC2SecurityGroupId = "string",
#'   EC2SecurityGroupOwnerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_revoke_db_security_group_ingress
rds_revoke_db_security_group_ingress <- function(DBSecurityGroupName, CIDRIP = NULL, EC2SecurityGroupName = NULL, EC2SecurityGroupId = NULL, EC2SecurityGroupOwnerId = NULL) {
  op <- new_operation(
    name = "RevokeDBSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$revoke_db_security_group_ingress_input(DBSecurityGroupName = DBSecurityGroupName, CIDRIP = CIDRIP, EC2SecurityGroupName = EC2SecurityGroupName, EC2SecurityGroupId = EC2SecurityGroupId, EC2SecurityGroupOwnerId = EC2SecurityGroupOwnerId)
  output <- .rds$revoke_db_security_group_ingress_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$revoke_db_security_group_ingress <- rds_revoke_db_security_group_ingress

#' Starts an Amazon Aurora DB cluster that was stopped using the AWS
#' console, the stop-db-cluster AWS CLI command, or the StopDBCluster
#' action
#'
#' Starts an Amazon Aurora DB cluster that was stopped using the AWS
#' console, the stop-db-cluster AWS CLI command, or the StopDBCluster
#' action.
#' 
#' For more information, see [Stopping and Starting an Aurora
#' Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_start_db_cluster(DBClusterIdentifier)
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the Amazon Aurora DB cluster to be started.
#' This parameter is stored as a lowercase string.
#'
#' @section Request syntax:
#' ```
#' svc$start_db_cluster(
#'   DBClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_start_db_cluster
rds_start_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "StartDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$start_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .rds$start_db_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$start_db_cluster <- rds_start_db_cluster

#' Starts an Amazon RDS DB instance that was stopped using the AWS console,
#' the stop-db-instance AWS CLI command, or the StopDBInstance action
#'
#' Starts an Amazon RDS DB instance that was stopped using the AWS console,
#' the stop-db-instance AWS CLI command, or the StopDBInstance action.
#' 
#' For more information, see [Starting an Amazon RDS DB instance That Was
#' Previously
#' Stopped](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StartInstance.html)
#' in the *Amazon RDS User Guide.*
#' 
#' This command doesn\'t apply to Aurora MySQL and Aurora PostgreSQL. For
#' Aurora DB clusters, use StartDBCluster instead.
#'
#' @usage
#' rds_start_db_instance(DBInstanceIdentifier)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The user-supplied instance identifier.
#'
#' @section Request syntax:
#' ```
#' svc$start_db_instance(
#'   DBInstanceIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_start_db_instance
rds_start_db_instance <- function(DBInstanceIdentifier) {
  op <- new_operation(
    name = "StartDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$start_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier)
  output <- .rds$start_db_instance_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$start_db_instance <- rds_start_db_instance

#' Stops an Amazon Aurora DB cluster
#'
#' Stops an Amazon Aurora DB cluster. When you stop a DB cluster, Aurora
#' retains the DB cluster\'s metadata, including its endpoints and DB
#' parameter groups. Aurora also retains the transaction logs so you can do
#' a point-in-time restore if necessary.
#' 
#' For more information, see [Stopping and Starting an Aurora
#' Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-cluster-stop-start.html)
#' in the *Amazon Aurora User Guide.*
#' 
#' This action only applies to Aurora DB clusters.
#'
#' @usage
#' rds_stop_db_cluster(DBClusterIdentifier)
#'
#' @param DBClusterIdentifier &#91;required&#93; The DB cluster identifier of the Amazon Aurora DB cluster to be stopped.
#' This parameter is stored as a lowercase string.
#'
#' @section Request syntax:
#' ```
#' svc$stop_db_cluster(
#'   DBClusterIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_stop_db_cluster
rds_stop_db_cluster <- function(DBClusterIdentifier) {
  op <- new_operation(
    name = "StopDBCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$stop_db_cluster_input(DBClusterIdentifier = DBClusterIdentifier)
  output <- .rds$stop_db_cluster_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$stop_db_cluster <- rds_stop_db_cluster

#' Stops an Amazon RDS DB instance
#'
#' Stops an Amazon RDS DB instance. When you stop a DB instance, Amazon RDS
#' retains the DB instance\'s metadata, including its endpoint, DB
#' parameter group, and option group membership. Amazon RDS also retains
#' the transaction logs so you can do a point-in-time restore if necessary.
#' 
#' For more information, see [Stopping an Amazon RDS DB Instance
#' Temporarily](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StopInstance.html)
#' in the *Amazon RDS User Guide.*
#' 
#' This command doesn\'t apply to Aurora MySQL and Aurora PostgreSQL. For
#' Aurora clusters, use StopDBCluster instead.
#'
#' @usage
#' rds_stop_db_instance(DBInstanceIdentifier, DBSnapshotIdentifier)
#'
#' @param DBInstanceIdentifier &#91;required&#93; The user-supplied instance identifier.
#' @param DBSnapshotIdentifier The user-supplied instance identifier of the DB Snapshot created
#' immediately before the DB instance is stopped.
#'
#' @section Request syntax:
#' ```
#' svc$stop_db_instance(
#'   DBInstanceIdentifier = "string",
#'   DBSnapshotIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname rds_stop_db_instance
rds_stop_db_instance <- function(DBInstanceIdentifier, DBSnapshotIdentifier = NULL) {
  op <- new_operation(
    name = "StopDBInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .rds$stop_db_instance_input(DBInstanceIdentifier = DBInstanceIdentifier, DBSnapshotIdentifier = DBSnapshotIdentifier)
  output <- .rds$stop_db_instance_output()
  svc <- .rds$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.rds$operations$stop_db_instance <- rds_stop_db_instance
