% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectwisdomservice_operations.R
\name{connectwisdomservice_update_knowledge_base_template_uri}
\alias{connectwisdomservice_update_knowledge_base_template_uri}
\title{Updates the template URI of a knowledge base}
\usage{
connectwisdomservice_update_knowledge_base_template_uri(
  knowledgeBaseId,
  templateUri
)
}
\arguments{
\item{knowledgeBaseId}{[required] The identifier of the knowledge base. This should not be a
QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
resource to it. Can be either the ID or the ARN. URLs cannot contain the
ARN.}

\item{templateUri}{[required] The template URI to update.}
}
\description{
Updates the template URI of a knowledge base. This is only supported for knowledge bases of type EXTERNAL. Include a single variable in \verb{$\{variable\}} format; this interpolated by Wisdom using ingested content. For example, if you ingest a Salesforce article, it has an \code{Id} value, and you can set the template URI to \verb{https://myInstanceName.lightning.force.com/lightning/r/Knowledge__kav/*$\{Id\}*/view}.

See \url{https://www.paws-r-sdk.com/docs/connectwisdomservice_update_knowledge_base_template_uri/} for full documentation.
}
\keyword{internal}
