% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_update_task_template}
\alias{connect_update_task_template}
\title{Updates details about a specific task template in the specified Amazon
Connect instance}
\usage{
connect_update_task_template(
  TaskTemplateId,
  InstanceId,
  Name = NULL,
  Description = NULL,
  ContactFlowId = NULL,
  Constraints = NULL,
  Defaults = NULL,
  Status = NULL,
  Fields = NULL
)
}
\arguments{
\item{TaskTemplateId}{[required] A unique identifier for the task template.}

\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can find the
instanceId in the ARN of the instance.}

\item{Name}{The name of the task template.}

\item{Description}{The description of the task template.}

\item{ContactFlowId}{The identifier of the flow that runs by default when a task is created
by referencing this template.}

\item{Constraints}{Constraints that are applicable to the fields listed.}

\item{Defaults}{The default values for fields when a task is created by referencing this
template.}

\item{Status}{Marks a template as \code{ACTIVE} or \code{INACTIVE} for a task to refer to it.
Tasks can only be created from \code{ACTIVE} templates. If a template is
marked as \code{INACTIVE}, then a task that refers to this template cannot be
created.}

\item{Fields}{Fields that are part of the template.}
}
\description{
Updates details about a specific task template in the specified Amazon Connect instance. This operation does not support partial updates. Instead it does a full update of template content.

See \url{https://paws-r.github.io/docs/connect/update_task_template.html} for full documentation.
}
\keyword{internal}
