% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_list_default_vocabularies}
\alias{connect_list_default_vocabularies}
\title{Lists the default vocabularies for the specified Amazon Connect instance}
\usage{
connect_list_default_vocabularies(
  InstanceId,
  LanguageCode = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can find the
instanceId in the ARN of the instance.}

\item{LanguageCode}{The language code of the vocabulary entries. For a list of languages and
their corresponding language codes, see \href{https://docs.aws.amazon.com/transcribe/latest/dg/what-is.html}{What is Amazon Transcribe?}}

\item{MaxResults}{The maximum number of results to return per page.}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}
}
\description{
Lists the default vocabularies for the specified Amazon Connect instance.

See \url{https://paws-r.github.io/docs/connect/list_default_vocabularies.html} for full documentation.
}
\keyword{internal}
