% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_get_metric_data}
\alias{connect_get_metric_data}
\title{Gets historical metric data from the specified Amazon Connect instance}
\usage{
connect_get_metric_data(
  InstanceId,
  StartTime,
  EndTime,
  Filters,
  Groupings = NULL,
  HistoricalMetrics,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can find the
instanceId in the ARN of the instance.}

\item{StartTime}{[required] The timestamp, in UNIX Epoch time format, at which to start the
reporting interval for the retrieval of historical metrics data. The
time must be specified using a multiple of 5 minutes, such as 10:05,
10:10, 10:15.

The start time cannot be earlier than 24 hours before the time of the
request. Historical metrics are available only for 24 hours.}

\item{EndTime}{[required] The timestamp, in UNIX Epoch time format, at which to end the reporting
interval for the retrieval of historical metrics data. The time must be
specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10,
and must be later than the start time timestamp.

The time range between the start and end time must be less than 24
hours.}

\item{Filters}{[required] The queues, up to 100, or channels, to use to filter the metrics
returned. Metric data is retrieved only for the resources associated
with the queues or channels included in the filter. You can include both
queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK
channels are supported.

To filter by \code{Queues}, enter the queue ID/ARN, not the name of the
queue.}

\item{Groupings}{The grouping applied to the metrics returned. For example, when results
are grouped by queue, the metrics returned are grouped by queue. The
values returned apply to the metrics for each queue rather than
aggregated for all queues.

If no grouping is specified, a summary of metrics for all queues is
returned.}

\item{HistoricalMetrics}{[required] The metrics to retrieve. Specify the name, unit, and statistic for each
metric. The following historical metrics are available. For a
description of each metric, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html}{Historical Metrics Definitions}
in the \emph{Amazon Connect Administrator Guide}.

This API does not support a contacts incoming metric (there's no
CONTACTS_INCOMING metric missing from the documented list).

\strong{ABANDON_TIME}

Unit: SECONDS

Statistic: AVG

\strong{AFTER_CONTACT_WORK_TIME}

Unit: SECONDS

Statistic: AVG

\strong{API_CONTACTS_HANDLED}

Unit: COUNT

Statistic: SUM

\strong{CALLBACK_CONTACTS_HANDLED}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_ABANDONED}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_AGENT_HUNG_UP_FIRST}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_CONSULTED}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_HANDLED}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_HANDLED_INCOMING}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_HANDLED_OUTBOUND}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_HOLD_ABANDONS}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_MISSED}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_QUEUED}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_TRANSFERRED_IN}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_TRANSFERRED_IN_FROM_QUEUE}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_TRANSFERRED_OUT}

Unit: COUNT

Statistic: SUM

\strong{CONTACTS_TRANSFERRED_OUT_FROM_QUEUE}

Unit: COUNT

Statistic: SUM

\strong{HANDLE_TIME}

Unit: SECONDS

Statistic: AVG

\strong{HOLD_TIME}

Unit: SECONDS

Statistic: AVG

\strong{INTERACTION_AND_HOLD_TIME}

Unit: SECONDS

Statistic: AVG

\strong{INTERACTION_TIME}

Unit: SECONDS

Statistic: AVG

\strong{OCCUPANCY}

Unit: PERCENT

Statistic: AVG

\strong{QUEUE_ANSWER_TIME}

Unit: SECONDS

Statistic: AVG

\strong{QUEUED_TIME}

Unit: SECONDS

Statistic: MAX

\strong{SERVICE_LEVEL}

You can include up to 20 SERVICE_LEVEL metrics in a request.

Unit: PERCENT

Statistic: AVG

Threshold: For \code{ThresholdValue}, enter any whole number from 1 to 604800
(inclusive), in seconds. For \code{Comparison}, you must enter \code{LT} (for
"Less than").}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{The maximum number of results to return per page.}
}
\description{
Gets historical metric data from the specified Amazon Connect instance.

See \url{https://paws-r.github.io/docs/connect/get_metric_data.html} for full documentation.
}
\keyword{internal}
