% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_create_receipt_filter}
\alias{ses_create_receipt_filter}
\title{Creates a new IP address filter}
\usage{
ses_create_receipt_filter(Filter)
}
\arguments{
\item{Filter}{[required] A data structure that describes the IP address filter to create, which
consists of a name, an IP address range, and whether to allow or block
mail from it.}
}
\description{
Creates a new IP address filter.
}
\details{
For information about setting up IP address filters, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$create_receipt_filter(
  Filter = list(
    Name = "string",
    IpFilter = list(
      Policy = "Block"|"Allow",
      Cidr = "string"
    )
  )
)
}
}

\examples{
# The following example creates a new IP address filter:
\dontrun{svc$create_receipt_filter(
  Filter = list(
    IpFilter = list(
      Cidr = "1.2.3.4/24",
      Policy = "Allow"
    ),
    Name = "MyFilter"
  )
)}

}
\keyword{internal}
