% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_get_metric_data}
\alias{connect_get_metric_data}
\title{The GetMetricData operation retrieves historical metrics data from your
Amazon Connect instance}
\usage{
connect_get_metric_data(InstanceId, StartTime, EndTime, Filters,
  Groupings, HistoricalMetrics, NextToken, MaxResults)
}
\arguments{
\item{InstanceId}{[required] The identifier for your Amazon Connect instance. To find the ID of your
instance, open the AWS console and select Amazon Connect. Select the
alias of the instance in the Instance alias column. The instance ID is
displayed in the Overview section of your instance settings. For
example, the instance ID is the set of characters at the end of the
instance ARN, after instance/, such as
10a4c4eb-f57e-4d4c-b602-bf39176ced07.}

\item{StartTime}{[required] The timestamp, in UNIX Epoch time format, at which to start the
reporting interval for the retrieval of historical metrics data. The
time must be specified using a multiple of 5 minutes, such as 10:05,
10:10, 10:15.

\code{StartTime} cannot be earlier than 24 hours before the time of the
request. Historical metrics are available in Amazon Connect only for 24
hours.}

\item{EndTime}{[required] The timestamp, in UNIX Epoch time format, at which to end the reporting
interval for the retrieval of historical metrics data. The time must be
specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10,
and must be later than the \code{StartTime} timestamp.

The time range between \code{StartTime} and \code{EndTime} must be less than 24
hours.}

\item{Filters}{[required] A \code{Filters} object that contains a list of queue IDs or queue ARNs, up
to 100, or a list of Channels to use to filter the metrics returned in
the response. Metric data is retrieved only for the resources associated
with the IDs, ARNs, or Channels included in the filter. You can use both
IDs and ARNs together in a request. Only VOICE is supported for Channel.

To find the ARN for a queue, open the queue you want to use in the
Amazon Connect Queue editor. The ARN for the queue is displayed in the
address bar as part of the URL. For example, the queue ARN is the set of
characters at the end of the URL, after 'id=' such as
\code{arn:aws:connect:us-east-1:270923740243:instance/78fb859d-1b7d-44b1-8aa3-12f0835c5855/queue/1d1a4575-9618-40ab-bbeb-81e45795fe61}.
The queue ID is also included in the URL, and is the string after
'queue/'.}

\item{Groupings}{The grouping applied to the metrics returned. For example, when results
are grouped by queueId, the metrics returned are grouped by queue. The
values returned apply to the metrics for each queue rather than
aggregated for all queues.

The current version supports grouping by Queue

If no \code{Grouping} is included in the request, a summary of
\code{HistoricalMetrics} for all queues is returned.}

\item{HistoricalMetrics}{[required] A list of \code{HistoricalMetric} objects that contain the metrics to
retrieve with the request.

A \code{HistoricalMetric} object contains: \code{HistoricalMetricName},
\code{Statistic}, \code{Threshold}, and \code{Unit}.

You must list each metric to retrieve data for in the request. For each
historical metric you include in the request, you must include a \code{Unit}
and a \code{Statistic}.

The following historical metrics are available:

CONTACTS\_QUEUED

:   Unit: COUNT\preformatted{Statistic: SUM
}

CONTACTS\_HANDLED

:   Unit: COUNT\preformatted{Statistics: SUM
}

CONTACTS\_ABANDONED

:   Unit: COUNT\preformatted{Statistics: SUM
}

CONTACTS\_CONSULTED

:   Unit: COUNT\preformatted{Statistics: SUM
}

CONTACTS\_AGENT\_HUNG\_UP\_FIRST

:   Unit: COUNT\preformatted{Statistics: SUM
}

CONTACTS\_HANDLED\_INCOMING

:   Unit: COUNT\preformatted{Statistics: SUM
}

CONTACTS\_HANDLED\_OUTBOUND

:   Unit: COUNT\preformatted{Statistics: SUM
}

CONTACTS\_HOLD\_ABANDONS

:   Unit: COUNT\preformatted{Statistics: SUM
}

CONTACTS\_TRANSFERRED\_IN

:   Unit: COUNT\preformatted{Statistics: SUM
}

CONTACTS\_TRANSFERRED\_OUT

:   Unit: COUNT\preformatted{Statistics: SUM
}

CONTACTS\_TRANSFERRED\_IN\_FROM\_QUEUE

:   Unit: COUNT\preformatted{Statistics: SUM
}

CONTACTS\_TRANSFERRED\_OUT\_FROM\_QUEUE

:   Unit: COUNT\preformatted{Statistics: SUM
}

CALLBACK\_CONTACTS\_HANDLED

:   Unit: COUNT\preformatted{Statistics: SUM
}

CALLBACK\_CONTACTS\_HANDLED

:   Unit: COUNT\preformatted{Statistics: SUM
}

API\_CONTACTS\_HANDLED

:   Unit: COUNT\preformatted{Statistics: SUM
}

CONTACTS\_MISSED

:   Unit: COUNT\preformatted{Statistics: SUM
}

OCCUPANCY

:   Unit: PERCENT\preformatted{Statistics: AVG
}

HANDLE\_TIME

:   Unit: SECONDS\preformatted{Statistics: AVG
}

AFTER\_CONTACT\_WORK\_TIME

:   Unit: SECONDS\preformatted{Statistics: AVG
}

QUEUED\_TIME

:   Unit: SECONDS\preformatted{Statistics: MAX
}

ABANDON\_TIME

:   Unit: COUNT\preformatted{Statistics: SUM
}

QUEUE\_ANSWER\_TIME

:   Unit: SECONDS\preformatted{Statistics: AVG
}

HOLD\_TIME

:   Unit: SECONDS\preformatted{Statistics: AVG
}

INTERACTION\_TIME

:   Unit: SECONDS\preformatted{Statistics: AVG
}

INTERACTION\_AND\_HOLD\_TIME

:   Unit: SECONDS\preformatted{Statistics: AVG
}

SERVICE\_LEVEL

:   Unit: PERCENT\preformatted{Statistics: AVG

Threshold: Only \"Less than\" comparisons are supported, with the
following service level thresholds: 15, 20, 25, 30, 45, 60, 90, 120,
180, 240, 300, 600
}}

\item{NextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}

\item{MaxResults}{Indicates the maximum number of results to return per page in the
response, between 1-100.}
}
\description{
The \code{GetMetricData} operation retrieves historical metrics data from
your Amazon Connect instance.
}
\details{
If you are using an IAM account, it must have permission to the
\code{connect:GetMetricData} action.
}
\section{Request syntax}{
\preformatted{svc$get_metric_data(
  InstanceId = "string",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  Filters = list(
    Queues = list(
      "string"
    ),
    Channels = list(
      "VOICE"
    )
  ),
  Groupings = list(
    "QUEUE"|"CHANNEL"
  ),
  HistoricalMetrics = list(
    list(
      Name = "CONTACTS_QUEUED"|"CONTACTS_HANDLED"|"CONTACTS_ABANDONED"|"CONTACTS_CONSULTED"|"CONTACTS_AGENT_HUNG_UP_FIRST"|"CONTACTS_HANDLED_INCOMING"|"CONTACTS_HANDLED_OUTBOUND"|"CONTACTS_HOLD_ABANDONS"|"CONTACTS_TRANSFERRED_IN"|"CONTACTS_TRANSFERRED_OUT"|"CONTACTS_TRANSFERRED_IN_FROM_QUEUE"|"CONTACTS_TRANSFERRED_OUT_FROM_QUEUE"|"CONTACTS_MISSED"|"CALLBACK_CONTACTS_HANDLED"|"API_CONTACTS_HANDLED"|"OCCUPANCY"|"HANDLE_TIME"|"AFTER_CONTACT_WORK_TIME"|"QUEUED_TIME"|"ABANDON_TIME"|"QUEUE_ANSWER_TIME"|"HOLD_TIME"|"INTERACTION_TIME"|"INTERACTION_AND_HOLD_TIME"|"SERVICE_LEVEL",
      Threshold = list(
        Comparison = "LT",
        ThresholdValue = 123.0
      ),
      Statistic = "SUM"|"MAX"|"AVG",
      Unit = "SECONDS"|"COUNT"|"PERCENT"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
