% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_get_journey}
\alias{pinpoint_get_journey}
\title{Retrieves information about the status, configuration, and other
settings for a journey}
\usage{
pinpoint_get_journey(ApplicationId, JourneyId)
}
\arguments{
\item{ApplicationId}{[required] The unique identifier for the application. This identifier is displayed
as the \strong{Project ID} on the Amazon Pinpoint console.}

\item{JourneyId}{[required] The unique identifier for the journey.}
}
\value{
A list with the following syntax:\preformatted{list(
  JourneyResponse = list(
    Activities = list(
      list(
        CUSTOM = list(
          DeliveryUri = "string",
          EndpointTypes = list(
            "PUSH"|"GCM"|"APNS"|"APNS_SANDBOX"|"APNS_VOIP"|"APNS_VOIP_SANDBOX"|"ADM"|"SMS"|"VOICE"|"EMAIL"|"BAIDU"|"CUSTOM"
          ),
          MessageConfig = list(
            Data = "string"
          ),
          NextActivity = "string",
          TemplateName = "string",
          TemplateVersion = "string"
        ),
        ConditionalSplit = list(
          Condition = list(
            Conditions = list(
              list(
                EventCondition = list(
                  Dimensions = list(
                    Attributes = list(
                      list(
                        AttributeType = "INCLUSIVE"|"EXCLUSIVE",
                        Values = list(
                          "string"
                        )
                      )
                    ),
                    EventType = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Metrics = list(
                      list(
                        ComparisonOperator = "string",
                        Value = 123.0
                      )
                    )
                  ),
                  MessageActivity = "string"
                ),
                SegmentCondition = list(
                  SegmentId = "string"
                ),
                SegmentDimensions = list(
                  Attributes = list(
                    list(
                      AttributeType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    )
                  ),
                  Behavior = list(
                    Recency = list(
                      Duration = "HR_24"|"DAY_7"|"DAY_14"|"DAY_30",
                      RecencyType = "ACTIVE"|"INACTIVE"
                    )
                  ),
                  Demographic = list(
                    AppVersion = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Channel = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    DeviceType = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Make = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Model = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Platform = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    )
                  ),
                  Location = list(
                    Country = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    GPSPoint = list(
                      Coordinates = list(
                        Latitude = 123.0,
                        Longitude = 123.0
                      ),
                      RangeInKilometers = 123.0
                    )
                  ),
                  Metrics = list(
                    list(
                      ComparisonOperator = "string",
                      Value = 123.0
                    )
                  ),
                  UserAttributes = list(
                    list(
                      AttributeType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    )
                  )
                )
              )
            ),
            Operator = "ALL"|"ANY"
          ),
          EvaluationWaitTime = list(
            WaitFor = "string",
            WaitUntil = "string"
          ),
          FalseActivity = "string",
          TrueActivity = "string"
        ),
        Description = "string",
        EMAIL = list(
          MessageConfig = list(
            FromAddress = "string"
          ),
          NextActivity = "string",
          TemplateName = "string",
          TemplateVersion = "string"
        ),
        Holdout = list(
          NextActivity = "string",
          Percentage = 123
        ),
        MultiCondition = list(
          Branches = list(
            list(
              Condition = list(
                EventCondition = list(
                  Dimensions = list(
                    Attributes = list(
                      list(
                        AttributeType = "INCLUSIVE"|"EXCLUSIVE",
                        Values = list(
                          "string"
                        )
                      )
                    ),
                    EventType = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Metrics = list(
                      list(
                        ComparisonOperator = "string",
                        Value = 123.0
                      )
                    )
                  ),
                  MessageActivity = "string"
                ),
                SegmentCondition = list(
                  SegmentId = "string"
                ),
                SegmentDimensions = list(
                  Attributes = list(
                    list(
                      AttributeType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    )
                  ),
                  Behavior = list(
                    Recency = list(
                      Duration = "HR_24"|"DAY_7"|"DAY_14"|"DAY_30",
                      RecencyType = "ACTIVE"|"INACTIVE"
                    )
                  ),
                  Demographic = list(
                    AppVersion = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Channel = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    DeviceType = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Make = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Model = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    Platform = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    )
                  ),
                  Location = list(
                    Country = list(
                      DimensionType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    ),
                    GPSPoint = list(
                      Coordinates = list(
                        Latitude = 123.0,
                        Longitude = 123.0
                      ),
                      RangeInKilometers = 123.0
                    )
                  ),
                  Metrics = list(
                    list(
                      ComparisonOperator = "string",
                      Value = 123.0
                    )
                  ),
                  UserAttributes = list(
                    list(
                      AttributeType = "INCLUSIVE"|"EXCLUSIVE",
                      Values = list(
                        "string"
                      )
                    )
                  )
                )
              ),
              NextActivity = "string"
            )
          ),
          DefaultActivity = "string",
          EvaluationWaitTime = list(
            WaitFor = "string",
            WaitUntil = "string"
          )
        ),
        PUSH = list(
          MessageConfig = list(
            TimeToLive = "string"
          ),
          NextActivity = "string",
          TemplateName = "string",
          TemplateVersion = "string"
        ),
        RandomSplit = list(
          Branches = list(
            list(
              NextActivity = "string",
              Percentage = 123
            )
          )
        ),
        SMS = list(
          MessageConfig = list(
            MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
            SenderId = "string"
          ),
          NextActivity = "string",
          TemplateName = "string",
          TemplateVersion = "string"
        ),
        Wait = list(
          NextActivity = "string",
          WaitTime = list(
            WaitFor = "string",
            WaitUntil = "string"
          )
        )
      )
    ),
    ApplicationId = "string",
    CreationDate = "string",
    Id = "string",
    LastModifiedDate = "string",
    Limits = list(
      DailyCap = 123,
      EndpointReentryCap = 123,
      MessagesPerSecond = 123
    ),
    LocalTime = TRUE|FALSE,
    Name = "string",
    QuietTime = list(
      End = "string",
      Start = "string"
    ),
    RefreshFrequency = "string",
    Schedule = list(
      EndTime = as.POSIXct(
        "2015-01-01"
      ),
      StartTime = as.POSIXct(
        "2015-01-01"
      ),
      Timezone = "string"
    ),
    StartActivity = "string",
    StartCondition = list(
      Description = "string",
      EventStartCondition = list(
        EventFilter = list(
          Dimensions = list(
            Attributes = list(
              list(
                AttributeType = "INCLUSIVE"|"EXCLUSIVE",
                Values = list(
                  "string"
                )
              )
            ),
            EventType = list(
              DimensionType = "INCLUSIVE"|"EXCLUSIVE",
              Values = list(
                "string"
              )
            ),
            Metrics = list(
              list(
                ComparisonOperator = "string",
                Value = 123.0
              )
            )
          ),
          FilterType = "SYSTEM"|"ENDPOINT"
        ),
        SegmentId = "string"
      ),
      SegmentStartCondition = list(
        SegmentId = "string"
      )
    ),
    State = "DRAFT"|"ACTIVE"|"COMPLETED"|"CANCELLED"|"CLOSED",
    tags = list(
      "string"
    )
  )
)
}
}
\description{
Retrieves information about the status, configuration, and other
settings for a journey.
}
\section{Request syntax}{
\preformatted{svc$get_journey(
  ApplicationId = "string",
  JourneyId = "string"
)
}
}

\keyword{internal}
