% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paymentcryptographydataplane_operations.R
\name{paymentcryptographydataplane_translate_pin_data}
\alias{paymentcryptographydataplane_translate_pin_data}
\title{Translates encrypted PIN block from and to ISO 9564 formats 0,1,3,4}
\usage{
paymentcryptographydataplane_translate_pin_data(
  IncomingKeyIdentifier,
  OutgoingKeyIdentifier,
  IncomingTranslationAttributes,
  OutgoingTranslationAttributes,
  EncryptedPinBlock,
  IncomingDukptAttributes = NULL,
  OutgoingDukptAttributes = NULL,
  IncomingWrappedKey = NULL,
  OutgoingWrappedKey = NULL
)
}
\arguments{
\item{IncomingKeyIdentifier}{[required] The \code{keyARN} of the encryption key under which incoming PIN block data
is encrypted. This key type can be PEK or BDK.

When a WrappedKeyBlock is provided, this value will be the identifier to
the key wrapping key for PIN block. Otherwise, it is the key identifier
used to perform the operation.}

\item{OutgoingKeyIdentifier}{[required] The \code{keyARN} of the encryption key for encrypting outgoing PIN block
data. This key type can be PEK or BDK.}

\item{IncomingTranslationAttributes}{[required] The format of the incoming PIN block data for translation within Amazon
Web Services Payment Cryptography.}

\item{OutgoingTranslationAttributes}{[required] The format of the outgoing PIN block data after translation by Amazon
Web Services Payment Cryptography.}

\item{EncryptedPinBlock}{[required] The encrypted PIN block data that Amazon Web Services Payment
Cryptography translates.}

\item{IncomingDukptAttributes}{The attributes and values to use for incoming DUKPT encryption key for
PIN block translation.}

\item{OutgoingDukptAttributes}{The attributes and values to use for outgoing DUKPT encryption key after
PIN block translation.}

\item{IncomingWrappedKey}{The WrappedKeyBlock containing the encryption key under which incoming
PIN block data is encrypted.}

\item{OutgoingWrappedKey}{The WrappedKeyBlock containing the encryption key for encrypting
outgoing PIN block data.}
}
\description{
Translates encrypted PIN block from and to ISO 9564 formats 0,1,3,4. For more information, see \href{https://docs.aws.amazon.com/payment-cryptography/latest/userguide/translate-pin-data.html}{Translate PIN data} in the \emph{Amazon Web Services Payment Cryptography User Guide}.

See \url{https://www.paws-r-sdk.com/docs/paymentcryptographydataplane_translate_pin_data/} for full documentation.
}
\keyword{internal}
