% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplaceentitlementservice_operations.R
\name{marketplaceentitlementservice_get_entitlements}
\alias{marketplaceentitlementservice_get_entitlements}
\title{GetEntitlements retrieves entitlement values for a given product}
\usage{
marketplaceentitlementservice_get_entitlements(ProductCode, Filter,
  NextToken, MaxResults)
}
\arguments{
\item{ProductCode}{[required] Product code is used to uniquely identify a product in AWS Marketplace.
The product code will be provided by AWS Marketplace when the product
listing is created.}

\item{Filter}{Filter is used to return entitlements for a specific customer or for a
specific dimension. Filters are described as keys mapped to a lists of
values. Filtered requests are \emph{unioned} for each value in the value
list, and then \emph{intersected} for each filter key.}

\item{NextToken}{For paginated calls to GetEntitlements, pass the NextToken from the
previous GetEntitlementsResult.}

\item{MaxResults}{The maximum number of items to retrieve from the GetEntitlements
operation. For pagination, use the NextToken field in subsequent calls
to GetEntitlements.}
}
\value{
A list with the following syntax:\preformatted{list(
  Entitlements = list(
    list(
      ProductCode = "string",
      Dimension = "string",
      CustomerIdentifier = "string",
      Value = list(
        IntegerValue = 123,
        DoubleValue = 123.0,
        BooleanValue = TRUE|FALSE,
        StringValue = "string"
      ),
      ExpirationDate = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
GetEntitlements retrieves entitlement values for a given product. The
results can be filtered based on customer identifier or product
dimensions.
}
\section{Request syntax}{
\preformatted{svc$get_entitlements(
  ProductCode = "string",
  Filter = list(
    list(
      "string"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
