% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_list_insights}
\alias{eks_list_insights}
\title{Returns a list of all insights checked for against the specified cluster}
\usage{
eks_list_insights(
  clusterName,
  filter = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{clusterName}{[required] The name of the Amazon EKS cluster associated with the insights.}

\item{filter}{The criteria to filter your list of insights for your cluster. You can
filter which insights are returned by category, associated Kubernetes
version, and status.}

\item{maxResults}{The maximum number of identity provider configurations returned by
\code{\link[=eks_list_insights]{list_insights}} in paginated output. When you use
this parameter, \code{\link[=eks_list_insights]{list_insights}} returns only
\code{maxResults} results in a single page along with a \code{nextToken} response
element. You can see the remaining results of the initial request by
sending another \code{\link[=eks_list_insights]{list_insights}} request with the
returned \code{nextToken} value. This value can be between 1 and 100. If you
don't use this parameter, \code{\link[=eks_list_insights]{list_insights}} returns
up to 100 results and a \code{nextToken} value, if applicable.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{\link[=eks_list_insights]{list_insights}} request. When the results of a
\code{\link[=eks_list_insights]{list_insights}} request exceed \code{maxResults}, you
can use this value to retrieve the next page of results. This value is
\code{null} when there are no more results to return.}
}
\description{
Returns a list of all insights checked for against the specified cluster. You can filter which insights are returned by category, associated Kubernetes version, and status.

See \url{https://www.paws-r-sdk.com/docs/eks_list_insights/} for full documentation.
}
\keyword{internal}
