% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_image_attribute}
\alias{ec2_modify_image_attribute}
\title{Modifies the specified attribute of the specified AMI}
\usage{
ec2_modify_image_attribute(
  Attribute = NULL,
  Description = NULL,
  ImageId,
  LaunchPermission = NULL,
  OperationType = NULL,
  ProductCodes = NULL,
  UserGroups = NULL,
  UserIds = NULL,
  Value = NULL,
  OrganizationArns = NULL,
  OrganizationalUnitArns = NULL,
  ImdsSupport = NULL,
  DryRun = NULL
)
}
\arguments{
\item{Attribute}{The name of the attribute to modify.

Valid values: \code{description} | \code{imdsSupport} | \code{launchPermission}}

\item{Description}{A new description for the AMI.}

\item{ImageId}{[required] The ID of the AMI.}

\item{LaunchPermission}{A new launch permission for the AMI.}

\item{OperationType}{The operation type. This parameter can be used only when the \code{Attribute}
parameter is \code{launchPermission}.}

\item{ProductCodes}{Not supported.}

\item{UserGroups}{The user groups. This parameter can be used only when the \code{Attribute}
parameter is \code{launchPermission}.}

\item{UserIds}{The Amazon Web Services account IDs. This parameter can be used only
when the \code{Attribute} parameter is \code{launchPermission}.}

\item{Value}{The value of the attribute being modified. This parameter can be used
only when the \code{Attribute} parameter is \code{description} or \code{imdsSupport}.}

\item{OrganizationArns}{The Amazon Resource Name (ARN) of an organization. This parameter can be
used only when the \code{Attribute} parameter is \code{launchPermission}.}

\item{OrganizationalUnitArns}{The Amazon Resource Name (ARN) of an organizational unit (OU). This
parameter can be used only when the \code{Attribute} parameter is
\code{launchPermission}.}

\item{ImdsSupport}{Set to \code{v2.0} to indicate that IMDSv2 is specified in the AMI. Instances
launched from this AMI will have \code{HttpTokens} automatically set to
\code{required} so that, by default, the instance requires that IMDSv2 is
used when requesting instance metadata. In addition,
\code{HttpPutResponseHopLimit} is set to \code{2}. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration}{Configure the AMI}
in the \emph{Amazon EC2 User Guide}.

Do not use this parameter unless your AMI software supports IMDSv2.
After you set the value to \code{v2.0}, you can't undo it. The only way to
“reset” your AMI is to create a new AMI from the underlying snapshot.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Modifies the specified attribute of the specified AMI. You can specify only one attribute at a time.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_image_attribute/} for full documentation.
}
\keyword{internal}
