% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_import_key_pair}
\alias{ec2_import_key_pair}
\title{Imports the public key from an RSA or ED25519 key pair that you created
using a third-party tool}
\usage{
ec2_import_key_pair(
  TagSpecifications = NULL,
  DryRun = NULL,
  KeyName,
  PublicKeyMaterial
)
}
\arguments{
\item{TagSpecifications}{The tags to apply to the imported key pair.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{KeyName}{[required] A unique name for the key pair.}

\item{PublicKeyMaterial}{[required] The public key.}
}
\description{
Imports the public key from an RSA or ED25519 key pair that you created using a third-party tool. You give Amazon Web Services only the public key. The private key is never transferred between you and Amazon Web Services.

See \url{https://www.paws-r-sdk.com/docs/ec2_import_key_pair/} for full documentation.
}
\keyword{internal}
