% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_placement_group}
\alias{ec2_create_placement_group}
\title{Creates a placement group in which to launch instances}
\usage{
ec2_create_placement_group(
  PartitionCount = NULL,
  TagSpecifications = NULL,
  SpreadLevel = NULL,
  DryRun = NULL,
  GroupName = NULL,
  Strategy = NULL
)
}
\arguments{
\item{PartitionCount}{The number of partitions. Valid only when \strong{Strategy} is set to
\code{partition}.}

\item{TagSpecifications}{The tags to apply to the new placement group.}

\item{SpreadLevel}{Determines how placement groups spread instances.
\itemize{
\item Host – You can use \code{host} only with Outpost placement groups.
\item Rack – No usage restrictions.
}}

\item{DryRun}{Checks whether you have the required permissions for the operation,
without actually making the request, and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{GroupName}{A name for the placement group. Must be unique within the scope of your
account for the Region.

Constraints: Up to 255 ASCII characters}

\item{Strategy}{The placement strategy.}
}
\description{
Creates a placement group in which to launch instances. The strategy of the placement group determines how the instances are organized within the group.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_placement_group/} for full documentation.
}
\keyword{internal}
