% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_put_account_setting}
\alias{ecs_put_account_setting}
\title{Modifies an account setting}
\usage{
ecs_put_account_setting(name, value, principalArn = NULL)
}
\arguments{
\item{name}{[required] The Amazon ECS resource name for which to modify the account setting. If
you specify \code{serviceLongArnFormat}, the ARN for your Amazon ECS services
is affected. If you specify \code{taskLongArnFormat}, the ARN and resource ID
for your Amazon ECS tasks is affected. If you specify
\code{containerInstanceLongArnFormat}, the ARN and resource ID for your
Amazon ECS container instances is affected. If you specify
\code{awsvpcTrunking}, the elastic network interface (ENI) limit for your
Amazon ECS container instances is affected. If you specify
\code{containerInsights}, the default setting for Amazon Web Services
CloudWatch Container Insights for your clusters is affected. If you
specify \code{fargateFIPSMode}, Fargate FIPS 140 compliance is affected. If
you specify \code{tagResourceAuthorization}, the opt-in option for tagging
resources on creation is affected. For information about the opt-in
timeline, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#tag-resources}{Tagging authorization timeline}
in the \emph{Amazon ECS Developer Guide}. If you specify
\code{fargateTaskRetirementWaitPeriod}, the wait time to retire a Fargate
task is affected.

The \code{guardDutyActivate} parameter is read-only in Amazon ECS and
indicates whether Amazon ECS Runtime Monitoring is enabled or disabled
by your security administrator in your Amazon ECS account. Amazon
GuardDuty controls this account setting on your behalf. For more
information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-guard-duty-integration.html}{Protecting Amazon ECS workloads with Amazon ECS Runtime Monitoring}.}

\item{value}{[required] The account setting value for the specified principal ARN. Accepted
values are \code{enabled}, \code{disabled}, \code{on}, and \code{off}.

When you specify \code{fargateTaskRetirementWaitPeriod} for the \code{name}, the
following are the valid values:
\itemize{
\item \code{0} - Amazon Web Services sends the notification, and immediately
retires the affected tasks.
\item \code{7} - Amazon Web Services sends the notification, and waits 7
calendar days to retire the tasks.
\item \code{14} - Amazon Web Services sends the notification, and waits 14
calendar days to retire the tasks.
}}

\item{principalArn}{The ARN of the principal, which can be a user, role, or the root user.
If you specify the root user, it modifies the account setting for all
users, roles, and the root user of the account unless a user or role
explicitly overrides these settings. If this field is omitted, the
setting is changed only for the authenticated user.

You must use the root user when you set the Fargate wait time
(\code{fargateTaskRetirementWaitPeriod}).

Federated users assume the account setting of the root user and can't
have explicit account settings set for them.}
}
\description{
Modifies an account setting. Account settings are set on a per-Region basis.

See \url{https://www.paws-r-sdk.com/docs/ecs_put_account_setting/} for full documentation.
}
\keyword{internal}
