% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_publish_version}
\alias{lambda_publish_version}
\title{Creates a version from the current code and configuration of a function}
\usage{
lambda_publish_version(
  FunctionName,
  CodeSha256 = NULL,
  Description = NULL,
  RevisionId = NULL
)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Partial ARN} - \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{CodeSha256}{Only publish a version if the hash value matches the value that's
specified. Use this option to avoid publishing a version if the function
code has changed since you last updated it. You can get the hash for the
version that you uploaded from the output of
\code{\link[=lambda_update_function_code]{update_function_code}}.}

\item{Description}{A description for the version to override the description in the
function configuration.}

\item{RevisionId}{Only update the function if the revision ID matches the ID that's
specified. Use this option to avoid publishing a version if the function
configuration has changed since you last updated it.}
}
\description{
Creates a \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html}{version} from the current code and configuration of a function. Use versions to create a snapshot of your function code and configuration that doesn't change.

See \url{https://www.paws-r-sdk.com/docs/lambda_publish_version/} for full documentation.
}
\keyword{internal}
