% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_assign_private_ip_addresses}
\alias{ec2_assign_private_ip_addresses}
\title{Assigns one or more secondary private IP addresses to the specified
network interface}
\usage{
ec2_assign_private_ip_addresses(
  AllowReassignment = NULL,
  NetworkInterfaceId,
  PrivateIpAddresses = NULL,
  SecondaryPrivateIpAddressCount = NULL,
  Ipv4Prefixes = NULL,
  Ipv4PrefixCount = NULL
)
}
\arguments{
\item{AllowReassignment}{Indicates whether to allow an IP address that is already assigned to
another network interface or instance to be reassigned to the specified
network interface.}

\item{NetworkInterfaceId}{[required] The ID of the network interface.}

\item{PrivateIpAddresses}{The IP addresses to be assigned as a secondary private IP address to the
network interface. You can't specify this parameter when also specifying
a number of secondary IP addresses.

If you don't specify an IP address, Amazon EC2 automatically selects an
IP address within the subnet range.}

\item{SecondaryPrivateIpAddressCount}{The number of secondary IP addresses to assign to the network interface.
You can't specify this parameter when also specifying private IP
addresses.}

\item{Ipv4Prefixes}{One or more IPv4 prefixes assigned to the network interface. You cannot
use this option if you use the \code{Ipv4PrefixCount} option.}

\item{Ipv4PrefixCount}{The number of IPv4 prefixes that Amazon Web Services automatically
assigns to the network interface. You cannot use this option if you use
the \verb{Ipv4 Prefixes} option.}
}
\description{
Assigns one or more secondary private IP addresses to the specified network interface.

See \url{https://www.paws-r-sdk.com/docs/ec2_assign_private_ip_addresses/} for full documentation.
}
\keyword{internal}
