% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_certificate}
\alias{lightsail_create_certificate}
\title{Creates an SSL/TLS certificate for an Amazon Lightsail content delivery
network (CDN) distribution and a container service}
\usage{
lightsail_create_certificate(
  certificateName,
  domainName,
  subjectAlternativeNames = NULL,
  tags = NULL
)
}
\arguments{
\item{certificateName}{[required] The name for the certificate.}

\item{domainName}{[required] The domain name (e.g., \code{example.com}) for the certificate.}

\item{subjectAlternativeNames}{An array of strings that specify the alternate domains (e.g.,
\code{example2.com}) and subdomains (e.g., \code{blog.example.com}) for the
certificate.

You can specify a maximum of nine alternate domains (in addition to the
primary domain name).

Wildcard domain entries (e.g., \verb{*.example.com}) are not supported.}

\item{tags}{The tag keys and optional values to add to the certificate during
create.

Use the \code{\link[=lightsail_tag_resource]{tag_resource}} action to tag a
resource after it's created.}
}
\description{
Creates an SSL/TLS certificate for an Amazon Lightsail content delivery network (CDN) distribution and a container service.

See \url{https://www.paws-r-sdk.com/docs/lightsail_create_certificate/} for full documentation.
}
\keyword{internal}
